/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.mut;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.utilities.Execute;
import com.sap.sapdb.testframe.utilities.Zipper;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;

public class MutStarter
extends TestCase {
    private static int noOfLoops = 1;
    private static String instRoot;
    private static String jtestRoot;
    private static String fileSep;
    private static String osVersion;
    private static String osUser;
    private static String osPassword;
    private static String omsFlag;
    private static String kernelMode;
    private static String dbName;

    public static void prepare() throws TestCaseException {
        noOfLoops = new Integer(TestCase.getParameterString((String)"noOfLoops", (String)"1"));
        kernelMode = TestCase.getParameterString((String)"kernelMode", (String)"-f");
    }

    public static long getTimeout() {
        long dummyTime = 0L;
        dummyTime = noOfLoops * 10 < 120 ? 0x6DDD00L : (long)(noOfLoops * 10 * 1000 * 60);
        if (kernelMode != null && kernelMode.equalsIgnoreCase("-s")) {
            dummyTime *= 2L;
        }
        return dummyTime;
    }

    public void run() {
        block25: {
            StringBuffer sb = null;
            try {
                instRoot = TestCase.mTestDriverOptions.getProperty("DBRoot");
                if (instRoot == null) {
                    TestCase.addGlobalMessage((String)"", (char)'E', (String)"Error in run(). DBROOT not set.");
                    throw new TestCaseException("DBROOT not set.");
                }
                jtestRoot = System.getProperty("jtest.root");
                if (jtestRoot == null) {
                    TestCase.addGlobalMessage((String)"", (char)'E', (String)"Error in run(). Property jtest.root not set.");
                    throw new TestCaseException("Property jtest.root not set.");
                }
                fileSep = System.getProperty("file.separator");
                osVersion = TestDriver.getOpSystem().substring(0, 3);
                if (!osVersion.equalsIgnoreCase("WIN")) {
                    osUser = TestCase.mTestDriverOptions.getProperty("OSUser");
                    osPassword = TestCase.mTestDriverOptions.getProperty("OSPwd");
                }
                if (TestCase.getParameterBoolean((String)"omsFlag", (boolean)false)) {
                    if (!osVersion.equalsIgnoreCase("WIN")) {
                        TestCase.addGlobalMessage((String)"", (char)'E', (String)"Error in run(). OMS MUT only supported on Windows.");
                        throw new TestCaseException("OMS MUT only supported on Windows.");
                    }
                    omsFlag = "-o ";
                } else {
                    omsFlag = "";
                }
                if (!(kernelMode.equals("-f") || kernelMode.equals("-s") || kernelMode.equals("-q"))) {
                    kernelMode = "-f";
                }
                kernelMode = String.valueOf(kernelMode) + " ";
                dbName = TestCase.getDatabase().getName();
                FileWriter writer = new FileWriter(new File(String.valueOf(System.getProperty("jtest.root")) + fileSep + "mut" + fileSep + "mutvar"));
                writer.write(String.valueOf(dbName) + " DBA DBA CONTROL CONTROL\n");
                writer.close();
                String cmd = "perl " + jtestRoot + fileSep + "mut" + fileSep + "mutparam.pl " + omsFlag;
                if (instRoot != null && !instRoot.equals("")) {
                    cmd = String.valueOf(cmd) + "-R " + instRoot;
                }
                if (!osVersion.equalsIgnoreCase("WIN") && osUser != null && osPassword != null) {
                    cmd = String.valueOf(cmd) + " -l " + osUser + "," + osPassword;
                }
                System.out.println(cmd);
                sb = new StringBuffer();
                System.out.println("Executing command:\n" + cmd);
                System.out.println(sb.toString());
                Execute exc = new Execute(cmd, null, sb);
                exc.exec(new File(String.valueOf(jtestRoot) + fileSep + "mut"));
                int errorCode = 0;
                errorCode = exc.getExitValue();
                if (errorCode > 255) {
                    errorCode -= 65536;
                } else if (errorCode > 127) {
                    errorCode -= 256;
                }
                if (errorCode != 0) {
                    TestCase.addGlobalMessage((String)"", (char)'E', (String)(String.valueOf(cmd) + " => RC = " + errorCode));
                    TestCase.addGlobalMessage((String)"", (char)'E', (String)"Error in run(). mutparam failed.");
                    if (sb.toString().length() != 0) {
                        TestCase.addGlobalMessage((String)"", (char)'T', (String)sb.toString());
                    }
                    throw new TestCaseException("mutparam failed.");
                }
                TestCase.addGlobalMessage((String)"", (char)'I', (String)(String.valueOf(cmd) + " successful!"));
                noOfLoops = new Integer(TestCase.getParameterString((String)"noOfLoops", (String)"1"));
                cmd = "perl " + jtestRoot + fileSep + "mut" + fileSep + "muti.pl " + omsFlag;
                if (instRoot != null && !instRoot.equals("")) {
                    cmd = String.valueOf(cmd) + "-R " + instRoot;
                }
                cmd = String.valueOf(cmd) + " " + kernelMode + noOfLoops;
                System.out.println(cmd);
                long startTime = System.currentTimeMillis();
                sb = new StringBuffer();
                sb.append("Executing command:\n" + cmd + "\nwith a timeout of " + MutStarter.getTimeout() / 1000L / 60L + " min. ");
                System.out.println(sb.toString());
                TestCase.addGlobalMessage((String)"", (char)'I', (String)sb.toString());
                sb = new StringBuffer();
                exc = new Execute(cmd, null, sb);
                exc.exec(new File(String.valueOf(jtestRoot) + fileSep + "mut"));
                long endTime = System.currentTimeMillis();
                errorCode = 0;
                errorCode = exc.getExitValue();
                if (errorCode > 255) {
                    errorCode -= 65536;
                } else if (errorCode > 127) {
                    errorCode -= 256;
                }
                if (errorCode == 0) {
                    TestCase.addGlobalMessage((String)"", (char)'I', (String)(String.valueOf(cmd) + " successful!"));
                    if (sb.toString().length() != 0 && sb.toString().indexOf("coredump") != -1) {
                        TestCase.addGlobalMessage((String)"stdout contains 'coredump'", (char)'E', (String)sb.toString());
                    }
                } else {
                    TestCase.addGlobalMessage((String)"", (char)'E', (String)(String.valueOf(cmd) + " => RC = " + errorCode));
                    TestCase.addGlobalMessage((String)"", (char)'E', (String)"Error in run(). muti failed.");
                    if (sb.toString().length() != 0) {
                        TestCase.addGlobalMessage((String)"", (char)'T', (String)sb.toString());
                    }
                }
                if (endTime - startTime < 360000L && noOfLoops > 9) {
                    TestCase.addGlobalMessage((String)"run()", (char)'E', (String)("The script 'muti.pl' with a loop counter of " + noOfLoops + " has finished in less than six minutes. \nRuntime: " + (endTime - startTime) / 1000L + " sec. It is almost certain that there have been undetected errors."));
                }
            }
            catch (Exception e) {
                this.addMessage("run()", 'E', "Exception: " + e.getMessage());
                if (sb == null || sb.toString().length() <= 3) break block25;
                this.addMessage("run()", 'T', "TestOutPut until the error: \n" + sb.toString());
            }
        }
    }

    public String getLogFile() {
        File theZipFile = new File(String.valueOf(this.getDataOutputPath()) + File.separator + "mut_prot.zip");
        Zipper myZipper = new Zipper(theZipFile);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".prt");
            }
        };
        File[] filelist = new File(String.valueOf(jtestRoot) + fileSep + "mut").listFiles(filter);
        myZipper.addFiles(filelist);
        myZipper.addFile(new File(String.valueOf(jtestRoot) + fileSep + "mut" + fileSep + "endlos.prot"));
        try {
            myZipper.zip();
        }
        catch (IOException e) {
            this.addMessage("MutStarter", 'W', "Failed to create a zipfile with the protocol files\n" + e.getLocalizedMessage());
            return String.valueOf(jtestRoot) + fileSep + "mut" + fileSep + "endlos.prot";
        }
        return theZipFile.getAbsolutePath();
    }
}

