/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.AverageSetFunction;
import com.sap.sapdb.oltptest.join.simulation.CellAccessorFunction;
import com.sap.sapdb.oltptest.join.simulation.CountSetFunction;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.LessCondition;
import com.sap.sapdb.oltptest.join.simulation.MaterializeResultOperator;
import com.sap.sapdb.oltptest.join.simulation.MaxSetFunction;
import com.sap.sapdb.oltptest.join.simulation.NestedLoopJoin;
import com.sap.sapdb.oltptest.join.simulation.SetFunctionFilter;
import com.sap.sapdb.oltptest.join.simulation.SumSetFunction;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import com.sap.sapdb.oltptest.join.simulation.unittests.TestHelpers;
import junit.framework.Assert;
import junit.framework.TestCase;

public class SetFunctionFilterTest
extends TestCase {
    public void testSimple() {
        System.out.println("SetFunctionFilter: simple");
        DatabaseTable t = TestHelpers.createTable(3, 10);
        CountSetFunction cf = new CountSetFunction();
        SumSetFunction sf = new SumSetFunction(new CellAccessorFunction(t, 2));
        AverageSetFunction af = new AverageSetFunction(new CellAccessorFunction(t, 2));
        SetFunctionFilter sff = new SetFunctionFilter(new DbResultTable(t));
        sff.addFunction(cf, 1);
        sff.addFunction(sf, 2);
        sff.addFunction(af, 3);
        MaterializeResultOperator m = new MaterializeResultOperator(sff);
        DatabaseTable verifyTable = new DatabaseTable(m);
        TableRow verifyRow = new TableRow(verifyTable);
        verifyRow.setValue(1, new IntegerCell(10));
        verifyRow.setValue(2, new IntegerCell(75));
        verifyRow.setValue(3, new IntegerCell(7));
        verifyTable.insert(verifyRow);
        Assert.assertTrue((boolean)verifyTable.sortAndCompare(m.getResultTable(), true));
    }

    public void testTwoInputTables() {
        System.out.println("SetFunctionFilter: two input tables");
        DatabaseTable t1 = TestHelpers.createTable(1, 10);
        DatabaseTable t2 = TestHelpers.createTable(2, 10);
        LessCondition c1 = new LessCondition(t1, 1, t2, 2);
        NestedLoopJoin joinResult = new NestedLoopJoin(new DbResultTable(t1), new DbResultTable(t2), c1);
        CountSetFunction cf = new CountSetFunction();
        SumSetFunction sf = new SumSetFunction(new CellAccessorFunction(t1, 1));
        AverageSetFunction af = new AverageSetFunction(new CellAccessorFunction(t2, 2));
        SetFunctionFilter sff = new SetFunctionFilter(joinResult);
        sff.addFunction(cf, 1);
        sff.addFunction(sf, 2);
        sff.addFunction(af, 3);
        MaterializeResultOperator m = new MaterializeResultOperator(sff);
        DatabaseTable verifyTable = new DatabaseTable(m);
        TableRow verifyRow = new TableRow(verifyTable);
        verifyRow.setValue(1, new IntegerCell(55));
        verifyRow.setValue(2, new IntegerCell(275));
        verifyRow.setValue(3, new IntegerCell(8));
        verifyTable.insert(verifyRow);
        Assert.assertTrue((boolean)verifyTable.sortAndCompare(m.getResultTable(), true));
    }

    public void testMaxFunction() {
        System.out.println("SetFunctionFilter: max set function");
        DatabaseTable t1 = TestHelpers.createTable(1, 10);
        MaxSetFunction max = new MaxSetFunction(new CellAccessorFunction(t1, 1, 1));
        SetFunctionFilter sff = new SetFunctionFilter(new DbResultTable(t1));
        sff.addFunction(max, 1);
        MaterializeResultOperator m = new MaterializeResultOperator(sff);
        m.dumpStructure();
        m.getResultTable().dump();
    }
}

