/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.oltptest.join.simulation.unittests;

import com.sap.sapdb.oltptest.join.simulation.AbstractCondition;
import com.sap.sapdb.oltptest.join.simulation.AlwaysTrueCondition;
import com.sap.sapdb.oltptest.join.simulation.BruteForceJoin;
import com.sap.sapdb.oltptest.join.simulation.CorrelatedSubqueryOperator;
import com.sap.sapdb.oltptest.join.simulation.DatabaseTable;
import com.sap.sapdb.oltptest.join.simulation.DbResultTable;
import com.sap.sapdb.oltptest.join.simulation.EqualCondition;
import com.sap.sapdb.oltptest.join.simulation.ExistsPredicate;
import com.sap.sapdb.oltptest.join.simulation.IntegerCell;
import com.sap.sapdb.oltptest.join.simulation.MaterializeResultOperator;
import com.sap.sapdb.oltptest.join.simulation.ProjectionOperator;
import com.sap.sapdb.oltptest.join.simulation.TableRow;
import com.sap.sapdb.oltptest.join.simulation.unittests.TestHelpers;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;

public class CorrelatedSubqueryOperatorTest
extends TestCase {
    private AbstractList tableList;
    private DatabaseTable t1;
    private DatabaseTable t2;
    private DatabaseTable t3;

    protected void setUp() throws Exception {
        super.setUp();
        this.tableList = new ArrayList(3);
        this.t1 = TestHelpers.createTable(2, 7);
        this.t2 = TestHelpers.createTable(3, 5);
        this.t3 = TestHelpers.createTable(1, 10);
        Iterator it = this.tableList.iterator();
        while (it.hasNext()) {
            DatabaseTable databaseTable = (DatabaseTable)it.next();
        }
    }

    private DatabaseTable getTable(int index) {
        return (DatabaseTable)this.tableList.get(index);
    }

    public void testCorrelatedSubquerySimpleQualification() {
        System.out.println("CorrelatedSubquery: simpleQualification");
        EqualCondition eq = new EqualCondition(this.t1, 1, this.t2, 2);
        MaterializeResultOperator t0 = new MaterializeResultOperator(new BruteForceJoin(new DbResultTable(this.t1), new DbResultTable(this.t2), eq));
        CorrelatedSubqueryOperator q = new CorrelatedSubqueryOperator(t0);
        q.addCorrelatedTable(this.t1);
        eq = new EqualCondition(this.t1, 1, this.t3, 1);
        BruteForceJoin subjoin = new BruteForceJoin(q.newCorrelatedTableInstance(this.t1), new DbResultTable(this.t3), eq);
        ProjectionOperator subquery = new ProjectionOperator(subjoin, this.t3, 1);
        eq = new EqualCondition(this.t1, 1, subquery, 1);
        q.addAndSubquery(subquery, eq);
        DatabaseTable result = new MaterializeResultOperator(q).getResultTable();
        result.dump();
        DatabaseTable verify = new DatabaseTable(result);
        TableRow vrow = new TableRow(verify);
        vrow.setValue(1, new IntegerCell(3));
        vrow.setValue(2, new IntegerCell(4));
        vrow.setValue(3, new IntegerCell(2));
        vrow.setValue(4, new IntegerCell(3));
        vrow.setValue(5, new IntegerCell(4));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(4));
        vrow.setValue(2, new IntegerCell(5));
        vrow.setValue(3, new IntegerCell(3));
        vrow.setValue(4, new IntegerCell(4));
        vrow.setValue(5, new IntegerCell(5));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(5));
        vrow.setValue(2, new IntegerCell(6));
        vrow.setValue(3, new IntegerCell(4));
        vrow.setValue(4, new IntegerCell(5));
        vrow.setValue(5, new IntegerCell(6));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(6));
        vrow.setValue(2, new IntegerCell(7));
        vrow.setValue(3, new IntegerCell(5));
        vrow.setValue(4, new IntegerCell(6));
        vrow.setValue(5, new IntegerCell(7));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(7));
        vrow.setValue(2, new IntegerCell(8));
        vrow.setValue(3, new IntegerCell(6));
        vrow.setValue(4, new IntegerCell(7));
        vrow.setValue(5, new IntegerCell(8));
        verify.insert(vrow);
        Assert.assertTrue((boolean)result.sortAndCompare(verify, true));
    }

    public void testCorrelatedSubquerySimpleExists() {
        System.out.println("CorrelatedSubquery: simpleExists");
        AbstractCondition eq = new EqualCondition(this.t1, 1, this.t2, 2);
        MaterializeResultOperator t0 = new MaterializeResultOperator(new BruteForceJoin(new DbResultTable(this.t1), new DbResultTable(this.t2), eq));
        CorrelatedSubqueryOperator q = new CorrelatedSubqueryOperator(t0);
        q.addCorrelatedTable(this.t1);
        eq = new EqualCondition(this.t1, 1, this.t3, 1);
        BruteForceJoin subjoin = new BruteForceJoin(q.newCorrelatedTableInstance(this.t1), new DbResultTable(this.t3), eq);
        ProjectionOperator subquery = new ProjectionOperator(subjoin, this.t3, 1);
        eq = new ExistsPredicate(subquery);
        q.addAndSubquery(subquery, eq);
        DatabaseTable result = new MaterializeResultOperator(q).getResultTable();
        result.dump();
        DatabaseTable verify = new DatabaseTable(result);
        TableRow vrow = new TableRow(verify);
        vrow.setValue(1, new IntegerCell(3));
        vrow.setValue(2, new IntegerCell(4));
        vrow.setValue(3, new IntegerCell(2));
        vrow.setValue(4, new IntegerCell(3));
        vrow.setValue(5, new IntegerCell(4));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(4));
        vrow.setValue(2, new IntegerCell(5));
        vrow.setValue(3, new IntegerCell(3));
        vrow.setValue(4, new IntegerCell(4));
        vrow.setValue(5, new IntegerCell(5));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(5));
        vrow.setValue(2, new IntegerCell(6));
        vrow.setValue(3, new IntegerCell(4));
        vrow.setValue(4, new IntegerCell(5));
        vrow.setValue(5, new IntegerCell(6));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(6));
        vrow.setValue(2, new IntegerCell(7));
        vrow.setValue(3, new IntegerCell(5));
        vrow.setValue(4, new IntegerCell(6));
        vrow.setValue(5, new IntegerCell(7));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(7));
        vrow.setValue(2, new IntegerCell(8));
        vrow.setValue(3, new IntegerCell(6));
        vrow.setValue(4, new IntegerCell(7));
        vrow.setValue(5, new IntegerCell(8));
        verify.insert(vrow);
        Assert.assertTrue((boolean)result.sortAndCompare(verify, true));
    }

    public void testCorrelatedSubqueryTwoQualifications() {
        System.out.println("CorrelatedSubquery: two qualifications");
        EqualCondition eq = new EqualCondition(this.t1, 1, this.t3, 1);
        MaterializeResultOperator t0 = new MaterializeResultOperator(new BruteForceJoin(new DbResultTable(this.t1), new DbResultTable(this.t3), eq));
        CorrelatedSubqueryOperator q = new CorrelatedSubqueryOperator(t0);
        q.addCorrelatedTable(this.t1);
        eq = new EqualCondition(this.t1, 1, this.t2, 1);
        BruteForceJoin subjoin = new BruteForceJoin(new DbResultTable(this.t2), q.newCorrelatedTableInstance(this.t1), eq);
        ProjectionOperator subquery = new ProjectionOperator(subjoin, this.t2, 1);
        eq = new EqualCondition(this.t1, 1, subquery, 1);
        q.addAndSubquery(subquery, eq);
        eq = new EqualCondition(this.t1, 2, this.t2, 2);
        subjoin = new BruteForceJoin(new DbResultTable(this.t2), q.newCorrelatedTableInstance(this.t1), eq);
        subquery = new ProjectionOperator(subjoin, this.t2, 1);
        eq = new EqualCondition(this.t3, 1, subquery, 1);
        q.addAndSubquery(subquery, eq);
        DatabaseTable result = new MaterializeResultOperator(q).getResultTable();
        DatabaseTable verify = new DatabaseTable(result);
        TableRow vrow = new TableRow(verify);
        vrow.setValue(1, new IntegerCell(2));
        vrow.setValue(2, new IntegerCell(3));
        vrow.setValue(3, new IntegerCell(2));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(3));
        vrow.setValue(2, new IntegerCell(4));
        vrow.setValue(3, new IntegerCell(3));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(4));
        vrow.setValue(2, new IntegerCell(5));
        vrow.setValue(3, new IntegerCell(4));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(5));
        vrow.setValue(2, new IntegerCell(6));
        vrow.setValue(3, new IntegerCell(5));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(6));
        vrow.setValue(2, new IntegerCell(7));
        vrow.setValue(3, new IntegerCell(6));
        verify.insert(vrow);
        Assert.assertTrue((boolean)result.sortAndCompare(verify, true));
    }

    public void testCorrelatedSubqueryTwoTables() {
        System.out.println("CorrelatedSubquery: two tables");
        EqualCondition eq = new EqualCondition(this.t1, 1, this.t3, 1);
        MaterializeResultOperator t0 = new MaterializeResultOperator(new BruteForceJoin(new DbResultTable(this.t1), new DbResultTable(this.t3), eq));
        CorrelatedSubqueryOperator q = new CorrelatedSubqueryOperator(t0);
        q.addCorrelatedTable(this.t1);
        q.addCorrelatedTable(this.t3);
        eq = new EqualCondition(this.t1, 1, this.t2, 1);
        BruteForceJoin subjoin = new BruteForceJoin(new DbResultTable(this.t2), q.newCorrelatedTableInstance(this.t1), eq);
        ProjectionOperator subquery = new ProjectionOperator(subjoin, this.t2, 1);
        eq = new EqualCondition(this.t1, 1, subquery, 1);
        q.addAndSubquery(subquery, eq);
        eq = new EqualCondition(this.t3, 1, this.t2, 1);
        subjoin = new BruteForceJoin(q.newCorrelatedTableInstance(this.t3), new DbResultTable(this.t2), eq);
        subquery = new ProjectionOperator(subjoin, this.t3, 1);
        eq = new EqualCondition(this.t3, 1, subquery, 1);
        q.addAndSubquery(subquery, eq);
        DatabaseTable result = new MaterializeResultOperator(q).getResultTable();
        DatabaseTable verify = new DatabaseTable(result);
        TableRow vrow = new TableRow(verify);
        vrow.setValue(1, new IntegerCell(2));
        vrow.setValue(2, new IntegerCell(3));
        vrow.setValue(3, new IntegerCell(2));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(3));
        vrow.setValue(2, new IntegerCell(4));
        vrow.setValue(3, new IntegerCell(3));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(4));
        vrow.setValue(2, new IntegerCell(5));
        vrow.setValue(3, new IntegerCell(4));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(5));
        vrow.setValue(2, new IntegerCell(6));
        vrow.setValue(3, new IntegerCell(5));
        verify.insert(vrow);
        vrow.setValue(1, new IntegerCell(6));
        vrow.setValue(2, new IntegerCell(7));
        vrow.setValue(3, new IntegerCell(6));
        verify.insert(vrow);
        Assert.assertTrue((boolean)result.sortAndCompare(verify, true));
    }

    public void testCorrelatedSubqueryOrQualification() {
        System.out.println("CorrelatedSubquery: or qualification");
        AbstractCondition eq = new AlwaysTrueCondition();
        MaterializeResultOperator t0 = new MaterializeResultOperator(new BruteForceJoin(new DbResultTable(this.t1), new DbResultTable(this.t3), eq));
        CorrelatedSubqueryOperator q = new CorrelatedSubqueryOperator(t0);
        q.addCorrelatedTable(this.t1);
        q.addCorrelatedTable(this.t3);
        eq = new EqualCondition(this.t1, 1, this.t3, 1);
        q.setQualification(eq);
        eq = new EqualCondition(this.t1, 1, this.t2, 1);
        BruteForceJoin subjoin = new BruteForceJoin(new DbResultTable(this.t2), q.newCorrelatedTableInstance(this.t1), eq);
        ProjectionOperator subquery = new ProjectionOperator(subjoin, this.t2, 1);
        eq = new EqualCondition(this.t1, 1, subquery, 1);
        q.addAndSubquery(subquery, eq);
        eq = new EqualCondition(this.t3, 1, this.t2, 1);
        subjoin = new BruteForceJoin(q.newCorrelatedTableInstance(this.t3), new DbResultTable(this.t2), eq);
        subquery = new ProjectionOperator(subjoin, this.t3, 1);
        eq = new EqualCondition(this.t3, 1, subquery, 1);
        q.addOrSubquery(subquery, eq);
        DatabaseTable result = new MaterializeResultOperator(q).getResultTable();
        result.sort();
        result.dump();
        q.dumpStructure();
        ArrayList<DatabaseTable> verList = new ArrayList<DatabaseTable>(2);
        verList.add(this.t1);
        verList.add(this.t3);
        TestHelpers.verifyTableDefinition(q, verList);
    }
}

