/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities.webdav.protocol;

import com.sap.sapdb.testframe.utilities.webdav.protocol.URLStreamHandlerFactory;
import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVCore;
import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVException;
import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVSAXParser;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.SAXException;

public class WebDAVPrepareCore {
    public WebDAVCore core;
    protected URL webDAVServerURL = null;
    protected String url = null;
    protected URLStreamHandlerFactory fac = new URLStreamHandlerFactory();
    protected URLStreamHandler handler = this.fac.createURLStreamHandler("http");
    public static final int ALL = 0;
    public static final int COLLECTION = 1;
    public static final int FILE = 2;

    public WebDAVPrepareCore(URL webDAVServer) {
        try {
            this.webDAVServerURL = webDAVServer = new URL(webDAVServer, "", this.handler);
            this.core = new WebDAVCore(webDAVServer);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    protected URL buildUrl(String resource) {
        int index = resource.indexOf(" ");
        while (index != -1) {
            resource = resource.substring(0, index) + "%20" + resource.substring(index + 1);
            index = resource.indexOf(" ");
        }
        if (resource.length() > 7 && (resource.substring(0, 7).toLowerCase().equals("http://") || resource.substring(0, 8).toLowerCase().equals("https://"))) {
            try {
                return new URL(null, resource, this.handler);
            }
            catch (MalformedURLException me) {
                System.err.println("Malformed URL: " + resource);
                return null;
            }
        }
        try {
            return new URL(this.webDAVServerURL, resource, this.handler);
        }
        catch (MalformedURLException me) {
            System.err.println("Malformed URL: " + this.webDAVServerURL.toString() + resource);
            return null;
        }
    }

    public boolean exists(String resource) throws WebDAVException {
        boolean result;
        URL url = this.buildUrl(resource);
        if (url == null) {
            return false;
        }
        this.core.setURL(url);
        try {
            result = this.core.HEAD(null);
        }
        catch (WebDAVException wde) {
            if (wde.getStatusCode() == 404) {
                return false;
            }
            if (wde.getStatusCode() == -1) {
                throw wde;
            }
            System.err.println("Error: " + wde.getStatusCode() + " " + wde.getMessage());
            return false;
        }
        return result;
    }

    public boolean create(String resource) throws WebDAVException {
        URL url = null;
        String part = "";
        boolean alreadyExist = false;
        StringTokenizer st = new StringTokenizer(resource, "/");
        while (st.hasMoreTokens()) {
            part = part + st.nextToken() + "/";
            alreadyExist = false;
            try {
                if (this.exists(part)) {
                    alreadyExist = true;
                    continue;
                }
                url = this.buildUrl(part);
                this.core.setURL(url);
                this.core.MKCOL(null);
            }
            catch (WebDAVException wde) {
                if (wde.getStatusCode() == -1) {
                    throw wde;
                }
                System.err.println("Error: " + wde.getStatusCode() + " " + wde.getMessage());
                return false;
            }
        }
        return this.core.getStatus().getStatusCode() == 201 || alreadyExist;
    }

    public boolean download(String resource, File destination) throws WebDAVException {
        boolean result;
        try {
            if (!this.exists(resource)) {
                System.err.println("File " + this.buildUrl(resource).toString() + " does not exist!");
                return false;
            }
            this.core.setURL(this.buildUrl(resource));
            result = this.core.GET(destination);
        }
        catch (WebDAVException wde) {
            if (wde.getStatusCode() == -1) {
                throw wde;
            }
            System.err.println("Error: " + wde.getStatusCode() + " " + wde.getMessage());
            return false;
        }
        if (this.core.getStatus().getStatusCode() == 200 && result) {
            return true;
        }
        if (result) {
            System.err.println("WebDAV Status: " + this.core.getStatus());
        }
        return false;
    }

    public boolean upload(File file, String resource) throws WebDAVException {
        boolean result;
        if (!file.exists()) {
            System.err.println("File " + file.toString() + " does not exist!");
            return false;
        }
        String part = "";
        StringTokenizer st = new StringTokenizer(resource, "/");
        while (st.countTokens() > 1) {
            part = part + st.nextToken() + "/";
        }
        try {
            this.create(part);
            if (this.exists(resource)) {
                this.core.DELETE(null);
            }
            this.core.setURL(this.buildUrl(resource));
            result = resource.endsWith("html") ? this.core.PUT(file, "text/html", null) : this.core.PUT(file, null, null);
            if (!result) {
                this.core.DELETE(null);
            }
        }
        catch (WebDAVException wde) {
            if (wde.getStatusCode() == -1) {
                throw wde;
            }
            System.err.println("Error upload: " + wde.getStatusCode() + " " + wde.getMessage());
            return false;
        }
        if ((this.core.getStatus().getStatusCode() == 201 || this.core.getStatus().getStatusCode() == 204) && result) {
            return true;
        }
        if (result) {
            System.err.println("WebDAV Status: " + this.core.getStatus());
        }
        return false;
    }

    public boolean upload(String content, String resource) throws WebDAVException {
        boolean result;
        String part = "";
        StringTokenizer st = new StringTokenizer(resource, "/");
        while (st.countTokens() > 1) {
            part = part + st.nextToken() + "/";
        }
        try {
            this.create(part);
            if (this.exists(resource)) {
                this.core.DELETE(null);
            }
            this.core.setURL(this.buildUrl(resource));
            result = resource.endsWith("html") ? this.core.PUT(content, "text/html", null) : this.core.PUT(content, null, null);
            if (!result) {
                this.core.DELETE(null);
            }
        }
        catch (WebDAVException wde) {
            if (wde.getStatusCode() == -1) {
                throw wde;
            }
            System.err.println("Error: " + wde.getStatusCode() + " " + wde.getMessage());
            return false;
        }
        if ((this.core.getStatus().getStatusCode() == 201 || this.core.getStatus().getStatusCode() == 204) && result) {
            return true;
        }
        if (result) {
            System.err.println("WebDAV Status: " + this.core.getStatus());
        }
        return false;
    }

    public Vector list(String resource) throws WebDAVException {
        return this.list(resource, 0);
    }

    public Vector list(String resource, int mode) throws WebDAVException {
        Vector v = new Vector();
        URL url = this.buildUrl(resource);
        if (url == null) {
            return null;
        }
        this.core.setURL(url);
        try {
            File x = this.core.PROPFIND("<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:getcontenttype/><D:displayname/><D:getcontentlength/></D:prop></D:propfind>");
            if (x == null) {
                return null;
            }
            WebDAVSAXParser.parse(x, v, mode);
        }
        catch (WebDAVException wde) {
            if (wde.getStatusCode() == 404) {
                System.err.println("Collection " + this.buildUrl(resource).toString() + " does not exist!");
                return null;
            }
            if (wde.getStatusCode() == -1) {
                throw wde;
            }
            System.err.println("Error: " + wde.getStatusCode() + " " + wde.getMessage());
            return null;
        }
        catch (SAXException se) {
            System.err.println("Error: " + se.getLocalizedMessage());
            return null;
        }
        catch (IOException ioe) {
            System.err.println("Error: " + ioe.getLocalizedMessage());
            return null;
        }
        return v;
    }

    public int getSize(String resource) throws WebDAVException {
        Vector v = new Vector();
        int size = 0;
        try {
            if (!this.exists(resource)) {
                System.err.println("Collection " + this.buildUrl(resource).toString() + " does not exist!");
                return -1;
            }
            File x = this.core.PROPFIND("<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:getcontentlength/></D:prop></D:propfind>");
            if (x == null) {
                return -1;
            }
            WebDAVSAXParser.parse(x, v, 3);
            for (int i = 0; i < v.size(); ++i) {
                if (!(v.elementAt(i) instanceof Integer)) continue;
                size += ((Integer)v.elementAt(i)).intValue();
            }
        }
        catch (WebDAVException wde) {
            if (wde.getStatusCode() == -1) {
                throw wde;
            }
            System.err.println("Error: " + wde.getStatusCode() + " " + wde.getMessage());
            return -1;
        }
        catch (SAXException se) {
            System.err.println("Error: " + se.getLocalizedMessage());
            return -1;
        }
        catch (IOException ioe) {
            System.err.println("Error: " + ioe.getLocalizedMessage());
            return -1;
        }
        return size;
    }
}

