/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.DBInputStream;
import com.sap.sapdb.testframe.utilities.Index;
import com.sap.sapdb.testframe.utilities.IndexField;
import com.sap.sapdb.testframe.utilities.RandomFieldValueGenerator;
import com.sap.sapdb.testframe.utilities.TableField;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Set;

public class Table {
    private String mName;
    private TableField[] mFields = new TableField[255];
    private int mNoOfFields = 0;
    private RandomFieldValueGenerator mRandomGen;
    private boolean mTableHasLong = false;
    private HashMap mIndexMap = new HashMap(10);
    private Connection mConnection = null;
    private PreparedStatement mInsertStatement = null;

    public Table(String pName) {
        this.mName = pName;
        this.mRandomGen = new RandomFieldValueGenerator();
    }

    public Table(String pName, int pRandomInit) {
        this.mName = pName;
        this.mRandomGen = new RandomFieldValueGenerator(pRandomInit);
    }

    public void addBoolean(String pName, boolean pKey, boolean pRandom, boolean pDefaultValue) {
        this.mFields[this.mNoOfFields++] = new TableField(pName, "BOOLEAN", false, -1, -1, this.mNoOfFields, pKey, pRandom, String.valueOf(pDefaultValue), false, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public void addCharacter(String pName, int pLength, boolean pKey, boolean pUnique, boolean pRandom, String pDefaultValue) {
        this.mFields[this.mNoOfFields++] = new TableField(pName, "CHARACTER", false, pLength, -1, this.mNoOfFields, pKey, pRandom, pDefaultValue, pUnique, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public void addCharacterBinary(String pName, int pLength, boolean pKey, boolean pUnique, boolean pRandom, String pDefaultValue) {
        this.mFields[this.mNoOfFields++] = new TableField(pName, "CHARACTER", true, pLength, -1, this.mNoOfFields, pKey, pRandom, pDefaultValue, pUnique, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public void addDate(String pName, boolean pKey, boolean pUnique, boolean pRandom, String pDefaultValue, String pMinRandomValue, String pMaxRandomValue) {
        long lMin = Long.MIN_VALUE;
        long lMax = Long.MAX_VALUE;
        if (pMinRandomValue != null && pMinRandomValue.trim() != "") {
            lMin = Date.valueOf(pMinRandomValue).getTime();
        }
        if (pMaxRandomValue != null && pMaxRandomValue.trim() != "") {
            lMax = Date.valueOf(pMaxRandomValue).getTime();
        }
        this.mFields[this.mNoOfFields++] = new TableField(pName, "DATE", false, -1, -1, this.mNoOfFields, pKey, pRandom, pDefaultValue, pUnique, lMin, lMax);
    }

    public void addFixed(String pName, int pLength, int pDecimals, boolean pKey, boolean pUnique, boolean pRandom, float pDefaultValue, int pMinRandomValue, int pMaxRandomValue) {
        this.mFields[this.mNoOfFields++] = new TableField(pName, "FIXED", false, pLength, pDecimals, this.mNoOfFields, pKey, pRandom, Float.toString(pDefaultValue), pUnique, pMinRandomValue, pMaxRandomValue);
    }

    public void addFloat(String pName, int pLength, boolean pKey, boolean pUnique, boolean pRandom, double pDefaultValue, int pMinRandomValue, int pMaxRandomValue) {
        this.mFields[this.mNoOfFields++] = new TableField(pName, "FLOAT", false, pLength, -1, this.mNoOfFields, pKey, pRandom, Double.toString(pDefaultValue), pUnique, pMinRandomValue, pMaxRandomValue);
    }

    public void addInteger(String pName, boolean pKey, boolean pUnique, boolean pRandom, int pDefaultValue, int pMinRandomValue, int pMaxRandomValue) {
        this.mFields[this.mNoOfFields++] = new TableField(pName, "INTEGER", false, -1, -1, this.mNoOfFields, pKey, pRandom, Integer.toString(pDefaultValue), pUnique, pMinRandomValue, pMaxRandomValue);
    }

    public void addLong(String pName, boolean pRandom, String pDefaultValue) {
        this.mFields[this.mNoOfFields++] = new TableField(pName, "LONG", false, -1, -1, this.mNoOfFields, false, pRandom, pDefaultValue, false, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.mTableHasLong = true;
    }

    public void addLongBinary(String pName, boolean pRandom, String pDefaultValue) {
        this.mFields[this.mNoOfFields++] = new TableField(pName, "LONG", true, -1, -1, this.mNoOfFields, false, pRandom, pDefaultValue, false, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.mTableHasLong = true;
    }

    public void addTime(String pName, boolean pKey, boolean pUnique, boolean pRandom, String pDefaultValue, String pMinRandomValue, String pMaxRandomValue) {
        long lMin = Long.MIN_VALUE;
        long lMax = Long.MAX_VALUE;
        if (pMinRandomValue != null && pMinRandomValue.trim() != "") {
            lMin = Time.valueOf(pMinRandomValue).getTime();
        }
        if (pMaxRandomValue != null && pMaxRandomValue.trim() != "") {
            lMax = Time.valueOf(pMaxRandomValue).getTime();
        }
        this.mFields[this.mNoOfFields++] = new TableField(pName, "TIME", false, -1, -1, this.mNoOfFields, pKey, pRandom, pDefaultValue, pUnique, lMin, lMax);
    }

    public void addTimestamp(String pName, boolean pKey, boolean pUnique, boolean pRandom, String pDefaultValue, String pMinRandomValue, String pMaxRandomValue) {
        long lMin = Long.MIN_VALUE;
        long lMax = Long.MAX_VALUE;
        if (pMinRandomValue != null && pMinRandomValue.trim() != "") {
            lMin = Timestamp.valueOf(pMinRandomValue).getTime();
        }
        if (pMaxRandomValue != null && pMaxRandomValue.trim() != "") {
            lMax = Timestamp.valueOf(pMaxRandomValue).getTime();
        }
        this.mFields[this.mNoOfFields++] = new TableField(pName, "TIMESTAMP", false, -1, -1, this.mNoOfFields, pKey, pRandom, pDefaultValue, pUnique, lMin, lMax);
    }

    public void addVarchar(String pName, int pLength, boolean pKey, boolean pUnique, boolean pRandom, String pDefaultValue) {
        this.mFields[this.mNoOfFields++] = new TableField(pName, "VARCHAR", false, pLength, -1, this.mNoOfFields, pKey, pRandom, pDefaultValue, pUnique, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public void addVarcharBinary(String pName, int pLength, boolean pKey, boolean pUnique, boolean pRandom, String pDefaultValue) {
        this.mFields[this.mNoOfFields++] = new TableField(pName, "VARCHAR", true, pLength, -1, this.mNoOfFields, pKey, pRandom, pDefaultValue, pUnique, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public void create() throws SQLException {
        this.create(false);
    }

    public void create(boolean pDropIfExistent) throws SQLException {
        if (this.mName == null || this.mName.trim() == "") {
            return;
        }
        if (this.mNoOfFields == 0) {
            return;
        }
        if (this.mConnection == null) {
            return;
        }
        Statement lStmt = this.mConnection.createStatement();
        String lFieldList = "";
        String lPrimaryKeyList = "";
        String lForeignKeyList = "";
        for (int i = 0; i < this.mNoOfFields; ++i) {
            lFieldList = lFieldList + this.mFields[i].getName() + " " + this.mFields[i].getType();
            if (this.mFields[i].getLength() != -1) {
                lFieldList = lFieldList + "(" + this.mFields[i].getLength();
                if (this.mFields[i].getDecimals() != -1) {
                    lFieldList = lFieldList + "," + this.mFields[i].getDecimals();
                }
                lFieldList = lFieldList + ")";
            }
            if (this.mFields[i].getDefaultValue() != "") {
                lFieldList = lFieldList + " default " + this.mFields[i].getDefaultValue();
            }
            if (this.mFields[i].isByte()) {
                lFieldList = lFieldList + " byte";
            }
            if (i < this.mNoOfFields - 1) {
                lFieldList = lFieldList + ", ";
            }
            if (this.mFields[i].isPrimaryKey()) {
                lPrimaryKeyList = lPrimaryKeyList == "" ? this.mFields[i].getName() : lPrimaryKeyList + ", " + this.mFields[i].getName();
            }
            if (!this.mFields[i].isForeignKey()) continue;
            lForeignKeyList = lForeignKeyList == "" ? this.mFields[i].getName() : lForeignKeyList + ", " + this.mFields[i].getName();
        }
        String lSql = "";
        lSql = lSql + "create table " + this.mName + " ( " + lFieldList;
        if (lPrimaryKeyList != "") {
            lSql = lSql + ", primary key ( " + lPrimaryKeyList + " ) ";
        }
        if (lForeignKeyList != "") {
            lSql = lSql + ", foreign key ( " + lForeignKeyList + " ) ";
        }
        lSql = lSql + " ) ";
        try {
            if (pDropIfExistent) {
                try {
                    lStmt.executeUpdate("DROP TABLE " + this.mName);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            lStmt.executeUpdate(lSql);
            this.mConnection.commit();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -125) {
                lStmt.executeUpdate("ENABLE WRITE TRANSACTION");
                lStmt.executeUpdate(lSql);
                this.mConnection.commit();
            }
            throw e;
        }
    }

    public void createIndex(String pName, IndexField[] pFields, boolean pUnique, TestStatement pTStmt) throws SQLException {
        this.mIndexMap.put(pName, new Index(pName, this, pFields, pUnique));
        ((Index)this.mIndexMap.get(pName)).create(pTStmt);
    }

    public void createIndex(String pName, String[] pFields, boolean pUnique, TestStatement pTStmt) throws SQLException {
        this.mIndexMap.put(pName, new Index(pName, this, pFields, pUnique));
        ((Index)this.mIndexMap.get(pName)).create(pTStmt);
    }

    public void drop() throws SQLException {
        this.drop(true);
    }

    public void drop(boolean pThrowException) throws SQLException {
        block3: {
            if (this.mConnection == null) {
                return;
            }
            Statement lStmt = this.mConnection.createStatement();
            try {
                lStmt.executeUpdate("drop table " + this.mName);
            }
            catch (SQLException se) {
                if (!pThrowException) break block3;
                throw se;
            }
        }
    }

    public void dropIndex(String pName) throws SQLException {
        this.dropIndex(pName, true);
    }

    public void dropIndex(String pName, boolean pThrowException) throws SQLException {
        if (this.mConnection == null) {
            return;
        }
        Statement lStmt = this.mConnection.createStatement();
        Index lIndex = (Index)this.mIndexMap.get(pName);
        if (lIndex == null) {
            lIndex = new Index(pName, this, (String[])null, false);
        } else {
            this.mIndexMap.remove(pName);
        }
        lIndex.drop(lStmt, pThrowException);
    }

    public Connection getConnection() {
        return this.mConnection;
    }

    public TableField getField(int pIndex) {
        return this.mFields[pIndex];
    }

    public Set getIndexNames() {
        return this.mIndexMap.keySet();
    }

    public String getName() {
        return this.mName;
    }

    public int getNumberOfFields() {
        return this.mNoOfFields;
    }

    public RandomFieldValueGenerator getRandomGen() {
        return this.mRandomGen;
    }

    public boolean isTableHasLong() {
        return this.mTableHasLong;
    }

    public static void main(String[] args) {
        Table tt = null;
        try {
            tt = new Table("MyTab");
            tt.addDate("f0", true, true, true, "1998-12-12", "1998-12-12", "1999-03-31");
            tt.addTime("f0", true, true, true, "20:12:11", "20:20:20", "21:21:21");
            tt.addInteger("f0", false, true, true, 999, 0, 500);
            tt.addCharacter("k0", 12, true, true, false, "Key");
            tt.addVarchar("f1", 102, false, false, true, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tt == null) {
            System.out.println("NULL");
        }
    }

    public void randomInsert() throws SQLException {
        if (this.mConnection == null) {
            return;
        }
        if (this.mNoOfFields == 0) {
            return;
        }
        if (this.mInsertStatement == null) {
            String lHostVar = "";
            for (int i = 1; i <= this.mNoOfFields; ++i) {
                lHostVar = lHostVar + "?";
                if (i >= this.mNoOfFields) continue;
                lHostVar = lHostVar + ",";
            }
            String lSql = "insert into " + this.getName() + " values (" + lHostVar + ")";
            this.mInsertStatement = this.mConnection.prepareStatement(lSql);
        }
        for (int j = 0; j < this.mNoOfFields; ++j) {
            this.setFieldValue(this.mInsertStatement, this.getField(j));
        }
        this.mInsertStatement.execute();
    }

    public void setConnection(Connection newConnection) {
        this.mConnection = newConnection;
    }

    private final boolean setFieldValue(PreparedStatement pTestStmt, TableField pField) throws SQLException {
        TableField lField = pField;
        switch (lField.getTypeInternal()) {
            case -7: {
                pTestStmt.setBoolean(lField.getPosition(), this.getRandomGen().determineBoolean(lField));
                break;
            }
            case -6: {
                pTestStmt.setByte(lField.getPosition(), this.getRandomGen().determineByte(lField));
                break;
            }
            case 5: {
                pTestStmt.setShort(lField.getPosition(), this.getRandomGen().determineShort(lField));
                break;
            }
            case 4: {
                pTestStmt.setInt(lField.getPosition(), this.getRandomGen().determineInt(lField));
                break;
            }
            case -5: {
                pTestStmt.setLong(lField.getPosition(), this.getRandomGen().determineLong(lField));
                break;
            }
            case 6: {
                pTestStmt.setFloat(lField.getPosition(), this.getRandomGen().determineFloat(lField));
                break;
            }
            case 7: {
                pTestStmt.setFloat(lField.getPosition(), this.getRandomGen().determineFloat(lField));
                break;
            }
            case 8: {
                pTestStmt.setDouble(lField.getPosition(), this.getRandomGen().determineDouble(lField));
                break;
            }
            case 2: {
                pTestStmt.setBigDecimal(lField.getPosition(), this.getRandomGen().determineBigDecimal(lField));
                break;
            }
            case 3: {
                pTestStmt.setBigDecimal(lField.getPosition(), this.getRandomGen().determineBigDecimal(lField));
                break;
            }
            case 1: {
                pTestStmt.setString(lField.getPosition(), this.getRandomGen().determineString(lField));
                break;
            }
            case 12: {
                pTestStmt.setString(lField.getPosition(), this.getRandomGen().determineString(lField));
                break;
            }
            case -1: {
                DBInputStream dbi = this.getRandomGen().determineAsciiStream(lField);
                pTestStmt.setAsciiStream(lField.getPosition(), (InputStream)dbi.getBis(), dbi.getLen());
                try {
                    dbi.getBis().close();
                }
                catch (IOException e) {}
                break;
            }
            case 91: {
                pTestStmt.setDate(lField.getPosition(), this.getRandomGen().determineDate(lField));
                break;
            }
            case 92: {
                pTestStmt.setTime(lField.getPosition(), this.getRandomGen().determineTime(lField));
                break;
            }
            case 93: {
                pTestStmt.setTimestamp(lField.getPosition(), this.getRandomGen().determineTimestamp(lField));
                break;
            }
            case -2: {
                pTestStmt.setBytes(lField.getPosition(), this.getRandomGen().determineBytes(lField));
                break;
            }
            case -3: {
                pTestStmt.setBytes(lField.getPosition(), this.getRandomGen().determineBytes(lField));
                break;
            }
            case -4: {
                DBInputStream dbi = this.getRandomGen().determineBinaryStream(lField);
                pTestStmt.setBinaryStream(lField.getPosition(), (InputStream)dbi.getBis(), dbi.getLen());
                try {
                    dbi.getBis().close();
                }
                catch (IOException e) {}
                break;
            }
            case 0: {
                break;
            }
            case 1111: {
                pTestStmt.setNull(lField.getPosition(), 1111);
                break;
            }
            case 2000: {
                pTestStmt.setNull(lField.getPosition(), 2000);
                break;
            }
            case 2001: {
                pTestStmt.setNull(lField.getPosition(), 2001);
                break;
            }
            case 2002: {
                pTestStmt.setNull(lField.getPosition(), 2002);
                break;
            }
            case 2003: {
                pTestStmt.setNull(lField.getPosition(), 2003);
                break;
            }
            case 2004: {
                pTestStmt.setNull(lField.getPosition(), 2004);
                break;
            }
            case 2005: {
                pTestStmt.setNull(lField.getPosition(), 2005);
                break;
            }
            case 2006: {
                pTestStmt.setNull(lField.getPosition(), 2006);
                break;
            }
            default: {
                throw new RuntimeException("Unknown sql field type. Method TableFiller.fill");
            }
        }
        return true;
    }

    public void setName(String newName) {
        this.mName = newName;
    }

    public TestStatement updateStatistics(TestStatement pTStmt) throws SQLException {
        pTStmt.executeUpdate("update statistics " + this.getName());
        pTStmt.executeUpdate("update statistics column (*) for " + this.getName());
        return pTStmt;
    }
}

