/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.Table;
import com.sap.sapdb.testframe.utilities.TableFiller;
import java.sql.Connection;
import java.sql.SQLException;

public class RuntimeMeasurement {
    private int mTableEntries = -1;
    public static final char SIZE_SMALL = 'S';
    public static final char SIZE_LARGE = 'L';
    public static final char SIZE_MEDIUM = 'M';
    private Table mTable = null;
    private long mRuntime = -1L;
    private String mRuntimeTableName = "XYZRUNTIMEXYZ";
    private String sRuntimeUser = "XYZRUN";
    private String sRuntimePassword = "XYZRUN";

    public RuntimeMeasurement(TestCase pTestCase, TestDatabase pDatabase, char pSize) throws SQLException {
        this.mTableEntries = pSize == 'S' ? 5000 : (pSize == 'M' ? 20000 : 50000);
        this.measurement(pTestCase, pDatabase);
    }

    public RuntimeMeasurement(TestCase pTestCase, TestDatabase pDatabase) throws SQLException {
        this.measurement(pTestCase, pDatabase);
    }

    public void createMeasurementTable(TestCase pTestCase, TestDatabase pDatabase) throws SQLException {
        this.mTable = new Table(this.mRuntimeTableName);
        this.mTable.addInteger("a", true, true, false, 0, 0, 0);
        this.mTable.addCharacter("b", 20, true, false, false, "b_key_field");
        this.mTable.addTime("c", true, false, true, null, null, null);
        this.mTable.addFixed("d", 10, 4, false, false, true, 0.0f, 0, 100000);
        this.mTable.addVarchar("e", 80, false, false, true, null);
        this.mTable.addFloat("f", 12, false, false, true, 0.0, 999, 8888888);
        this.mTable.create();
        try {
            this.mTable.setConnection(pDatabase.connect());
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        try {
            TableFiller tf = new TableFiller(this.mTable, pTestCase, pDatabase, this.sRuntimeUser, this.sRuntimePassword, this.mTableEntries, 1 + this.mTableEntries / 10000);
            tf.start();
            tf.join();
            if (tf.hasError()) {
                throw new SQLException(tf.getException().getMessage());
            }
        }
        catch (InterruptedException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public final long getRuntime() {
        if (this.mRuntime == -1L) {
            throw new RuntimeException("Runtime measurement failed");
        }
        return this.mRuntime;
    }

    public void measurement(TestCase pTestCase, TestDatabase pDatabase) throws SQLException {
        Connection lCon = null;
        TestStatement lStmt = null;
        try {
            lCon = pDatabase.connect(pDatabase.getUser(), pDatabase.getPassword());
            lStmt = new TestStatement(pTestCase, lCon);
            lStmt.enableExceptions(false);
            lStmt.executeUpdate("create user " + this.sRuntimeUser + " password " + this.sRuntimePassword + " resource not exclusive");
            lStmt.close();
            lCon.close();
            lCon = pDatabase.connect(this.sRuntimeUser, this.sRuntimePassword);
            lStmt = new TestStatement(pTestCase, lCon);
            lStmt.enableExceptions(false);
            lStmt.executeQuery("select count(*) from " + this.mRuntimeTableName);
            if (this.mTableEntries != lStmt.getResultCounter()) {
                this.createMeasurementTable(pTestCase, pDatabase);
            }
            this.runMeasurement(lStmt);
        }
        catch (TestDatabaseException e) {
            throw new SQLException(e.getMessage());
        }
        finally {
            lStmt.close();
            lCon.commit();
            lCon.close();
        }
    }

    public void runMeasurement(TestStatement pStmt) throws SQLException {
        pStmt.enableExplain(false);
        pStmt.executeQuery("Select * from " + this.mRuntimeTableName);
        pStmt.executeQuery("Select * from " + this.mRuntimeTableName);
        if (pStmt.getResultCounter() != this.mTableEntries) {
            throw new SQLException("Full table scan of runtime measurement result in diffent table entries");
        }
        this.mRuntime = pStmt.getRuntime();
        pStmt.executeQuery("Select * from " + this.mRuntimeTableName);
        if (pStmt.getResultCounter() != this.mTableEntries) {
            throw new SQLException("Full table scan of runtime measurement result in diffent table entries");
        }
        this.mRuntime = (this.mRuntime + pStmt.getRuntime()) / 2L;
    }
}

