/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities;

import com.sap.dbtech.powertoys.DBM;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DBMFile {
    private DBM dbm = null;
    private Vector files = new Vector(10);

    public DBMFile(DBM dbm) throws IllegalArgumentException {
        if (dbm == null) {
            throw new IllegalArgumentException("Parameter <dbm> is null. Can't operate without a connection to a database manager.");
        }
        String fileList = null;
        try {
            fileList = dbm.cmd("file_getlist 1000");
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't retrieve list of available files via 'file_getlist'. Reply from DBM: \"" + ex.getMessage() + "\".");
        }
        try {
            Vector<String> fields = new Vector<String>(7);
            BufferedReader br = new BufferedReader(new StringReader(fileList));
            StringTokenizer stFields = new StringTokenizer(br.readLine(), ",", false);
            while (stFields.hasMoreTokens()) {
                fields.add(stFields.nextToken());
            }
            Vector<String> intfields = new Vector<String>();
            intfields.add("size");
            StreamTokenizer stFiles = new StreamTokenizer(br);
            stFiles.resetSyntax();
            stFiles.eolIsSignificant(true);
            stFiles.lowerCaseMode(false);
            stFiles.slashSlashComments(false);
            stFiles.slashStarComments(false);
            stFiles.wordChars(32, 126);
            stFiles.whitespaceChars(9, 9);
            int field = 0;
            DBMFileDescription cf = new DBMFileDescription();
            while (stFiles.nextToken() != -1) {
                if (stFiles.ttype == 10) {
                    this.files.add(cf);
                    cf = new DBMFileDescription();
                    field = 0;
                    continue;
                }
                String fieldName = (String)fields.elementAt(field);
                if (intfields.contains(fieldName)) {
                    Integer tmp = new Integer(stFiles.sval);
                    cf.setProperty(fieldName, tmp);
                } else {
                    cf.setProperty(fieldName, stFiles.sval);
                }
                ++field;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("I/O error while parsing list of available files: \"" + ex.getMessage() + "\".");
        }
        this.dbm = dbm;
    }

    public DBMFileDescription[] getFiles() {
        DBMFileDescription[] r = new DBMFileDescription[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            r[i] = (DBMFileDescription)this.files.elementAt(i);
        }
        return r;
    }

    public DBMFileInputStream getInputStream(String filekey) throws Exception {
        for (int i = 0; i < this.files.size(); ++i) {
            if (!((DBMFileDescription)this.files.elementAt(i)).getKeyname().equals(filekey)) continue;
            return new DBMFileInputStream(filekey);
        }
        throw new IllegalArgumentException("No file with key <" + filekey + "> available.");
    }

    public DBMFileInputStream getInputStream(DBMFileDescription file) throws Exception {
        return this.getInputStream(file.getKeyname());
    }

    public static class DBMFileDescription {
        protected Hashtable props = new Hashtable(7);

        public String getKeyname() {
            return this.getStringProp("keyname");
        }

        public void setKeyname(String s) {
            this.props.put("keyname", s);
        }

        public String getDate() {
            return this.getStringProp("date");
        }

        public void setDate(String s) {
            this.props.put("date", s);
        }

        public String getTime() {
            return this.getStringProp("time");
        }

        public void setTime(String s) {
            this.props.put("date", s);
        }

        public String getComment() {
            return this.getStringProp("comment");
        }

        public void setComment(String s) {
            this.props.put("comment", s);
        }

        public String getFilename() {
            return this.getStringProp("filename");
        }

        public void setFilename(String s) {
            this.props.put("filename", s);
        }

        public String getMode() {
            return this.getStringProp("mode");
        }

        public void setMode(String s) {
            this.props.put("mode", s);
        }

        public int getSize() {
            return this.getIntProp("size");
        }

        public void setSize(int n) {
            Integer i = new Integer(n);
            this.props.put("size", i);
        }

        protected String getStringProp(String key) {
            try {
                return (String)this.props.get(key);
            }
            catch (Exception ex) {
                return null;
            }
        }

        protected final int getIntProp(String key) {
            try {
                return (Integer)this.props.get(key);
            }
            catch (Exception ex) {
                return 0;
            }
        }

        public String toString() {
            return this.getFilename() + " (key: " + this.getKeyname() + ") comment: " + this.getComment() + " size: " + this.getSize();
        }

        public void setProperty(Object key, Object value) {
            this.props.put(key, value);
        }

        public Object getProperty(Object key) {
            return this.props.get(key);
        }
    }

    public class DBMFileInputStream
    extends InputStream {
        protected byte[] buf = null;
        protected int pos = 0;
        protected int handle = -1;
        protected int total = 0;
        protected boolean cont = false;
        protected String filekey = null;
        protected static final int S_HANDLE = 1;
        protected static final int S_CONTINUE = 2;
        protected static final int S_TOTAL_SIZE = 3;
        protected static final int S_PACKET_SIZE = 4;
        protected static final int S_END = 5;

        public DBMFileInputStream(String filekey) throws Exception {
            if (filekey == null) {
                throw new IllegalArgumentException("Parameter filekey is null.");
            }
            this.filekey = filekey;
            this.getfirst();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void getfirst() throws Exception {
            String reply = null;
            try {
                DBM dBM = DBMFile.this.dbm;
                synchronized (dBM) {
                    reply = DBMFile.this.dbm.cmd("file_getfirst " + this.filekey);
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Can't fetch file <" + this.filekey + ">: " + ex.getMessage());
            }
            this.fillBuffer(reply.getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void getnext() throws Exception {
            String reply = null;
            try {
                DBM dBM = DBMFile.this.dbm;
                synchronized (dBM) {
                    reply = DBMFile.this.dbm.cmd("file_getnext " + this.filekey + " " + this.handle);
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Can't fetch file <" + this.filekey + ">: " + ex.getMessage());
            }
            this.fillBuffer(reply.getBytes());
        }

        protected void fillBuffer(byte[] data) throws Exception {
            int he;
            int nlc = 0;
            for (he = 0; he < data.length && (data[he] != 10 || ++nlc < 3); ++he) {
            }
            String header = new String(data, 0, he);
            int state = 1;
            int psize = 0;
            try {
                StringTokenizer st = new StringTokenizer(header);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim();
                    switch (state) {
                        case 1: {
                            int rh = Integer.parseInt(token);
                            if (this.handle == -1) {
                                this.handle = rh;
                            } else if (this.handle != rh) {
                                throw new Exception("Expecting handle <" + this.handle + "> got <" + rh + ">");
                            }
                            state = 2;
                            break;
                        }
                        case 2: {
                            if (token.equals("CONTINUE")) {
                                this.cont = true;
                            } else if (token.equals("END")) {
                                this.cont = false;
                            } else {
                                throw new Exception("Expecting (CONTINUE | END) got <" + token + ">");
                            }
                            state = 3;
                            break;
                        }
                        case 3: {
                            if (this.total == 0) {
                                this.total = Integer.parseInt(token);
                            }
                            state = 4;
                            break;
                        }
                        case 4: {
                            psize = Integer.parseInt(token);
                            state = 5;
                            break;
                        }
                        case 5: {
                            throw new Exception("Unexpected token: <" + token + ">");
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new Exception("Error while parsing header: " + ex.getMessage());
            }
            if (state != 5) {
                throw new Exception("Corrupted header.");
            }
            this.buf = new byte[psize];
            this.pos = 0;
            System.arraycopy(data, he + 1, this.buf, 0, psize);
        }

        public int read() throws IOException {
            if (this.pos < this.buf.length) {
                --this.total;
                return this.buf[this.pos++] & 0xFF;
            }
            if (this.cont) {
                try {
                    this.getnext();
                }
                catch (Exception ex) {
                    throw new IOException(ex.getMessage());
                }
                return this.read();
            }
            this.total = 0;
            return -1;
        }

        public int available() {
            if (this.total < 0) {
                return this.buf.length;
            }
            return this.total;
        }
    }
}

