/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.test;

import com.sap.sdb.syncMan.test.TestConfig;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Wisconsin {
    private static final int STRINGLEN = 52;
    private static final int MIDCHARPOS = 27;
    private static final int FILLLENGTH = 200;
    private static final int NO_INT_ATTRIBUTES = 15;
    private static final int NO_OF_CHAR = 16;
    private static final int MAX_RAND_TRIES = 3;
    private static StringBuffer mBasisstring = new StringBuffer(53);
    private static StringBuffer mAlphabet = new StringBuffer(27);
    private static String mFillValue = "";
    private static String[] string4 = new String[4];
    private static long[][] mStorage = null;
    private static String[] mCharStorage = null;
    private static int mNumberOfRows = 0;
    private static int mMaxNumberOfRows = 0;
    private Connection mExclusiveConnection = null;
    private Statement mExclusiveStatement = null;
    private Connection mPrepExclusiveConnection = null;
    private PreparedStatement mPrepExclusiveStatement = null;
    private Random mRandomGenerator = new Random();
    TestConfig mTestConfig = null;

    public Wisconsin(String file, int rows) {
        try {
            this.mTestConfig = new TestConfig(file, null);
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
        catch (ParserConfigurationException pex) {
            System.out.println(pex.toString());
        }
        catch (SAXException sax) {
            System.out.println(sax.toString());
        }
        mMaxNumberOfRows = rows;
        mStorage = new long[rows][15];
        mCharStorage = new String[rows];
    }

    public static void main(String[] args) {
        String file = null;
        int rows = 0;
        try {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-f")) {
                    file = args[i + 1];
                    i += 2;
                    continue;
                }
                if (args[i].equals("-rows")) {
                    rows = Integer.parseInt(args[i + 1]);
                    i += 2;
                    continue;
                }
                System.out.println("unknown argument in command line at position " + (i + 1) + ": " + args[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Wisconsin w = new Wisconsin(file, rows);
        w.doit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doit() {
        block14: {
            Wisconsin.printInfo(1, "Wisconsin", "*************************************************");
            this.prepareInsertData();
            this.mExclusiveConnection = this.connectInternal(this.mTestConfig.getSourceJDBCDriver(), this.mTestConfig.getSourceDatabaseURL(), this.mTestConfig.getSourceUser(), this.mTestConfig.getSourcePassword());
            this.mPrepExclusiveConnection = this.connectInternal(this.mTestConfig.getSourceJDBCDriver(), this.mTestConfig.getSourceDatabaseURL(), this.mTestConfig.getSourceUser(), this.mTestConfig.getSourcePassword());
            System.out.println("Filling table ONEKTUP");
            mNumberOfRows = (int)((double)(mMaxNumberOfRows / 10) + 0.5);
            this.fillTable("ONEKTUP", 100);
            System.out.println("Filling table TENKTUP1");
            mNumberOfRows = (int)((double)mMaxNumberOfRows + 0.5);
            this.fillTable("TENKTUP1", 101);
            System.out.println("Filling table TENKTUP2");
            mNumberOfRows = (int)((double)mMaxNumberOfRows + 0.5);
            this.fillTable("TENKTUP2", 102);
            System.out.println("INSERT 1 tuple");
            this.insertOne(10000001L, "TENKTUP1", 26);
            this.insertOne(10000001L, "TENKTUP2", 26);
            this.insertOne(10000002L, "TENKTUP1", 26);
            this.insertOne(10000002L, "TENKTUP2", 26);
            this.insertOne(10000003L, "TENKTUP1", 26);
            this.insertOne(10000003L, "TENKTUP2", 26);
            this.insertOne(10000004L, "TENKTUP1", 26);
            this.insertOne(10000004L, "TENKTUP2", 26);
            this.insertOne(10000005L, "TENKTUP1", 26);
            this.insertOne(10000005L, "TENKTUP2", 26);
            System.out.println("DELETE 1 tuple");
            this.deleteOne("TENKTUP1", "UNIQUE2B", 10000001L, 27);
            this.deleteOne("TENKTUP2", "UNIQUE2C", 10000001L, 27);
            this.deleteOne("TENKTUP1", "UNIQUE2B", 10000002L, 27);
            this.deleteOne("TENKTUP2", "UNIQUE2C", 10000002L, 27);
            this.deleteOne("TENKTUP1", "UNIQUE2B", 10000003L, 27);
            this.deleteOne("TENKTUP2", "UNIQUE2C", 10000003L, 27);
            this.deleteOne("TENKTUP1", "UNIQUE2B", 10000004L, 27);
            this.deleteOne("TENKTUP2", "UNIQUE2C", 10000004L, 27);
            this.deleteOne("TENKTUP1", "UNIQUE2B", 10000005L, 27);
            this.deleteOne("TENKTUP2", "UNIQUE2C", 10000005L, 27);
            System.out.println("UPDATE 1 tuple");
            this.updateOne("TENKTUP1", "UNIQUE2B", 396900L, 10000001L, 28);
            this.updateOne("TENKTUP2", "UNIQUE2C", 396900L, 10000001L, 28);
            this.updateOne("TENKTUP1", "UNIQUE2B", 579900L, 10000002L, 28);
            this.updateOne("TENKTUP2", "UNIQUE2C", 579900L, 10000002L, 28);
            this.updateOne("TENKTUP1", "UNIQUE2B", 673900L, 10000003L, 28);
            this.updateOne("TENKTUP2", "UNIQUE2C", 673900L, 10000003L, 28);
            this.updateOne("TENKTUP1", "UNIQUE2B", 409800L, 10000004L, 28);
            this.updateOne("TENKTUP2", "UNIQUE2C", 409800L, 10000004L, 28);
            this.updateOne("TENKTUP1", "UNIQUE2B", 845700L, 10000005L, 28);
            this.updateOne("TENKTUP2", "UNIQUE2C", 845700L, 10000005L, 28);
            System.out.println("Reverse previous UPDATES");
            this.updateOne("TENKTUP1", "UNIQUE2B", 10000001L, 396900L, -1);
            this.updateOne("TENKTUP2", "UNIQUE2C", 10000001L, 396900L, -1);
            this.updateOne("TENKTUP1", "UNIQUE2B", 10000002L, 579900L, -1);
            this.updateOne("TENKTUP2", "UNIQUE2C", 10000002L, 579900L, -1);
            this.updateOne("TENKTUP1", "UNIQUE2B", 10000003L, 673900L, -1);
            this.updateOne("TENKTUP2", "UNIQUE2C", 10000003L, 673900L, -1);
            this.updateOne("TENKTUP1", "UNIQUE2B", 10000004L, 409800L, -1);
            this.updateOne("TENKTUP2", "UNIQUE2C", 10000004L, 409800L, -1);
            this.updateOne("TENKTUP1", "UNIQUE2B", 10000005L, 845700L, -1);
            this.updateOne("TENKTUP2", "UNIQUE2C", 10000005L, 845700L, -1);
            System.out.println("Create INDICES");
            this.createOneIndex("TENKTUP1", "TK1UQ1", "UNIQUE1B", "", 103);
            this.createOneIndex("TENKTUP1", "TK1THOUS", "THOUSANDB", "", 103);
            this.createOneIndex("TENKTUP2", "TK2UQ1", "UNIQUE1C", "", 103);
            this.createOneIndex("TENKTUP2", "TK2THOUS", "THOUSANDC", "", 103);
            System.out.println("INSERT");
            this.insertOne(10000001L, "TENKTUP1", 29);
            this.insertOne(10000001L, "TENKTUP2", 29);
            this.insertOne(10000002L, "TENKTUP1", 29);
            this.insertOne(10000002L, "TENKTUP2", 29);
            this.insertOne(10000003L, "TENKTUP1", 29);
            this.insertOne(10000003L, "TENKTUP2", 29);
            this.insertOne(10000004L, "TENKTUP1", 29);
            this.insertOne(10000004L, "TENKTUP2", 29);
            this.insertOne(10000005L, "TENKTUP1", 29);
            this.insertOne(10000005L, "TENKTUP2", 29);
            System.out.println("DELETE");
            this.deleteOne("TENKTUP1", "UNIQUE2B", 10000001L, 30);
            this.deleteOne("TENKTUP2", "UNIQUE2C", 10000001L, 30);
            this.deleteOne("TENKTUP1", "UNIQUE2B", 10000002L, 30);
            this.deleteOne("TENKTUP2", "UNIQUE2C", 10000002L, 30);
            this.deleteOne("TENKTUP1", "UNIQUE2B", 10000003L, 30);
            this.deleteOne("TENKTUP2", "UNIQUE2C", 10000003L, 30);
            this.deleteOne("TENKTUP1", "UNIQUE2B", 10000004L, 30);
            this.deleteOne("TENKTUP2", "UNIQUE2C", 10000004L, 30);
            this.deleteOne("TENKTUP1", "UNIQUE2B", 10000005L, 30);
            this.deleteOne("TENKTUP2", "UNIQUE2C", 10000005L, 30);
            System.out.println("UPDATE");
            this.updateOne("TENKTUP1", "UNIQUE2B", 396900L, 10000001L, 31);
            this.updateOne("TENKTUP2", "UNIQUE2C", 396900L, 10000001L, 31);
            this.updateOne("TENKTUP1", "UNIQUE2B", 579900L, 10000002L, 31);
            this.updateOne("TENKTUP2", "UNIQUE2C", 579900L, 10000002L, 31);
            this.updateOne("TENKTUP1", "UNIQUE2B", 673900L, 10000003L, 31);
            this.updateOne("TENKTUP2", "UNIQUE2C", 673900L, 10000003L, 31);
            this.updateOne("TENKTUP1", "UNIQUE2B", 409800L, 10000004L, 31);
            this.updateOne("TENKTUP2", "UNIQUE2C", 409800L, 10000004L, 31);
            this.updateOne("TENKTUP1", "UNIQUE2B", 845700L, 10000005L, 31);
            this.updateOne("TENKTUP2", "UNIQUE2C", 845700L, 10000005L, 31);
            System.out.println("Reverse UPDATES");
            this.updateOne("TENKTUP1", "UNIQUE2B", 10000001L, 396900L, -1);
            this.updateOne("TENKTUP2", "UNIQUE2C", 10000001L, 396900L, -1);
            this.updateOne("TENKTUP1", "UNIQUE2B", 10000002L, 579900L, -1);
            this.updateOne("TENKTUP2", "UNIQUE2C", 10000002L, 579900L, -1);
            this.updateOne("TENKTUP1", "UNIQUE2B", 10000003L, 673900L, -1);
            this.updateOne("TENKTUP2", "UNIQUE2C", 10000003L, 673900L, -1);
            this.updateOne("TENKTUP1", "UNIQUE2B", 10000004L, 409800L, -1);
            this.updateOne("TENKTUP2", "UNIQUE2C", 10000004L, 409800L, -1);
            this.updateOne("TENKTUP1", "UNIQUE2B", 10000005L, 845700L, -1);
            this.updateOne("TENKTUP2", "UNIQUE2C", 10000005L, 845700L, -1);
            System.out.println("UPDATE");
            this.updateOne("TENKTUP1", "UNIQUE1B", 396900L, 10000001L, 32);
            this.updateOne("TENKTUP2", "UNIQUE1C", 396900L, 10000001L, 32);
            this.updateOne("TENKTUP1", "UNIQUE1B", 579900L, 10000002L, 32);
            this.updateOne("TENKTUP2", "UNIQUE1C", 579900L, 10000002L, 32);
            this.updateOne("TENKTUP1", "UNIQUE1B", 673900L, 10000003L, 32);
            this.updateOne("TENKTUP2", "UNIQUE1C", 673900L, 10000003L, 32);
            this.updateOne("TENKTUP1", "UNIQUE1B", 409800L, 10000004L, 32);
            this.updateOne("TENKTUP2", "UNIQUE1C", 409800L, 10000004L, 32);
            this.updateOne("TENKTUP1", "UNIQUE1B", 845700L, 10000005L, 32);
            this.updateOne("TENKTUP2", "UNIQUE1C", 845700L, 10000005L, 32);
            System.out.println("Reverse UPDATES");
            this.updateOne("TENKTUP1", "UNIQUE1B", 10000001L, 396900L, -1);
            this.updateOne("TENKTUP2", "UNIQUE1C", 10000001L, 396900L, -1);
            this.updateOne("TENKTUP1", "UNIQUE1B", 10000002L, 579900L, -1);
            this.updateOne("TENKTUP2", "UNIQUE1C", 10000002L, 579900L, -1);
            this.updateOne("TENKTUP1", "UNIQUE1B", 10000003L, 673900L, -1);
            this.updateOne("TENKTUP2", "UNIQUE1C", 10000003L, 673900L, -1);
            this.updateOne("TENKTUP1", "UNIQUE1B", 10000004L, 409800L, -1);
            this.updateOne("TENKTUP2", "UNIQUE1C", 10000004L, 409800L, -1);
            this.updateOne("TENKTUP1", "UNIQUE1B", 10000005L, 845700L, -1);
            this.updateOne("TENKTUP2", "UNIQUE1C", 10000005L, 845700L, -1);
            System.out.println("Drop INDICES");
            this.dropOneIndex("TENKTUP1", "TK1UQ1", 104);
            this.dropOneIndex("TENKTUP1", "TK1THOUS", 104);
            this.dropOneIndex("TENKTUP2", "TK2UQ1", 104);
            this.dropOneIndex("TENKTUP2", "TK2THOUS", 104);
            Object var3_1 = null;
            try {
                this.mExclusiveStatement.close();
                this.mPrepExclusiveStatement.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                this.mExclusiveConnection.commit();
                this.mExclusiveConnection.close();
                this.mPrepExclusiveConnection.commit();
                this.mPrepExclusiveConnection.close();
            }
            catch (Exception e2) {}
            break block14;
            {
                catch (Exception e) {
                    System.out.println("Method run Exception: " + e.getClass() + e.getMessage());
                    Object var3_2 = null;
                    try {
                        this.mExclusiveStatement.close();
                        this.mPrepExclusiveStatement.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        this.mExclusiveConnection.commit();
                        this.mExclusiveConnection.close();
                        this.mPrepExclusiveConnection.commit();
                        this.mPrepExclusiveConnection.close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    this.mExclusiveStatement.close();
                    this.mPrepExclusiveStatement.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    this.mExclusiveConnection.commit();
                    this.mExclusiveConnection.close();
                    this.mPrepExclusiveConnection.commit();
                    this.mPrepExclusiveConnection.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void fillTable(String pTableName, int pQueryNo) {
        String lSqlString = "";
        this.fillColumn(1, mNumberOfRows);
        this.fillColumn(2, 2);
        this.fillColumn(3, 4);
        this.fillColumn(4, 10);
        this.fillColumn(5, 20);
        this.fillColumn(6, 100);
        this.fillColumn(7, 1000);
        this.fillColumn(8, 2000);
        this.fillColumn(9, 5000);
        this.fillColumn(10, 10000);
        this.fillColumn(11, 50);
        this.fillColumn(12, 50);
        this.fillColumn(13, 4);
        this.fillLikeColumn(22);
        try {
            lSqlString = "insert " + pTableName + " values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            this.mPrepExclusiveStatement = this.mPrepExclusiveConnection.prepareStatement(lSqlString);
            for (int k = 0; k <= mNumberOfRows - 1; ++k) {
                this.mPrepExclusiveStatement.setLong(1, k * 100);
                this.mPrepExclusiveStatement.setLong(2, mStorage[k][0]);
                this.mPrepExclusiveStatement.setLong(3, mStorage[k][1]);
                this.mPrepExclusiveStatement.setLong(4, mStorage[k][2]);
                this.mPrepExclusiveStatement.setLong(5, mStorage[k][3]);
                this.mPrepExclusiveStatement.setLong(6, mStorage[k][4]);
                this.mPrepExclusiveStatement.setLong(7, mStorage[k][5]);
                this.mPrepExclusiveStatement.setLong(8, mStorage[k][6]);
                this.mPrepExclusiveStatement.setLong(9, mStorage[k][7]);
                this.mPrepExclusiveStatement.setLong(10, mStorage[k][8]);
                this.mPrepExclusiveStatement.setLong(11, mStorage[k][9]);
                this.mPrepExclusiveStatement.setLong(12, mStorage[k][10] * 2L + 1L);
                this.mPrepExclusiveStatement.setLong(13, mStorage[k][11] * 2L);
                this.mPrepExclusiveStatement.setString(14, mCharStorage[k]);
                StringBuffer lUniqueString = Wisconsin.getScalableUniqueString((int)mStorage[k][0]);
                this.mPrepExclusiveStatement.setString(15, lUniqueString.toString());
                lUniqueString = Wisconsin.getScalableUniqueString(k);
                this.mPrepExclusiveStatement.setString(16, lUniqueString.toString());
                this.mPrepExclusiveStatement.setString(17, string4[k % 4]);
                this.mPrepExclusiveStatement.setString(18, mFillValue);
                this.mPrepExclusiveStatement.setString(19, " ");
                this.mPrepExclusiveStatement.execute();
                if ((k + 1) % mNumberOfRows != 0) continue;
                this.mPrepExclusiveConnection.commit();
            }
            this.mPrepExclusiveStatement.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void deleteOne(String pTab, String pFieldName, long pFieldVal, int pQueryNo) {
        String lSqlString = "";
        try {
            lSqlString = "DELETE FROM " + pTab + " WHERE " + pFieldName + " = " + pFieldVal;
            this.mPrepExclusiveStatement = this.mPrepExclusiveConnection.prepareStatement(lSqlString);
            this.mPrepExclusiveStatement.executeUpdate();
            this.mPrepExclusiveConnection.commit();
            this.mPrepExclusiveStatement.close();
        }
        catch (Exception e) {
            System.out.println("deleteOne() -- ERROR during DELETE: " + e.getClass() + e.getMessage());
        }
    }

    private void updateOne(String pTab, String pFieldName, long pFieldVal, long pNewVal, int pQueryNo) {
        String lSqlString = "";
        try {
            lSqlString = "UPDATE " + pTab + " SET " + pFieldName + " = " + pNewVal + " WHERE " + pFieldName + " = " + pFieldVal;
            this.mPrepExclusiveStatement = this.mPrepExclusiveConnection.prepareStatement(lSqlString);
            this.mPrepExclusiveStatement.executeUpdate();
            this.mPrepExclusiveConnection.commit();
            if (pQueryNo != -1) {
                // empty if block
            }
            this.mPrepExclusiveStatement.close();
        }
        catch (Exception e) {
            System.out.println("updateOne() -- ERROR during UPDATE: " + e.getClass() + e.getMessage());
        }
    }

    private void insertOne(long pUnique2, String pTab, int pQueryNo) {
        String lSqlString = "";
        String lStringl = "ABCDEFGHIJKLMNOP";
        String lStringu1 = "MxxxxxxxxxxxxxxxxxxxxxxxxxGxxxxxxxxxxxxxxxxxxxxxxxxC";
        String lStringu2 = "GxxxxxxxxxxxxxxxxxxxxxxxxxCxxxxxxxxxxxxxxxxxxxxxxxxA";
        String lString4 = "OxxxxxxxxxxxxxxxxxxxxxxxxxOxxxxxxxxxxxxxxxxxxxxxxxxO";
        try {
            lSqlString = "INSERT INTO " + pTab + " VALUES (" + pUnique2 + ", 10100, 0, 2, 5, 10, 68, 688, 1950, 4950, 9950, 1, 100, '" + lStringl + "', '" + lStringu1 + "', '" + lStringu2 + "', '" + lString4 + "', ' ', ' ')";
            this.mPrepExclusiveStatement = this.mPrepExclusiveConnection.prepareStatement(lSqlString);
            this.mPrepExclusiveStatement.executeUpdate();
            this.mPrepExclusiveConnection.commit();
            lSqlString = "INSERT INTO " + pTab + " VALUES (" + pUnique2 + ", 10100, 0, 2, 5, 10, 68, 688, 1950, 4950, 9950, 1, 100, ...)";
            this.mPrepExclusiveStatement.close();
        }
        catch (Exception e) {
            System.out.println("insertOne() -- ERROR during INSERT: " + e.getClass() + e.getMessage());
        }
    }

    private void prepareInsertData() {
        int i;
        for (i = 0; i <= 51; ++i) {
            mBasisstring = mBasisstring.append("x");
        }
        for (i = 0; i <= 199; ++i) {
            mFillValue = mFillValue + "x";
        }
        for (i = 0; i <= 3; ++i) {
            mBasisstring.setCharAt(0, (char)(65 + i * 7));
            mBasisstring.setCharAt(26, (char)(65 + i * 7));
            mBasisstring.setCharAt(51, (char)(65 + i * 7));
            Wisconsin.string4[i] = mBasisstring.toString();
        }
        mAlphabet.append("ABCDEFGHIJKLMNOPQRSTUV");
        Wisconsin.printInfo(2, "prepareInsertData()", ": Preparing data to be INSERTed");
    }

    private void createOneIndex(String pTableName, String pIndexName, String pColumn, String pUniqueInd, int pQueryNo) {
        try {
            String lSqlString = "CREATE " + pUniqueInd + " INDEX " + pIndexName + " ON " + pTableName + " (" + pColumn + ")";
            this.mPrepExclusiveStatement = this.mPrepExclusiveConnection.prepareStatement(lSqlString);
            this.mPrepExclusiveStatement.execute();
            this.mPrepExclusiveConnection.commit();
            this.mPrepExclusiveStatement.close();
        }
        catch (SQLException se) {
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void dropOneIndex(String pTableName, String pIndexName, int pQueryNo) {
        try {
            String lSqlString = "DROP INDEX " + pIndexName;
            this.mPrepExclusiveStatement = this.mPrepExclusiveConnection.prepareStatement(lSqlString);
            this.mPrepExclusiveStatement.execute();
            this.mPrepExclusiveConnection.commit();
            this.mPrepExclusiveStatement.close();
        }
        catch (SQLException se) {
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void fillColumn(int pColumn, int pValueRange) {
        int[] lOccurrence = new int[mMaxNumberOfRows + 1];
        for (int i = 0; i <= mNumberOfRows; ++i) {
            lOccurrence[i] = 0;
        }
        long lMaxSameNumber = pValueRange >= mNumberOfRows ? 1L : (long)((mNumberOfRows - 1) / pValueRange + 1);
        for (int lRow = 1; lRow <= mNumberOfRows; ++lRow) {
            boolean lFound = false;
            int lRandNumber = this.randomInteger(0, pValueRange - 1);
            for (long lRandTries = 0L; lRandTries < 3L && !lFound; ++lRandTries) {
                if ((long)lOccurrence[lRandNumber] < lMaxSameNumber) {
                    lFound = true;
                    continue;
                }
                lRandNumber = this.randomInteger(0, pValueRange - 1);
            }
            while (!lFound) {
                if (++lRandNumber == pValueRange) {
                    lRandNumber = 0;
                }
                if ((long)lOccurrence[lRandNumber] >= lMaxSameNumber) continue;
                lFound = true;
            }
            Wisconsin.mStorage[lRow - 1][pColumn - 1] = lRandNumber;
            int n = lRandNumber;
            lOccurrence[n] = lOccurrence[n] + 1;
        }
    }

    private void fillLikeColumn(int pValueRange) {
        String lString = "";
        int lRandNumber = this.randomInteger(0, pValueRange - 1);
        for (int row = 1; row <= mNumberOfRows; ++row) {
            int column;
            for (column = 1; column <= 2; ++column) {
                lRandNumber = this.randomInteger(0, 3);
                lString = lString + mAlphabet.charAt(lRandNumber);
            }
            for (column = 3; column <= 16; ++column) {
                lRandNumber = this.randomInteger(0, pValueRange - 1);
                lString = lString + mAlphabet.charAt(lRandNumber);
            }
            Wisconsin.mCharStorage[row - 1] = lString;
            lString = "";
        }
    }

    private static StringBuffer getScalableUniqueString(int pModValue) {
        StringBuffer lTemp = new StringBuffer(7).append("AAAAAAA");
        String l45Xes = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        int i = 6;
        int cnt = 0;
        while (pModValue > 0) {
            int rem = pModValue % 26;
            lTemp.setCharAt(i, (char)(65 + rem));
            pModValue /= 26;
            --i;
            ++cnt;
        }
        StringBuffer lUniqueString = new StringBuffer(53).append(lTemp.toString()).append(l45Xes);
        return lUniqueString;
    }

    private static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 >= Integer.MIN_VALUE) {
            System.out.println(pComponent + " --> " + pInfoText);
        }
    }

    private int randomInteger(int pMinValue, int pMaxValue) {
        return (int)((double)this.mRandomGenerator.nextFloat() * (double)(pMaxValue - pMinValue + 1)) + pMinValue;
    }

    private Connection connectInternal(String jdbcDriver, String databaseURL, String user, String password) throws SQLException {
        Connection connection = null;
        try {
            Class.forName(jdbcDriver);
            connection = DriverManager.getConnection(databaseURL, user, password);
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
        }
        catch (ClassNotFoundException ex) {
            throw new SQLException(ex.toString());
        }
        return connection;
    }

    static class AsciiStream
    extends InputStream {
        protected long size;
        protected long position;

        public AsciiStream(long size) {
            this.size = size;
            this.position = 0L;
        }

        public int available() throws IOException {
            return (int)(this.size - this.position);
        }

        public void close() {
        }

        public void mark(int readlimit) {
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            if (this.position >= this.size) {
                return -1;
            }
            byte result = this.currentByte();
            ++this.position;
            return result;
        }

        public byte currentByte() {
            return (byte)(48 + (byte)(this.position % 10L));
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            long result = Math.min((long)len, this.size - this.position);
            if (result == 0L) {
                return -1;
            }
            int i = 0;
            while ((long)i < result) {
                b[off + i] = this.currentByte();
                ++this.position;
                ++i;
            }
            return (int)result;
        }

        public void reset() throws IOException {
            this.position = 0L;
        }

        public long skip(long count) throws IOException {
            long result = Math.min(count, this.size - this.position);
            this.position += count;
            return result;
        }

        public static void main(String[] args) throws IOException {
            long streamLen = Long.valueOf(args[0]);
            AsciiStream stream = new AsciiStream(streamLen);
            byte[] buf = new byte[1024];
            boolean atEnd = false;
            int pos = 0;
            while (!atEnd) {
                int chunkSize = stream.read(buf);
                if (chunkSize == 0) {
                    atEnd = true;
                    continue;
                }
                System.out.println("at " + (pos += chunkSize) + " of " + streamLen);
            }
        }

        public long getPosition() {
            return this.position;
        }

        public String toString() {
            return "<generators.AsciiStream (" + this.size + ")>";
        }
    }
}

