/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.test;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class ApplicationParam {
    private Properties m_prop;
    private String[] m_paramList;
    private LinkedList m_additionalHelp;
    private LinkedList m_additionalBoolParam;
    private LinkedList m_additionalStringParam;
    private boolean m_getDriverAndURL = false;
    private boolean m_getUser = false;
    static final String PARAM_DRIVER = "driver";
    static final String PARAM_PASSWORD = "password";
    static final String PARAM_URL = "url";
    static final String PARAM_USER = "user";
    static final String DEFAULT_DRIVER = "com.sap.dbtech.jdbc.DriverSapDB";
    static final String DEFAULT_URL = "jdbc:sapdb://127.0.0.1/DBMASTER";

    ApplicationParam(String[] paramList) {
        this.m_paramList = paramList;
        this.m_prop = new Properties();
        this.m_additionalHelp = new LinkedList();
        this.m_additionalBoolParam = new LinkedList();
        this.m_additionalStringParam = new LinkedList();
    }

    private boolean additionalBoolParamFound(int paramIndex) {
        if (this.m_additionalBoolParam.size() < 1) {
            return false;
        }
        Iterator iter = this.m_additionalBoolParam.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!this.m_paramList[paramIndex].equalsIgnoreCase("-" + name)) continue;
            this.m_prop.put(name, "true");
            return true;
        }
        return false;
    }

    private boolean additionalStringParamFound(int paramIndex) {
        if (this.m_additionalStringParam.size() < 1) {
            return false;
        }
        Iterator iter = this.m_additionalStringParam.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!this.m_paramList[paramIndex].equalsIgnoreCase("-" + name)) continue;
            this.m_prop.put(name, this.m_paramList[paramIndex + 1]);
            return true;
        }
        return false;
    }

    boolean createProperties() {
        if (this.m_paramList.length > 0 && (this.m_paramList[0].equalsIgnoreCase("-help") || this.m_paramList[0].equalsIgnoreCase("-h") || this.m_paramList[0].equals("?"))) {
            System.out.println();
            System.out.println("optional application parameters:");
            System.out.println();
            this.displayHelpInfo(this.m_getDriverAndURL, PARAM_DRIVER, "JDBCDriverClass");
            this.displayHelpInfo(this.m_getDriverAndURL, PARAM_URL, "databaseURL");
            this.displayHelpInfo(this.m_getUser, PARAM_USER, "userName");
            this.displayHelpInfo(this.m_getUser, PARAM_PASSWORD, PARAM_PASSWORD);
            if (this.m_additionalHelp.size() > 0) {
                Iterator iter = this.m_additionalHelp.iterator();
                while (iter.hasNext()) {
                    System.out.println(iter.next());
                }
            }
            System.out.println();
            return false;
        }
        boolean isOK = true;
        int i = 0;
        while (i < this.m_paramList.length) {
            if (this.additionalBoolParamFound(i)) {
                ++i;
                continue;
            }
            if (i + 1 >= this.m_paramList.length) {
                isOK = false;
                System.out.println("*** unknown option: '" + this.m_paramList[i] + "'");
                break;
            }
            if (this.m_paramList[i].equalsIgnoreCase("-driver")) {
                this.m_prop.put(PARAM_DRIVER, this.m_paramList[++i]);
            } else if (this.m_paramList[i].equalsIgnoreCase("-url")) {
                this.m_prop.put(PARAM_URL, this.m_paramList[++i]);
            } else if (this.m_getUser && this.m_paramList[i].equalsIgnoreCase("-user")) {
                this.m_prop.put(PARAM_USER, this.m_paramList[++i]);
            } else if (this.m_getUser && this.m_paramList[i].equalsIgnoreCase("-password")) {
                this.m_prop.put(PARAM_PASSWORD, this.m_paramList[++i]);
            } else if (this.additionalStringParamFound(i)) {
                ++i;
            } else {
                isOK = false;
                System.out.println("*** unknown option: '" + this.m_paramList[i] + "'");
            }
            ++i;
        }
        if (!isOK) {
            return false;
        }
        if (this.m_getDriverAndURL && !this.loadJDBCDriver(PARAM_DRIVER)) {
            return false;
        }
        this.m_paramList = null;
        this.m_additionalHelp = null;
        this.m_additionalBoolParam = null;
        this.m_additionalStringParam = null;
        return true;
    }

    void defineBoolParam(String propName, String helpInfo) {
        if (propName == null) {
            return;
        }
        this.m_additionalBoolParam.addLast(propName);
        if (helpInfo == null) {
            this.m_additionalHelp.addLast("   -" + propName);
        } else {
            this.m_additionalHelp.addLast("   -" + propName + " // " + helpInfo);
        }
    }

    void defineParam(String propName, String paramValueName, String defaultValue) {
        if (propName == null) {
            return;
        }
        this.m_additionalStringParam.addLast(propName);
        if (defaultValue != null) {
            this.m_prop.put(propName, defaultValue);
        }
        this.m_additionalHelp.addLast(this.getHelpInfo(propName, paramValueName));
    }

    private void displayHelpInfo(boolean wanted, String propName, String paramValueName) {
        if (wanted) {
            System.out.println(this.getHelpInfo(propName, paramValueName));
        }
    }

    void enableParamDriverAndURL() {
        this.m_getDriverAndURL = true;
        this.m_prop.put(PARAM_DRIVER, DEFAULT_DRIVER);
        this.m_prop.put(PARAM_URL, DEFAULT_URL);
    }

    void enableParamUser(String defaultUser, String defaultPassword) {
        this.m_getUser = true;
        if (defaultUser != null) {
            this.m_prop.put(PARAM_USER, defaultUser);
        }
        if (defaultPassword != null) {
            this.m_prop.put(PARAM_PASSWORD, defaultPassword);
        }
    }

    private static String fill(String s, int minLength) {
        int maxFill;
        String filler = "........................................";
        int n = maxFill = minLength > filler.length() ? filler.length() : minLength;
        if (s == null || s.length() == 0) {
            return filler.substring(0, maxFill);
        }
        if (s.length() >= maxFill) {
            return s;
        }
        return s + filler.substring(s.length(), maxFill);
    }

    boolean getBoolean(String propName) {
        return this.m_prop.getProperty(propName) != null;
    }

    String getDriver() {
        return this.m_prop.getProperty(PARAM_DRIVER);
    }

    private String getHelpInfo(String propName, String paramValueName) {
        String defaultValue;
        String line = "   -" + propName;
        if (paramValueName != null) {
            line = line + " <" + paramValueName + ">";
        }
        if ((defaultValue = this.m_prop.getProperty(propName)) != null) {
            while (line.length() < 35) {
                line = line + " ";
            }
            line = line + " // default: " + defaultValue;
        }
        return line;
    }

    int getInt(String propName) {
        String value = this.m_prop.getProperty(propName);
        return value == null ? 0 : Integer.parseInt(value);
    }

    String getPassword() {
        return this.m_prop.getProperty(PARAM_PASSWORD);
    }

    String getString(String propName) {
        return this.m_prop.getProperty(propName);
    }

    String getUser() {
        return this.m_prop.getProperty(PARAM_USER);
    }

    String getURL() {
        return this.m_prop.getProperty(PARAM_URL);
    }

    boolean loadJDBCDriver(String paramDriver) {
        try {
            Class.forName(this.m_prop.getProperty(paramDriver));
            return true;
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex.toString());
            return false;
        }
    }

    void printParameters(String[] skipParamList) {
        String paramName;
        Map.Entry<Object, Object> currEntry;
        if (this.m_prop.size() == 0) {
            System.out.println("Application parameters not specified");
            return;
        }
        System.out.println("Application parameters:");
        TreeMap<String, Object> sortedList = new TreeMap<String, Object>();
        int maxNameLength = 0;
        Iterator<Map.Entry<Object, Object>> iter = this.m_prop.entrySet().iterator();
        while (iter.hasNext()) {
            currEntry = iter.next();
            paramName = (String)currEntry.getKey();
            if (skipParamList != null) {
                boolean skipEnrty = false;
                for (int i = 0; i < skipParamList.length; ++i) {
                    if (paramName.indexOf(skipParamList[i]) < 0) continue;
                    skipEnrty = true;
                    break;
                }
                if (skipEnrty) continue;
            }
            sortedList.put(paramName, currEntry.getValue());
            if (paramName.length() <= maxNameLength) continue;
            maxNameLength = paramName.length();
        }
        iter = sortedList.entrySet().iterator();
        while (iter.hasNext()) {
            currEntry = iter.next();
            paramName = (String)currEntry.getKey();
            String value = (String)currEntry.getValue();
            System.out.println("   " + ApplicationParam.fill(paramName, maxNameLength) + ": " + value);
        }
    }
}

