/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;

public class TransactionTopicPublisher
implements ExceptionListener {
    private TopicSession myPubSession;
    private TopicPublisher myPublisher;
    private TopicConnection myConnection;
    private String myUserName;

    public TransactionTopicPublisher(String topicName, String username, String password) throws Exception {
        this.myUserName = username;
        InitialContext jndi = null;
        try {
            jndi = new InitialContext();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        TopicConnectionFactory conFactory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
        this.myConnection = conFactory.createTopicConnection(username, password);
        this.myPubSession = this.myConnection.createTopicSession(true, 1);
        Topic chatTopic = (Topic)jndi.lookup("jms.topic." + topicName);
        this.myPublisher = this.myPubSession.createPublisher(chatTopic);
        this.myConnection.setExceptionListener((ExceptionListener)this);
        try {
            this.myConnection.start();
        }
        catch (Exception ex) {
            this.myConnection.close();
            throw ex;
        }
    }

    public void onException(JMSException jsme) {
        this.exit();
    }

    protected void writeMessage(String text) throws JMSException {
        TextMessage message = this.myPubSession.createTextMessage();
        message.setText(this.myUserName + " : " + text);
        this.myPublisher.publish((Message)message);
        System.out.println(message.getText());
    }

    protected void writeMessages() {
        boolean commit = true;
        try {
            for (int sentMessages = 1; sentMessages <= 100; ++sentMessages) {
                this.writeMessage(Integer.toString(sentMessages));
                if (commit) {
                    if (sentMessages % 10 != 0) continue;
                    this.myPubSession.commit();
                    commit = false;
                    continue;
                }
                if (sentMessages % 10 != 0) continue;
                this.myPubSession.rollback();
                commit = true;
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    public void close() throws JMSException {
        this.myConnection.close();
    }

    private void exit() {
        try {
            this.myConnection.close();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        TransactionTopicPublisher aTTB = null;
        try {
            if (args.length != 3) {
                System.out.println("Topic or username missing");
            }
            aTTB = new TransactionTopicPublisher(args[0], args[1], args[2]);
            aTTB.writeMessages();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error e) {
            System.out.println("Attention!!! Unhandled Error!");
            e.printStackTrace();
        }
        try {
            if (aTTB != null) {
                aTTB.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

