/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TransactionQueueReceiver
implements MessageListener,
ExceptionListener {
    private QueueConnection qConnect = null;
    private QueueSession qSession = null;
    private Queue receiveQueue = null;
    private int myMessagesReceived = 0;
    private int myMessagesToReceive = 0;
    private boolean myCommit = true;
    private long myRedelivered = 0L;
    private long myRollback = 0L;

    public TransactionQueueReceiver(String queueName, String messagesToReceive) {
        try {
            this.myMessagesToReceive = Integer.parseInt(messagesToReceive);
            QueueConnectionFactory qFactory = null;
            InitialContext jndi = null;
            jndi = new InitialContext();
            qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
            this.qConnect = qFactory.createQueueConnection("", "");
            this.qSession = this.qConnect.createQueueSession(true, 1);
            this.receiveQueue = (Queue)jndi.lookup("jms.queue." + queueName);
            QueueReceiver qReceiver = this.qSession.createReceiver(this.receiveQueue);
            qReceiver.setMessageListener((MessageListener)this);
            this.qConnect.setExceptionListener((ExceptionListener)this);
            this.qConnect.start();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        System.out.println("Exit Receiver due to: " + jsme.toString());
        this.exit();
    }

    public void onMessage(Message message) {
        ++this.myMessagesReceived;
        try {
            TextMessage textMessage = (TextMessage)message;
            String text = textMessage.getText();
            String out = "Received ";
            if (textMessage.getJMSRedelivered()) {
                out = out + "and redelivered: ";
            }
            if (this.myCommit) {
                if (this.myMessagesReceived % 10 == 0) {
                    try {
                        this.qSession.commit();
                    }
                    catch (JMSException jmse) {
                        jmse.printStackTrace();
                    }
                    this.myCommit = false;
                }
            } else if (this.myMessagesReceived % 10 == 0) {
                try {
                    this.qSession.rollback();
                }
                catch (JMSException jmse) {
                    jmse.printStackTrace();
                }
                this.myCommit = true;
            }
            if (text.length() > 64) {
                System.out.println(out + text.substring(0, 64));
            } else {
                System.out.println(out + text);
            }
            if (this.myMessagesReceived == this.myMessagesToReceive) {
                Date end = new Date();
                System.out.println("Last Message received: " + text + " at " + end.toString());
                System.out.println("Rollback:" + this.myRollback + ",Redelivered:" + this.myRedelivered);
                this.exit();
            }
        }
        catch (Exception rte) {
            rte.printStackTrace();
        }
    }

    public void exit() {
        try {
            this.qConnect.close();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 2) {
            System.out.println("QueueName or Messagenumber missing");
        }
        TransactionQueueReceiver qr = new TransactionQueueReceiver(argv[0], argv[1]);
        System.out.println("TransactionQueueReceiver application started. Stop with 'exit'");
        boolean end = false;
        while (!end) {
            try {
                BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                String s = stdin.readLine();
                if (!s.equals("exit")) continue;
                qr.exit();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

