/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.util.Date;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SeqQueueSender
extends Thread
implements ExceptionListener {
    private QueueConnection[] myConnection;
    private QueueSession[] qSession;
    private QueueSender[] qSender;
    private Queue[] sendQueue;
    TextMessage[] myTextMsg;
    private int myMessagesToSend = 0;
    private int mySentMessages = 0;
    private int myPriority = 0;
    private int myDeliverMode = 0;
    private int mySenderCount = 0;

    public SeqQueueSender(String senderCount, String queueName, String priority, String messagesToSend, String persistent) {
        try {
            this.mySenderCount = Integer.parseInt(senderCount);
            this.myPriority = Integer.parseInt(priority);
            this.myMessagesToSend = Integer.parseInt(messagesToSend);
            this.myPriority = Integer.parseInt(priority);
            this.myDeliverMode = persistent.equalsIgnoreCase("persistent") ? 2 : 1;
            QueueConnectionFactory qFactory = null;
            InitialContext jndi = null;
            jndi = new InitialContext();
            qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
            this.myConnection = new QueueConnection[this.mySenderCount];
            this.qSession = new QueueSession[this.mySenderCount];
            this.qSender = new QueueSender[this.mySenderCount];
            this.sendQueue = new Queue[this.mySenderCount];
            this.myTextMsg = new TextMessage[this.mySenderCount];
            for (int i = 0; i < this.mySenderCount; ++i) {
                this.myConnection[i] = qFactory.createQueueConnection("", "");
                this.qSession[i] = this.myConnection[0].createQueueSession(false, 1);
                this.sendQueue[i] = (Queue)jndi.lookup("jms.queue." + queueName + new Integer(i + 1).toString());
                this.qSender[i] = this.qSession[i].createSender(this.sendQueue[i]);
                this.myConnection[i].setExceptionListener((ExceptionListener)this);
                this.myTextMsg[i] = this.qSession[i].createTextMessage();
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        System.out.println("Exit Sender due to: " + jsme.toString());
        this.exit();
    }

    private void sendAMessage(int iMessageNumber, int priority) {
        try {
            String prefix = iMessageNumber + " with Priority(" + priority + ")" + " ";
            for (int i = 0; i < this.mySenderCount; ++i) {
                this.myTextMsg[i].setText(prefix);
                System.out.println("Send Message: " + this.myTextMsg[i].getText());
                this.myTextMsg[i].setIntProperty("MsgNumber", iMessageNumber);
                this.myTextMsg[i].setIntProperty("QueueNumber", i);
                this.qSender[i].send((Message)this.myTextMsg[i], this.myDeliverMode, priority, 0L);
            }
            ++this.mySentMessages;
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    public void run() {
        Date start = new Date();
        while (this.mySentMessages < this.myMessagesToSend) {
            try {
                this.sendAMessage(this.mySentMessages, this.myPriority);
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        Date end = new Date();
        System.out.println(start.toString());
        System.out.println(end.toString());
    }

    private void exit() {
        try {
            for (int i = 0; i < this.mySenderCount; ++i) {
                this.myConnection[i].close();
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 5) {
            System.out.println("SenderCount,QueueName,Priority,Messagenumber or (non)persistent missing");
        }
        SeqQueueSender qs = new SeqQueueSender(argv[0], argv[1], argv[2], argv[3], argv[4]);
        System.out.println("SeqQueueSender application started");
        qs.start();
    }
}

