/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import com.sap.sdb.msgServer.test.ReceiverClient;

class ReceiveStatisticHandler
extends Thread {
    private int m_maxClients;
    private int m_clientsRunning;
    private long m_committedMessages;
    private long m_receivedMessages;
    private long m_startTime;
    private Object[] m_clientList = null;
    private static final int DISPLAY_INTERVAL = 1000;
    private static final int RECEIVE_TIMEOUT = 20;

    ReceiveStatisticHandler(int maxClients) {
        this.m_maxClients = maxClients;
        this.m_clientsRunning = 0;
        this.m_committedMessages = 0L;
        this.m_receivedMessages = 0L;
        this.m_startTime = 0L;
        this.m_clientList = new Object[maxClients];
    }

    synchronized void addCommits(long count) {
        if (count > 0L) {
            this.m_committedMessages += count;
        }
    }

    synchronized void clientStarted(ReceiverClient client) {
        this.m_clientList[client.getThreadId()] = client;
        ++this.m_clientsRunning;
        if (this.m_clientsRunning == this.m_maxClients) {
            this.notifyAll();
            this.m_startTime = System.currentTimeMillis();
        } else {
            this.waitForLastClient();
        }
    }

    private synchronized long getReceivedMessages() {
        return this.m_receivedMessages;
    }

    synchronized void incrSumMessages() {
        ++this.m_receivedMessages;
        if (this.m_receivedMessages % 1000L == 0L) {
            this.printMessagesPerSecond(0L);
        }
    }

    private synchronized void printMessagesPerSecond(long diff) {
        long duration = System.currentTimeMillis() - 1000L * diff - this.m_startTime;
        if (duration > 0L) {
            System.out.println("========== " + this.m_receivedMessages + " messages === " + this.m_receivedMessages * 1000L / duration + " messages/sec ===");
        }
    }

    private void stopReceiver() {
        System.out.println("+++++ no messages received for 20 seconds +++++");
        System.out.println();
        if (this.m_committedMessages > 0L) {
            System.out.println(this.m_committedMessages + " messages committed");
            System.out.println();
        }
        long sum = 0L;
        long errorCount = 0L;
        for (int i = 0; i < this.m_maxClients; ++i) {
            ReceiverClient client = (ReceiverClient)this.m_clientList[i];
            long msgCount = client.getMessageCount();
            errorCount += client.getErrorCount();
            sum += msgCount;
            System.out.println("T" + i + ":  " + msgCount + " messages");
        }
        System.out.println("    -----");
        System.out.println("    " + sum);
        if (errorCount > 0L) {
            System.out.println();
            if (errorCount == 1L) {
                System.out.println("*** 1 error detected");
            } else {
                System.out.println("*** " + errorCount + " errors detected");
            }
            System.out.println();
        }
        System.out.println("+++++ Receiver finished +++++");
        System.exit(0);
    }

    private synchronized void waitForLastClient() {
        if (this.m_clientsRunning < this.m_maxClients) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        this.waitForLastClient();
        long prevMsgCount = this.getReceivedMessages();
        while (true) {
            try {
                ReceiveStatisticHandler.sleep(20000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long currMsgCount = this.getReceivedMessages();
            if (prevMsgCount < currMsgCount) {
                prevMsgCount = currMsgCount;
                continue;
            }
            this.stopReceiver();
        }
    }
}

