/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.util.Date;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class OneQueueSender
extends Thread
implements ExceptionListener {
    private QueueConnection myConnection = null;
    private QueueSession mySession = null;
    private QueueSender mySender = null;
    private Queue myQueue = null;
    private int myMessagesToSend = 0;
    private int mySentMessages = 1;
    private int myPriority = 0;
    private int myDeliverMode = 0;
    TextMessage myTextMsg;

    public OneQueueSender(String queueName, String priority, String messagesToSend, String persistent, String password) {
        try {
            this.myPriority = Integer.parseInt(priority);
            this.myMessagesToSend = Integer.parseInt(messagesToSend);
            this.myPriority = Integer.parseInt(priority);
            this.myDeliverMode = persistent.equalsIgnoreCase("persistent") ? 2 : 1;
            QueueConnectionFactory qFactory = null;
            InitialContext jndi = null;
            jndi = new InitialContext();
            qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
            this.myConnection = qFactory.createQueueConnection("", password);
            this.mySession = this.myConnection.createQueueSession(false, 1);
            this.myQueue = (Queue)jndi.lookup("jms.queue." + queueName);
            this.mySender = this.mySession.createSender(this.myQueue);
            this.myConnection.setExceptionListener((ExceptionListener)this);
            this.myTextMsg = this.mySession.createTextMessage();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        System.out.println("Exit Sender due to: " + jsme.toString());
        this.exit();
    }

    private void sendMessage() {
        try {
            String prefix = this.mySentMessages + " with Priority(" + this.myPriority + ")" + " ";
            this.myTextMsg.setText(prefix);
            System.out.println("Send Message: " + this.myTextMsg.getText());
            this.myTextMsg.setIntProperty("MsgNumber", this.mySentMessages);
            this.mySender.send((Message)this.myTextMsg, this.myDeliverMode, this.myPriority, 0L);
            ++this.mySentMessages;
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    public void run() {
        Date start = new Date();
        while (this.mySentMessages < this.myMessagesToSend) {
            try {
                this.sendMessage();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        Date end = new Date();
        System.out.println(start.toString());
        System.out.println(end.toString());
    }

    private void exit() {
        try {
            this.myConnection.close();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] argv) {
        if (argv.length != 5) {
            System.out.println("QueueName,Priority,Messagenumber,(non)persistent or password missing");
        }
        OneQueueSender qs = new OneQueueSender(argv[0], argv[1], argv[2], argv[3], argv[4]);
        System.out.println("OneQueueSender application started");
        qs.start();
    }
}

