/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MultiQueueSender
extends Thread
implements ExceptionListener {
    private QueueSender[] q_sender_list = new QueueSender[senders_numb];
    private QueueSession q_session = null;
    private static Queue a_queue = null;
    private static int sessions_numb = 0;
    private static int msg_numb = 0;
    private static int senders_numb = 0;
    private static String outstr = null;
    private static String payload = "";
    private static StringBuffer payload_buf = null;
    private static PrintStream out = System.out;

    public MultiQueueSender(String threadname, QueueConnection q_conn) {
        super(threadname);
        try {
            this.q_session = q_conn.createQueueSession(false, 1);
            for (int i = 0; i < senders_numb; ++i) {
                this.q_sender_list[i] = this.q_session.createSender(a_queue);
            }
            q_conn.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException jmse) {
            jmse.printStackTrace(out);
            System.exit(1);
        }
    }

    public void onException(JMSException jsme) {
        out.println("sender exit : " + jsme.toString());
        jsme.printStackTrace(out);
        System.exit(1);
    }

    public void run() {
        try {
            TextMessage textMsg = this.q_session.createTextMessage();
            textMsg.setText(payload);
            for (int i = 0; i < msg_numb; ++i) {
                for (int j = 0; j < senders_numb; ++j) {
                    this.q_sender_list[j].send((Message)textMsg);
                }
            }
        }
        catch (JMSException jmse) {
            jmse.printStackTrace(out);
        }
    }

    public static void main(String[] argv) throws FileNotFoundException {
        long startmillis = 0L;
        long endmillis = 0L;
        long total_msgs = 0L;
        long total_bytes = 0L;
        QueueConnectionFactory qFactory = null;
        InitialContext jndi = null;
        String queuename = argv[0];
        int conn_numb = 0;
        int payload_size = 0;
        int i = 0;
        int cidx = 0;
        MultiQueueSender[][] t_list = null;
        QueueConnection[] q_conn_list = null;
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException iex) {
            // empty catch block
        }
        if (!argv[1].equals("-")) {
            out = new PrintStream(new FileOutputStream(argv[1], true));
        }
        payload_size = Integer.parseInt(argv[2]);
        conn_numb = Integer.parseInt(argv[3]);
        sessions_numb = Integer.parseInt(argv[4]);
        senders_numb = Integer.parseInt(argv[5]);
        msg_numb = Integer.parseInt(argv[6]);
        total_msgs = msg_numb * senders_numb * sessions_numb * conn_numb;
        total_bytes = total_msgs * (long)payload_size;
        outstr = "persistent , asynchronous , queue , sender   , nondurable , " + conn_numb + " , " + sessions_numb + " , " + senders_numb + " , " + total_msgs + " , " + "                       , " + total_msgs + " , ";
        try {
            jndi = new InitialContext();
            a_queue = (Queue)jndi.lookup("jms.queue." + queuename);
            qFactory = (QueueConnectionFactory)jndi.lookup("jms.QueueConnectionFactory");
        }
        catch (NamingException jne) {
            jne.printStackTrace(out);
            System.exit(1);
        }
        t_list = new MultiQueueSender[conn_numb][sessions_numb];
        q_conn_list = new QueueConnection[conn_numb];
        payload_buf = new StringBuffer("");
        for (i = 0; i < payload_size; ++i) {
            payload_buf.append("a");
        }
        payload = payload_buf.toString();
        for (cidx = 0; cidx < conn_numb; ++cidx) {
            try {
                q_conn_list[cidx] = qFactory.createQueueConnection("", "");
            }
            catch (JMSException jmse) {
                jmse.printStackTrace(out);
                System.exit(1);
            }
            startmillis = System.currentTimeMillis();
            for (i = 0; i < sessions_numb; ++i) {
                t_list[cidx][i] = new MultiQueueSender("thread [" + cidx + "]" + "[" + i + "]", q_conn_list[cidx]);
                t_list[cidx][i].start();
            }
        }
        for (cidx = 0; cidx < conn_numb; ++cidx) {
            for (i = 0; i < sessions_numb; ++i) {
                if (t_list[cidx][i] == null) continue;
                try {
                    t_list[cidx][i].join();
                    continue;
                }
                catch (InterruptedException iex) {
                    // empty catch block
                }
            }
        }
        endmillis = System.currentTimeMillis();
        for (cidx = 0; cidx < conn_numb; ++cidx) {
            try {
                q_conn_list[cidx].close();
                continue;
            }
            catch (JMSException jmse) {
                jmse.printStackTrace(out);
                System.exit(1);
            }
        }
        outstr = outstr + total_bytes + " ," + startmillis + " , " + endmillis;
        out.println(outstr);
        out.flush();
        out.close();
        System.exit(0);
    }
}

