/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.test;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MassTopicPublisher
extends Thread
implements ExceptionListener {
    private TopicConnection m_connection = null;
    private TopicSession m_session = null;
    private TopicPublisher m_publisher = null;
    private Topic m_topic = null;
    private TextMessage m_textMsg = null;
    private String m_countPrefix = "0000";
    private int m_ownThreadId = 0;
    private int m_messagesSent = 0;
    private int m_sendCalls = 0;
    private int m_committedMsg = 0;
    private int m_priority = 0;
    private static boolean m_with_properties = false;
    private static boolean m_transacted = false;
    private static int m_deliveryMode = 2;
    private static int m_acknowledgeMode = 1;
    private static int m_displayInterval = 100;
    private static int m_maxMsgPerClient = 0;
    private static int m_runningClients = 0;
    private static int m_maxPrio = 0;
    private static int m_sumCommittedMsg = 0;
    private static int m_sumMessagesSent = 0;
    private static long m_startTime = 0L;
    private static String m_startDate = null;
    private static final int MAX_CLIENTS = 2;
    private static final int TIME_TO_LIVE_ZERO = 0;
    private static final int MAX_PRIORITY = 9;
    private static final int NORMAL_PRIORITY = 0;

    public static void main(String[] argv) {
        if (argv.length < 3) {
            System.out.println("Parameter required: <topicName1> <topicName2> <maxMessages>[PRIO] [PROPERTIES] [TRANSIENT] [TRANSACTED]");
            return;
        }
        int msgsWanted = Integer.parseInt(argv[2]);
        m_maxMsgPerClient = msgsWanted < 2 ? 20 : msgsWanted / 2;
        int ArgIndex = 2;
        if (argv.length > ArgIndex + 1 && argv[ArgIndex + 1].equalsIgnoreCase("prio")) {
            ++ArgIndex;
            m_maxPrio = 9;
        }
        if (argv.length > ArgIndex + 1 && argv[ArgIndex + 1].equalsIgnoreCase("properties")) {
            ++ArgIndex;
            m_with_properties = true;
            System.out.println("Messages with properties");
        }
        if (argv.length > ArgIndex + 1 && argv[ArgIndex + 1].equalsIgnoreCase("transient")) {
            ++ArgIndex;
            m_deliveryMode = 1;
            System.out.println("Send transient messages");
        }
        if (argv.length > ArgIndex + 1 && argv[ArgIndex + 1].equalsIgnoreCase("transacted")) {
            ++ArgIndex;
            m_transacted = true;
            System.out.println("transacted sessions");
        }
        if (!m_transacted && m_deliveryMode == 1) {
            m_displayInterval = 1000;
        }
        SimpleDateFormat currDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        m_startDate = currDateTime.format(new Date());
        m_startTime = System.currentTimeMillis();
        m_runningClients = 2;
        for (int i = 0; i < 2; ++i) {
            MassTopicPublisher currSender = i % 2 == 0 ? new MassTopicPublisher(i, argv[0]) : new MassTopicPublisher(i, argv[1]);
            System.out.println("Topic Publisher T" + i + " started");
            currSender.start();
        }
    }

    public MassTopicPublisher(int threadId, String topicName) {
        try {
            this.m_ownThreadId = threadId;
            this.m_priority = 0;
            InitialContext jndi = new InitialContext();
            TopicConnectionFactory factory = (TopicConnectionFactory)jndi.lookup("jms.TopicConnectionFactory");
            this.m_connection = factory.createTopicConnection();
            this.m_session = this.m_connection.createTopicSession(m_transacted, m_acknowledgeMode);
            this.m_topic = (Topic)jndi.lookup("jms.topic." + topicName);
            this.m_publisher = this.m_session.createPublisher(this.m_topic);
            try {
                for (int i = 1; i <= 3; ++i) {
                    this.m_session.createDurableSubscriber(this.m_topic, "durable" + i + "_" + topicName);
                }
            }
            catch (JMSException ex) {
                System.out.println("--> " + ex.getMessage());
            }
            this.m_connection.setExceptionListener((ExceptionListener)this);
            this.m_textMsg = this.m_session.createTextMessage();
        }
        catch (JMSException jmse) {
            jmse.printStackTrace();
            System.exit(1);
        }
        catch (NamingException jne) {
            jne.printStackTrace();
            System.exit(1);
        }
    }

    private synchronized void exitClient() {
        m_sumMessagesSent += this.m_messagesSent;
        m_sumCommittedMsg += this.m_committedMsg;
        if (--m_runningClients <= 0) {
            long duration = System.currentTimeMillis() - m_startTime;
            System.out.println(m_sumMessagesSent + " messages sent: " + duration + " msec");
            if (m_transacted) {
                System.out.println(m_sumCommittedMsg + " committed messages");
            }
            if (duration > 0L) {
                System.out.println((long)(m_sumMessagesSent * 1000) / duration + " messages/sec");
            }
            System.exit(0);
        }
    }

    public void onException(JMSException jsme) {
        System.out.println("Exit Sender due to: " + jsme.toString());
        System.exit(1);
    }

    private void println(String msg) {
        System.out.println("T" + this.m_ownThreadId + ": " + msg);
    }

    public void run() {
        long startTime = System.currentTimeMillis();
        try {
            while (this.m_sendCalls < m_maxMsgPerClient) {
                ++this.m_sendCalls;
                this.sendMessage();
            }
            if (m_transacted) {
                this.m_session.rollback();
            }
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        long duration = System.currentTimeMillis() - startTime;
        this.println(this.m_messagesSent + " messages sent: " + duration + " msec");
        if (duration > 0L) {
            this.println((long)(this.m_messagesSent * 1000) / duration + " messages/sec");
        }
        try {
            this.m_connection.close();
        }
        catch (JMSException ex) {
            // empty catch block
        }
        this.exitClient();
    }

    private void sendMessage() {
        try {
            int priority;
            ++this.m_messagesSent;
            switch (this.m_messagesSent) {
                case 10: {
                    this.m_countPrefix = "000";
                    break;
                }
                case 100: {
                    this.m_countPrefix = "00";
                    break;
                }
                case 1000: {
                    this.m_countPrefix = "0";
                    break;
                }
                case 10000: {
                    this.m_countPrefix = "";
                }
            }
            String prefix = m_startDate + " " + this.m_ownThreadId + "." + this.m_countPrefix + this.m_messagesSent;
            int n = priority = this.m_priority == 0 && this.m_messagesSent % 250 == 0 ? m_maxPrio : this.m_priority;
            if (priority > 0) {
                prefix = prefix + " with priority " + priority;
            }
            this.m_textMsg.setText(prefix);
            if (this.m_messagesSent % m_displayInterval == 0) {
                this.println("send: " + this.m_textMsg.getText());
                if (m_transacted) {
                    if (this.m_messagesSent % 200 == 0) {
                        this.m_session.rollback();
                    } else {
                        this.m_committedMsg += 100;
                        this.m_session.commit();
                    }
                }
            }
            if (m_with_properties) {
                this.m_textMsg.setIntProperty("IntProperty", this.m_messagesSent);
                if (priority > 0) {
                    this.m_textMsg.setStringProperty("StringProperty", "Holla");
                } else {
                    this.m_textMsg.setStringProperty("StringProperty", "Hallo");
                }
            }
            this.m_publisher.publish((Message)this.m_textMsg, m_deliveryMode, priority, 0L);
        }
        catch (JMSException jmse) {
            System.out.println("*** " + jmse.getMessage());
            --this.m_messagesSent;
        }
    }
}

