/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.msgServer.ptest;

import com.sap.sdb.msgServer.ptest.PExec;
import com.sap.sdb.msgServer.ptest.PTest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.StringTokenizer;

public class PTestCase {
    private PrintWriter m_out = new PrintWriter(System.out);
    private String m_serverout = null;
    private String m_outputfilename = null;
    private String m_run_dir = null;
    private File m_run_dir_file = null;
    private String m_jrun = null;
    private String m_jrun_options = null;
    private String m_jrun_classpath = null;
    private String m_db_clean_prog = null;
    private String m_db_clean_options = null;
    private String m_db_clean_script = null;
    private String m_proc_aff_prog = null;
    private String m_proc_aff_options = null;
    private String m_server_class = null;
    private String m_server_options = null;
    private String m_shutdown_class = null;
    private String m_shutdown_options = null;
    private String m_producer_class = null;
    private String m_consumer_class = null;
    private long m_dbclean_sleep_millis = 0L;
    private long m_server_sleep_millis = 0L;
    private long m_test_sleep_millis = 0L;
    private long m_shutdown_sleep_millis = 0L;
    private long m_testcase_timeout_millis = 0L;
    private String m_ptest_log_dir = null;
    private String m_killall_prog = null;
    private String m_killall_prog_options = null;
    private String m_createdest_class = null;
    private String m_createdest_options = null;
    private static final boolean DEBUG = false;

    public PTestCase(String this_logfile, String server_logfile, String outputfilename, String inst_dir, String run_dir, String jrun, String jrun_options, String jrun_classpath, String db_clean_prog, String db_clean_options, String db_clean_script, String proc_aff_prog, String proc_aff_options, String server_class, String server_options, String shutdown_class, String shutdown_options, String producer_class, String consumer_class, long dbclean_sleep_millis, long server_sleep_millis, long test_sleep_millis, long shutdown_sleep_millis, long testcase_timeout_millis, String ptest_log_dir, String killall_prog, String killall_prog_options, String createdest_class, String createdest_options) throws FileNotFoundException {
        if (!this_logfile.equals("-")) {
            this.m_out = new PrintWriter(new FileOutputStream(this_logfile, true));
        }
        this.m_serverout = server_logfile;
        this.m_outputfilename = outputfilename;
        this.m_run_dir = inst_dir;
        this.m_run_dir = run_dir;
        this.m_run_dir_file = new File(this.m_run_dir);
        this.m_jrun = jrun;
        this.m_jrun_options = jrun_options;
        this.m_jrun_classpath = jrun_classpath;
        this.m_db_clean_prog = db_clean_prog;
        this.m_db_clean_options = db_clean_options;
        this.m_db_clean_script = db_clean_script;
        this.m_proc_aff_prog = proc_aff_prog;
        this.m_proc_aff_options = proc_aff_options;
        this.m_server_class = server_class;
        this.m_server_options = server_options;
        this.m_shutdown_class = shutdown_class;
        this.m_shutdown_options = shutdown_options;
        this.m_producer_class = producer_class;
        this.m_consumer_class = consumer_class;
        this.m_dbclean_sleep_millis = dbclean_sleep_millis;
        this.m_server_sleep_millis = server_sleep_millis;
        this.m_test_sleep_millis = test_sleep_millis;
        this.m_shutdown_sleep_millis = shutdown_sleep_millis;
        this.m_testcase_timeout_millis = testcase_timeout_millis;
        this.m_ptest_log_dir = ptest_log_dir;
        this.m_killall_prog = killall_prog;
        this.m_killall_prog_options = killall_prog_options;
        this.m_createdest_class = createdest_class;
        this.m_createdest_options = createdest_options;
    }

    public static void main(String[] argv) throws Exception {
        PTestCase testcase_obj = null;
        testcase_obj = new PTestCase(argv[2], argv[3], argv[21], argv[28], argv[29], argv[30], argv[44], argv[45], argv[31], argv[43], argv[46], argv[32], argv[47], argv[33], argv[34], argv[35], argv[36], argv[37], argv[38], Long.parseLong(argv[39]), Long.parseLong(argv[40]), Long.parseLong(argv[41]), Long.parseLong(argv[42]), Long.parseLong(argv[48]), argv[49], argv[51], argv[52], argv[56], argv[57]);
        testcase_obj.main_internal(argv[0], argv[1], Integer.parseInt(argv[4]), Long.parseLong(argv[5]), Integer.parseInt(argv[6]), Integer.parseInt(argv[7]), Long.parseLong(argv[8]), Long.parseLong(argv[9]), argv[10], Integer.parseInt(argv[11]), argv[12], Integer.parseInt(argv[13]), argv[14], Integer.parseInt(argv[15]), !argv[16].equalsIgnoreCase("parallel"), !argv[17].equalsIgnoreCase("sync"), !argv[18].equalsIgnoreCase("durable"), !argv[19].equalsIgnoreCase("transient"), !argv[20].equalsIgnoreCase("topic"), Integer.parseInt(argv[22]), Integer.parseInt(argv[23]), Integer.parseInt(argv[24]), Integer.parseInt(argv[25]), Integer.parseInt(argv[26]), Long.parseLong(argv[27]), !argv[50].equalsIgnoreCase("noselector"), argv[53], Integer.parseInt(argv[54]), Integer.parseInt(argv[55]));
    }

    public void main_internal(String output_prefix, String special_client, int server_agents, long server_so_polling_time, int server_send_queue_len, int server_so_polling_push_sz, long server_gc_time, long server_status_output_time, String server_affinity, int server_cpus, String producer_affinity, int producer_cpus, String consumer_affinity, int consumer_cpus, boolean haveSequential, boolean haveAsync, boolean haveNondurable, boolean havePersistent, boolean haveQueue, int conn_numb, int sessions_numb, int clients_numb, int msg_numb, int payload_size, long consumer_timeout, boolean runMsgSel, String message_selector_string, int dest_numb, int subscriptions_numb) throws Exception {
        PExec dbclean_process = null;
        PExec server_process = null;
        PExec producer_process = null;
        PExec consumer_process = null;
        PExec shutdown_process = null;
        String client_output_prefix = output_prefix + new Date().toString() + "," + special_client + "," + PTest.format(server_agents, 3, 0) + "," + PTest.format(server_so_polling_time, 5, 0) + "," + PTest.format(server_send_queue_len, 4, 0) + "," + PTest.format(server_so_polling_push_sz, 4, 0) + "," + PTest.format(server_gc_time, 13, 0) + "," + PTest.format(server_status_output_time, 6, 0) + "," + PTest.format(server_cpus, 2, 0) + "," + PTest.format(producer_cpus, 2, 0) + "," + PTest.format(consumer_cpus, 2, 0) + "," + PTest.format(this.m_testcase_timeout_millis, 8, 0) + "," + (haveSequential ? "sequential," : "parallel  ,") + (havePersistent ? "persistent," : "transient ,") + (haveAsync ? "asynchronous," : "synchronous ,") + (haveQueue ? "queue," : "topic,") + (haveNondurable ? "nondurable," : "durable   ,") + (runMsgSel ? "selector  ," : "noselector,") + (runMsgSel ? message_selector_string.substring(0, 10) : "          ") + "," + PTest.format(payload_size, 8, 0) + "," + PTest.format(dest_numb, 5, 0) + "," + PTest.format(subscriptions_numb, 5, 0) + "," + ",,";
        String[] server_launch_cmdl = new String[]{this.m_jrun, this.m_jrun_options, this.m_jrun_classpath, this.m_server_class, this.m_server_options, "-LogFilename", this.m_serverout, "-Agents", "" + server_agents, "-SendOrderPollingInMilliSec", "" + server_so_polling_time, "-LengthSendOrderQueue", "" + server_send_queue_len, "-PushSizeForSendOrderQueue", "" + server_so_polling_push_sz, "-GarbageCollectingTimeInSec", "" + server_gc_time, "-DisplayServerStateInSec", "" + server_status_output_time};
        boolean[] server_launch_cmdl_tokenize = new boolean[]{false, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        String[] producer_launch_cmdl = new String[]{this.m_jrun, this.m_jrun_options, "Pjndi" + File.pathSeparator + this.m_jrun_classpath, this.m_producer_class, client_output_prefix, havePersistent ? "persistent" : "transient", haveQueue ? "queue" : "topic", this.m_ptest_log_dir + "P" + this.m_outputfilename, "" + conn_numb, "" + sessions_numb, "" + clients_numb, "" + msg_numb, "" + payload_size, runMsgSel ? "selector" : "noselector", "" + dest_numb, "" + subscriptions_numb};
        boolean[] producer_launch_cmdl_tokenize = new boolean[]{false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        String[] consumer_launch_cmdl = new String[]{this.m_jrun, this.m_jrun_options, "Cjndi" + File.pathSeparator + this.m_jrun_classpath, this.m_consumer_class, client_output_prefix, haveAsync ? "async" : "sync", haveQueue ? "queue" : "topic", haveNondurable ? "nondurable" : "durable", this.m_ptest_log_dir + "C" + this.m_outputfilename, "" + conn_numb, "" + sessions_numb, "" + clients_numb, "" + msg_numb, "" + consumer_timeout, runMsgSel ? "selector" : "noselector", runMsgSel ? message_selector_string : "-", "" + dest_numb, "" + subscriptions_numb};
        boolean[] consumer_launch_cmdl_tokenize = new boolean[]{false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        String[] shutdown_launch_cmdl = new String[]{this.m_jrun, this.m_jrun_options, this.m_jrun_classpath, this.m_shutdown_class, this.m_shutdown_options};
        boolean[] shutdown_launch_cmdl_tokenize = new boolean[]{false, true, false, false, true};
        String[] killall_cmdl = new String[]{this.m_killall_prog, this.m_killall_prog_options};
        boolean[] killall_cmdl_tokenize = new boolean[]{false, true};
        String[] db_clean_cmdl = new String[]{this.m_db_clean_prog, this.m_db_clean_options, this.m_db_clean_script == null || this.m_db_clean_script.equals("") ? " " : this.m_db_clean_script};
        boolean[] db_clean_cmdl_tokenize = new boolean[]{false, true, false};
        this.m_out.println(client_output_prefix);
        this.m_out.flush();
        dbclean_process = this.launch(db_clean_cmdl, db_clean_cmdl_tokenize, this.m_out);
        this.waitFor(dbclean_process);
        Thread.sleep(this.m_dbclean_sleep_millis);
        this.m_out.println(new Date().toString() + " database clean.");
        this.m_out.flush();
        server_process = this.launch(server_launch_cmdl, server_launch_cmdl_tokenize, server_affinity, this.m_out);
        Thread.sleep(this.m_server_sleep_millis);
        this.m_out.println(new Date().toString() + " server started.");
        this.m_out.flush();
        for (int didx = 0; didx < dest_numb; ++didx) {
            String destname = PTestCase.makeDestname(didx, haveQueue);
            this.createDestination(destname, haveQueue);
        }
        this.m_out.println(new Date().toString() + " destinations created.");
        this.m_out.flush();
        this.createDurableSubscriptions(haveAsync, haveQueue, haveNondurable, conn_numb, sessions_numb, clients_numb, runMsgSel, message_selector_string, dest_numb, subscriptions_numb);
        this.m_out.println(new Date().toString() + " durable subscriptions created.");
        this.m_out.flush();
        if (haveSequential) {
            this.m_out.println(new Date().toString() + " sequential run.");
            producer_process = this.launch(producer_launch_cmdl, producer_launch_cmdl_tokenize, producer_affinity, this.m_out);
            this.m_out.println(new Date().toString() + " producer started.");
            this.m_out.flush();
            this.waitFor(producer_process);
            this.m_out.println(new Date().toString() + " producer ended.");
            this.m_out.flush();
            consumer_process = this.launch(consumer_launch_cmdl, consumer_launch_cmdl_tokenize, consumer_affinity, this.m_out);
            this.m_out.println(new Date().toString() + " consumer started.");
            this.m_out.flush();
            this.waitFor(consumer_process);
            this.m_out.println(new Date().toString() + " consumer ended.");
            this.m_out.flush();
        } else {
            consumer_process = this.launch(consumer_launch_cmdl, consumer_launch_cmdl_tokenize, consumer_affinity, this.m_out);
            this.m_out.println(new Date().toString() + " consumer started.");
            this.m_out.flush();
            producer_process = this.launch(producer_launch_cmdl, producer_launch_cmdl_tokenize, producer_affinity, this.m_out);
            this.m_out.println(new Date().toString() + " producer started.");
            this.m_out.flush();
            this.waitFor(consumer_process);
            this.m_out.println(new Date().toString() + " consumer ended.");
            this.m_out.flush();
            this.waitFor(producer_process);
            this.m_out.println(new Date().toString() + " producer ended.");
            this.m_out.flush();
        }
        Thread.sleep(this.m_test_sleep_millis);
        this.m_out.flush();
        this.m_out.println(new Date().toString() + " shutting down the server");
        shutdown_process = this.launch(shutdown_launch_cmdl, shutdown_launch_cmdl_tokenize, this.m_out);
        this.waitFor(shutdown_process);
        this.waitFor(server_process);
        this.m_out.println(new Date().toString() + " server down ?");
        this.m_out.flush();
        if (this.m_killall_prog != null && !this.m_killall_prog.equals("")) {
            this.launch(killall_cmdl, killall_cmdl_tokenize, this.m_out);
            this.launch(killall_cmdl, killall_cmdl_tokenize, this.m_out);
            this.launch(killall_cmdl, killall_cmdl_tokenize, this.m_out);
            this.launch(killall_cmdl, killall_cmdl_tokenize, this.m_out);
        }
        Thread.sleep(this.m_shutdown_sleep_millis);
        this.m_out.println(new Date().toString() + " server down.");
        this.m_out.println(new Date().toString() + "------------------------------------------------------------------------");
        this.m_out.flush();
        this.m_out.close();
    }

    private PExec launch(String[] cmdl, boolean[] tokenize, PrintWriter pw) throws IOException {
        PExec retval = null;
        int len = 0;
        String[][] exp = new String[cmdl.length][];
        for (int i = 0; i < cmdl.length; ++i) {
            if (tokenize[i]) {
                StringTokenizer st = new StringTokenizer(cmdl[i]);
                int sublen = st.countTokens();
                exp[i] = new String[sublen];
                int j = 0;
                while (st.hasMoreTokens()) {
                    exp[i][j] = st.nextToken();
                    ++j;
                }
                len += sublen;
                continue;
            }
            exp[i] = new String[1];
            exp[i][0] = cmdl[i];
            ++len;
        }
        String[] ccmdl = new String[len];
        int i = 0;
        int currlen = 0;
        while (i < cmdl.length) {
            System.arraycopy(exp[i], 0, ccmdl, currlen, exp[i].length);
            currlen += exp[i++].length;
        }
        retval = new PExec(ccmdl, null, this.m_run_dir_file, pw);
        retval.setTimeoutMillis(this.m_testcase_timeout_millis);
        retval.execNoWait();
        return retval;
    }

    private PExec launch(String[] cmdl, boolean[] tokenize, String cpu_affinity, PrintWriter pw) throws IOException {
        PExec retval = null;
        if (this.m_proc_aff_prog != null && !this.m_proc_aff_prog.equals("")) {
            String[] pac = new String[]{this.m_proc_aff_prog, this.m_proc_aff_options, cpu_affinity};
            boolean[] pact = new boolean[]{false, true, false};
            String[] ccmdl = new String[pac.length + cmdl.length];
            boolean[] ccmdlt = new boolean[pact.length + tokenize.length];
            System.arraycopy(pac, 0, ccmdl, 0, pac.length);
            System.arraycopy(cmdl, 0, ccmdl, pac.length, cmdl.length);
            System.arraycopy(pact, 0, ccmdlt, 0, pact.length);
            System.arraycopy(tokenize, 0, ccmdlt, pact.length, tokenize.length);
            retval = this.launch(ccmdl, ccmdlt, pw);
        } else {
            retval = this.launch(cmdl, tokenize, pw);
        }
        return retval;
    }

    private void waitFor(PExec p) throws Exception {
        if (p != null) {
            p.waitFor();
        }
    }

    public static String makeDestname(int didx, boolean haveQueue) {
        String retval = "ptest_" + (haveQueue ? "queue" : "topic") + "_" + didx;
        return retval;
    }

    public static String makeSubscriptionname(int didx, boolean haveQueue, int cidx, int sidx, int clidx, int sbidx) {
        String retval = PTestCase.makeDestname(didx, haveQueue) + "_" + cidx + "_" + sidx + "_" + clidx + "_" + sbidx;
        return retval;
    }

    public void createDestination(String destName, boolean haveQueue) throws Exception {
        String[] admcli_launch_cmdl = new String[]{this.m_jrun, this.m_jrun_options, this.m_jrun_classpath, this.m_createdest_class, this.m_createdest_options, "create "};
        boolean[] admcli_launch_cmdl_tokenize = new boolean[]{false, true, false, false, true, false};
        admcli_launch_cmdl[5] = admcli_launch_cmdl[5] + (haveQueue ? "queue " : "topic ") + destName;
        PExec admcli_process = this.launch(admcli_launch_cmdl, admcli_launch_cmdl_tokenize, this.m_out);
        this.waitFor(admcli_process);
    }

    public void createDurableSubscriptions(boolean haveAsync, boolean haveQueue, boolean haveNondurable, int conn_numb, int sessions_numb, int clients_numb, boolean runMsgSel, String message_selector_string, int dest_numb, int subscriptions_numb) throws Exception {
        if (!haveQueue && !haveNondurable) {
            PExec create_subscription_process = null;
            String[] create_subscription_cmdl = new String[]{this.m_jrun, this.m_jrun_options, "Cjndi" + File.pathSeparator + this.m_jrun_classpath, this.m_consumer_class, "-", haveAsync ? "async" : "sync", haveQueue ? "queue" : "topic", haveNondurable ? "nondurable" : "durable", "-", "" + conn_numb, "" + sessions_numb, "" + clients_numb, "0", "0", runMsgSel ? "selector" : "noselector", runMsgSel ? message_selector_string : "-", "" + dest_numb, "" + subscriptions_numb};
            boolean[] create_subscription_cmdl_tokenize = new boolean[]{false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
            create_subscription_process = this.launch(create_subscription_cmdl, create_subscription_cmdl_tokenize, this.m_out);
            this.waitFor(create_subscription_process);
        }
    }
}

