/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.wisconsin;

import com.sap.sapdb.benchmark.common.StorableObject;
import com.sap.sapdb.benchmark.wisconsin.WiscAtomicQuery;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class WiscQueryResult
implements Comparable {
    private int mTestRunId;
    private int mQueryNo;
    private String mQueryDescription;
    private int mNoExecutions;
    private Vector mWiscAtomicQuery;
    private int mAvgRuntime;
    private int mAvgCPUtime;
    private int mAvgReadIO;

    public WiscQueryResult(int mTestRunId, int mQueryNo, String mQueryDescription, int mNoExecutions, Vector mWiscAtomicQuery, int mAvgRuntime, int mAvgCPUtime, int mAvgReadIO) {
        this.mTestRunId = mTestRunId;
        this.mQueryNo = mQueryNo;
        this.mQueryDescription = mQueryDescription;
        this.mNoExecutions = mNoExecutions;
        this.mWiscAtomicQuery = mWiscAtomicQuery;
        this.mAvgRuntime = mAvgRuntime;
        this.mAvgCPUtime = mAvgCPUtime;
        this.mAvgReadIO = mAvgReadIO;
    }

    public static WiscQueryResult loadWiscQueryResult(int id, int queryNo, String stmt_desc, int noEx, int rt, int cput, int rio) {
        return new WiscQueryResult(id, queryNo, stmt_desc, noEx, null, rt, cput, rio);
    }

    public int getTestRunId() {
        return this.mTestRunId;
    }

    public int getQueryNumber() {
        return this.mQueryNo;
    }

    public String getQueryDescription() {
        return this.mQueryDescription;
    }

    public int getNoExecutions() {
        return this.mNoExecutions;
    }

    public Vector getAtomicQueries() {
        if (this.mWiscAtomicQuery == null) {
            try {
                this.loadAtomicQueries();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.mWiscAtomicQuery;
    }

    public int getAvgCPUtime() {
        return this.mAvgCPUtime;
    }

    public int getAvgReadIO() {
        return this.mAvgReadIO;
    }

    public int getAvgRuntime() {
        return this.mAvgRuntime;
    }

    public Vector loadAtomicQueries() throws SQLException {
        this.mWiscAtomicQuery = new Vector();
        Statement stmt = StorableObject.getConnection().createStatement();
        ResultSet RS = stmt.executeQuery("select statement, run_time, cpu_time, readio from wisc_results where testrun_id = " + this.mTestRunId + " and query_no = " + this.mQueryNo);
        while (RS.next()) {
            this.mWiscAtomicQuery.add(new WiscAtomicQuery(RS.getInt("run_time"), RS.getInt("cpu_time"), RS.getInt("readio"), RS.getString("statement")));
        }
        RS.close();
        stmt.close();
        StorableObject.getConnection().commit();
        return this.mWiscAtomicQuery;
    }

    public int compareTo(Object obj) {
        if (obj instanceof WiscQueryResult) {
            return this.getQueryNumber() - ((WiscQueryResult)obj).getQueryNumber();
        }
        return 0;
    }
}

