/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.benchmark.tp2.common;

import com.sap.sapdb.benchmark.tp2.common.Tp2Result;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class AverageResult
implements Comparable {
    private Timestamp testDate;
    private int userCount;
    private int errorCount;
    private int testCount;
    private float tpsAvg;
    private float tpsDev;
    private String staticWherePart = null;
    private SortedSet results = null;

    public static AverageResult sum(AverageResult ar1, AverageResult ar2) {
        if (ar1.getUserCount() != ar2.getUserCount()) {
            return null;
        }
        int uc = ar1.getUserCount();
        if (ar1.getResults() == null || ar2.getResults() == null) {
            double quadSum2;
            double quadSum1;
            float tpsAvg = (ar1.getTpsAvgAsFloat() * (float)ar1.getTestCount() + ar2.getTpsAvgAsFloat() * (float)ar2.getTestCount()) / (float)(ar1.getTestCount() + ar2.getTestCount());
            if (ar1.getTestCount() == 1) {
                quadSum1 = (tpsAvg - (float)ar1.getTpsAvg()) * (tpsAvg - (float)ar1.getTpsAvg());
            } else {
                double tpsDev1 = ar1.getTpsDev() * ar1.getTpsAvgAsFloat() / 100.0f;
                quadSum1 = tpsDev1 * tpsDev1 * (double)ar1.getTestCount();
            }
            if (ar2.getTestCount() == 1) {
                quadSum2 = (tpsAvg - (float)ar2.getTpsAvg()) * (tpsAvg - (float)ar2.getTpsAvg());
            } else {
                double tpsDev2 = ar2.getTpsDev() * ar2.getTpsAvgAsFloat() / 100.0f;
                quadSum2 = tpsDev2 * tpsDev2 * (double)ar2.getTestCount();
            }
            float tpsDev = (float)(Math.sqrt((quadSum1 + quadSum2) / (double)(ar1.getTestCount() + ar2.getTestCount())) * 100.0) / tpsAvg;
            String swPart = null;
            swPart = ar1.userCount == ar2.userCount ? "(" + ar1.getStaticWherePart() + ") " : "(" + ar1.getStaticWherePart() + ") OR (" + ar2.getStaticWherePart() + ") ";
            int testCount = ar1.getTestCount() + ar2.getTestCount();
            int errorCount = ar1.getErrorCount() + ar2.getErrorCount();
            Timestamp testDate = ar1.getTestDate();
            return new AverageResult(uc, tpsAvg, tpsDev, testCount, testDate, errorCount, swPart);
        }
        TreeSet list = new TreeSet();
        list.addAll(ar1.getResults());
        list.addAll(ar2.getResults());
        return new AverageResult(uc, list);
    }

    public AverageResult(int userCount, float tpsAvg, float tpsDev, int testCount, Timestamp testDate, int errorCount, String staticWherePart) {
        this.userCount = userCount;
        this.tpsAvg = tpsAvg;
        this.tpsDev = tpsDev;
        this.testCount = testCount;
        this.testDate = testDate;
        this.errorCount = errorCount;
        this.staticWherePart = staticWherePart;
    }

    public AverageResult(int userCount, SortedSet resultsArg) {
        this.userCount = userCount;
        this.testCount = 0;
        this.results = new TreeSet();
        Iterator itArg = resultsArg.iterator();
        double tpsSum = 0.0;
        double tpsQuadSum = 0.0;
        double tpsAvgD = 0.0;
        int tErrorCount = 0;
        while (itArg.hasNext()) {
            Tp2Result res = (Tp2Result)itArg.next();
            if (res.getUserCount() != userCount) continue;
            tpsSum += (double)res.getTpsAsFloat();
            tpsQuadSum += (double)(res.getTpsAsFloat() * res.getTpsAsFloat());
            tErrorCount += res.getErrorCount();
            ++this.testCount;
            this.results.add(res);
        }
        tpsAvgD = tpsSum / (double)this.testCount;
        this.tpsAvg = (float)tpsAvgD;
        this.tpsDev = (float)(Math.sqrt(tpsQuadSum / (double)this.testCount - tpsAvgD * tpsAvgD) * 100.0 / tpsAvgD);
        this.errorCount = tErrorCount;
    }

    public Timestamp getTestDate() {
        return this.testDate;
    }

    public int getTestCount() {
        return this.testCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getTpsAvg() {
        return (int)this.tpsAvg;
    }

    public float getTpsAvgAsFloat() {
        return (int)this.tpsAvg;
    }

    public float getTpsDev() {
        return (float)Math.round(this.tpsDev * 10.0f) / 10.0f;
    }

    public int getUserCount() {
        return this.userCount;
    }

    public SortedSet getResults() {
        return this.results;
    }

    public String getStaticWherePart() {
        return this.staticWherePart;
    }

    public String getAsHttpSWP() {
        return URLEncoder.encode(this.staticWherePart);
    }

    public String getColor() {
        String color = "black";
        if (this.errorCount != 0) {
            return "red";
        }
        if (this.getTestCount() < 2) {
            color = "gray";
        } else if (this.getTpsDev() >= 5.0f && this.getTpsDev() < 10.0f) {
            color = "orange";
        } else if (this.getTpsDev() >= 10.0f) {
            color = "red";
        }
        return color;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AverageResult) {
            AverageResult ar = (AverageResult)obj;
            return ar.getUserCount() == this.userCount && (float)ar.getTpsAvg() == this.tpsAvg && ar.getTpsDev() == this.tpsDev && ar.getTestCount() == this.testCount;
        }
        return false;
    }

    public int compareTo(Object obj) {
        if (obj instanceof AverageResult) {
            AverageResult ar = (AverageResult)obj;
            return this.userCount - ar.getUserCount();
        }
        return 0;
    }
}

