/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.triggerMinDB;

import com.sap.sdb.minDB.triggerInterface.TriggerConnection;
import com.sap.sdb.minDB.triggerInterface.TriggerImageSet;
import com.sap.sdb.minDB.triggerInterface.TriggerParamSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;

public abstract class ClientTrigger {
    static final int DUPLICATE_KEY = 200;
    protected static final String COLUMN_PREFIX = "_";
    static final String PARAM_COL_COUNT = "COLUMN_COUNT";
    static final String PARAM_COL_NN = "COL";
    static final String PARAM_KEY_COUNT = "KEY_COUNT";
    static final String PARAM_KEY_NN = "KEY";
    static final String PARAM_VER_NN = "VER";
    static final String PARAM_VER_COUNT = "VER_COUNT";
    static final String PARAM_SHADOWTAB = "SHADOW_TABLE";
    static final String PARAM_SYNCUSER = "SYNCMAN_USER";
    static final String PARAM_SYNCSCHEMA = "SYNCMAN_SCHEMA";
    static final String PARAM_UPDATER_ID = "UPDATER_ID";
    static final String PARAM_VERSIONTAB = "VERSION_TABLE";
    static final String PARAM_BEFOREIMAGE = "BEFORE_IMAGE";
    private static final String PARAM_SEQUENCE = "SEQUENCE_NAME";
    private static final String STMT_INSERT_TRANS_TAB = "insertTransTab";
    private static final String STMT_UPDATE_TRANS_TAB = "updateTransTab";

    String buildKeyCondition(TriggerParamSet param, int keyCount) throws SQLException {
        String keyCondition = "";
        for (int i = 1; i <= keyCount; ++i) {
            if (i > 1) {
                keyCondition = keyCondition + " AND ";
            }
            keyCondition = keyCondition + "\"_" + param.getString(PARAM_KEY_NN + i) + "\" = ?";
        }
        return keyCondition;
    }

    String getNextSequenceNo(TriggerConnection connection, TriggerParamSet param, String syncSchema) throws SQLException {
        long sequence = connection.getSequenceNextval(syncSchema, param.getString(PARAM_SEQUENCE));
        return Long.toString(sequence);
    }

    void insertIntoTransList(TriggerConnection connection, HashMap prepStmtMap, TriggerImageSet image, String syncSchema, String transID, String sequenceNo) throws SQLException {
        String schemaName = image.getSchemaName();
        String tableName = image.getTableName();
        PreparedStatement insertStmt = (PreparedStatement)prepStmtMap.get(STMT_INSERT_TRANS_TAB);
        if (insertStmt == null) {
            String sql = "INSERT INTO " + syncSchema + "." + "REPLICATION_TRANSACTION_LIST" + " VALUES (?, ?, ?, ?)";
            if (connection.isVerboseTrigger()) {
                connection.println(sql);
            }
            insertStmt = connection.prepareStatement(sql);
            prepStmtMap.put(STMT_INSERT_TRANS_TAB, insertStmt);
        }
        insertStmt.setString(1, transID);
        insertStmt.setString(2, schemaName);
        insertStmt.setString(3, tableName);
        insertStmt.setString(4, sequenceNo);
        boolean isDuplicate = false;
        try {
            insertStmt.executeUpdate();
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 200) {
                isDuplicate = true;
            }
            throw ex;
        }
        insertStmt = null;
        if (isDuplicate) {
            PreparedStatement updateStmt = (PreparedStatement)prepStmtMap.get(STMT_UPDATE_TRANS_TAB);
            if (updateStmt == null) {
                String sql = "UPDATE " + syncSchema + "." + "REPLICATION_TRANSACTION_LIST" + " SET REP_SEQ = ?" + " WHERE REP_TRANSID = ?" + "  AND " + "TABLE_SCHEMA" + "= ? AND TABLE_NAME = ?";
                if (connection.isVerboseTrigger()) {
                    connection.println(sql);
                }
                updateStmt = connection.prepareStatement(sql);
                prepStmtMap.put(STMT_UPDATE_TRANS_TAB, updateStmt);
            }
            updateStmt.setString(1, sequenceNo);
            updateStmt.setString(2, transID);
            updateStmt.setString(3, schemaName);
            updateStmt.setString(4, tableName);
            updateStmt.executeUpdate();
        }
    }
}

