/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.consumption;

import com.sap.sdb.syncMan.consumption.ConsumptionIgnoreList;
import com.sap.sdb.syncMan.consumption.ConsumptionIgnoreListSQLHandler;
import com.sap.sdb.syncMan.definition.ReplicationUnit;
import com.sap.sdb.syncMan.message.RowReceiveMessage;
import com.sap.sdb.syncMan.util.ConnectionPool;
import com.sap.sdb.syncMan.util.DebugOutput;
import com.sap.sdb.syncMan.util.TableName;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;

public class MinDBConsumptionIgnoreListSQLHandler
extends ConsumptionIgnoreListSQLHandler {
    private Hashtable m_initializeListCache = new Hashtable(1);
    private Hashtable m_criticalInsertCache = new Hashtable(1);
    private Hashtable m_criticalUpdateCache = new Hashtable(1);
    private Hashtable m_criticalDeleteCache = new Hashtable(1);
    private String m_initializeListSQL;
    private String m_criticalInsertSQL;
    private String m_criticalUpdateSQL;
    private String m_criticalDeleteSQL;

    public MinDBConsumptionIgnoreListSQLHandler(ReplicationUnit unit) {
        super(unit);
        TableName ignoreTab = new TableName(ConnectionPool.getSchema(), "REPLICATION_IGNORE_LIST");
        this.m_initializeListSQL = "select LAST_UPDATER, ROW_CREATOR, ROW_VERSION, REF_COUNT from " + ignoreTab.getSQLTableName() + " where " + "UNIT_ID" + " = '" + this.m_unit.getUnitID() + "'";
        String ignoreTableKeyClause = " where UNIT_ID = '" + this.m_unit.getUnitID() + "' and " + "LAST_UPDATER" + " = ? and " + "ROW_CREATOR" + " = ? and " + "ROW_VERSION" + " = ? ";
        this.m_criticalInsertSQL = "insert into " + ignoreTab.getSQLTableName() + " ( " + "UNIT_ID" + ", " + "LAST_UPDATER" + ", " + "ROW_CREATOR" + ", " + "ROW_VERSION" + ", " + "REF_COUNT" + " ) values ( '" + this.m_unit.getUnitID() + "', ?, ?, ?, ? )";
        this.m_criticalUpdateSQL = "update " + ignoreTab.getSQLTableName() + " set " + "REF_COUNT" + " = ? " + ignoreTableKeyClause;
        this.m_criticalDeleteSQL = "delete from " + ignoreTab.getSQLTableName() + ignoreTableKeyClause;
    }

    public void initializeList(Connection konnek, ConsumptionIgnoreList iList) throws Exception {
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_initializeListCache, this.m_initializeListSQL);
        ResultSet result = pstmt.executeQuery();
        while (result.next()) {
            iList.setCritical(result.getLong(1), result.getLong(2), result.getLong(3), result.getInt(4));
        }
        result.close();
    }

    public void beginCritical(Connection konnek, RowReceiveMessage msg, boolean increment, int incrementedRefCount) throws Exception {
        if (increment) {
            this.updateCritical(konnek, msg.getUpdaterId(), msg.getRowCreatorID(), msg.getRowVersion(), incrementedRefCount);
        } else {
            this.insertCritical(konnek, msg.getUpdaterId(), msg.getRowCreatorID(), msg.getRowVersion(), 1);
        }
    }

    public void endCritical(Connection konnek, RowReceiveMessage msg, boolean decrement, int decrementedRefCount) throws Exception {
        if (decrement) {
            this.updateCritical(konnek, msg.getUpdaterId(), msg.getRowCreatorID(), msg.getRowVersion(), decrementedRefCount);
        } else {
            this.deleteCritical(konnek, msg.getUpdaterId(), msg.getRowCreatorID(), msg.getRowVersion());
        }
    }

    private void updateCritical(Connection konnek, long lastUpdaterId, long rowCreatorId, long rowVersion, int refcount) throws Exception {
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_criticalUpdateCache, this.m_criticalUpdateSQL);
        pstmt.setInt(1, refcount);
        pstmt.setLong(2, lastUpdaterId);
        pstmt.setLong(3, rowCreatorId);
        pstmt.setLong(4, rowVersion);
        pstmt.executeUpdate();
    }

    private void deleteCritical(Connection konnek, long lastUpdaterId, long rowCreatorId, long rowVersion) throws Exception {
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_criticalDeleteCache, this.m_criticalDeleteSQL);
        pstmt.setLong(1, lastUpdaterId);
        pstmt.setLong(2, rowCreatorId);
        pstmt.setLong(3, rowVersion);
        pstmt.executeUpdate();
    }

    private void insertCritical(Connection konnek, long lastUpdaterId, long rowCreatorId, long rowVersion, int refcount) throws Exception {
        PreparedStatement pstmt = this.getCachedPStatement(konnek, this.m_criticalInsertCache, this.m_criticalInsertSQL);
        pstmt.setLong(1, lastUpdaterId);
        pstmt.setLong(2, rowCreatorId);
        pstmt.setLong(3, rowVersion);
        pstmt.setInt(4, refcount);
        pstmt.executeUpdate();
    }

    private synchronized PreparedStatement getCachedPStatement(Connection konnek, Hashtable cache, String SQL) throws Exception {
        PreparedStatement retval = (PreparedStatement)cache.get(konnek);
        if (retval == null) {
            if (DebugOutput.isVerboseConsumption()) {
                DebugOutput.println("consumption INFO : statement not cached, SQL : " + SQL + " thread : " + Thread.currentThread());
            }
            retval = konnek.prepareStatement(SQL);
            cache.put(konnek, retval);
        }
        return retval;
    }
}

