/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.consumption;

import com.sap.sdb.syncMan.SyncManThread;
import com.sap.sdb.syncMan.consumption.ConsumptionManager;
import com.sap.sdb.syncMan.consumption.ConsumptionMessageListener;
import com.sap.sdb.syncMan.consumption.ConsumptionQueue;
import com.sap.sdb.syncMan.consumption.ConsumptionUpdateHandlerMasterThread;
import com.sap.sdb.syncMan.consumption.ConsumptionUpdateHandlerSlaveThread;
import com.sap.sdb.syncMan.consumption.TableConsumptionSQLHandler;
import com.sap.sdb.syncMan.definition.ReplicationSchema;
import com.sap.sdb.syncMan.definition.ReplicationUnit;
import com.sap.sdb.syncMan.message.RowReceiveMessage;
import com.sap.sdb.syncMan.util.ConnectionPool;
import com.sap.sdb.syncMan.util.DebugOutput;
import com.sap.sdb.syncMan.util.SQLNames;
import java.sql.Connection;

public abstract class ConsumptionUpdateHandlerThread
extends SyncManThread
implements SQLNames {
    protected ReplicationSchema m_schema;
    protected ReplicationUnit m_unit;
    protected ConsumptionQueue m_cqueue;
    protected ConsumptionMessageListener m_listener;
    protected Connection m_konnek;
    private long m_mod_counter;

    public static ConsumptionUpdateHandlerThread create(ConsumptionMessageListener listener) throws Exception {
        ReplicationUnit unit = listener.getUnit();
        ConsumptionUpdateHandlerThread retval = unit.isMaster() ? new ConsumptionUpdateHandlerMasterThread(listener) : new ConsumptionUpdateHandlerSlaveThread(listener);
        return retval;
    }

    protected ConsumptionUpdateHandlerThread(ConsumptionMessageListener listener, String threadName) throws Exception {
        super(threadName);
        this.m_unit = listener.getUnit();
        this.m_schema = this.m_unit.getSchema();
        this.m_cqueue = listener.getCQueue();
        this.m_listener = listener;
        this.m_konnek = ConnectionPool.getConnection();
        if (DebugOutput.isVerboseConsumptionMsg()) {
            DebugOutput.println("consumption INFO : ConsumptionUpdateHandlerThread " + this + " got db connection : " + this.m_konnek);
        }
        this.m_mod_counter = 0L;
    }

    public void doWork() throws Exception {
        RowReceiveMessage msg = this.m_cqueue.pop();
        if (DebugOutput.isVerboseConsumptionMsg()) {
            DebugOutput.println("" + System.currentTimeMillis() + " : " + "ConsumptionUpdateHandlerThread " + this + " : doWork(" + msg.toString() + ")");
        }
        try {
            this.handleMsg(msg);
        }
        catch (Exception ex) {
            if (ConnectionPool.isWorkRolledBackOrTimeout(ex)) {
                if (DebugOutput.isVerbose()) {
                    DebugOutput.printException(ex);
                }
                this.m_listener.retryMsgTransaction();
            }
            throw ex;
        }
        ++this.m_mod_counter;
        this.m_mod_counter %= 10000000000L;
        this.setCustomMsg("processed msgs (mod 10GMsg) : " + this.m_mod_counter);
    }

    public void commitDbConnection() throws Exception {
        this.m_konnek.commit();
    }

    public void rollbackDbConnection() throws Exception {
        this.m_konnek.rollback();
    }

    public void freeDbConnection() throws Exception {
        ConnectionPool.freeConnection(this.m_konnek);
        this.m_konnek = null;
    }

    public abstract void reinitializeIgnoreList() throws Exception;

    protected abstract void handleMsg(RowReceiveMessage var1) throws Exception;

    protected void auditAndLog(RowReceiveMessage msg, int conflictType) throws Exception {
        if (this.m_unit.isOutbound()) {
            int updateType = msg.getActionType();
            if ((ConsumptionManager.haveConflictTables() && conflictType != 0 && conflictType != 128 || ConsumptionManager.haveAuditTables()) && updateType != 7) {
                TableConsumptionSQLHandler sqlHandler = this.m_unit.getTableById(msg.getTableId()).getTableConsumptionSQLHandler();
                sqlHandler.auditMsg(this.m_konnek, msg, conflictType);
            }
            if (DebugOutput.isVerboseConsumption() && conflictType != 0 && conflictType != 128) {
                String conflictInfo;
                String actionTypeString;
                switch (updateType) {
                    case 1: {
                        actionTypeString = "update";
                        break;
                    }
                    case 2: {
                        actionTypeString = "delete";
                        break;
                    }
                    case 0: {
                        actionTypeString = "insert";
                        break;
                    }
                    case 6: {
                        actionTypeString = "";
                        break;
                    }
                    case 4: {
                        actionTypeString = "";
                        break;
                    }
                    case 5: {
                        actionTypeString = "";
                        break;
                    }
                    case 256: {
                        actionTypeString = "";
                        break;
                    }
                    case 320: {
                        actionTypeString = "";
                        break;
                    }
                    default: {
                        actionTypeString = "";
                    }
                }
                switch (conflictType) {
                    case 1: {
                        conflictInfo = " message failed due to mismatch of (generalized) before image";
                        break;
                    }
                    case 2: {
                        conflictInfo = " message failed due to row version mismatch";
                        break;
                    }
                    case 32: {
                        conflictInfo = " message failed due missing row";
                        break;
                    }
                    case 33: {
                        conflictInfo = " message failed due missing row or mismatch of (generalized) before image";
                        break;
                    }
                    case 8: {
                        conflictInfo = " message failed due to duplicate insert";
                        break;
                    }
                    case 64: {
                        conflictInfo = "refresh with acknowledgement request due to conflict at master";
                        break;
                    }
                    case 4: {
                        conflictInfo = " message failed due to critical phase";
                        break;
                    }
                    case 16: {
                        conflictInfo = " end of critical phase";
                        break;
                    }
                    case 128: {
                        conflictInfo = "separate end of transaction message";
                        break;
                    }
                    case 320: {
                        conflictInfo = "refresh message with acknowledgement request out of row version";
                        break;
                    }
                    case 256: {
                        conflictInfo = "refresh message out of row version";
                        break;
                    }
                    default: {
                        conflictInfo = "unknown conflict";
                    }
                }
                DebugOutput.println("consumption INFO: " + actionTypeString + conflictInfo + ", msg: " + msg.toString());
            }
        }
    }
}

