/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.consumption;

import com.sap.sdb.syncMan.consumption.ConsumptionMessageListener;
import com.sap.sdb.syncMan.definition.ReplicationSchema;
import com.sap.sdb.syncMan.definition.ReplicationUnit;
import java.util.Enumeration;
import java.util.Hashtable;

public class ConsumptionManager {
    private static ConsumptionManager s_ConsumptionManager = null;
    private ReplicationSchema m_schema;
    private Hashtable m_datalisteners = null;
    private int m_consumptionUpdateHandlerCount;
    private boolean m_audit_tables;
    private boolean m_conflict_tables;

    private ConsumptionManager(ReplicationSchema schema, int consumptionUpdateHandlerCount, boolean audit_tables, boolean conflict_tables) {
        this.m_schema = schema;
        this.m_audit_tables = audit_tables;
        this.m_conflict_tables = conflict_tables;
        this.m_consumptionUpdateHandlerCount = consumptionUpdateHandlerCount;
        this.m_datalisteners = new Hashtable();
    }

    private static ConsumptionManager getInstance() {
        if (s_ConsumptionManager == null) {
            throw new IllegalStateException("ConsumptionManager singleton not created.");
        }
        return s_ConsumptionManager;
    }

    public static synchronized void createInstance(ReplicationSchema schema, int consumptionUpdateHandlers, boolean audit_tables, boolean conflict_tables) throws Exception {
        if (s_ConsumptionManager != null) {
            throw new IllegalStateException("ConsumptionManager singleton already created.");
        }
        s_ConsumptionManager = new ConsumptionManager(schema, consumptionUpdateHandlers, audit_tables, conflict_tables);
    }

    public static synchronized void destroyInstance() throws Exception {
        s_ConsumptionManager = null;
    }

    public static boolean haveAuditTables() {
        return ConsumptionManager.getInstance().m_audit_tables;
    }

    public static boolean haveConflictTables() {
        return ConsumptionManager.getInstance().m_conflict_tables;
    }

    public ReplicationSchema getSchema() {
        return this.m_schema;
    }

    public int getUpdateHandlerCount() {
        return this.m_consumptionUpdateHandlerCount;
    }

    public static void startConsumption() throws Exception {
        if (ConsumptionManager.getInstance().m_schema.getInUnitCount() > 0) {
            Enumeration ing_enum = ConsumptionManager.getInstance().m_schema.getInUnitEnum();
            while (ing_enum.hasMoreElements()) {
                ReplicationUnit unt = (ReplicationUnit)ing_enum.nextElement();
                ConsumptionMessageListener msg_listener = new ConsumptionMessageListener(unt);
                ConsumptionManager.getInstance().m_datalisteners.put(unt, msg_listener);
                msg_listener.start();
            }
        }
    }
}

