/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.SyncManThread;
import com.sap.sdb.syncMan.capture.CaptureHandler;
import com.sap.sdb.syncMan.capture.CapturePrepStmtCache;
import com.sap.sdb.syncMan.capture.CaptureTable;
import com.sap.sdb.syncMan.util.ConnectionPool;
import com.sap.sdb.syncMan.util.DebugOutput;
import java.sql.Connection;

class CaptureTableHandler
extends SyncManThread {
    private CaptureHandler m_captureHandler;
    private CapturePrepStmtCache m_prepStmtCache;
    private static final String CAPTURE_TAB_HANDLER_NAME = "CaptureTableHandler";

    CaptureTableHandler(CaptureHandler captureHandler, String[] unitnames) {
        super(CAPTURE_TAB_HANDLER_NAME);
        this.m_captureHandler = captureHandler;
        this.m_prepStmtCache = new CapturePrepStmtCache(ConnectionPool.getSchema(), unitnames);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doWork() throws Exception {
        CaptureTable currentTable = this.m_captureHandler.getNextCaptureTable();
        Connection con = null;
        try {
            try {
                con = ConnectionPool.getConnection();
                super.setCustomMsg("capture table " + currentTable.getBaseTableName().getSQLTableName());
                if (DebugOutput.isVerboseCapture()) {
                    super.printOwnAction();
                }
                currentTable.captureEntries(con, this.m_prepStmtCache);
                con.commit();
                this.m_captureHandler.signalTableHandlerFinished(currentTable);
            }
            catch (Exception ex) {
                this.m_captureHandler.signalTableHandlerError(ex);
                throw ex;
            }
            Object var5_3 = null;
            super.resetCustomMsg();
            if (con == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            super.resetCustomMsg();
            if (con == null) throw throwable;
            ConnectionPool.freeConnection(con);
            throw throwable;
        }
        ConnectionPool.freeConnection(con);
    }
}

