/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.capture.CaptureResult;
import com.sap.sdb.syncMan.capture.CaptureResultRow;
import com.sap.sdb.syncMan.util.TableName;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

class CaptureSourceResult
extends CaptureResult {
    private ResultSet m_result;
    private CaptureResultRow m_currRow;
    private long m_rowCreatorID;
    private long m_rowVersion;
    private long m_updaterID;
    private long m_colGroupVersion;
    private static final String ALIAS_PREFIX = "__V_";
    private static final String ALIAS_ROW_CREATOR = "__V_ROW_CREATOR";
    private static final String ALIAS_ROW_VERSION = "__V_ROW_VERSION";
    private static final String ALIAS_UPDATER = "__V_LAST_UPDATER";
    private static final String ALIAS_COL_GROUP_VERSION = "__V_COL_GROUP_VERSION";

    CaptureSourceResult(ResultSet result) {
        this.resetRow();
        this.m_result = result;
        this.m_currRow = new CaptureResultRow(result);
    }

    void close() throws SQLException {
        if (this.m_result == null) {
            return;
        }
        this.resetRow();
        this.m_result.close();
        this.m_result = null;
    }

    int getActionType() {
        return 0;
    }

    long getColGroupVersion() {
        return this.m_colGroupVersion;
    }

    CaptureResultRow getCurrRow() {
        return this.m_currRow;
    }

    ResultSetMetaData getMetaData() throws SQLException {
        return this.m_result.getMetaData();
    }

    long getRowCreatorID() {
        return this.m_rowCreatorID;
    }

    long getRowVersion() {
        return this.m_rowVersion;
    }

    static String getSelectListVersionPart(TableName versionTableName) {
        String versTab = versionTableName.getSQLIdentifier();
        return versTab + "." + "ROW_CREATOR" + " \"" + ALIAS_ROW_CREATOR + "\", " + versTab + "." + "ROW_VERSION" + " \"" + ALIAS_ROW_VERSION + "\", " + versTab + "." + "LAST_UPDATER" + " \"" + ALIAS_UPDATER + "\", " + versTab + "." + "COL_GROUP_VERSION" + " \"" + ALIAS_COL_GROUP_VERSION + "\"";
    }

    long getUpdaterID() {
        return this.m_updaterID;
    }

    boolean isInsDelUpdAction() {
        return true;
    }

    boolean next(Connection con) throws SQLException {
        if (!this.m_result.next()) {
            return false;
        }
        this.m_rowCreatorID = this.m_currRow.getLong(ALIAS_ROW_CREATOR);
        this.m_rowVersion = this.m_currRow.getLong(ALIAS_ROW_VERSION);
        this.m_updaterID = this.m_currRow.getLong(ALIAS_UPDATER);
        this.m_colGroupVersion = this.m_currRow.getLong(ALIAS_COL_GROUP_VERSION);
        return true;
    }

    private void resetRow() {
        this.m_currRow = null;
        this.m_rowCreatorID = -1L;
        this.m_rowVersion = -1L;
        this.m_updaterID = -1L;
        this.m_colGroupVersion = -1L;
    }
}

