/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.capture.CaptureResult;
import com.sap.sdb.syncMan.capture.CaptureResultRow;
import com.sap.sdb.syncMan.util.SQLBuilder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

class CaptureShadowResult
extends CaptureResult {
    private ResultSet m_result;
    private CaptureResultRow m_currRow;
    private int m_actionType;
    private long m_entrySequence;
    private long m_rowCreatorID;
    private long m_rowVersion;
    private long m_updaterID;
    private long m_colGroupVersion;
    private long m_singleReceiverID;
    private byte[] m_colUpdateFlags;

    CaptureShadowResult(ResultSet result) {
        this.resetRow();
        this.m_result = result;
        this.m_currRow = new CaptureResultRow(result);
    }

    void close() throws SQLException {
        if (this.m_result == null) {
            return;
        }
        this.resetRow();
        this.m_result.close();
        this.m_result = null;
    }

    int getActionType() {
        return this.m_actionType;
    }

    long getColGroupVersion() {
        return this.m_colGroupVersion;
    }

    byte[] getColUpdateFlags() {
        return this.m_colUpdateFlags;
    }

    CaptureResultRow getCurrRow() {
        return this.m_currRow;
    }

    long getEntrySequence() {
        return this.m_entrySequence;
    }

    ResultSetMetaData getMetaData() throws SQLException {
        return this.m_result.getMetaData();
    }

    long getRowCreatorID() {
        return this.m_rowCreatorID;
    }

    long getRowVersion() {
        return this.m_rowVersion;
    }

    long getSingleReceiverID() {
        return this.m_singleReceiverID;
    }

    long getUpdaterID() {
        return this.m_updaterID;
    }

    boolean isDeleteAction() {
        return this.m_actionType == 2;
    }

    boolean isInsDelUpdAction() {
        return this.m_actionType == 0 || this.m_actionType == 2 || this.m_actionType == 1;
    }

    boolean isRefreshAction() {
        return this.m_actionType == 4 || this.m_actionType == 5;
    }

    boolean isRefreshDoneAction() {
        return this.m_actionType == 6;
    }

    boolean isUpdateAction() {
        return this.m_actionType == 1;
    }

    boolean next(Connection con) throws SQLException {
        if (!this.m_result.next()) {
            return false;
        }
        this.m_actionType = this.m_currRow.getInt("REP_TYPE");
        this.m_entrySequence = this.m_currRow.getLong("REP_COUNTER");
        this.m_rowCreatorID = this.m_currRow.getLong("ROW_CREATOR");
        this.m_rowVersion = this.m_currRow.getLong("ROW_VERSION");
        this.m_updaterID = this.m_currRow.getLong("UPDATER_ID");
        this.m_colGroupVersion = this.m_currRow.getLong("COL_GROUP_VERSION");
        this.m_singleReceiverID = -1L;
        this.m_colUpdateFlags = null;
        if (this.m_actionType == 1) {
            this.m_colUpdateFlags = this.m_currRow.getBytes("REP_CHANGE");
        } else if (this.m_actionType == 4 || this.m_actionType == 5) {
            this.m_singleReceiverID = SQLBuilder.getIDFromByteArray(this.m_currRow.getBytes("REP_CHANGE"));
        }
        return true;
    }

    private void resetRow() {
        this.m_currRow = null;
        this.m_actionType = -1;
        this.m_entrySequence = -1L;
        this.m_rowCreatorID = -1L;
        this.m_rowVersion = -1L;
        this.m_updaterID = -1L;
        this.m_colGroupVersion = -1L;
        this.m_singleReceiverID = -1L;
        this.m_colUpdateFlags = null;
    }
}

