/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.capture;

import com.sap.sdb.syncMan.capture.CaptureColConstraint;
import com.sap.sdb.syncMan.capture.CaptureResultRow;
import com.sap.sdb.syncMan.message.RowSendMessage;
import com.sap.sdb.syncMan.util.SQLNames;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

class CaptureColDesc
implements SQLNames {
    private String m_columnName;
    private long m_columnID;
    private int m_columnType;
    private int m_keyPos;
    private int m_resultColNo;
    private boolean m_versioned;
    private boolean m_hasAnyConstraint;
    private Long m_columnGroupID;
    private CaptureColConstraint[] m_constraints = null;
    private static final int NOKEY = -1;

    CaptureColDesc(String columnName, ResultSet colDescResult, HashMap colNameIndex, LinkedList keyColList) throws SQLException {
        this.m_columnName = columnName;
        this.m_columnID = colDescResult.getLong("COLUMN_ID");
        this.m_columnType = colDescResult.getInt("SQL_TYPE");
        this.m_versioned = colDescResult.getInt("COLUMN_GROUP_VERSIONED") == 1;
        this.m_keyPos = colDescResult.getInt("KEY_POS");
        this.m_hasAnyConstraint = false;
        long groupID = colDescResult.getLong("COLUMN_GROUP_ID");
        this.m_columnGroupID = this.m_versioned || groupID == -1L || groupID == -2L ? null : new Long(groupID);
        Integer resultColNo = (Integer)colNameIndex.get(this.m_columnName);
        if (resultColNo == null) {
            throw new SQLException("unknown column name: " + this.m_columnName);
        }
        this.m_resultColNo = resultColNo;
        if (this.m_keyPos != -1) {
            keyColList.addLast(this);
        }
    }

    void addConstraintList(LinkedList constraintList) {
        if (constraintList.size() <= 0) {
            return;
        }
        this.m_constraints = new CaptureColConstraint[constraintList.size()];
        Iterator iter = constraintList.iterator();
        for (int i = 0; i < this.m_constraints.length; ++i) {
            this.m_constraints[i] = (CaptureColConstraint)iter.next();
        }
    }

    int addDataToMsg(Connection con, CaptureResultRow captureRow, RowSendMessage msg, byte imageType) throws SQLException {
        int unqualifiedClientsCount = 0;
        if (this.m_resultColNo < 1) {
            return unqualifiedClientsCount;
        }
        if (imageType == 1 && this.m_constraints != null) {
            unqualifiedClientsCount = this.checkConstraints(con, captureRow, this.m_resultColNo, msg);
        }
        msg.addColumn(this.m_columnID, this.m_columnType, captureRow, this.m_resultColNo, imageType);
        return unqualifiedClientsCount;
    }

    void addDataToMsg(Connection con, CaptureResultRow captureRow, int colNo, RowSendMessage msg) throws SQLException {
        if (this.m_constraints != null) {
            this.checkConstraints(con, captureRow, colNo, msg);
        }
        msg.addColumn(this.m_columnID, this.m_columnType, captureRow, colNo, (byte)1);
    }

    void addGroupBeforeImageToMsg(CaptureResultRow row, RowSendMessage msg) throws SQLException {
        msg.addColumn(this.m_columnID, this.m_columnType, row, this.m_resultColNo, (byte)0);
    }

    private int checkConstraints(Connection con, CaptureResultRow captureRow, int captureColNo, RowSendMessage msg) throws SQLException {
        String colValue = captureRow.getString(captureColNo);
        boolean isNull = captureRow.wasNull();
        int violationCount = 0;
        for (int i = 0; i < this.m_constraints.length; ++i) {
            Long unqualifiedClient = this.m_constraints[i].checkUnqualifiedClient(con, colValue, isNull);
            if (unqualifiedClient == null) continue;
            ++violationCount;
            msg.addUnqualifiedClient(unqualifiedClient);
        }
        return violationCount;
    }

    Long getColGroupID() {
        return this.m_columnGroupID;
    }

    long getID() {
        return this.m_columnID;
    }

    String getName() {
        return this.m_columnName;
    }

    boolean hasConstraint() {
        return this.m_hasAnyConstraint;
    }

    boolean isKeyCol() {
        return this.m_keyPos != -1;
    }

    boolean isUpdatedCol(byte[] colUpdateFlags) {
        return colUpdateFlags != null && this.m_resultColNo <= colUpdateFlags.length ? colUpdateFlags[this.m_resultColNo - 1] == 1 : false;
    }

    boolean isVersionedCol() {
        return this.m_versioned;
    }

    void setPrepStmtKeyCol(int paramNo, CaptureResultRow captureRow, PreparedStatement prepStmtDeleteShadowRows, PreparedStatement prepStmtSelectSourceRow) throws SQLException {
        switch (this.m_columnType) {
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                long x = captureRow.getLong(this.m_resultColNo);
                prepStmtDeleteShadowRows.setLong(paramNo, x);
                prepStmtSelectSourceRow.setLong(paramNo, x);
                return;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                double x = captureRow.getDouble(this.m_resultColNo);
                prepStmtDeleteShadowRows.setDouble(paramNo, x);
                prepStmtSelectSourceRow.setDouble(paramNo, x);
                return;
            }
            case -1: 
            case 1: 
            case 12: {
                String x = captureRow.getString(this.m_resultColNo);
                prepStmtDeleteShadowRows.setString(paramNo, x);
                prepStmtSelectSourceRow.setString(paramNo, x);
                return;
            }
            case 91: {
                Date x = captureRow.getDate(this.m_resultColNo);
                prepStmtDeleteShadowRows.setDate(paramNo, x);
                prepStmtSelectSourceRow.setDate(paramNo, x);
                return;
            }
            case 92: {
                Time x = captureRow.getTime(this.m_resultColNo);
                prepStmtDeleteShadowRows.setTime(paramNo, x);
                prepStmtSelectSourceRow.setTime(paramNo, x);
                return;
            }
            case 93: {
                Timestamp x = captureRow.getTimestamp(this.m_resultColNo);
                prepStmtDeleteShadowRows.setTimestamp(paramNo, x);
                prepStmtSelectSourceRow.setTimestamp(paramNo, x);
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] x = captureRow.getBytes(this.m_resultColNo);
                prepStmtDeleteShadowRows.setBytes(paramNo, x);
                prepStmtSelectSourceRow.setBytes(paramNo, x);
                return;
            }
        }
        Object x = captureRow.getObject(this.m_resultColNo);
        prepStmtDeleteShadowRows.setObject(paramNo, x);
        prepStmtSelectSourceRow.setObject(paramNo, x);
    }
}

