/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan;

import com.sap.sdb.programmargs.AccParams;
import com.sap.sdb.programmargs.PasswordPrompt;
import com.sap.sdb.syncMan.SyncManThreadManager;
import com.sap.sdb.syncMan.SyncServiceAdminThread;
import com.sap.sdb.syncMan.capture.CaptureManager;
import com.sap.sdb.syncMan.consumption.ConsumptionManager;
import com.sap.sdb.syncMan.definition.ReplicationSchema;
import com.sap.sdb.syncMan.util.Configuration;
import com.sap.sdb.syncMan.util.ConnectionPool;
import com.sap.sdb.syncMan.util.DebugOutput;
import com.sap.sdb.syncMan.util.FileConfiguration;
import com.sap.sdb.syncMan.util.SQLNames;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class SyncService
implements SQLNames {
    private static final String VERSION_MAJOR = "7";
    private static final String VERSION_MINOR = "6";
    private static SyncService s_agent;
    private static final String NO_CAPTURE = "no_capture";
    private static final String NO_CONSUMPTION = "no_consumption";
    private static final String INITIAL = "initial";
    private static final String INITIAL_CLIENT = "initial_client";
    private static final String ACCUMULATED_UPDATES = "accumulated_updates";
    private static final String TRANSIENT = "transient";
    private static final String MAX_CAPTURE_TABLE_HANDLERS = "max_capture_table_handlers";
    private static final String CONSUMPTION_UPDATE_HANDLERS = "consumption_update_handlers";
    private static final String DISPLAY_INTERVAL_SEC = "display_interval_sec";
    public static final String URL = "database_url";
    public static final String JDBC_DRIVER = "jdbc_driver";
    public static final String DB_HOST = "database_host";
    public static final String DB_NAME = "database_name";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String DATABASE_KEY = "access_key";
    public static final String OLDSCHOOL_DB_HOST = "n";
    public static final String OLDSCHOOL_DB_NAME = "d";
    public static final String OLDSCHOOL_USER_PASSWORD = "u";
    public static final String OLDSCHOOL_DATABASE_KEY = "A";
    private static final String CONFIG = "config";
    private static final String UNIT_SELECTION = "units";
    private static final String UNITS = "unit_list_item";
    private static final String EXIT_TIMEOUT = "exit_timeout";
    private static final String PARAM_INFO = "param_info";
    private static final String LOGFILE = "logfile";
    private static final String VERBOSE = "verbose";
    private static final String VERBOSE_PARAM = "verbose_param";
    private static final String VERBOSE_CAPTURE = "verbose_capture";
    private static final String VERBOSE_CAPTURE_MESSAGES = "verbose_capture_messages";
    private static final String VERBOSE_CONSUMPTION = "verbose_consumption";
    private static final String VERBOSE_CONSUMPTION_MESSAGES = "verbose_consumption_messages";
    private static final String VERBOSE_EXCEPTION = "verbose_exception";
    private static final String VERBOSE_EXCEPTION_STACKTRACE = "verbose_exception_stacktrace";
    private static final String VERBOSE_WAIT = "verbose_wait";
    private static final String SILENT = "silent";
    private static final String CONFLICT_TABLES = "conflict_tables";
    private static final String AUDIT_TABLES = "audit_tables";
    private static final String ADMIN_PORT = "admin_port";
    private static final String ADMIN_SSL = "admin_ssl";
    private static final String SECURITY_PROVIDER = "security_provider";
    private static final String HELP = "help";
    private static final String HELP2 = "-help";
    private static final String HELP3 = "-h";
    private static final String HELP4 = "?";
    private static final String HELP5 = "-?";
    private static final String MSGSERVER_CONTEXT_FACTORY = "msgserver_context_factory";
    private static final String MSGSERVER_JNDI_HOST = "jndiserver_host";
    private static final String MSGSERVER_JNDI_PORT = "jndiserver_port";
    private static final String MSGSERVER_JMS_HOST = "msgserver_host";
    private static final String MSGSERVER_JMS_PORT = "msgserver_port";
    private static final String MSGCLIENT_JMS_TIMEOUT = "msgclient_socket_timeout";
    private static final String MSGCLIENT_JMS_LOGFILE = "msgclient_logfile";
    private static final String MSGCLIENT_JMS_MAXQUEUESIZE = "msgclient_maxqueuesize";
    private static final String DEFAULT_NO_CAPTURE = "false";
    private static final String DEFAULT_NO_CONSUMPTION = "false";
    private static final String DEFAULT_INITIAL = "false";
    private static final String DEFAULT_INITIAL_CLIENT = "allunits";
    private static final String DEFAULT_ACCUMULATED_UPDATES = "false";
    private static final String DEFAULT_TRANSIENT = "false";
    private static final String DEFAULT_MAX_CAPTURE_TABLE_HANDLERS = "3";
    private static final String DEFAULT_CONSUMPTION_UPDATE_HANDLERS = "3";
    private static final String DEFAULT_DISPLAY_INTERVAL_SEC = "10";
    private static final String DEFAULT_JDBC_DRIVER = "com.sap.dbtech.jdbc.DriverSapDB";
    private static final String DEFAULT_DATABASE_KEY = "DBSERVICE";
    private static final String DEFAULT_UNIT_SELECTION = "false";
    private static final String[] DEFAULT_UNITS;
    private static final String DEFAULT_EXIT_TIMEOUT = "0";
    private static final String DEFAULT_PARAM_INFO = "false";
    private static final String DEFAULT_LOGFILE;
    private static final String DEFAULT_VERBOSE = "false";
    private static final String DEFAULT_VERBOSE_PARAM = "false";
    private static final String DEFAULT_VERBOSE_CAPTURE = "false";
    private static final String DEFAULT_VERBOSE_CAPTURE_MESSAGES = "false";
    private static final String DEFAULT_VERBOSE_CONSUMPTION = "false";
    private static final String DEFAULT_VERBOSE_CONSUMPTION_MESSAGES = "false";
    private static final String DEFAULT_VERBOSE_EXCEPTION = "false";
    private static final String DEFAULT_VERBOSE_EXCEPTION_STACKTRACE = "false";
    private static final String DEFAULT_VERBOSE_WAIT = "false";
    private static final String DEFAULT_SILENT = "false";
    private static final String DEFAULT_CONFLICT_TABLES = "false";
    private static final String DEFAULT_AUDIT_TABLES = "false";
    private static final String DEFAULT_HELP = "false";
    private static final String DEFAULT_ADMIN_PORT = "7223";
    private static final String DEFAULT_ADMIN_SSL = "false";
    private static final String DEFAULT_SECURITY_PROVIDER = "com.sun.crypto.provider.SunJCE";
    private static String DEFAULT_MSGSERVER_CONTEXT_FACTORY;
    private static String DEFAULT_MSGSERVER_JNDI_HOST;
    private static String DEFAULT_MSGSERVER_JNDI_PORT;
    private static String DEFAULT_MSGSERVER_JMS_HOST;
    private static String DEFAULT_MSGSERVER_JMS_PORT;
    private static String DEFAULT_MSGCLIENT_JMS_TIMEOUT;
    private static String DEFAULT_MSGCLIENT_JMS_LOGFILE;
    private static String DEFAULT_MSGCLIENT_JMS_MAXQUEUESIZE;
    private static final String SRCNAME_CMDL = "commandline option";
    private static final String SRCNAME_FILE = "configuration file";
    private static final String SRCNAME_INTERNAL = "internal default";
    private boolean m_noCapture;
    private boolean m_noConsumption;
    private boolean m_initialCopy;
    private String m_initialClient;
    private boolean m_accumulatedUpdates;
    private boolean m_sendTransient;
    private int m_maxCaptureTableHandlers;
    private int m_consumptionUpdateHandlers;
    private int m_displayIntervalSec;
    private String m_databaseURL;
    private String m_jdbcDriver;
    private String m_dbHost;
    private String m_dbName;
    private String m_username;
    private String m_password;
    private String m_databaseKey;
    private String m_oldschoolDatabaseKey;
    private String m_oldschoolDbHost;
    private String m_oldschoolDbName;
    private String m_oldschoolUsernamePassword;
    private String m_configFilename;
    private boolean m_unit_selection;
    private String[] m_units;
    private int m_exitTimeoutSec;
    private boolean m_paramInfo;
    private String m_logFile;
    private boolean m_verbose;
    private boolean m_verboseParam;
    private boolean m_verboseCapture;
    private boolean m_verboseCaptureMessages;
    private boolean m_verboseConsumption;
    private boolean m_verboseConsumptionMessages;
    private boolean m_verboseEception;
    private boolean m_verboseExceptionStacktrace;
    private boolean m_verboseWait;
    private boolean m_silent;
    private boolean m_conflict_tables;
    private boolean m_audit_tables;
    private boolean m_help;
    private String m_msgServerContextFactory;
    private String m_msgServerJNDIHost;
    private String m_msgServerJNDIPort;
    private String m_msgServerJMSHost;
    private String m_msgServerJMSPort;
    private String m_msgClientJMSTimeout;
    private String m_msgClientJMSLogfile;
    private String m_msgClientJMSMaxqueuesize;
    private Properties m_jndiProps;
    private boolean m_adminSSL;
    private String m_adminPort;
    private String m_securityProvider;
    private String m_oldschoolUsername;
    private String m_oldschoolPassword;
    private String m_effectiveDatabaseKey;
    private String m_effectiveDbHost;
    private String m_effectiveDbName;
    private String m_effectiveUsername;
    private String m_effectivePassword;
    private String m_effectiveAdminPort;
    private static final String LSEP;
    private HashMap m_paramSrcNames;
    private boolean m_keepAlive;
    SyncServiceAdminThread m_adminThread;

    public static void main(String[] argv) {
        s_agent = new SyncService(argv);
        s_agent.doReplication();
    }

    public static Properties getJndiProps() {
        return SyncService.s_agent.m_jndiProps;
    }

    private SyncService(String[] argv) {
        Exception exit_reason = null;
        try {
            this.m_jndiProps = new Properties();
            InputStream istream = ClassLoader.getSystemClassLoader().getResourceAsStream("jndi.properties");
            this.m_jndiProps.load(istream);
            if (istream != null) {
                istream.close();
            }
            if (this.m_jndiProps.getProperty("java.naming.factory.initial") != null) {
                DEFAULT_MSGSERVER_CONTEXT_FACTORY = this.m_jndiProps.getProperty("java.naming.factory.initial");
            }
            if (this.m_jndiProps.getProperty("jndi.host") != null) {
                DEFAULT_MSGSERVER_JNDI_HOST = this.m_jndiProps.getProperty("jndi.host");
            }
            if (this.m_jndiProps.getProperty("jndi.port") != null) {
                DEFAULT_MSGSERVER_JNDI_PORT = this.m_jndiProps.getProperty("jndi.port");
            }
            if (this.m_jndiProps.getProperty("jms.host") != null) {
                DEFAULT_MSGSERVER_JMS_HOST = this.m_jndiProps.getProperty("jms.host");
            }
            if (this.m_jndiProps.getProperty("jms.port") != null) {
                DEFAULT_MSGSERVER_JMS_PORT = this.m_jndiProps.getProperty("jms.port");
            }
            if (this.m_jndiProps.getProperty("jms.timeout") != null) {
                DEFAULT_MSGCLIENT_JMS_TIMEOUT = this.m_jndiProps.getProperty("jms.timeout");
            }
            if (this.m_jndiProps.getProperty("jms.logfile") != null) {
                DEFAULT_MSGCLIENT_JMS_LOGFILE = this.m_jndiProps.getProperty("jms.logfile");
            }
            if (this.m_jndiProps.getProperty("jms.maxqueuesize") != null) {
                DEFAULT_MSGCLIENT_JMS_MAXQUEUESIZE = this.m_jndiProps.getProperty("jms.maxqueuesize");
            }
            this.processOptions(argv);
        }
        catch (Exception ex) {
            exit_reason = ex;
        }
        if (this.m_verboseParam) {
            this.displayParamInfo();
        } else {
            this.displayBriefParamInfo();
        }
        if (exit_reason != null) {
            DebugOutput.println();
            DebugOutput.println("ERROR: configuring parameters failed, reason:");
            DebugOutput.println("ERROR: " + exit_reason.toString());
            DebugOutput.println("ERROR: " + exit_reason.getMessage());
            if (this.m_verboseExceptionStacktrace) {
                exit_reason.printStackTrace();
            }
            System.exit(-1);
        }
        if (this.m_paramInfo) {
            System.exit(0);
        }
        this.displayMode();
        this.m_keepAlive = true;
        SyncManThreadManager.createInstance();
        if (this.m_effectiveAdminPort == null || this.m_effectiveAdminPort.length() < 1) {
            this.m_effectiveAdminPort = DEFAULT_ADMIN_PORT;
        }
        DebugOutput.println("INFO: starting administration thread at port " + this.m_effectiveAdminPort + " ...");
        this.m_adminThread = new SyncServiceAdminThread(this, Integer.parseInt(this.m_effectiveAdminPort), this.m_adminSSL, ConnectionPool.getReplicationUserPassword());
        this.m_adminThread.setDaemon(true);
        this.m_adminThread.start();
        DebugOutput.println("INFO: ... done.");
    }

    private void doReplication() {
        try {
            ReplicationSchema schema = new ReplicationSchema(this.m_units, this.m_noConsumption, this.m_jndiProps);
            if (!this.m_noConsumption) {
                ConsumptionManager.createInstance(schema, this.m_consumptionUpdateHandlers, this.m_audit_tables, this.m_conflict_tables);
                ConsumptionManager.startConsumption();
            }
            if (!this.m_noCapture && schema.getOutUnitCount() > 0) {
                if (this.m_initialCopy) {
                    CaptureManager.startInitialClientCopy(SyncService.getJndiProps(), this.m_initialClient, this.m_units, this.m_sendTransient, this.m_maxCaptureTableHandlers);
                } else {
                    CaptureManager.startCaptureTransacted(SyncService.getJndiProps(), this.m_accumulatedUpdates, this.m_exitTimeoutSec * 1000, this.m_sendTransient, this.m_maxCaptureTableHandlers);
                }
            }
            SyncManThreadManager.startMonitoring(this.m_displayIntervalSec);
            if (!this.m_noCapture && schema.getOutUnitCount() > 0) {
                CaptureManager.waitForTablesCaptured();
            }
            if (!this.m_initialCopy) {
                this.waitForInactivityTimeout();
            }
        }
        catch (Exception ex) {
            DebugOutput.setVerboseException();
            DebugOutput.printException(ex);
        }
        this.shutdownServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownServer() {
        try {
            Exception fatalError;
            if (this.m_adminThread != null) {
                this.m_adminThread.pleaseStop();
            }
            SyncManThreadManager.stopAllThreads();
            if (!this.m_noCapture) {
                CaptureManager.destroyInstance();
            }
            if (!this.m_noConsumption) {
                ConsumptionManager.destroyInstance();
            }
            if ((fatalError = SyncManThreadManager.getFatalError()) != null) {
                throw fatalError;
            }
        }
        catch (Exception ex) {
            DebugOutput.setVerboseException();
            DebugOutput.printException(ex);
        }
        finally {
            SyncManThreadManager.destroyInstance();
            ConnectionPool.destroyInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInactivityTimeout() {
        if (this.m_exitTimeoutSec > 0) {
            this.m_keepAlive = true;
            while (this.m_keepAlive) {
                this.m_keepAlive = false;
                try {
                    Thread.sleep(this.m_exitTimeoutSec * 1000);
                }
                catch (InterruptedException iex) {
                    return;
                }
                if (SyncManThreadManager.getFatalError() == null) continue;
                return;
            }
        } else {
            while (SyncManThreadManager.getFatalError() == null) {
                try {
                    SyncService iex = this;
                    synchronized (iex) {
                        this.wait(10000L);
                    }
                }
                catch (InterruptedException iex) {
                    return;
                }
            }
        }
    }

    public static void keepAlive() {
        if (s_agent != null) {
            SyncService.s_agent.m_keepAlive = true;
        }
    }

    private void processOptions(String[] argv) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        this.m_paramSrcNames = new HashMap();
        String no_conf = "NOT CONFIGURED";
        this.m_paramSrcNames.put(NO_CAPTURE, no_conf);
        this.m_paramSrcNames.put(NO_CONSUMPTION, no_conf);
        this.m_paramSrcNames.put(INITIAL, no_conf);
        this.m_paramSrcNames.put(INITIAL_CLIENT, no_conf);
        this.m_paramSrcNames.put(ACCUMULATED_UPDATES, no_conf);
        this.m_paramSrcNames.put(TRANSIENT, no_conf);
        this.m_paramSrcNames.put(MAX_CAPTURE_TABLE_HANDLERS, no_conf);
        this.m_paramSrcNames.put(CONSUMPTION_UPDATE_HANDLERS, no_conf);
        this.m_paramSrcNames.put(DISPLAY_INTERVAL_SEC, no_conf);
        this.m_paramSrcNames.put(VERBOSE, no_conf);
        this.m_paramSrcNames.put(VERBOSE_PARAM, no_conf);
        this.m_paramSrcNames.put(VERBOSE_CAPTURE, no_conf);
        this.m_paramSrcNames.put(VERBOSE_CAPTURE_MESSAGES, no_conf);
        this.m_paramSrcNames.put(VERBOSE_CONSUMPTION, no_conf);
        this.m_paramSrcNames.put(VERBOSE_CONSUMPTION_MESSAGES, no_conf);
        this.m_paramSrcNames.put(VERBOSE_EXCEPTION, no_conf);
        this.m_paramSrcNames.put(VERBOSE_EXCEPTION_STACKTRACE, no_conf);
        this.m_paramSrcNames.put(VERBOSE_WAIT, no_conf);
        this.m_paramSrcNames.put(URL, no_conf);
        this.m_paramSrcNames.put(JDBC_DRIVER, no_conf);
        this.m_paramSrcNames.put(DB_HOST, no_conf);
        this.m_paramSrcNames.put(DB_NAME, no_conf);
        this.m_paramSrcNames.put(USER, no_conf);
        this.m_paramSrcNames.put(PASSWORD, no_conf);
        this.m_paramSrcNames.put(DATABASE_KEY, no_conf);
        this.m_paramSrcNames.put(OLDSCHOOL_DATABASE_KEY, no_conf);
        this.m_paramSrcNames.put(OLDSCHOOL_DB_HOST, no_conf);
        this.m_paramSrcNames.put(OLDSCHOOL_DB_NAME, no_conf);
        this.m_paramSrcNames.put(OLDSCHOOL_USER_PASSWORD, no_conf);
        this.m_paramSrcNames.put(CONFIG, no_conf);
        this.m_paramSrcNames.put(UNIT_SELECTION, no_conf);
        this.m_paramSrcNames.put(UNITS, no_conf);
        this.m_paramSrcNames.put(EXIT_TIMEOUT, no_conf);
        this.m_paramSrcNames.put(PARAM_INFO, no_conf);
        this.m_paramSrcNames.put(LOGFILE, no_conf);
        this.m_paramSrcNames.put(SILENT, no_conf);
        this.m_paramSrcNames.put(CONFLICT_TABLES, no_conf);
        this.m_paramSrcNames.put(AUDIT_TABLES, no_conf);
        this.m_paramSrcNames.put(HELP, no_conf);
        this.m_paramSrcNames.put(ADMIN_SSL, no_conf);
        this.m_paramSrcNames.put(ADMIN_PORT, no_conf);
        this.m_paramSrcNames.put(MSGSERVER_JNDI_HOST, no_conf);
        this.m_paramSrcNames.put(MSGSERVER_JNDI_PORT, no_conf);
        this.m_paramSrcNames.put(MSGSERVER_JMS_HOST, no_conf);
        this.m_paramSrcNames.put(MSGSERVER_JMS_PORT, no_conf);
        this.m_paramSrcNames.put(MSGCLIENT_JMS_TIMEOUT, no_conf);
        this.m_paramSrcNames.put(MSGCLIENT_JMS_LOGFILE, no_conf);
        this.m_paramSrcNames.put(MSGCLIENT_JMS_MAXQUEUESIZE, no_conf);
        this.m_paramSrcNames.put(SECURITY_PROVIDER, no_conf);
        defaults.put(NO_CAPTURE, "false");
        defaults.put(NO_CONSUMPTION, "false");
        defaults.put(INITIAL, "false");
        defaults.put(INITIAL_CLIENT, DEFAULT_INITIAL_CLIENT);
        defaults.put(ACCUMULATED_UPDATES, "false");
        defaults.put(TRANSIENT, "false");
        defaults.put(MAX_CAPTURE_TABLE_HANDLERS, "3");
        defaults.put(CONSUMPTION_UPDATE_HANDLERS, "3");
        defaults.put(DISPLAY_INTERVAL_SEC, DEFAULT_DISPLAY_INTERVAL_SEC);
        defaults.put(JDBC_DRIVER, DEFAULT_JDBC_DRIVER);
        defaults.put(VERBOSE, "false");
        defaults.put(VERBOSE_PARAM, "false");
        defaults.put(VERBOSE_CAPTURE, "false");
        defaults.put(VERBOSE_CAPTURE_MESSAGES, "false");
        defaults.put(VERBOSE_CONSUMPTION, "false");
        defaults.put(VERBOSE_CONSUMPTION_MESSAGES, "false");
        defaults.put(VERBOSE_EXCEPTION, "false");
        defaults.put(VERBOSE_EXCEPTION_STACKTRACE, "false");
        defaults.put(VERBOSE_WAIT, "false");
        defaults.put(EXIT_TIMEOUT, DEFAULT_EXIT_TIMEOUT);
        defaults.put(UNIT_SELECTION, "false");
        defaults.put(UNITS, DEFAULT_UNITS);
        defaults.put(PARAM_INFO, "false");
        defaults.put(LOGFILE, DEFAULT_LOGFILE);
        defaults.put(SILENT, "false");
        defaults.put(CONFLICT_TABLES, "false");
        defaults.put(AUDIT_TABLES, "false");
        defaults.put(HELP, "false");
        defaults.put(ADMIN_SSL, "false");
        defaults.put(MSGSERVER_CONTEXT_FACTORY, DEFAULT_MSGSERVER_CONTEXT_FACTORY);
        defaults.put(MSGSERVER_JNDI_HOST, DEFAULT_MSGSERVER_JNDI_HOST);
        defaults.put(MSGSERVER_JNDI_PORT, DEFAULT_MSGSERVER_JNDI_PORT);
        defaults.put(MSGSERVER_JMS_HOST, DEFAULT_MSGSERVER_JMS_HOST);
        defaults.put(MSGSERVER_JMS_PORT, DEFAULT_MSGSERVER_JMS_PORT);
        defaults.put(MSGCLIENT_JMS_TIMEOUT, DEFAULT_MSGCLIENT_JMS_TIMEOUT);
        defaults.put(MSGCLIENT_JMS_LOGFILE, DEFAULT_MSGCLIENT_JMS_LOGFILE);
        defaults.put(MSGCLIENT_JMS_MAXQUEUESIZE, DEFAULT_MSGCLIENT_JMS_MAXQUEUESIZE);
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equalsIgnoreCase("-no_capture")) {
                options.put(NO_CAPTURE, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-no_consumption")) {
                options.put(NO_CONSUMPTION, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-initial")) {
                options.put(INITIAL, "true");
                if (argv.length > i + 1) {
                    options.put(INITIAL_CLIENT, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for initial option.");
            }
            if (argv[i].equalsIgnoreCase("-accumulated_updates")) {
                options.put(ACCUMULATED_UPDATES, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-transient")) {
                options.put(TRANSIENT, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-max_capture_table_handlers")) {
                if (argv.length > i + 1) {
                    options.put(MAX_CAPTURE_TABLE_HANDLERS, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for max_capture_table_handlers option.");
            }
            if (argv[i].equalsIgnoreCase("-consumption_update_handlers")) {
                if (argv.length > i + 1) {
                    options.put(CONSUMPTION_UPDATE_HANDLERS, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for consumption_update_handlers option.");
            }
            if (argv[i].equalsIgnoreCase("-display_interval_sec")) {
                if (argv.length > i + 1) {
                    options.put(DISPLAY_INTERVAL_SEC, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for display_interval_sec option.");
            }
            if (argv[i].equalsIgnoreCase(HELP) || argv[i].equalsIgnoreCase(HELP2) || argv[i].equalsIgnoreCase(HELP3) || argv[i].equalsIgnoreCase(HELP4) || argv[i].equalsIgnoreCase(HELP5)) {
                options.put(HELP, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-verbose")) {
                options.put(VERBOSE, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-verbose_param")) {
                options.put(VERBOSE_PARAM, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-verbose_capture")) {
                options.put(VERBOSE_CAPTURE, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-verbose_capture_messages")) {
                options.put(VERBOSE_CAPTURE_MESSAGES, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-verbose_consumption")) {
                options.put(VERBOSE_CONSUMPTION, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-verbose_consumption_messages")) {
                options.put(VERBOSE_CONSUMPTION_MESSAGES, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-verbose_exception")) {
                options.put(VERBOSE_EXCEPTION, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-verbose_exception_stacktrace")) {
                options.put(VERBOSE_EXCEPTION_STACKTRACE, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-verbose_wait")) {
                options.put(VERBOSE_WAIT, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-database_url")) {
                if (argv.length > i + 1) {
                    options.put(URL, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for database_url option.");
            }
            if (argv[i].equalsIgnoreCase("-jdbc_driver")) {
                if (argv.length > i + 1) {
                    options.put(JDBC_DRIVER, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for jdbc_driver option.");
            }
            if (argv[i].equalsIgnoreCase("-database_host")) {
                if (argv.length > i + 1) {
                    options.put(DB_HOST, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for database_host option.");
            }
            if (argv[i].equalsIgnoreCase("-database_name")) {
                if (argv.length > i + 1) {
                    options.put(DB_NAME, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for database_name option.");
            }
            if (argv[i].equalsIgnoreCase("-user")) {
                if (argv.length > i + 1) {
                    options.put(USER, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for user option.");
            }
            if (argv[i].equalsIgnoreCase("-password")) {
                if (argv.length > i + 1) {
                    options.put(PASSWORD, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for password option.");
            }
            if (argv[i].equalsIgnoreCase("-access_key")) {
                if (argv.length > i + 1) {
                    options.put(DATABASE_KEY, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for access_key option.");
            }
            if (argv[i].equals("-n")) {
                if (argv.length > i + 1) {
                    options.put(OLDSCHOOL_DB_HOST, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for n option.");
            }
            if (argv[i].equals("-d")) {
                if (argv.length > i + 1) {
                    options.put(OLDSCHOOL_DB_NAME, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for d option.");
            }
            if (argv[i].equals("-u")) {
                if (argv.length > i + 1) {
                    options.put(OLDSCHOOL_USER_PASSWORD, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for u option.");
            }
            if (argv[i].equals("-A")) {
                if (argv.length > i + 1) {
                    options.put(OLDSCHOOL_DATABASE_KEY, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for A option.");
            }
            if (argv[i].equalsIgnoreCase("-config")) {
                if (argv.length > i + 1) {
                    options.put(CONFIG, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for config option.");
            }
            if (argv[i].equalsIgnoreCase("-exit_timeout")) {
                if (argv.length > i + 1) {
                    options.put(EXIT_TIMEOUT, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for exit_timeout option.");
            }
            if (argv[i].equalsIgnoreCase("-param_info")) {
                options.put(PARAM_INFO, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-logfile")) {
                if (argv.length > i + 1) {
                    options.put(LOGFILE, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for logfile option.");
            }
            if (argv[i].equalsIgnoreCase("-jndiserver_host")) {
                if (argv.length > i + 1) {
                    options.put(MSGSERVER_JNDI_HOST, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for jndiserver_host option.");
            }
            if (argv[i].equalsIgnoreCase("-jndiserver_port")) {
                if (argv.length > i + 1) {
                    options.put(MSGSERVER_JNDI_PORT, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for jndiserver_port option.");
            }
            if (argv[i].equalsIgnoreCase("-msgserver_host")) {
                if (argv.length > i + 1) {
                    options.put(MSGSERVER_JMS_HOST, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for msgserver_host option.");
            }
            if (argv[i].equalsIgnoreCase("-msgserver_port")) {
                if (argv.length > i + 1) {
                    options.put(MSGSERVER_JMS_PORT, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for msgserver_port option.");
            }
            if (argv[i].equalsIgnoreCase("-msgclient_socket_timeout")) {
                if (argv.length > i + 1) {
                    options.put(MSGCLIENT_JMS_TIMEOUT, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for msgclient_socket_timeout option.");
            }
            if (argv[i].equalsIgnoreCase("-msgclient_logfile")) {
                if (argv.length > i + 1) {
                    options.put(MSGCLIENT_JMS_LOGFILE, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for msgclient_logfile option.");
            }
            if (argv[i].equalsIgnoreCase("-msgclient_maxqueuesize")) {
                if (argv.length > i + 1) {
                    options.put(MSGCLIENT_JMS_MAXQUEUESIZE, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for msgclient_maxqueuesize option.");
            }
            if (argv[i].equalsIgnoreCase("-silent")) {
                options.put(SILENT, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-conflict_tables")) {
                options.put(CONFLICT_TABLES, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-audit_tables")) {
                options.put(AUDIT_TABLES, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-units")) {
                options.put(UNIT_SELECTION, "true");
                String[] arry = new String[argv.length - i - 1];
                for (int j = 0; j < argv.length - i - 1; ++j) {
                    arry[j] = argv[i + j + 1];
                }
                i = argv.length - 1;
                options.put(UNITS, arry);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-admin_ssl")) {
                options.put(ADMIN_SSL, "true");
                continue;
            }
            if (argv[i].equalsIgnoreCase("-admin_port")) {
                if (argv.length > i + 1) {
                    options.put(ADMIN_PORT, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for jndiserver_port option.");
            }
            if (argv[i].equalsIgnoreCase("-security_provider")) {
                if (argv.length > i + 1) {
                    options.put(SECURITY_PROVIDER, argv[i + 1]);
                    ++i;
                    continue;
                }
                throw new Exception("missing parameter for security_provider option.");
            }
            throw new Exception("unknown commandline option \"" + argv[i] + "\".");
        }
        FileConfiguration fileConfig = null;
        Object[] param_srcs = new Object[]{options};
        String[] src_names = new String[]{SRCNAME_CMDL};
        this.m_configFilename = this.getStringParameter(CONFIG, param_srcs, src_names);
        this.m_help = this.getBoolParameter(HELP, param_srcs, src_names);
        if (this.m_configFilename != null) {
            fileConfig = new FileConfiguration(this.m_configFilename);
        }
        if (this.m_help) {
            this.displayHelp();
            System.exit(0);
        }
        param_srcs = new Object[]{options, fileConfig, defaults};
        src_names = new String[]{SRCNAME_CMDL, SRCNAME_FILE, SRCNAME_INTERNAL};
        this.m_jdbcDriver = this.getStringParameter(JDBC_DRIVER, param_srcs, src_names);
        this.m_silent = this.getBoolParameter(SILENT, param_srcs, src_names);
        this.m_oldschoolDbHost = this.getStringParameter(OLDSCHOOL_DB_HOST, param_srcs, src_names);
        this.m_databaseKey = this.getStringParameter(DATABASE_KEY, param_srcs, src_names);
        this.m_oldschoolDatabaseKey = this.getStringParameter(OLDSCHOOL_DATABASE_KEY, param_srcs, src_names);
        this.m_dbHost = this.getStringParameter(DB_HOST, param_srcs, src_names);
        this.m_dbName = this.getStringParameter(DB_NAME, param_srcs, src_names);
        this.m_oldschoolDbName = this.getStringParameter(OLDSCHOOL_DB_NAME, param_srcs, src_names);
        this.m_username = this.getStringParameter(USER, param_srcs, src_names);
        this.m_oldschoolUsernamePassword = this.getStringParameter(OLDSCHOOL_USER_PASSWORD, param_srcs, src_names);
        this.m_password = this.getStringParameter(PASSWORD, param_srcs, src_names);
        this.m_databaseURL = this.getStringParameter(URL, param_srcs, src_names);
        this.m_noCapture = this.getBoolParameter(NO_CAPTURE, param_srcs, src_names);
        this.m_noConsumption = this.getBoolParameter(NO_CONSUMPTION, param_srcs, src_names);
        this.m_initialCopy = this.getBoolParameter(INITIAL, param_srcs, src_names);
        this.m_initialClient = this.getStringParameter(INITIAL_CLIENT, param_srcs, src_names);
        this.m_accumulatedUpdates = this.getBoolParameter(ACCUMULATED_UPDATES, param_srcs, src_names);
        this.m_sendTransient = this.getBoolParameter(TRANSIENT, param_srcs, src_names);
        this.m_maxCaptureTableHandlers = this.getIntParameter(MAX_CAPTURE_TABLE_HANDLERS, param_srcs, src_names);
        this.m_consumptionUpdateHandlers = this.getIntParameter(CONSUMPTION_UPDATE_HANDLERS, param_srcs, src_names);
        this.m_displayIntervalSec = this.getIntParameter(DISPLAY_INTERVAL_SEC, param_srcs, src_names);
        this.m_verbose = this.getBoolParameter(VERBOSE, param_srcs, src_names);
        this.m_verboseParam = this.getBoolParameter(VERBOSE_PARAM, param_srcs, src_names);
        this.m_verboseCapture = this.getBoolParameter(VERBOSE_CAPTURE, param_srcs, src_names);
        this.m_verboseCaptureMessages = this.getBoolParameter(VERBOSE_CAPTURE_MESSAGES, param_srcs, src_names);
        this.m_verboseConsumption = this.getBoolParameter(VERBOSE_CONSUMPTION, param_srcs, src_names);
        this.m_verboseConsumptionMessages = this.getBoolParameter(VERBOSE_CONSUMPTION_MESSAGES, param_srcs, src_names);
        this.m_verboseEception = this.getBoolParameter(VERBOSE_EXCEPTION, param_srcs, src_names);
        this.m_verboseExceptionStacktrace = this.getBoolParameter(VERBOSE_EXCEPTION_STACKTRACE, param_srcs, src_names);
        this.m_verboseWait = this.getBoolParameter(VERBOSE_WAIT, param_srcs, src_names);
        this.m_unit_selection = this.getBoolParameter(UNIT_SELECTION, param_srcs, src_names);
        this.m_exitTimeoutSec = this.getIntParameter(EXIT_TIMEOUT, param_srcs, src_names);
        this.m_paramInfo = this.getBoolParameter(PARAM_INFO, param_srcs, src_names);
        this.m_logFile = this.getStringParameter(LOGFILE, param_srcs, src_names);
        this.m_conflict_tables = this.getBoolParameter(CONFLICT_TABLES, param_srcs, src_names);
        this.m_audit_tables = this.getBoolParameter(AUDIT_TABLES, param_srcs, src_names);
        this.m_msgServerContextFactory = this.getStringParameter(MSGSERVER_CONTEXT_FACTORY, param_srcs, src_names);
        this.m_msgServerJNDIHost = this.getStringParameter(MSGSERVER_JNDI_HOST, param_srcs, src_names);
        this.m_msgServerJNDIPort = this.getStringParameter(MSGSERVER_JNDI_PORT, param_srcs, src_names);
        this.m_msgServerJMSHost = this.getStringParameter(MSGSERVER_JMS_HOST, param_srcs, src_names);
        this.m_msgServerJMSPort = this.getStringParameter(MSGSERVER_JMS_PORT, param_srcs, src_names);
        this.m_msgClientJMSTimeout = this.getStringParameter(MSGCLIENT_JMS_TIMEOUT, param_srcs, src_names);
        this.m_msgClientJMSLogfile = this.getStringParameter(MSGCLIENT_JMS_LOGFILE, param_srcs, src_names);
        this.m_msgClientJMSMaxqueuesize = this.getStringParameter(MSGCLIENT_JMS_MAXQUEUESIZE, param_srcs, src_names);
        this.m_adminSSL = this.getBoolParameter(ADMIN_SSL, param_srcs, src_names);
        this.m_adminPort = this.getStringParameter(ADMIN_PORT, param_srcs, src_names);
        this.m_securityProvider = this.getStringParameter(SECURITY_PROVIDER, param_srcs, src_names);
        this.m_units = this.m_unit_selection ? this.getStringArrayParameter(UNITS, param_srcs, src_names) : DEFAULT_UNITS;
        DebugOutput.setSilent(this.m_silent);
        if (this.m_oldschoolUsernamePassword != null) {
            try {
                StringTokenizer tok = new StringTokenizer(this.m_oldschoolUsernamePassword, ",");
                this.m_oldschoolUsername = (String)tok.nextElement();
                this.m_oldschoolPassword = (String)tok.nextElement();
            }
            catch (Exception ex) {
                throw new Exception("illegal syntax in user name/password specification.");
            }
        }
        if (this.m_oldschoolDbHost != null && this.m_dbHost != null) {
            throw new Exception("conflicting specifications for database host.");
        }
        if (this.m_oldschoolDbName != null && this.m_dbName != null) {
            throw new Exception("conflicting specifications for database name.");
        }
        if (this.m_oldschoolUsername != null && this.m_username != null) {
            throw new Exception("conflicting specifications for user name.");
        }
        if (this.m_oldschoolPassword != null && this.m_password != null) {
            throw new Exception("conflicting specifications for password.");
        }
        if (this.m_oldschoolUsername != null) {
            this.m_effectiveUsername = this.m_oldschoolUsername;
        }
        if (this.m_username != null) {
            this.m_effectiveUsername = this.m_username;
        }
        if (this.m_oldschoolPassword != null) {
            this.m_effectivePassword = this.m_oldschoolPassword;
        }
        if (this.m_password != null) {
            this.m_effectivePassword = this.m_password;
        }
        if (this.m_oldschoolDbHost != null) {
            this.m_effectiveDbHost = this.m_oldschoolDbHost;
        }
        if (this.m_dbHost != null) {
            this.m_effectiveDbHost = this.m_dbHost;
        }
        if (this.m_oldschoolDbName != null) {
            this.m_effectiveDbName = this.m_oldschoolDbName;
        }
        if (this.m_dbName != null) {
            this.m_effectiveDbName = this.m_dbName;
        }
        if (this.m_adminPort != null) {
            this.m_effectiveAdminPort = this.m_adminPort;
        }
        if (this.m_databaseKey != null && this.m_oldschoolDatabaseKey != null) {
            throw new Exception("conflicting specifications for database key.");
        }
        if (this.m_oldschoolDatabaseKey != null) {
            this.m_effectiveDatabaseKey = this.m_oldschoolDatabaseKey;
        }
        if (this.m_databaseKey != null) {
            this.m_effectiveDatabaseKey = this.m_databaseKey;
        }
        if (this.m_effectiveDatabaseKey != null && this.m_databaseURL != null) {
            throw new Exception("conflicting specifications: database key and database url.");
        }
        if (this.m_effectiveDbHost != null && this.m_effectiveDatabaseKey != null || this.m_effectiveDbName != null && this.m_effectiveDatabaseKey != null || this.m_effectiveUsername != null && this.m_effectiveDatabaseKey != null || this.m_effectivePassword != null && this.m_effectiveDatabaseKey != null) {
            throw new Exception("conflicting specifications: db name, db host, user name, password, and database key.");
        }
        if (this.m_effectiveDbHost != null && this.m_databaseURL != null || this.m_effectiveDbName != null && this.m_databaseURL != null) {
            throw new Exception("conflicting specifications: database name, database host, and database url.");
        }
        if (this.m_effectiveAdminPort != null && this.m_effectiveDatabaseKey != null) {
            throw new Exception("conflicting specifications: admin port.");
        }
        if (this.m_effectiveDatabaseKey == null && this.m_databaseURL == null && this.m_effectiveDbHost == null && this.m_effectiveDbName == null && this.m_effectiveUsername == null && this.m_effectivePassword == null) {
            this.m_effectiveDatabaseKey = DEFAULT_DATABASE_KEY;
        }
        if (this.m_effectiveDatabaseKey != null) {
            AccParams param = new AccParams(this.m_effectiveDatabaseKey, this.m_securityProvider == null ? DEFAULT_SECURITY_PROVIDER : this.m_securityProvider);
            param.loadParameters();
            this.m_effectiveUsername = param.getDBUser();
            this.m_effectivePassword = param.getDBPassword();
            this.m_effectiveDbHost = param.getDBHost();
            this.m_effectiveDbName = param.getDBName();
            this.m_effectiveAdminPort = param.getSyncAdminPort();
            this.m_msgServerJNDIHost = param.getMsgServer();
            this.m_msgServerJNDIPort = param.getJndiPort();
            this.m_msgServerJMSHost = param.getMsgServer();
            this.m_msgServerJMSPort = param.getMsgPort();
        }
        if (this.m_effectiveUsername == null) {
            throw new Exception("database username not defined.");
        }
        if (this.m_effectivePassword == null) {
            this.m_effectivePassword = PasswordPrompt.getPassword("enter database password(will not appear):\n");
        }
        if (this.m_effectivePassword == null) {
            throw new Exception("database password not defined.");
        }
        if (this.m_databaseURL == null && (this.m_effectiveDbHost == null || this.m_effectiveDbName == null)) {
            throw new Exception("database name or database host not defined.");
        }
        if (this.m_databaseURL != null) {
            DebugOutput.println("INFO: connecting to database \"" + this.m_databaseURL + "\" ...");
        } else {
            DebugOutput.println("INFO: connecting to database \"" + this.m_effectiveDbName + "\" at \"" + this.m_effectiveDbHost + "\" ...");
        }
        ConnectionPool.createInstance(this.m_jdbcDriver, this.m_databaseURL, this.m_effectiveDbHost, this.m_effectiveDbName, this.m_effectiveUsername, this.m_effectivePassword);
        DebugOutput.println("INFO: ... done.");
        if (this.m_logFile != null) {
            DebugOutput.createLogFile(this.m_logFile);
        }
        if (this.m_unit_selection) {
            DebugOutput.println("WARNING: replicating only selected units:");
            if (this.m_units.length == 0) {
                DebugOutput.println("WARNING: ZERO selected units.");
            }
            for (int j = 0; j < this.m_units.length; ++j) {
                DebugOutput.println("WARNING: selected unit " + this.m_units[j]);
            }
        }
        if (this.m_audit_tables) {
            this.m_conflict_tables = true;
            this.m_paramSrcNames.put(CONFLICT_TABLES, "implied by audit_tables");
        }
        if (this.m_verbose) {
            this.m_verboseParam = true;
            this.m_paramSrcNames.put(VERBOSE_PARAM, "implied by verbose");
        }
        if (this.m_paramInfo) {
            this.m_verboseParam = true;
            this.m_paramSrcNames.put(VERBOSE_PARAM, "implied by param_info");
            this.m_verbose = true;
            this.m_paramSrcNames.put(VERBOSE, "implied by param_info");
        }
        if (this.m_verboseCapture) {
            this.m_verboseParam = true;
            this.m_paramSrcNames.put(VERBOSE_PARAM, "implied by verbose_capture");
            this.m_verbose = true;
            this.m_paramSrcNames.put(VERBOSE, "implied by verbose_capture");
        }
        if (this.m_verboseCaptureMessages) {
            this.m_verboseCapture = true;
            this.m_paramSrcNames.put(VERBOSE_CAPTURE, "implied by verbose_capture_messages");
            this.m_verboseParam = true;
            this.m_paramSrcNames.put(VERBOSE_PARAM, "implied by verbose_capture_messages");
            this.m_verbose = true;
            this.m_paramSrcNames.put(VERBOSE, "implied by verbose_capture_messages");
        }
        if (this.m_verboseConsumption) {
            this.m_verboseParam = true;
            this.m_paramSrcNames.put(VERBOSE_PARAM, "implied by verbose_consumption");
            this.m_verbose = true;
            this.m_paramSrcNames.put(VERBOSE, "implied by verbose_consumption");
        }
        if (this.m_verboseConsumptionMessages) {
            this.m_verboseConsumption = true;
            this.m_paramSrcNames.put(VERBOSE_CONSUMPTION, "implied by verbose_consumption_messages");
            this.m_verboseParam = true;
            this.m_paramSrcNames.put(VERBOSE_PARAM, "implied by verbose_consumption_messages");
            this.m_verbose = true;
            this.m_paramSrcNames.put(VERBOSE, "implied by verbose_consumption_messages");
        }
        if (this.m_verboseEception) {
            this.m_verboseParam = true;
            this.m_paramSrcNames.put(VERBOSE_PARAM, "implied by verbose_exception");
            this.m_verbose = true;
            this.m_paramSrcNames.put(VERBOSE, "implied by verbose_exception");
        }
        if (this.m_verboseExceptionStacktrace) {
            this.m_verboseEception = true;
            this.m_paramSrcNames.put(VERBOSE_EXCEPTION, "implied by verbose_exception_stacktrace");
            this.m_verboseParam = true;
            this.m_paramSrcNames.put(VERBOSE_PARAM, "implied by verbose_exception_stacktrace");
            this.m_verbose = true;
            this.m_paramSrcNames.put(VERBOSE, "implied by verbose_exception_stacktrace");
        }
        if (this.m_verboseWait) {
            this.m_verboseParam = true;
            this.m_paramSrcNames.put(VERBOSE_PARAM, "implied by verbose_wait");
            this.m_verbose = true;
            this.m_paramSrcNames.put(VERBOSE, "implied by verbose_wait");
        }
        if (this.m_initialCopy) {
            this.m_noCapture = false;
            this.m_accumulatedUpdates = false;
            this.m_noConsumption = true;
            this.m_paramSrcNames.put(NO_CAPTURE, "reset due to initial copy");
            this.m_paramSrcNames.put(ACCUMULATED_UPDATES, "reset due to initial copy");
            this.m_paramSrcNames.put(NO_CONSUMPTION, "reset due to initial copy");
        }
        this.m_jndiProps.setProperty("jndi.host", this.m_msgServerJNDIHost);
        this.m_jndiProps.setProperty("jndi.port", this.m_msgServerJNDIPort);
        this.m_jndiProps.setProperty("jms.host", this.m_msgServerJMSHost);
        this.m_jndiProps.setProperty("jms.port", this.m_msgServerJMSPort);
        this.m_jndiProps.setProperty("jms.timeout", this.m_msgClientJMSTimeout);
        this.m_jndiProps.setProperty("jms.logfile", this.m_msgClientJMSLogfile);
        this.m_jndiProps.setProperty("jms.maxqueuesize", this.m_msgClientJMSMaxqueuesize);
        this.setVerbosityOptions();
    }

    private boolean getBoolParameter(String key, Object[] param_srcs, String[] src_names) {
        int i;
        String val = null;
        for (i = 0; i < param_srcs.length; ++i) {
            if (param_srcs[i] != null && param_srcs[i] instanceof Configuration) {
                val = ((Configuration)param_srcs[i]).getStringByTagName(key);
            } else if (param_srcs[i] instanceof HashMap) {
                val = (String)((HashMap)param_srcs[i]).get(key);
            }
            if (val != null) break;
        }
        if (i < param_srcs.length) {
            this.m_paramSrcNames.put(key, src_names[i]);
        }
        return val == null ? false : val.equalsIgnoreCase("true");
    }

    private int getIntParameter(String key, Object[] param_srcs, String[] src_names) throws Exception {
        int i;
        String val = null;
        for (i = 0; i < param_srcs.length; ++i) {
            if (param_srcs[i] != null && param_srcs[i] instanceof Configuration) {
                val = ((Configuration)param_srcs[i]).getStringByTagName(key);
            } else if (param_srcs[i] instanceof HashMap) {
                val = (String)((HashMap)param_srcs[i]).get(key);
            }
            if (val != null) break;
        }
        if (i < param_srcs.length) {
            this.m_paramSrcNames.put(key, src_names[i]);
        }
        return val == null ? 0 : Integer.parseInt(val);
    }

    private String getStringParameter(String key, Object[] param_srcs, String[] src_names) {
        int i;
        String val = null;
        for (i = 0; i < param_srcs.length; ++i) {
            if (param_srcs[i] != null && param_srcs[i] instanceof Configuration) {
                val = ((Configuration)param_srcs[i]).getStringByTagName(key);
            } else if (param_srcs[i] instanceof HashMap) {
                val = (String)((HashMap)param_srcs[i]).get(key);
            }
            if (val != null) break;
        }
        if (i < param_srcs.length) {
            this.m_paramSrcNames.put(key, src_names[i]);
        }
        return val;
    }

    private String[] getStringArrayParameter(String key, Object[] param_srcs, String[] src_names) {
        int i;
        String[] val = null;
        for (i = 0; i < param_srcs.length; ++i) {
            if (param_srcs[i] != null && param_srcs[i] instanceof Configuration) {
                val = ((Configuration)param_srcs[i]).getStringArrayByTagName(key);
            } else if (param_srcs[i] instanceof HashMap) {
                val = (String[])((HashMap)param_srcs[i]).get(key);
            }
            if (val != null) break;
        }
        if (i < param_srcs.length) {
            this.m_paramSrcNames.put(key, src_names[i]);
        }
        return val;
    }

    private void displayHelp() {
        DebugOutput.println();
        DebugOutput.println("commandline/configuration file parameters");
        DebugOutput.println();
        DebugOutput.println("search order for parameters:" + LSEP + "1st: command line, 2nd: config file, 3rd: internal defaults");
        DebugOutput.println();
        DebugOutput.println();
        DebugOutput.println("   -help                                        // show this help, then exit.");
        DebugOutput.println();
        DebugOutput.println("   -param_info                                  // show information about parameters, then exit," + LSEP + "                                                " + "// implies '-verbose_param', defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -config                      <filename>      // name of configuration file (no default).");
        DebugOutput.println();
        DebugOutput.println("   -database_url                <database URL>  // JDBC dabase URL. optional.");
        DebugOutput.println();
        DebugOutput.println("   -jdbc_driver                 <JDBC driver>   // fully qualified class name of JDBC driver.");
        DebugOutput.println();
        DebugOutput.println("   -access_key | -A           <database key>    // syncmanacc database key." + LSEP + "                                                " + "// optional.");
        DebugOutput.println();
        DebugOutput.println("   -database_host | -n          <hostname>      // database host name.");
        DebugOutput.println();
        DebugOutput.println("   -database_name | -d          <database name> // database name.");
        DebugOutput.println();
        DebugOutput.println("   -user                        <username>      // database user name. If not surrounded with doublequotes (\"), the given value" + LSEP + "                                                " + "// will be converted to uppercase. Note that most shells need escaping the quote signs.");
        DebugOutput.println();
        DebugOutput.println("   -password                    <password>      // database user password. If not surrounded with doublequotes (\"), the given value" + LSEP + "                                                " + "// will be converted to uppercase. Note that most shells need escaping the quote signs.");
        DebugOutput.println();
        DebugOutput.println("   -u                    <user>,<password>      // database user name and password. If not surrounded with doublequotes (\"), the given values" + LSEP + "                                                " + "// will be converted to uppercase. Note that most shells need escaping the quote signs.");
        DebugOutput.println();
        DebugOutput.println("   -initial                     <client unit id | 'allunits'>" + LSEP + LSEP + "                                                " + "// copies contents of all existing master units to specified client unit," + LSEP + "                                                " + "// '" + DEFAULT_INITIAL_CLIENT + "' stands for all client units." + LSEP + "                                                " + "// if master units are specified as parameters to the  " + LSEP + "                                                " + "// '-" + UNIT_SELECTION + "' option, only data from tables in these" + LSEP + "                                                " + "// master units is copied (if ever these match the client unit).");
        DebugOutput.println();
        DebugOutput.println("   -accumulated_updates                         // sends the accumulated updates of rows only, defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -no_capture                                  // inhibits capturing, defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -no_consumption                              // inhibits consumption, defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -transient                                   // sends non-persistently.");
        DebugOutput.println();
        DebugOutput.println("   -max_capture_table_handlers  <number>        // sets maximal number of threads used in capturing.");
        DebugOutput.println();
        DebugOutput.println("   -consumption_update_handlers <number>        // sets number of threads used in consumption.");
        DebugOutput.println();
        DebugOutput.println("   -display_interval_sec        <seconds>       // update interval of statistics output in seconds.");
        DebugOutput.println();
        DebugOutput.println("   -logfile                     <filename>      // file to write log output to.");
        DebugOutput.println();
        DebugOutput.println("   -silent                                      // if set, nothingt is written to" + LSEP + "                                                " + "// standard output or standard error." + LSEP + "                                                " + "// defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -conflict_tables                             // if set, occurred conflicts are logged" + LSEP + "                                                " + "// in the conflict tables." + LSEP + "                                                " + "// defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -audit_tables                                // if set, information about all incoming replication data" + LSEP + "                                                " + "// is logged in the conflict tables." + LSEP + "                                                " + "// defaults to false, implies -" + CONFLICT_TABLES);
        DebugOutput.println();
        DebugOutput.println("   -verbose                                     // generally increased output verbosity," + LSEP + "                                                " + "// implies '-verbose_param'." + LSEP + "                                                " + "// defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -verbose_param                               // show complete information about" + LSEP + "                                                " + "// actual values of invocation parameters." + LSEP + "                                                " + "// defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -verbose_capture                             // increased output verbosity for the capture component," + LSEP + "                                                " + "// implies '-verbose','-verbose_param'." + LSEP + "                                                " + "// defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -verbose_capture_messages                    // debugging grade output verbosity " + LSEP + "                                                " + "// for the capture component," + LSEP + "                                                " + "// implies '-verbose_capture','-verbose','-verbose_param'." + LSEP + "                                                " + "// defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -verbose_consumption                         // increased output verbosity for the consumption component," + LSEP + "                                                " + "// implies '-verbose','-verbose_param'." + LSEP + "                                                " + "// defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -verbose_consumption_messages                // debugging grade output verbosity " + LSEP + "                                                " + "// for the consumption component," + LSEP + "                                                " + "// implies '-verbose_consumption','-verbose','-verbose_param'." + LSEP + "                                                " + "// defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -verbose_exception                           // occurrences of non-fatal, recoverable error conditions" + LSEP + "                                                " + "// are indicated, implies '-verbose', '-verbose_param'." + LSEP + "                                                " + "// defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -verbose_exception_stacktrace                // stacktraces of all occurring exceptions are added, " + LSEP + "                                                " + "// implies '-verbose_exception','-verbose','-verbose_param'." + LSEP + "                                                " + "// defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -verbose_wait                                // information about thread wait and notify events," + LSEP + "                                                " + "// implies '-verbose','-verbose_param'." + LSEP + "                                                " + "// defaults to false.");
        DebugOutput.println();
        DebugOutput.println("   -exit_timeout                <seconds>       // inactivity timeout to stop synchronization," + LSEP + "                                                " + "// defaults to 0 (no timeout).");
        DebugOutput.println();
        DebugOutput.println("   -jndiserver_host       <host name|IP>        // naming server host name," + LSEP + "                                                " + "// defaults to what is found in the 'jndi.properties' resource.");
        DebugOutput.println();
        DebugOutput.println("   -jndiserver_port       <port number>         // naming server port number," + LSEP + "                                                " + "// defaults to what is found in the 'jndi.properties' resource.");
        DebugOutput.println();
        DebugOutput.println("   -msgserver_host       <host name|IP>         // messaging server host name," + LSEP + "                                                " + "// defaults to what is found in the 'jndi.properties' resource.");
        DebugOutput.println();
        DebugOutput.println("   -msgserver_port       <port number>          // messaging server port number," + LSEP + "                                                " + "// defaults to what is found in the 'jndi.properties' resource.");
        DebugOutput.println();
        DebugOutput.println("   -msgclient_socket_timeout    <milliseconds>  // messaging client socket timeout," + LSEP + "                                                " + "// defaults to what is found in the 'jndi.properties' resource.");
        DebugOutput.println();
        DebugOutput.println("   -msgclient_logfile           <file name>     // logfile of the messaging client," + LSEP + "                                                " + "// defaults to what is found in the 'jndi.properties' resource.");
        DebugOutput.println();
        DebugOutput.println("   -msgclient_maxqueuesize      <size>          // maximal queue size of the messaging client," + LSEP + "                                                " + "// defaults to what is found in the 'jndi.properties' resource.");
        DebugOutput.println();
        DebugOutput.println("   -admin_ssl                                   // if set, the admin connection to the SyncService is ssl.");
        DebugOutput.println();
        DebugOutput.println("   -admin_port                  <port number>   // the port for the admin connection.");
        DebugOutput.println();
        DebugOutput.println("   -security_provider     <security provider>   // class name of a security provider." + LSEP + "                                                " + "// optional.");
        DebugOutput.println();
        DebugOutput.println("   -units                       <unitname>...   // only specified local units are synchronized." + LSEP + "                                                " + "// This applies to 'initial copy' capture, and consumption, and is ignored " + LSEP + "                                                " + "// by non-'initial copy' capture. This must be the last option on the command line," + LSEP + "                                                " + "// and is an 'expert' option. Use only, if you know exactly what you are doing.");
    }

    private void displayMode() {
        String mode = "";
        if (this.m_initialCopy) {
            mode = "INITIAL COPY: to " + this.m_initialClient;
        } else {
            mode = !this.m_noCapture ? mode + "capture, " : mode + " +++ NO CAPTURE +++ , ";
            mode = !this.m_noConsumption ? mode + "consumption " : mode + " +++ NO CONSUMPTION +++ , ";
        }
        if (this.m_accumulatedUpdates) {
            mode = mode + " (accumulated updates)";
        }
        DebugOutput.println();
        DebugOutput.println();
        DebugOutput.println(mode);
        DebugOutput.println();
        DebugOutput.println();
        DebugOutput.println();
    }

    private void displayParamInfo() {
        int max_namelen = 30;
        int max_valuelen = 35;
        DebugOutput.println("-------------------------------------------------------------------------------------");
        DebugOutput.println("----------------------------- PARAMETER CONFIGURATION -------------------------------");
        DebugOutput.println();
        DebugOutput.println(SyncService.padRight("parameter name", max_namelen) + SyncService.padRight("  parameter value", max_valuelen) + "  configured by");
        DebugOutput.println("-------------------------------------------------------------------------------------");
        DebugOutput.println(SyncService.padRight(NO_CAPTURE, max_namelen) + SyncService.padRight("  " + this.m_noCapture, max_valuelen) + "  " + this.m_paramSrcNames.get(NO_CAPTURE));
        DebugOutput.println(SyncService.padRight(NO_CONSUMPTION, max_namelen) + SyncService.padRight("  " + this.m_noConsumption, max_valuelen) + "  " + this.m_paramSrcNames.get(NO_CONSUMPTION));
        DebugOutput.println(SyncService.padRight(INITIAL, max_namelen) + SyncService.padRight("  " + this.m_initialCopy, max_valuelen) + "  " + this.m_paramSrcNames.get(INITIAL));
        DebugOutput.println(SyncService.padRight(INITIAL_CLIENT, max_namelen) + SyncService.padRight("  " + this.m_initialClient, max_valuelen) + "  " + this.m_paramSrcNames.get(INITIAL_CLIENT));
        DebugOutput.println(SyncService.padRight(ACCUMULATED_UPDATES, max_namelen) + SyncService.padRight("  " + this.m_accumulatedUpdates, max_valuelen) + "  " + this.m_paramSrcNames.get(ACCUMULATED_UPDATES));
        DebugOutput.println(SyncService.padRight(TRANSIENT, max_namelen) + SyncService.padRight("  " + this.m_sendTransient, max_valuelen) + "  " + this.m_paramSrcNames.get(TRANSIENT));
        DebugOutput.println(SyncService.padRight(MAX_CAPTURE_TABLE_HANDLERS, max_namelen) + SyncService.padRight("  " + this.m_maxCaptureTableHandlers, max_valuelen) + "  " + this.m_paramSrcNames.get(MAX_CAPTURE_TABLE_HANDLERS));
        DebugOutput.println(SyncService.padRight(CONSUMPTION_UPDATE_HANDLERS, max_namelen) + SyncService.padRight("  " + this.m_consumptionUpdateHandlers, max_valuelen) + "  " + this.m_paramSrcNames.get(CONSUMPTION_UPDATE_HANDLERS));
        DebugOutput.println(SyncService.padRight(DISPLAY_INTERVAL_SEC, max_namelen) + SyncService.padRight("  " + this.m_displayIntervalSec, max_valuelen) + "  " + this.m_paramSrcNames.get(DISPLAY_INTERVAL_SEC));
        DebugOutput.println(SyncService.padRight(VERBOSE, max_namelen) + SyncService.padRight("  " + this.m_verbose, max_valuelen) + "  " + this.m_paramSrcNames.get(VERBOSE));
        DebugOutput.println(SyncService.padRight(VERBOSE_PARAM, max_namelen) + SyncService.padRight("  " + this.m_verboseParam, max_valuelen) + "  " + this.m_paramSrcNames.get(VERBOSE_PARAM));
        DebugOutput.println(SyncService.padRight(VERBOSE_CAPTURE, max_namelen) + SyncService.padRight("  " + this.m_verboseCapture, max_valuelen) + "  " + this.m_paramSrcNames.get(VERBOSE_CAPTURE));
        DebugOutput.println(SyncService.padRight(VERBOSE_CAPTURE_MESSAGES, max_namelen) + SyncService.padRight("  " + this.m_verboseCaptureMessages, max_valuelen) + "  " + this.m_paramSrcNames.get(VERBOSE_CAPTURE_MESSAGES));
        DebugOutput.println(SyncService.padRight(VERBOSE_CONSUMPTION, max_namelen) + SyncService.padRight("  " + this.m_verboseConsumption, max_valuelen) + "  " + this.m_paramSrcNames.get(VERBOSE_CONSUMPTION));
        DebugOutput.println(SyncService.padRight(VERBOSE_CONSUMPTION_MESSAGES, max_namelen) + SyncService.padRight("  " + this.m_verboseConsumptionMessages, max_valuelen) + "  " + this.m_paramSrcNames.get(VERBOSE_CONSUMPTION_MESSAGES));
        DebugOutput.println(SyncService.padRight(VERBOSE_EXCEPTION, max_namelen) + SyncService.padRight("  " + this.m_verboseEception, max_valuelen) + "  " + this.m_paramSrcNames.get(VERBOSE_EXCEPTION));
        DebugOutput.println(SyncService.padRight(VERBOSE_EXCEPTION_STACKTRACE, max_namelen) + SyncService.padRight("  " + this.m_verboseExceptionStacktrace, max_valuelen) + "  " + this.m_paramSrcNames.get(VERBOSE_EXCEPTION_STACKTRACE));
        DebugOutput.println(SyncService.padRight(VERBOSE_WAIT, max_namelen) + SyncService.padRight("  " + this.m_verboseWait, max_valuelen) + "  " + this.m_paramSrcNames.get(VERBOSE_WAIT));
        DebugOutput.println(SyncService.padRight(JDBC_DRIVER, max_namelen) + SyncService.padRight("  " + this.m_jdbcDriver, max_valuelen) + "  " + this.m_paramSrcNames.get(JDBC_DRIVER));
        if (this.m_databaseURL != null) {
            DebugOutput.println(SyncService.padRight(URL, max_namelen) + SyncService.padRight("  " + this.m_databaseURL, max_valuelen) + "  " + this.m_paramSrcNames.get(URL));
        } else {
            if (this.m_dbHost != null) {
                DebugOutput.println(SyncService.padRight(DB_HOST, max_namelen) + SyncService.padRight("  " + this.m_dbHost, max_valuelen) + "  " + this.m_paramSrcNames.get(DB_HOST));
            } else if (this.m_oldschoolDbHost != null) {
                DebugOutput.println(SyncService.padRight(OLDSCHOOL_DB_HOST, max_namelen) + SyncService.padRight("  " + this.m_oldschoolDbHost, max_valuelen) + "  " + this.m_paramSrcNames.get(OLDSCHOOL_DB_HOST));
            } else {
                DebugOutput.println(SyncService.padRight(DB_HOST, max_namelen) + SyncService.padRight("  " + this.m_effectiveDbHost, max_valuelen) + "  syncmanacc");
            }
            if (this.m_dbName != null) {
                DebugOutput.println(SyncService.padRight(DB_NAME, max_namelen) + SyncService.padRight("  " + this.m_dbName, max_valuelen) + "  " + this.m_paramSrcNames.get(DB_NAME));
            } else if (this.m_oldschoolDbName != null) {
                DebugOutput.println(SyncService.padRight(OLDSCHOOL_DB_NAME, max_namelen) + SyncService.padRight("  " + this.m_oldschoolDbName, max_valuelen) + "  " + this.m_paramSrcNames.get(OLDSCHOOL_DB_NAME));
            } else {
                DebugOutput.println(SyncService.padRight(DB_NAME, max_namelen) + SyncService.padRight("  " + this.m_effectiveDbName, max_valuelen) + "  syncmanacc");
            }
        }
        if (this.m_username != null) {
            DebugOutput.println(SyncService.padRight(USER, max_namelen) + SyncService.padRight("  " + this.m_username, max_valuelen) + "  " + this.m_paramSrcNames.get(USER));
        } else if (this.m_oldschoolUsername != null) {
            DebugOutput.println(SyncService.padRight(OLDSCHOOL_USER_PASSWORD, max_namelen) + SyncService.padRight("  " + this.m_oldschoolUsername + ",<password not shown>", max_valuelen) + "  " + this.m_paramSrcNames.get(OLDSCHOOL_USER_PASSWORD));
        } else {
            DebugOutput.println(SyncService.padRight(USER, max_namelen) + SyncService.padRight("  " + this.m_effectiveUsername, max_valuelen) + "  syncmanacc");
        }
        if (this.m_password != null) {
            DebugOutput.println(SyncService.padRight(PASSWORD, max_namelen) + SyncService.padRight("  <password not shown>", max_valuelen) + "  " + this.m_paramSrcNames.get(PASSWORD));
        } else if (this.m_oldschoolPassword == null) {
            DebugOutput.println(SyncService.padRight(PASSWORD, max_namelen) + SyncService.padRight("  <password not shown>", max_valuelen) + "  syncmanacc");
        }
        DebugOutput.println(SyncService.padRight(CONFIG, max_namelen) + SyncService.padRight("  " + this.m_configFilename, max_valuelen) + "  " + this.m_paramSrcNames.get(CONFIG));
        DebugOutput.println(SyncService.padRight(UNIT_SELECTION, max_namelen) + SyncService.padRight("  " + this.m_unit_selection, max_valuelen) + "  " + this.m_paramSrcNames.get(UNIT_SELECTION));
        DebugOutput.println(SyncService.padRight(EXIT_TIMEOUT, max_namelen) + SyncService.padRight("  " + this.m_exitTimeoutSec, max_valuelen) + "  " + this.m_paramSrcNames.get(EXIT_TIMEOUT));
        DebugOutput.println(SyncService.padRight(PARAM_INFO, max_namelen) + SyncService.padRight("  " + this.m_paramInfo, max_valuelen) + "  " + this.m_paramSrcNames.get(PARAM_INFO));
        DebugOutput.println(SyncService.padRight(LOGFILE, max_namelen) + SyncService.padRight("  " + this.m_logFile, max_valuelen) + "  " + this.m_paramSrcNames.get(LOGFILE));
        DebugOutput.println(SyncService.padRight(SILENT, max_namelen) + SyncService.padRight("  " + this.m_silent, max_valuelen) + "  " + this.m_paramSrcNames.get(SILENT));
        DebugOutput.println(SyncService.padRight(CONFLICT_TABLES, max_namelen) + SyncService.padRight("  " + this.m_conflict_tables, max_valuelen) + "  " + this.m_paramSrcNames.get(CONFLICT_TABLES));
        DebugOutput.println(SyncService.padRight(AUDIT_TABLES, max_namelen) + SyncService.padRight("  " + this.m_audit_tables, max_valuelen) + "  " + this.m_paramSrcNames.get(AUDIT_TABLES));
        DebugOutput.println(SyncService.padRight(MSGSERVER_CONTEXT_FACTORY, max_namelen) + SyncService.padRight("  " + this.m_msgServerContextFactory, max_valuelen) + "  " + this.m_paramSrcNames.get(MSGSERVER_CONTEXT_FACTORY));
        DebugOutput.println(SyncService.padRight(MSGSERVER_JNDI_HOST, max_namelen) + SyncService.padRight("  " + this.m_msgServerJNDIHost, max_valuelen) + "  " + this.m_paramSrcNames.get(MSGSERVER_JNDI_HOST));
        DebugOutput.println(SyncService.padRight(MSGSERVER_JNDI_PORT, max_namelen) + SyncService.padRight("  " + this.m_msgServerJNDIPort, max_valuelen) + "  " + this.m_paramSrcNames.get(MSGSERVER_JNDI_PORT));
        DebugOutput.println(SyncService.padRight(MSGSERVER_JMS_HOST, max_namelen) + SyncService.padRight("  " + this.m_msgServerJMSHost, max_valuelen) + "  " + this.m_paramSrcNames.get(MSGSERVER_JMS_HOST));
        DebugOutput.println(SyncService.padRight(MSGSERVER_JMS_PORT, max_namelen) + SyncService.padRight("  " + this.m_msgServerJMSPort, max_valuelen) + "  " + this.m_paramSrcNames.get(MSGSERVER_JMS_PORT));
        DebugOutput.println(SyncService.padRight(MSGCLIENT_JMS_TIMEOUT, max_namelen) + SyncService.padRight("  " + this.m_msgClientJMSTimeout, max_valuelen) + "  " + this.m_paramSrcNames.get(MSGCLIENT_JMS_TIMEOUT));
        DebugOutput.println(SyncService.padRight(MSGCLIENT_JMS_LOGFILE, max_namelen) + SyncService.padRight("  " + this.m_msgClientJMSLogfile, max_valuelen) + "  " + this.m_paramSrcNames.get(MSGCLIENT_JMS_LOGFILE));
        DebugOutput.println(SyncService.padRight(MSGCLIENT_JMS_MAXQUEUESIZE, max_namelen) + SyncService.padRight("  " + this.m_msgClientJMSMaxqueuesize, max_valuelen) + "  " + this.m_paramSrcNames.get(MSGCLIENT_JMS_MAXQUEUESIZE));
        DebugOutput.println(SyncService.padRight(ADMIN_SSL, max_namelen) + SyncService.padRight("  " + this.m_adminSSL, max_valuelen) + "  " + this.m_paramSrcNames.get(ADMIN_SSL));
        DebugOutput.println(SyncService.padRight(ADMIN_PORT, max_namelen) + SyncService.padRight("  " + this.m_adminPort, max_valuelen) + "  " + this.m_paramSrcNames.get(ADMIN_PORT));
        if (!this.m_initialCopy && this.m_units != null) {
            for (int i = 0; i < this.m_units.length; ++i) {
                DebugOutput.println(SyncService.padRight(UNITS, max_namelen) + SyncService.padRight("  " + this.m_units[i], max_valuelen) + "  " + this.m_paramSrcNames.get(UNITS));
            }
        }
        DebugOutput.println();
        DebugOutput.println("------------------------- END OF PARAMETER CONFIGURATION ----------------------------");
        DebugOutput.println("-------------------------------------------------------------------------------------");
    }

    private void displayBriefParamInfo() {
        int max_namelen = 30;
        int max_valuelen = 35;
        DebugOutput.println("-------------------------------------------------------------------------------------");
        DebugOutput.println("----------------------------- PARAMETER CONFIGURATION (BRIEF) -----------------------");
        DebugOutput.println();
        DebugOutput.println(SyncService.padRight("parameter name", max_namelen) + SyncService.padRight("  parameter value", max_valuelen) + "  configured by");
        DebugOutput.println("-------------------------------------------------------------------------------------");
        DebugOutput.println(SyncService.padRight(TRANSIENT, max_namelen) + SyncService.padRight("  " + this.m_sendTransient, max_valuelen) + "  " + this.m_paramSrcNames.get(TRANSIENT));
        DebugOutput.println(SyncService.padRight(JDBC_DRIVER, max_namelen) + SyncService.padRight("  " + this.m_jdbcDriver, max_valuelen) + "  " + this.m_paramSrcNames.get(JDBC_DRIVER));
        if (this.m_databaseURL != null) {
            DebugOutput.println(SyncService.padRight(URL, max_namelen) + SyncService.padRight("  " + this.m_databaseURL, max_valuelen) + "  " + this.m_paramSrcNames.get(URL));
        } else {
            if (this.m_dbHost != null) {
                DebugOutput.println(SyncService.padRight(DB_HOST, max_namelen) + SyncService.padRight("  " + this.m_dbHost, max_valuelen) + "  " + this.m_paramSrcNames.get(DB_HOST));
            } else if (this.m_oldschoolDbHost != null) {
                DebugOutput.println(SyncService.padRight(OLDSCHOOL_DB_HOST, max_namelen) + SyncService.padRight("  " + this.m_oldschoolDbHost, max_valuelen) + "  " + this.m_paramSrcNames.get(OLDSCHOOL_DB_HOST));
            } else {
                DebugOutput.println(SyncService.padRight(DB_HOST, max_namelen) + SyncService.padRight("  " + this.m_effectiveDbHost, max_valuelen) + "  syncmanacc");
            }
            if (this.m_dbName != null) {
                DebugOutput.println(SyncService.padRight(DB_NAME, max_namelen) + SyncService.padRight("  " + this.m_dbName, max_valuelen) + "  " + this.m_paramSrcNames.get(DB_NAME));
            } else if (this.m_oldschoolDbName != null) {
                DebugOutput.println(SyncService.padRight(OLDSCHOOL_DB_NAME, max_namelen) + SyncService.padRight("  " + this.m_oldschoolDbName, max_valuelen) + "  " + this.m_paramSrcNames.get(OLDSCHOOL_DB_NAME));
            } else {
                DebugOutput.println(SyncService.padRight(DB_NAME, max_namelen) + SyncService.padRight("  " + this.m_effectiveDbName, max_valuelen) + "  syncmanacc");
            }
        }
        if (this.m_username != null) {
            DebugOutput.println(SyncService.padRight(USER, max_namelen) + SyncService.padRight("  " + this.m_username, max_valuelen) + "  " + this.m_paramSrcNames.get(USER));
        } else if (this.m_oldschoolUsername != null) {
            DebugOutput.println(SyncService.padRight(OLDSCHOOL_USER_PASSWORD, max_namelen) + SyncService.padRight("  " + this.m_oldschoolUsername + ",<password not shown>", max_valuelen) + "  " + this.m_paramSrcNames.get(OLDSCHOOL_USER_PASSWORD));
        } else {
            DebugOutput.println(SyncService.padRight(USER, max_namelen) + SyncService.padRight("  " + this.m_effectiveUsername, max_valuelen) + "  syncmanacc");
        }
        if (this.m_password != null) {
            DebugOutput.println(SyncService.padRight(PASSWORD, max_namelen) + SyncService.padRight("  <password not shown>", max_valuelen) + "  " + this.m_paramSrcNames.get(PASSWORD));
        } else if (this.m_oldschoolPassword == null) {
            DebugOutput.println(SyncService.padRight(PASSWORD, max_namelen) + SyncService.padRight("  <password not shown>", max_valuelen) + "  syncmanacc");
        }
        DebugOutput.println(SyncService.padRight(CONFIG, max_namelen) + SyncService.padRight("  " + this.m_configFilename, max_valuelen) + "  " + this.m_paramSrcNames.get(CONFIG));
        DebugOutput.println(SyncService.padRight(MSGSERVER_JMS_HOST, max_namelen) + SyncService.padRight("  " + this.m_msgServerJMSHost, max_valuelen) + "  " + this.m_paramSrcNames.get(MSGSERVER_JMS_HOST));
        DebugOutput.println(SyncService.padRight(MSGSERVER_JMS_PORT, max_namelen) + SyncService.padRight("  " + this.m_msgServerJMSPort, max_valuelen) + "  " + this.m_paramSrcNames.get(MSGSERVER_JMS_PORT));
        DebugOutput.println(SyncService.padRight(UNIT_SELECTION, max_namelen) + SyncService.padRight("  " + this.m_unit_selection, max_valuelen) + "  " + this.m_paramSrcNames.get(UNIT_SELECTION));
        DebugOutput.println(SyncService.padRight(EXIT_TIMEOUT, max_namelen) + SyncService.padRight("  " + this.m_exitTimeoutSec, max_valuelen) + "  " + this.m_paramSrcNames.get(EXIT_TIMEOUT));
        DebugOutput.println(SyncService.padRight(LOGFILE, max_namelen) + SyncService.padRight("  " + this.m_logFile, max_valuelen) + "  " + this.m_paramSrcNames.get(LOGFILE));
        if (!this.m_initialCopy && this.m_units != null) {
            for (int i = 0; i < this.m_units.length; ++i) {
                DebugOutput.println(SyncService.padRight(UNITS, max_namelen) + SyncService.padRight("  " + this.m_units[i], max_valuelen) + "  " + this.m_paramSrcNames.get(UNITS));
            }
        }
        DebugOutput.println();
        DebugOutput.println("------------------------- END OF PARAMETER CONFIGURATION ----------------------------");
        DebugOutput.println("-------------------------------------------------------------------------------------");
    }

    private static String padRight(String s, int len) {
        String retval = s;
        if (s.length() < len) {
            retval = s + "                                                             ".substring(0, len - s.length());
        }
        return retval;
    }

    private void setVerbosityOptions() {
        if (this.m_verbose) {
            DebugOutput.setVerbose();
        }
        if (this.m_verboseCapture) {
            DebugOutput.setVerboseCapture();
        }
        if (this.m_verboseCaptureMessages) {
            DebugOutput.setVerboseCaptureMsg();
        }
        if (this.m_verboseConsumption) {
            DebugOutput.setVerboseConsumption();
        }
        if (this.m_verboseConsumptionMessages) {
            DebugOutput.setVerboseConsumptionMsg();
        }
        if (this.m_verboseEception) {
            DebugOutput.setVerboseException();
        }
        if (this.m_verboseExceptionStacktrace) {
            DebugOutput.setVerboseTraceback();
        }
        if (this.m_verboseWait) {
            DebugOutput.setVerboseWait();
        }
    }

    public static String getVersion() {
        return "7.6";
    }

    static {
        DEFAULT_UNITS = new String[0];
        DEFAULT_LOGFILE = null;
        DEFAULT_MSGSERVER_CONTEXT_FACTORY = "com.sap.sdb.msgServer.jndi.JndiFactory";
        DEFAULT_MSGSERVER_JNDI_HOST = "127.0.0.1";
        DEFAULT_MSGSERVER_JNDI_PORT = "7221";
        DEFAULT_MSGSERVER_JMS_HOST = "127.0.0.1";
        DEFAULT_MSGSERVER_JMS_PORT = "7222";
        DEFAULT_MSGCLIENT_JMS_TIMEOUT = "100000";
        DEFAULT_MSGCLIENT_JMS_LOGFILE = "";
        DEFAULT_MSGCLIENT_JMS_MAXQUEUESIZE = "1000";
        LSEP = System.getProperty("line.separator", "\r\n");
    }
}

