/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest2;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.upgradetest2.Configuration;
import com.sap.sapdb.upgradetest2.config.SettingNotFoundException;
import com.sap.sapdb.upgradetest2.config.xmlConfiguration;
import com.sap.sapdb.upgradetest2.util.DatabaseHelper;
import com.sap.sapdb.upgradetest2.util.InstallationHelper;
import com.sap.sapdb.upgradetest2.util.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class UpgradeTest
extends TestCase {
    private xmlConfiguration config;
    private File configFile;
    private InstallationHelper ih;
    private DatabaseHelper dh;
    private Vector testmsgs;
    private static String startDateTime;

    public String getSubDataOutputPath() {
        StringBuffer stringBuffer = new StringBuffer(super.getDataOutputPath());
        stringBuffer.append(File.separator);
        stringBuffer.append("UpgradeTest_at_");
        stringBuffer.append(startDateTime);
        File file = new File(stringBuffer.toString());
        String string = stringBuffer.toString();
        if (file.exists() && !file.isDirectory()) {
            Logger.error("Output dir blocked by " + string);
            return null;
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        Logger.log(Logger.DEBUG, "UpgradeTest.dataOutputPath() requested, returning " + string);
        return string;
    }

    public static void prepare() {
        Logger.setLevel(Logger.VERBOSE);
        Logger.setPrintStackTraces(true);
    }

    public void run() {
        try {
            this.runit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.addMessage(exception.hashCode() + "", 'W', exception.getMessage(), exception, null);
        }
    }

    public void runit() throws Exception {
        String string = TestCase.mTestDriverOptions.getProperty("MakeKey");
        String string2 = TestCase.getParameterString((String)"configfile", (String)"config.xml");
        boolean bl = TestCase.getParameterBoolean((String)"minimaltest", (boolean)false);
        String string3 = TestCase.getParameterString((String)"instprofile", (String)"");
        UpgradeTest.db("Creating configuration object ...");
        Configuration configuration = new Configuration();
        UpgradeTest.db("Have configuration object, no read QADB ...");
        StringBuffer stringBuffer = configuration.dump();
        UpgradeTest.db("Have read QADB, now write the configuration file ...");
        File file = new File(this.getDataInputPath(), "qadb.config");
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(stringBuffer.toString());
        fileWriter.flush();
        fileWriter.close();
        UpgradeTest.db("Have written configuration file \"" + file + "\"");
        file = new File(this.getDataInputPath(), "tests/scripts/upgradetest.pl");
        UpgradeTest.db("No starting perl process for \"" + file + "\"");
        Process process = Runtime.getRuntime().exec(new String[]{"perl", file.toString()});
        int n = process.waitFor();
        UpgradeTest.db("Perl process  return " + n);
    }

    public static long getTimeout() {
        return 0L;
    }

    private boolean handleStop(int n, int n2, String string) {
        block13: {
            String string2;
            try {
                this.config.getSetting("/test[" + n + "]/stop[@after=\"" + string + "\"]");
            }
            catch (SettingNotFoundException settingNotFoundException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            try {
                string2 = this.config.getSetting("/test[" + n + "]/stop[@after=\"" + string + "\"]/@when");
            }
            catch (SettingNotFoundException settingNotFoundException) {
                string2 = "";
            }
            if (string2.equals("failed") && n2 == 0) {
                return false;
            }
            try {
                if (this.config.getSetting("/test[" + n + "]/stop[@after=\"" + string + "\"]/@method").equals("endtests")) {
                    Logger.log(Logger.STANDARD, "stop node says to end the testrun - doing a soft exit!");
                    return true;
                }
                if (this.config.getSetting("/test[" + n + "]/stop[@after=\"" + string + "\"]/@method").equals("hardexit")) {
                    Logger.log(Logger.STANDARD, "After step " + string + " - doing a hard exit!");
                    System.exit(1);
                    return false;
                }
                if (!this.config.getSetting("/test[" + n + "]/stop[@after=\"" + string + "\"]/@method").equals("hold")) break block13;
                System.out.println("[UpgradeTest] " + string + " failed, press any key to continue or C to cancel the test...");
                try {
                    int n3 = System.in.read();
                    if (n3 == 99) {
                        System.exit(1);
                    }
                }
                catch (IOException iOException) {
                    Logger.error("Failed to get user input when waiting for ");
                }
                return false;
            }
            catch (SettingNotFoundException settingNotFoundException) {
                // empty catch block
            }
        }
        Logger.error("Found a relevant <stop> node but don't recognize the method");
        return false;
    }

    public String getLogFile() {
        return "Dummy log contents";
    }

    public static void cleanup() {
    }

    public static int getDBPort() {
        return Integer.parseInt(TestCase.mTestDriverOptions.getProperty("db-port", "7210"));
    }

    public static String getStartDateTime() {
        return startDateTime;
    }

    public static void resetStartDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yy_HH.mm");
        startDateTime = simpleDateFormat.format(new Date());
    }

    private static void db(Object object) {
        System.out.println("debug--> " + object);
    }
}

