/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.upgradetest;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.upgradetest.config.ConfigurationException;
import com.sap.sapdb.upgradetest.config.SettingNotFoundException;
import com.sap.sapdb.upgradetest.config.xmlConfiguration;
import com.sap.sapdb.upgradetest.util.DatabaseHelper;
import com.sap.sapdb.upgradetest.util.InstallationHelper;
import com.sap.sapdb.upgradetest.util.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class UpgradeTest
extends TestCase {
    private xmlConfiguration config;
    private File configFile;
    private InstallationHelper ih;
    private DatabaseHelper dh;
    private Vector testmsgs;
    private static String startDateTime;

    public String getSubDataOutputPath() {
        StringBuffer stringBuffer = new StringBuffer(super.getDataOutputPath());
        stringBuffer.append(File.separator);
        stringBuffer.append("UpgradeTest_at_");
        stringBuffer.append(startDateTime);
        File file = new File(stringBuffer.toString());
        String string = stringBuffer.toString();
        if (file.exists() && !file.isDirectory()) {
            Logger.error("Output dir blocked by " + string);
            return null;
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        Logger.log(Logger.DEBUG, "UpgradeTest.dataOutputPath() requested, returning " + string);
        return string;
    }

    public static void prepare() {
        Logger.setLevel(Logger.VERBOSE);
        Logger.setPrintStackTraces(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block103: {
            Object object;
            Object object2;
            block97: {
                try {
                    object2 = TestCase.mTestDriverOptions.getProperty("MakeKey");
                    this.config = xmlConfiguration.getInstance();
                    this.configFile = new File(this.getDataInputPath() + File.separator + TestCase.getParameterString((String)"configfile", (String)"config.xml"));
                    this.config.parseConfiguration(this.configFile, this.getDataInputPath());
                    if (object2 != null && ((String)object2).length() != 0 && !((String)object2).equals("0")) {
                        object = null;
                        try {
                            object = this.config.createAutoConfig((String)object2);
                        }
                        catch (ConfigurationException configurationException) {
                            if (configurationException.getMessage().startsWith("Couldn't fetch buildnumber for autocreatefor version")) {
                                Logger.warning("Could not fetch a buildnumber for the testversion - probably no such state, test skipped");
                                this.addMessage("[UpgradeTest]", 'W', "Could not fetch a buildnumber for the testversion - probably no such state, test skipped");
                                return;
                            }
                            Logger.error("Automatic creation of config failed, msg is " + configurationException.getMessage());
                            this.addMessage("[UpgradeTest]", 'E', "Automatic creation of config failed", configurationException);
                            try {
                                this.abort("UpgradeTest", "Automatic creation of config failed", configurationException, null);
                                return;
                            }
                            catch (TestCaseException testCaseException) {
                                return;
                            }
                        }
                        this.config.parseTestConfiguration(new ByteArrayInputStream(((StringBuffer)object).toString().getBytes()), this.getDataInputPath() + File.separator + "tests");
                        break block97;
                    }
                    object = this.getDataInputPath() + File.separator + TestCase.getParameterString((String)"testrun", (String)"tests/testrun.xml");
                    File file = new File((String)object);
                    this.config.parseTestConfiguration(new FileInputStream(file), this.getDataInputPath() + File.separator + "tests");
                }
                catch (ConfigurationException configurationException) {
                    Logger.error("Configuration parsing/creation failed.");
                    Logger.stackTrace(configurationException);
                    try {
                        this.abort("UpgradeTest()", "Configuration failed with exception " + configurationException.getMessage(), configurationException, null);
                    }
                    catch (TestCaseException testCaseException) {}
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Logger.error("Configuration file not found - exiting.");
                    Logger.stackTrace(fileNotFoundException);
                    try {
                        this.abort("UpgradeTest()", "Configuration failed with exception " + fileNotFoundException.getMessage(), fileNotFoundException, null);
                    }
                    catch (TestCaseException testCaseException) {
                        // empty catch block
                    }
                }
            }
            UpgradeTest.resetStartDateTime();
            try {
                Logger.setLevel(this.config.getSetting("/settings/log/level"));
            }
            catch (SettingNotFoundException settingNotFoundException) {
                // empty catch block
            }
            try {
                this.config.getSetting("/settings/log/file");
                if (this.config.getSetting("/settings/log/file/@autocreate").equalsIgnoreCase("true") || this.config.getSetting("/settings/log/file/@autocreate").equalsIgnoreCase("yes")) {
                    object2 = new File(this.getSubDataOutputPath() + File.separator + "UpgradeTest_at_" + startDateTime + ".log");
                    this.config.setSetting("/settings/log/file", ((File)object2).getCanonicalPath());
                } else {
                    object2 = new File(this.config.getSetting("/settings/log/file"));
                }
                Logger.log(Logger.STANDARD, "Found logfile settings in the configuration, starting to log into " + ((File)object2).getAbsolutePath());
                Logger.out = object = new PrintStream(new FileOutputStream((File)object2), true);
                Logger.err = object;
                Logger.log(Logger.STANDARD, "=======================================");
                Logger.log(Logger.STANDARD, "== Logfile started on " + startDateTime + " ==");
                Logger.log(Logger.STANDARD, "=======================================");
            }
            catch (SettingNotFoundException settingNotFoundException) {
                Logger.log(Logger.DEBUG, "No logfile specified, logging to stdout");
            }
            catch (IOException iOException) {
                Logger.error("Could not create or find logfile, exception was " + iOException.getMessage());
                try {
                    this.abort("UpgradeTest", "Could not create or find my logFile", iOException, null);
                }
                catch (TestCaseException testCaseException) {
                    // empty catch block
                }
            }
            if (TestCase.getParameterString((String)"os", (String)"").equals("AIX")) {
                if ((double)Float.parseFloat(System.getProperty("os.version")) >= 5.0) {
                    this.config.setSetting("/environment/os", "AIX5");
                } else {
                    this.config.setSetting("/environment/os", "AIX");
                }
            } else {
                this.config.setSetting("/environment/os", TestCase.getParameterString((String)"os", (String)""));
            }
            this.config.setSetting("/environment/bit", TestCase.getParameterString((String)"bit", (String)""));
            this.config.setSetting("/environment/platform", System.getProperty("os.arch"));
            this.ih = new InstallationHelper(this.config, new File(this.getSubDataOutputPath()));
            this.dh = new DatabaseHelper(this.getDataInputPath() + File.separator, this.config);
            Logger.log(Logger.DEBUG, "Successfully initialized InstallationHelper and DatabaseHelper");
            this.testmsgs = new Vector();
            try {
                int n = -1337;
                int n2 = 0;
                n2 = this.config.getTestCount();
                Logger.log(Logger.STANDARD, "UpgradeTest: starting to run " + n2 + " upgrade tests");
                int n3 = 1;
                while (n3 < n2 + 1) {
                    block102: {
                        StringBuffer stringBuffer;
                        StringBuffer stringBuffer2;
                        boolean bl;
                        boolean bl2;
                        boolean bl3;
                        block101: {
                            bl3 = false;
                            bl2 = false;
                            bl = false;
                            try {
                                if (this.config.getSetting("/test[" + n3 + "]/version[@role=\"brick\"]") != null) {
                                    bl = true;
                                }
                            }
                            catch (SettingNotFoundException settingNotFoundException) {
                                // empty catch block
                            }
                            stringBuffer2 = new StringBuffer();
                            stringBuffer = new StringBuffer();
                            try {
                                Object var15_43;
                                block100: {
                                    Object var13_42;
                                    block99: {
                                        Object var11_41;
                                        stringBuffer2.append("[" + this.config.getSetting("/environment/os") + "-" + this.config.getSetting("/environment/bit") + "bit-" + this.config.getSetting("/environment/platform") + "]");
                                        stringBuffer2.append(" [" + this.config.getSetting("/test[" + n3 + "]/version[@role=\"source\"]/versionnumber"));
                                        try {
                                            try {
                                                stringBuffer2.append(this.config.getSetting("/test[" + n3 + "]/version[@role=\"source\"]/versionnumber/@state"));
                                            }
                                            catch (SettingNotFoundException settingNotFoundException) {
                                                var11_41 = null;
                                                stringBuffer2.append("] ");
                                                break block99;
                                            }
                                            var11_41 = null;
                                            stringBuffer2.append("] ");
                                        }
                                        catch (Throwable throwable) {
                                            var11_41 = null;
                                            stringBuffer2.append("] ");
                                            throw throwable;
                                        }
                                    }
                                    stringBuffer2.append("--> [" + this.config.getSetting("/test[" + n3 + "]/version[@role=\"target\"]/versionnumber"));
                                    try {
                                        try {
                                            stringBuffer2.append(this.config.getSetting("/test[" + n3 + "]/version[@role=\"target\"]/versionnumber/@state"));
                                        }
                                        catch (SettingNotFoundException settingNotFoundException) {
                                            var13_42 = null;
                                            stringBuffer2.append("]");
                                            break block100;
                                        }
                                        var13_42 = null;
                                        stringBuffer2.append("]");
                                    }
                                    catch (Throwable throwable) {
                                        var13_42 = null;
                                        stringBuffer2.append("]");
                                        throw throwable;
                                    }
                                }
                                if (!bl) break block101;
                                stringBuffer2.append(" brick [" + this.config.getSetting("/test[" + n3 + "]/version[@role=\"brick\"]/versionnumber"));
                                try {
                                    try {
                                        stringBuffer2.append(this.config.getSetting("/test[" + n3 + "]/version[@role=\"brick\"]/versionnumber/@state"));
                                    }
                                    catch (SettingNotFoundException settingNotFoundException) {
                                        var15_43 = null;
                                        stringBuffer2.append("]");
                                        break block101;
                                    }
                                    var15_43 = null;
                                    stringBuffer2.append("]");
                                }
                                catch (Throwable throwable) {
                                    var15_43 = null;
                                    stringBuffer2.append("]");
                                    throw throwable;
                                }
                            }
                            catch (ConfigurationException configurationException) {
                                bl3 = true;
                                Logger.error("Missing configuration for testrun - skipping testrun. Exception: \"" + configurationException.getMessage() + "\"");
                                Logger.stackTrace(configurationException);
                                this.testmsgs.add("missing or malformed configuration - skipped");
                                this.addMessage("Test #[" + n3 + "]", 'E', "missing or malformed configuration - skipped");
                                break block102;
                            }
                        }
                        Logger.log(Logger.STANDARD, "OS properties: name [" + System.getProperty("os.name") + "] arch [" + System.getProperty("os.arch") + "] version [" + System.getProperty("os.version") + "]");
                        Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: " + stringBuffer2 + " started ...");
                        n = 0;
                        n = this.ih.getPackage(n3, "source");
                        if (n != 0) {
                            String string = n == 5 ? "No LC_APPS for this release" : (n == -1337 ? "Build #13 never exists" : "unknown");
                            Logger.warning("Couldn't get the source version [" + this.config.getSetting("/test[" + n3 + "]/version[@role=\"source\"]/versionnumber") + "] package for testrun " + n3 + ", exitvalue is " + n + " (presumed reason:" + string + ") - skipping the test");
                            this.testmsgs.add("Test #[" + n3 + "]: " + stringBuffer2 + " couldn't get source version [" + this.config.getSetting("/test[" + n3 + "]/version[@role=\"source\"]/versionnumber") + "] package - skipped");
                            this.addMessage("Test #[" + n3 + "]", 'E', stringBuffer2 + " couldn't get source version [" + this.config.getSetting("/test[" + n3 + "]/version[@role=\"source\"]/versionnumber") + "] package - skipped");
                        } else {
                            n = this.ih.getPackage(n3, "target");
                            if (n != 0) {
                                Logger.warning("Couldn't get the target version [" + this.config.getSetting("/test[" + n3 + "]/version[@role=\"target\"]/versionnumber") + "] package for testrun " + n3 + ", exitvalue is " + n + " - skipping the test");
                                this.testmsgs.add("Test #[" + n3 + "]: " + stringBuffer2 + " couldn't get target version package - skipped");
                                this.addMessage("Test #[" + n3 + "]", 'E', stringBuffer2 + " couldn't get target version package - skipped");
                            } else if (bl && (n = this.ih.getPackage(n3, "brick")) != 0) {
                                Logger.warning("Couldn't get the brick version [" + this.config.getSetting("/test[" + n3 + "]/version[@role=\"brick\"]/versionnumber") + "] package for testrun " + n3 + ", exitvalue is " + n + " - skipping the test");
                                this.testmsgs.add("Test #[" + n3 + "]: " + stringBuffer2 + " couldn't get brick version package - skipped");
                                this.addMessage("Test #[" + n3 + "]", 'W', stringBuffer2 + " couldn't get brick version package - skipped");
                            } else {
                                char c;
                                Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: starting to install the source version db");
                                try {
                                    n = this.ih.installDB(n3, "source");
                                }
                                catch (Exception exception) {
                                    Logger.log(Logger.VERBOSE, "Test #[" + n3 + "]: Installation of source version failed with exception \"" + exception.getMessage() + "\"");
                                    Logger.stackTrace(exception);
                                    n = 1;
                                }
                                if (this.handleStop(n3, n, "install-source")) break block103;
                                if (n == 0) {
                                    Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: installation of database source version successful");
                                } else {
                                    Logger.error("Test #[" + n3 + "]: installation of database source version FAILED, exitvalue is " + n);
                                    bl3 = true;
                                    stringBuffer.append("[installDB failed] ");
                                    n = 0;
                                }
                                Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: starting to install the brick version db");
                                if (bl) {
                                    try {
                                        n = this.ih.installDB(n3, "brick");
                                    }
                                    catch (Exception exception) {
                                        Logger.log(Logger.VERBOSE, "Test #[" + n3 + "]: Installation of brick version failed with exception \"" + exception.getMessage() + "\"");
                                        Logger.stackTrace(exception);
                                        n = 1;
                                    }
                                    if (n == 0) {
                                        Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: installation of database brick version successful");
                                    } else {
                                        Logger.error("Test #[" + n3 + "]: installation of database brick version FAILED, exitvalue is " + n);
                                        bl3 = true;
                                        stringBuffer.append("[install brick failed] ");
                                        n = 0;
                                    }
                                }
                                Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: starting X-Server...");
                                try {
                                    n = this.ih.startXServer();
                                }
                                catch (Exception exception) {
                                    Logger.log(Logger.VERBOSE, "Test #[" + n3 + "]: starting the X-Server failed with exception \"" + exception.getMessage() + "\"");
                                    Logger.stackTrace(exception);
                                    n = 1;
                                }
                                if (n == 0) {
                                    Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: X-Server started.");
                                } else {
                                    Logger.error("Test #[" + n3 + "]: starting the X-Server failed, exitvalue is " + n);
                                    bl2 = true;
                                    stringBuffer.append("[startXServer failed] ");
                                    n = 0;
                                }
                                Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: creating database instance");
                                try {
                                    n = this.dh.runDBMscript(n3, "createdb");
                                }
                                catch (Exception exception) {
                                    Logger.log(Logger.VERBOSE, "Test #[" + n3 + "]: creation of database instance failed with exception \"" + exception.getMessage() + "\"");
                                    Logger.stackTrace(exception);
                                    n = 1;
                                }
                                if (n == 0) {
                                    Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: database instance created successful");
                                } else {
                                    Logger.error("Test #[" + n3 + "]: creation of database instance failed, exitvalue is " + n);
                                    bl2 = true;
                                    stringBuffer.append("[createdb failed] ");
                                    n = 0;
                                }
                                Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: preparing the db instance for update ...");
                                try {
                                    this.dh.runDBMscript(n3, "prepupdate");
                                }
                                catch (Exception exception) {
                                    Logger.log(Logger.VERBOSE, "Test #[" + n3 + "]: preparing the db instance for update failed with exception \"" + exception.getMessage() + "\"");
                                    Logger.stackTrace(exception);
                                    n = 1;
                                }
                                if (n == 0) {
                                    Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: db prepared for update successfully.");
                                } else {
                                    Logger.error("Test #[" + n3 + "]: preparation of db for update failed, exitvalue is " + n);
                                    bl2 = true;
                                    stringBuffer.append("[prepareUpdate failed] ");
                                    n = 0;
                                }
                                Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: starting to update database ...");
                                try {
                                    n = this.ih.updateDB(n3, "target");
                                }
                                catch (Exception exception) {
                                    Logger.log(Logger.VERBOSE, "Test #[" + n3 + "]: database update failed with exception \"" + exception.getMessage() + "\"");
                                    Logger.stackTrace(exception);
                                    n = 1;
                                }
                                if (this.handleStop(n3, n, "updateDB")) break block103;
                                if (n == 0) {
                                    Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: database update finished successful.");
                                } else {
                                    Logger.error("Test #[" + n3 + "]: database update failed, exitvalue is " + n);
                                    bl3 = true;
                                    stringBuffer.append("[updateDB failed] ");
                                    n = 0;
                                }
                                Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: preparing uninstallation");
                                try {
                                    this.dh.runDBMscript(n3, "prepuninst");
                                }
                                catch (Exception exception) {
                                    Logger.log(Logger.VERBOSE, "Test #[" + n3 + "]: preparing uninstallation failed with exception \"" + exception.getMessage() + "\"");
                                    Logger.stackTrace(exception);
                                    n = 1;
                                }
                                if (n == 0) {
                                    Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: preparation of uninstallation successful.");
                                } else {
                                    Logger.error("Test #[" + n3 + "]: preparation of uninstallation failed, exitvalue is " + n);
                                    bl2 = true;
                                    stringBuffer.append("[prepareUninstallation failed] ");
                                    n = 0;
                                }
                                Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: stopping X-Server...");
                                try {
                                    n = this.ih.stopXServer();
                                }
                                catch (Exception exception) {
                                    Logger.log(Logger.VERBOSE, "Test #[" + n3 + "]: stopping the X-Server failed with exception \"" + exception.getMessage() + "\"");
                                    Logger.stackTrace(exception);
                                    n = 1;
                                }
                                if (n == 0) {
                                    Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: X-Server stopped.");
                                } else {
                                    Logger.error("Test #[" + n3 + "]: stopping the X-Server failed, exitvalue is " + n);
                                    bl2 = true;
                                    stringBuffer.append("[stopXServer failed] ");
                                    n = 0;
                                }
                                Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: unistalling the database ...");
                                try {
                                    this.ih.uninstallDB(n3);
                                }
                                catch (Exception exception) {
                                    Logger.log(Logger.VERBOSE, "Test #[" + n3 + "]: uninstallation failed with exception \"" + exception.getMessage() + "\"");
                                    Logger.stackTrace(exception);
                                    n = 1;
                                }
                                if (n == 0) {
                                    Logger.log(Logger.STANDARD, "Test #[" + n3 + "]: unistallation successful.");
                                } else {
                                    Logger.error("Test #[" + n3 + "]: unistallation failed, exitvalue is " + n);
                                    bl2 = true;
                                    stringBuffer.append("[uninstallDB failed] ");
                                    n = 0;
                                }
                                if (bl3) {
                                    stringBuffer.append("- FAILURE");
                                    Logger.log(Logger.STANDARD, "Test #[" + n3 + "] " + stringBuffer2 + " ... finished but FAILED.");
                                    c = 'E';
                                } else if (bl2) {
                                    stringBuffer.append("- WARNINGs received");
                                    Logger.log(Logger.STANDARD, "Test #[" + n3 + "] ... " + stringBuffer2 + " finished but had WARNINGS.");
                                    c = 'W';
                                } else {
                                    stringBuffer.append("- SUCCESS");
                                    Logger.log(Logger.STANDARD, "Test #[" + n3 + "] ... " + stringBuffer2 + " finished successfully.");
                                    c = 'I';
                                    this.ih.removeLogFiles(n3);
                                }
                                this.testmsgs.add("Test #[" + n3 + "]: " + stringBuffer2 + " Result: " + stringBuffer);
                                this.addMessage("Test #[" + n3 + "]", c, stringBuffer2 + " Result: " + stringBuffer);
                            }
                        }
                    }
                    ++n3;
                }
            }
            catch (Exception exception) {
                Logger.stackTrace(exception);
                this.handleExceptions(exception);
            }
        }
        try {
            this.ih.deleteTempFiles();
        }
        catch (Exception exception) {
            Logger.log(Logger.VERBOSE, "removing tempfiles failed with exception: \"" + exception.getMessage() + "\"");
            Logger.stackTrace(exception);
            this.addMessage("UpgradeTest Cleanup: ", 'W', "[tempfile removal failed - downloaded DEV states possibly still on disk and corrupted]");
        }
        int n = 0;
        while (n < this.testmsgs.size()) {
            Logger.log(Logger.STANDARD, (String)this.testmsgs.get(n));
            ++n;
        }
        return;
    }

    public static long getTimeout() {
        return 0L;
    }

    private boolean handleStop(int n, int n2, String string) {
        block13: {
            String string2;
            try {
                this.config.getSetting("/test[" + n + "]/stop[@after=\"" + string + "\"]");
            }
            catch (SettingNotFoundException settingNotFoundException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            try {
                string2 = this.config.getSetting("/test[" + n + "]/stop[@after=\"" + string + "\"]/@when");
            }
            catch (SettingNotFoundException settingNotFoundException) {
                string2 = "";
            }
            if (string2.equals("failed") && n2 == 0) {
                return false;
            }
            try {
                if (this.config.getSetting("/test[" + n + "]/stop[@after=\"" + string + "\"]/@method").equals("endtests")) {
                    Logger.log(Logger.STANDARD, "stop node says to end the testrun - doing a soft exit!");
                    return true;
                }
                if (this.config.getSetting("/test[" + n + "]/stop[@after=\"" + string + "\"]/@method").equals("hardexit")) {
                    Logger.log(Logger.STANDARD, "After step " + string + " - doing a hard exit!");
                    System.exit(1);
                    return false;
                }
                if (!this.config.getSetting("/test[" + n + "]/stop[@after=\"" + string + "\"]/@method").equals("hold")) break block13;
                System.out.println("[UpgradeTest] " + string + " failed, press any key to continue or C to cancel the test...");
                try {
                    int n3 = System.in.read();
                    if (n3 == 99) {
                        System.exit(1);
                    }
                }
                catch (IOException iOException) {
                    Logger.error("Failed to get user input when waiting for ");
                }
                return false;
            }
            catch (SettingNotFoundException settingNotFoundException) {
                // empty catch block
            }
        }
        Logger.error("Found a relevant <stop> node but don't recognize the method");
        return false;
    }

    public String getLogFile() {
        Logger.log(Logger.VERBOSE, "Logfile requested, creating the ZIP containing it.");
        if (this.ih == null) {
            Logger.warning("Cannot create zip with logfiles, InstallationHelper hasn't been created yet.");
            this.addMessage("[UpgradeTest]", 'W', "Failed to create zip with logfiles, InstallationHelper hasn't been created yet.");
            return null;
        }
        String string = null;
        try {
            string = this.ih.createLogfileZip(this.testmsgs, this.getDataOutputPath());
        }
        catch (Exception exception) {
            this.addMessage("[UpgradeTest]", 'W', "Failed to create logfile with zips - no logfiles added!");
            Logger.stackTrace(exception);
        }
        return string;
    }

    public static void cleanup() {
    }

    public static int getDBPort() {
        return Integer.parseInt(TestCase.mTestDriverOptions.getProperty("db-port", "7210"));
    }

    public static String getStartDateTime() {
        return startDateTime;
    }

    public static void resetStartDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yy_HH.mm");
        startDateTime = simpleDateFormat.format(new Date());
    }
}

