/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.tool;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ProtocolViewer
extends TextViewer {
    private OutputWriter mWriter;
    private PrintWriter _printWriter;
    private final Document mDocument;
    private Composite _parent;
    private Color _errorColor;

    public ProtocolViewer(Composite parent, int styles) {
        super(parent, styles);
        this._parent = parent;
        this.mDocument = new Document();
        this.mWriter = new OutputWriter();
        this._printWriter = new PrintWriter(this.mWriter);
        this._errorColor = new Color(null, 255, 0, 0);
        this.setDocument((IDocument)this.mDocument);
    }

    public void println(String text, boolean color) {
        if (!text.endsWith("\n")) {
            text = text + "\n";
        }
        this.print(text, color);
    }

    public void printlnasync(String text, boolean color) {
        if (!text.endsWith("\n")) {
            text = text + "\n";
        }
        Display.getDefault().asyncExec((Runnable)new ProtRunnable(text, color){});
    }

    private void print(String text, boolean color) {
        try {
            int line = this.mDocument.getLineOfOffset(this.mDocument.getLength() - 1);
            this.mDocument.replace(this.mDocument.getLength(), 0, text);
            this.setTopIndex(line);
            if (color) {
                this.setTextColor(this._errorColor, this.mDocument.getLength() - text.length(), text.length(), false);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void clear() {
        try {
            this.mDocument.replace(0, this.mDocument.getLength(), "");
            int line = this.mDocument.getLineOfOffset(this.mDocument.getLength() - 1);
            this.setTopIndex(line);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public PrintWriter getPrintWriter() {
        return this._printWriter;
    }

    public boolean isVisible() {
        try {
            return this._parent.isVisible();
        }
        catch (Exception ex) {
            return false;
        }
    }

    private class OutputWriter
    extends Writer {
        public void write(char[] cbuf, int off, int len) throws IOException {
            String text = new String(cbuf, off, len);
            ProtocolViewer.this.print(text, false);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }

    private class ProtRunnable
    implements Runnable {
        String _text;
        boolean _color;

        public ProtRunnable(String text, boolean color) {
            this._color = color;
            this._text = text;
        }

        public void run() {
            ProtocolViewer.this.print(this._text, this._color);
        }
    }
}

