/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.gui.jface_dialog;

import com.sap.sdb.syncMan.design.DesignSQLLayer;
import com.sap.sdb.syncMan.design.Participant;
import com.sap.sdb.syncMan.design.ParticipantConfig;
import com.sap.sdb.syncMan.gui.jface_objects.LogonHistoryData;
import com.sap.sdb.syncMan.tool.ConDataBase;
import com.sap.sdb.syncMan.tool.Resources;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParticipantDialog
extends Dialog {
    private static final int LABEL_WIDTH = 100;
    public static final int NEW_MASTER = 0;
    public static final int NEW_CLIENT_FROM_MASTER = 1;
    public static final int SHOW_CLIENT = 2;
    public static final int SHOW_MASTER = 3;
    public static final int ASK_PARTICIPANT_PASSWORD = 4;
    private Combo _participantName;
    private Combo _server;
    private Combo _database;
    private Text _user;
    private Text _password;
    private Button _storePWButton;
    private Combo _unitType;
    private int _dialogType;
    ConDataBase _con = null;
    Participant _participant = null;
    Hashtable _serverHistory = null;
    Hashtable _unitNameHistory = null;

    public ParticipantDialog(Shell parentShell, ConDataBase con, Hashtable serverHistory, Hashtable unitNameHistory, Participant particpant, int dialogType) {
        super(parentShell);
        this._con = con;
        this._serverHistory = serverHistory;
        this._unitNameHistory = unitNameHistory;
        this._participant = particpant;
        this._dialogType = dialogType;
    }

    public void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this._participant.isMaster()) {
            shell.setText(Resources.getString("ParticipantDialog.MasterUnit"));
        } else {
            shell.setText(Resources.getString("ParticipantDialog.ClientUnit"));
        }
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        page.setLayout((Layout)gridLayout);
        Group machineGroup = new Group(page, 0);
        machineGroup.setText("");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 10;
        gridLayout.horizontalSpacing = 10;
        machineGroup.setLayout((Layout)gridLayout);
        machineGroup.setLayoutData((Object)new GridData(1808));
        Label participantLabel = new Label((Composite)machineGroup, 0);
        participantLabel.setText(Resources.getString("Participant.ParticipantName"));
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        participantLabel.setLayoutData((Object)gridData);
        this._participantName = new Combo((Composite)machineGroup, 2048);
        this._participantName.setText(this._participant.getParticipantName());
        this._participantName.setEnabled(!this._participant.isInstalled() && this._dialogType != 4);
        gridData = new GridData(768);
        gridData.widthHint = 100;
        this._participantName.setLayoutData((Object)gridData);
        Enumeration<Object> enumeration = this._unitNameHistory.elements();
        while (enumeration.hasMoreElements()) {
            String data = (String)enumeration.nextElement();
            this._participantName.add(data);
        }
        Group accountGroup = null;
        if (this._dialogType != 0 && this._dialogType != 3) {
            accountGroup = new Group(page, 0);
            accountGroup.setText("");
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.verticalSpacing = 10;
            gridLayout.horizontalSpacing = 10;
            accountGroup.setLayout((Layout)gridLayout);
            accountGroup.setLayoutData((Object)new GridData(1808));
            Label serverLabel = new Label((Composite)machineGroup, 0);
            serverLabel.setText(Resources.getString("Participant.Server"));
            gridData = new GridData();
            gridData.widthHint = 100;
            serverLabel.setLayoutData((Object)gridData);
            this._server = new Combo((Composite)machineGroup, 2052);
            this._server.setEnabled(!this._participant.isInstalled() && this._dialogType != 4);
            if (this._participant.getParticipantName().length() > 0) {
                this._server.setText(this._participant.getHost());
            }
            gridData = new GridData(768);
            gridData.widthHint = 100;
            this._server.setLayoutData((Object)gridData);
            this._server.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String key;
                    Hashtable databases;
                    if (ParticipantDialog.this._server.getItemCount() > 0 && (databases = (Hashtable)ParticipantDialog.this._serverHistory.get(key = ParticipantDialog.this._server.getItem(ParticipantDialog.this._server.getSelectionIndex()))) != null) {
                        LogonHistoryData data;
                        ParticipantDialog.this._database.removeAll();
                        Enumeration enumeration = databases.elements();
                        while (enumeration.hasMoreElements()) {
                            data = (LogonHistoryData)enumeration.nextElement();
                            ParticipantDialog.this._database.add(data.database());
                        }
                        ParticipantDialog.this._database.select(0);
                        data = (LogonHistoryData)databases.get(ParticipantDialog.this._database.getItem(ParticipantDialog.this._database.getSelectionIndex()));
                        ParticipantDialog.this._user.setText(data.user());
                        ParticipantDialog.this._password.setText(data.password());
                    }
                }
            });
            enumeration = this._serverHistory.keys();
            while (enumeration.hasMoreElements()) {
                String data = (String)enumeration.nextElement();
                this._server.add(data);
            }
            Label databaseLabel = new Label((Composite)machineGroup, 0);
            databaseLabel.setText(Resources.getString("Participant.Database"));
            this._database = new Combo((Composite)machineGroup, 2048);
            this._database.setText(this._participant.getDataBase());
            this._database.setEnabled(!this._participant.isInstalled() && this._dialogType != 4);
            gridData = new GridData(768);
            this._database.setLayoutData((Object)gridData);
            this._database.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String key;
                    Hashtable databases;
                    if (ParticipantDialog.this._database.getItemCount() > 0 && (databases = (Hashtable)ParticipantDialog.this._serverHistory.get(key = ParticipantDialog.this._server.getItem(ParticipantDialog.this._server.getSelectionIndex()))) != null) {
                        LogonHistoryData data = (LogonHistoryData)databases.get(ParticipantDialog.this._database.getItem(ParticipantDialog.this._database.getSelectionIndex()));
                        ParticipantDialog.this._user.setText(data.user());
                        ParticipantDialog.this._password.setText(data.password());
                    }
                }
            });
            Label userLabel = new Label((Composite)accountGroup, 0);
            userLabel.setText(Resources.getString("Participant.User"));
            gridData = new GridData();
            gridData.widthHint = 100;
            userLabel.setLayoutData((Object)gridData);
            this._user = new Text((Composite)accountGroup, 2048);
            this._user.setText(this._participant.getUser());
            if (this._user.getText() == null || this._user.getText().length() < 1) {
                this._user.setText(Resources.getString("DefaultUser"));
            }
            this._user.setEnabled(!this._participant.isInstalled() && this._dialogType != 4);
            gridData = new GridData(768);
            gridData.widthHint = 100;
            this._user.setLayoutData((Object)gridData);
            this._user.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    if (ParticipantDialog.this._user.getText() != null && ParticipantDialog.this._user.getText().length() > 0 && ParticipantDialog.this._user.getText().charAt(0) != '\"' || (ParticipantDialog.this._user.getText() == null || ParticipantDialog.this._user.getText().length() < 1) && e.text.length() > 0 && e.text.charAt(0) != '\"') {
                        e.text = e.text.toUpperCase();
                    }
                }
            });
            Label passwordLabel = new Label((Composite)accountGroup, 0);
            passwordLabel.setText(Resources.getString("Participant.Password"));
            this._password = new Text((Composite)accountGroup, 2048);
            this._password.setText(this._participant.getPassWord());
            this._password.setEnabled(!this._participant.isInstalled() || this._dialogType == 4);
            gridData = new GridData(768);
            gridData.widthHint = 100;
            this._password.setLayoutData((Object)gridData);
            this._password.setEchoChar('*');
            this._password.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    if (ParticipantDialog.this._password.getText() != null && ParticipantDialog.this._password.getText().length() > 0 && ParticipantDialog.this._password.getText().charAt(0) != '\"' || (ParticipantDialog.this._password.getText() == null || ParticipantDialog.this._password.getText().length() < 1) && e.text.length() > 0 && e.text.charAt(0) != '\"') {
                        e.text = e.text.toUpperCase();
                    }
                }
            });
            if (this._dialogType != 4) {
                this._storePWButton = new Button((Composite)accountGroup, 32);
                this._storePWButton.setText(Resources.getString("ParticipantDialog.Save_Password"));
                this._storePWButton.setEnabled(!this._participant.isInstalled());
                gridData = new GridData(768);
                gridData.widthHint = 100;
                this._storePWButton.setLayoutData((Object)gridData);
                this._storePWButton.setSelection(this._participant.getPassWord().length() > 0);
                Label plain = new Label((Composite)accountGroup, 0);
                plain.setText("");
            }
        }
        Group tmp = accountGroup;
        if (this._dialogType == 0 || this._dialogType == 3) {
            tmp = machineGroup;
        }
        Label plainUnit = new Label((Composite)tmp, 0);
        plainUnit.setText(Resources.getString("ParticipantDialog.Unit_Type"));
        this._unitType = new Combo((Composite)tmp, 12);
        this._unitType.setText("");
        gridData = new GridData(768);
        gridData.widthHint = 100;
        this._unitType.setLayoutData((Object)gridData);
        if (this._dialogType == 1) {
            if (this._participant.getParticipantType() == 1) {
                this._unitType.add(Resources.getString("ParticipantDialog.In"), 0);
            }
            if (this._participant.getParticipantType() == 0) {
                this._unitType.add(Resources.getString("ParticipantDialog.Out"), 0);
            }
            if (this._participant.getParticipantType() == 2) {
                this._unitType.add(Resources.getString("ParticipantDialog.In"), 0);
                this._unitType.add(Resources.getString("ParticipantDialog.In/Out"), 1);
            }
            if (this._participant.getParticipantType() == 1 || this._participant.getParticipantType() == 0) {
                this._unitType.select(0);
            } else {
                this._unitType.select(1);
            }
        } else if (this._dialogType == 2) {
            if (this._participant.getMasterParticipantType() == 0) {
                this._unitType.add(Resources.getString("ParticipantDialog.In"), 0);
            }
            if (this._participant.getMasterParticipantType() == 1) {
                this._unitType.add(Resources.getString("ParticipantDialog.Out"), 0);
            }
            if (this._participant.getMasterParticipantType() == 2) {
                this._unitType.add(Resources.getString("ParticipantDialog.In"), 0);
                this._unitType.add(Resources.getString("ParticipantDialog.In/Out"), 1);
            }
            if (this._participant.getParticipantType() == 1 || this._participant.getParticipantType() == 0) {
                this._unitType.select(0);
            } else {
                this._unitType.select(1);
            }
        } else if (this._dialogType == 4) {
            if (this._participant.getParticipantType() == 1) {
                this._unitType.add(Resources.getString("ParticipantDialog.In"), 0);
            }
            if (this._participant.getParticipantType() == 0) {
                this._unitType.add(Resources.getString("ParticipantDialog.Out"), 0);
            }
            if (this._participant.getParticipantType() == 2) {
                this._unitType.add(Resources.getString("ParticipantDialog.In/Out"), 0);
            }
            this._unitType.select(0);
        } else if (this._dialogType == 0 || this._dialogType == 3) {
            this._unitType.add(Resources.getString("ParticipantDialog.Out"), 0);
            this._unitType.add(Resources.getString("ParticipantDialog.In/Out"), 1);
            if (this._participant.getParticipantType() == 2) {
                this._unitType.select(1);
            } else {
                this._unitType.select(0);
            }
        }
        this._unitType.setEnabled(!this._participant.isInstalled() && this._dialogType != 4 && this._dialogType != 3);
        this._participantName.setFocus();
        return page;
    }

    protected void okPressed() {
        String temp = this._participantName.getText();
        if (temp.length() < 1 || temp.equalsIgnoreCase("allunits")) {
            MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ParticipantDialog.Error"), (String)Resources.getString("ParticipantDialog.Enter_Valid_Unit_Name"));
            this._participantName.setFocus();
            return;
        }
        for (int i = 0; i < temp.length(); ++i) {
            if (Character.isJavaIdentifierPart(temp.charAt(i))) continue;
            MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ParticipantDialog.Error"), (String)(Resources.getString("ParticipantDialog.Character") + " '" + temp.charAt(i) + "' " + Resources.getString("ParticipantDialog.Not_Allowed_In_Unit_Name") + temp));
            this._participantName.setFocus();
            return;
        }
        if (this._dialogType != 0 && this._dialogType != 3 && (temp = this._user.getText()).length() < 1) {
            MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ParticipantDialog.Error"), (String)Resources.getString("ParticipantDialog.Enter_Valid_User_Name"));
            this._user.setFocus();
            return;
        }
        if (!this.applyParticpantUnit()) {
            this._participant.setParticipantName("");
            return;
        }
        if (this._dialogType != 0 && this._dialogType != 3) {
            LogonHistoryData data = new LogonHistoryData(this._server.getText(), this._database.getText(), this._user.getText(), this._password.getText());
            Hashtable<String, LogonHistoryData> databases = (Hashtable<String, LogonHistoryData>)this._serverHistory.get(data.server());
            if (databases == null) {
                databases = new Hashtable<String, LogonHistoryData>();
                this._serverHistory.put(data.server(), databases);
            }
            databases.put(data.database(), data);
            this._unitNameHistory.put(this._participantName.getText(), this._participantName.getText());
        }
        super.okPressed();
    }

    private boolean applyParticpantUnit() {
        if (this._participant.isInstalled() || this._dialogType == 4) {
            this._participant.setPassWord(this._password.getText());
            return true;
        }
        try {
            ParticipantConfig config = null;
            if (this._participant.getParticipantName().length() > 0) {
                config = DesignSQLLayer.selectParticipantConfig(this._con, this._participant.getHost(), this._participant.getDataBase());
            }
            if (this._unitType.getText().equals(Resources.getString("ParticipantDialog.Out"))) {
                this._participant.setParticipantType(0);
            } else if (this._unitType.getText().equals(Resources.getString("ParticipantDialog.In"))) {
                this._participant.setParticipantType(1);
            } else {
                this._participant.setParticipantType(2);
            }
            if (this._dialogType != 0 && this._dialogType != 3) {
                this._participant.setHost(this._server.getText());
                this._participant.setDataBase(this._database.getText());
                this._participant.setUser(this._user.getText());
                if (this._storePWButton.getSelection()) {
                    this._participant.setPassWord(this._password.getText());
                } else {
                    this._participant.setPassWord("");
                }
            }
            if (this._participant.getParticipantName().length() < 1) {
                this._participant.setParticipantName(this._participantName.getText());
                DesignSQLLayer.insertParticipant(this._con, this._participant, !this._participant.isMaster());
            } else {
                this._participant.setParticipantName(this._participantName.getText());
                DesignSQLLayer.alterParticipant(this._con, this._participant);
                DesignSQLLayer.deleteParticipantConfig(this._con, config.getHost(), config.getDataBase());
                config.setHost(this._participant.getHost());
                config.setDataBase(this._participant.getDataBase());
                DesignSQLLayer.insertParticipantConfigWithCheck(this._con, config);
            }
            this._con.getConnection().commit();
        }
        catch (Exception ex) {
            try {
                if (ex instanceof SQLException) {
                    if (((SQLException)ex).getErrorCode() == 250) {
                        MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ParticipantDialog.Error"), (String)Resources.getString("ParticipantDialog.Unit_name_in_use"));
                    } else {
                        MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ParticipantDialog.Error"), (String)ex.toString());
                    }
                }
                this._con.getConnection().rollback();
            }
            catch (SQLException ex2) {
                MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ParticipantDialog.Error"), (String)ex2.toString());
            }
            if (!(ex instanceof SQLException)) {
                MessageDialog.openError((Shell)this.getShell(), (String)Resources.getString("ParticipantDialog.Error"), (String)ex.toString());
            }
            return false;
        }
        return true;
    }
}

