/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.SyncMan.MsgService;

import com.sap.sapdb.SyncMan.MsgService.MsgClient;
import com.sap.sapdb.testframe.testcase.TestCase;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;

public abstract class MsgQueueClient
extends MsgClient {
    protected QueueConnection m_Connection = null;
    protected QueueSession m_SendSession = null;
    protected QueueSession m_ReceiveSession = null;
    protected QueueSender m_Sender = null;
    protected QueueReceiver m_Receiver = null;
    protected QueueConnectionFactory m_conFactory = (QueueConnectionFactory)this.m_jndi.lookup("jms.QueueConnectionFactory");
    protected Queue m_queue = null;

    public MsgQueueClient(TestCase testCase, int deliveryMode, String queueName, String user, String password, String selector, int sendAccMode, boolean sendTrans, int recAccMode, boolean recTrans, ThreadGroup group, String threadName) throws Exception {
        super(testCase, deliveryMode, user, password, group, threadName);
        this.m_Connection = this.m_conFactory.createQueueConnection(user, password);
        this.m_SendSession = this.m_Connection.createQueueSession(sendTrans, sendAccMode);
        this.m_ReceiveSession = this.m_Connection.createQueueSession(recTrans, recAccMode);
        this.m_queue = (Queue)this.m_jndi.lookup("jms.queue." + queueName);
        this.m_Sender = this.m_SendSession.createSender(this.m_queue);
        this.m_Receiver = this.m_ReceiveSession.createReceiver(this.m_queue, selector);
    }

    public void close() throws JMSException {
        this.m_Connection.close();
    }

    public void closeReceiver() throws JMSException {
        this.m_Receiver.close();
    }
}

