/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.lctest.DBProcedure;
import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.lctest.Oid;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.Execute;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class Performance
extends TestCase
implements LiveCacheConstants {
    private static final String sVersion = "0.42";
    private static int mScaling;
    private Connection mConnection = null;
    private TestStatement mStatement = null;
    private long mScaleFactor = 0L;
    private int mIOError = 0;
    private static int mSamples;
    private static int mNoOfObjects;
    private static int mPercentageObject;
    private static int mPercentageInsert;
    private static int mPercentageKeyed;
    private static int mPercentageVar;
    private static int mVarMaxLength;
    private static int mPercentageSubtransaction;
    private static int mPercentageSubtransCommit;
    private static int mPercentageUpdate;
    private static int mPercentageDelete;
    private Properties mResult = null;
    private long mOverheadTime = 0L;
    private int mIOErrorTotal = 0;
    private static int mTraceLevel;
    private static int mMeasurementOfCreate;
    private static int mMeasurementOfRead;
    private static int mMeasurementOfUpdate;
    private static int mMeasurementOfInsert;
    private static int mMeasurementOfDelete;

    public static String getTestClassId() {
        return "Performance";
    }

    private void calculateScaleFactor() {
        long diff = 0L;
        long start = 0L;
        long sum = 0L;
        try {
            int i;
            Performance.printInfo(1, "Performance", "Calculating scaling factor ... ");
            this.setStatus("Calculating scaling factor...");
            this.mConnection = Performance.getDatabase().connect(Performance.getUser(), Performance.getPassword());
            this.mStatement = new TestStatement((TestCase)this, this.mConnection);
            this.mStatement.execute("CALL SET_CURRENT_SCHEMA('testteam')");
            this.mConnection.commit();
            CallableStatement stm = null;
            stm = this.mConnection.prepareCall("CALL LIST_INIT");
            stm.execute();
            long max = Long.MIN_VALUE;
            long min = Long.MAX_VALUE;
            stm = this.mConnection.prepareCall("CALL EMPTY_PROCEDURE");
            for (i = 1; i <= mScaling; ++i) {
                start = System.currentTimeMillis();
                for (int j = 1; j <= mScaling * 2; ++j) {
                    stm.execute();
                }
                diff = (System.currentTimeMillis() - start) / (long)(mScaling * 2);
                if (min > diff) {
                    min = diff;
                }
                if (max < diff) {
                    max = diff;
                }
                sum += diff;
            }
            this.mOverheadTime = (sum - max - min) * 1000L / (long)(mScaling - 2);
            this.mResult.setProperty("JDBCOverhead", Long.toString(this.mOverheadTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            stm = this.mConnection.prepareCall("CALL SCALING_PROCEDURE");
            for (i = 1; i <= mScaling; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (min > diff) {
                    min = diff;
                }
                if (max < diff) {
                    max = diff;
                }
                sum += diff;
            }
            this.mScaleFactor = (sum - max - min) / (long)(mScaling - 2);
            this.mScaleFactor -= this.mOverheadTime / 1000L;
            Performance.printInfo(3, "Performance", "Scaling factor is " + String.valueOf(this.mScaleFactor) + "\n");
        }
        catch (Exception e) {
            System.out.println("\nError in calculating the scaling factor!");
            System.out.println("Exception in calculateScaleFactor(): " + e + "\n");
            this.mScaleFactor = 0L;
        }
        this.mResult.setProperty("ScaleFactor", Long.toString(this.mScaleFactor));
    }

    private boolean checkIOAccess() {
        ResultSet rs = null;
        TestStatement tstm = null;
        long number = 0L;
        try {
            tstm = new TestStatement(null, this.mConnection);
            rs = tstm.executeQuery("select sum (value) from " + Performance.getUser() + ".monitor_pages where description like '%physical%'");
            while (rs.next()) {
                number = rs.getLong(1);
            }
            if (number > 0L) {
                tstm.executeUpdate("MONITOR INIT");
                ++this.mIOError;
                ++this.mIOErrorTotal;
                return true;
            }
        }
        catch (Exception e) {
            System.out.println("\nPerformance - Exception in checkIOAccess(): " + e + "\n");
            Performance.addGlobalMessage((String)"Performance", (char)'E', (String)e.getMessage());
            return true;
        }
        return false;
    }

    private static void createDBProcedures() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        int ExecMode = 1;
        try {
            con = Performance.getDatabase().connect(Performance.getDatabase().getUser(), Performance.getDatabase().getPassword());
            stmt = new TestStatement(null, con);
            try {
                if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.4.4")) {
                    DBProcedure.createPackageWithFile(stmt, "consistent", "consistent");
                } else {
                    DBProcedure.createPackage(stmt, "consistent", "liveCache.consistent.TEST", ExecMode);
                }
            }
            catch (TestDatabaseException e) {
                throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version for creation of package 'consistent'");
            }
            DBProcedure.create(stmt, "EMPTY_PROCEDURE", "consistent", ExecMode);
            DBProcedure.create(stmt, "SCALING_PROCEDURE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_INIT", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_CREATE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_REMOVE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_INSERT", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_UPDATE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_DELETE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_READ", "consistent", ExecMode);
            DBProcedure.create(stmt, "CREATE_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "SET_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "DROP_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "CLASS_REGISTER", "consistent", ExecMode);
            stmt.enableExceptions(false);
            stmt.execute("CALL DROP_CURRENT_SCHEMA('testteam')");
            stmt.enableExceptions(true);
            stmt.execute("CALL CREATE_CURRENT_SCHEMA('testteam')");
            stmt.execute("CALL CLASS_REGISTER");
            con.commit();
        }
        catch (Exception e) {
            Performance.addGlobalMessage((String)"DPProc registration", (char)'E', (String)("SQL Error while registering DBProcedures: " + e.getMessage()));
            throw new TestCaseException("Performance.createDBProcedures() failed");
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    private String getHostname() {
        StringBuffer ProcessOutput = new StringBuffer();
        Execute SystemProcess = null;
        ProcessOutput.setLength(0);
        String currentCmd = "uname -n";
        SystemProcess = new Execute(currentCmd, null, ProcessOutput);
        SystemProcess.exec();
        if (SystemProcess.getExitValue() == 0 && ProcessOutput.length() != 0) {
            String hostName = ProcessOutput.toString().trim().toLowerCase();
            return hostName;
        }
        ProcessOutput.setLength(0);
        currentCmd = "hostname";
        SystemProcess = new Execute(currentCmd, null, ProcessOutput);
        SystemProcess.exec();
        if (SystemProcess.getExitValue() == 0 && ProcessOutput.length() != 0) {
            String hostName = ProcessOutput.toString().trim().toLowerCase();
            return hostName;
        }
        return "unknown";
    }

    private void getResults() {
        String datum = "";
        String zeit = "";
        String host = "";
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat formatZeit = new SimpleDateFormat("HH:mm:ss");
        String sqlCommand = "";
        String desc = "";
        String svalue = "";
        String databaseHost = "pts";
        if (mTestDriverOptions.getProperty("SaveDBHost") != null) {
            databaseHost = mTestDriverOptions.getProperty("SaveDBHost");
        }
        String databaseName = "pts";
        if (mTestDriverOptions.getProperty("SaveDBName") != null) {
            databaseName = mTestDriverOptions.getProperty("SaveDBName");
        }
        String URL2 = "jdbc:sapdb://" + databaseHost + "/" + databaseName;
        Connection lConnection = null;
        TestStatement Stmt = null;
        Performance.printInfo(3, "Performance", "Results:");
        this.setStatus("Save results...");
        if ((double)this.mScaleFactor != 0.0) {
            try {
                svalue = ((TestDatabaseSap)Performance.getDatabase()).getKernelVersion();
                this.mResult.setProperty("DBRelease", svalue);
                svalue = ((TestDatabaseSap)Performance.getDatabase()).getKernelMode();
                this.mResult.setProperty("DBMode", svalue);
                svalue = ((TestDatabaseSap)Performance.getDatabase()).getKernelBuild();
                this.mResult.setProperty("DBBuild", svalue);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.mResult.setProperty("Version", sVersion);
            this.mResult.setProperty("Objects", String.valueOf(mNoOfObjects));
            this.mResult.setProperty("Samples", String.valueOf(mSamples));
            this.mResult.setProperty("IO_ACCESS", String.valueOf(this.mIOErrorTotal));
            Enumeration<?> inhalt = this.mResult.propertyNames();
            datum = formatDate.format(new Date(System.currentTimeMillis()));
            zeit = formatZeit.format(new Date(System.currentTimeMillis()));
            host = this.getHostname();
            try {
                lConnection = DriverManager.getConnection(URL2, "TESTER", "TESTER");
                Stmt = new TestStatement((TestCase)this, lConnection);
                sqlCommand = "INSERT INTO performance set datum = '" + datum + "', zeit = '" + zeit + "', hostname = '" + host + "'";
                Stmt.executeUpdate(sqlCommand);
                while (inhalt.hasMoreElements()) {
                    desc = inhalt.nextElement();
                    svalue = this.mResult.getProperty(desc.toString());
                    sqlCommand = "UPDATE OF performance set " + desc + " = '" + svalue + "' where datum = '" + datum + "' AND zeit = '" + zeit + "' AND hostname = '" + host + "'";
                    Stmt.executeUpdate(sqlCommand);
                }
            }
            catch (Exception e) {
                System.out.println("Try to execute: " + sqlCommand);
                System.out.println("WARNING: Can't save performance results in database !!! \nE: " + e);
                Performance.addGlobalMessage((String)"Performance", (char)'W', (String)("WARNING: Can't save performance results in database !!!\nException: " + e));
            }
            StringTokenizer st = new StringTokenizer(this.mResult.toString(), ",");
            int numberOfOptions = st.countTokens();
            int counterOfOptions = 0;
            String currentOpt = null;
            while (st.hasMoreTokens()) {
                currentOpt = st.nextToken().trim();
                if (++counterOfOptions == 1) {
                    Performance.printInfo(3, "Performance", currentOpt.substring(1, currentOpt.length()));
                    continue;
                }
                if (counterOfOptions == numberOfOptions) {
                    Performance.printInfo(3, "Performance", currentOpt.substring(0, currentOpt.length() - 1));
                    continue;
                }
                Performance.printInfo(3, "Performance", currentOpt);
            }
        } else {
            Performance.printInfo(3, "Performance", "no useful result, because no useful scale factor!");
        }
        Performance.printInfo(2, "\nPerformance", "Performance measurement finished!\n");
    }

    public static void prepare() throws TestCaseException {
        Performance.readAndPrintParameters();
        Performance.createDBProcedures();
    }

    private static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(pComponent + " --> " + pInfoText);
        }
        Performance.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
    }

    private static void readAndPrintParameters() throws TestCaseException {
        int defaultValue = 10;
        mScaling = Performance.getParameterInt((String)"TimeScaling", (int)defaultValue);
        mSamples = Performance.getParameterInt((String)"Samples", (int)defaultValue);
        mNoOfObjects = Performance.getParameterInt((String)"Objects", (int)100);
        mPercentageObject = Performance.getParameterInt((String)"ObjPercentage", (int)50);
        mPercentageKeyed = Performance.getParameterInt((String)"KeyedPercentage", (int)50);
        mPercentageVar = Performance.getParameterInt((String)"VarPercentage", (int)0);
        mVarMaxLength = Performance.getParameterInt((String)"VarMaxLength", (int)100);
        mPercentageSubtransaction = Performance.getParameterInt((String)"SubtransactionPercentage", (int)0);
        mPercentageSubtransCommit = Performance.getParameterInt((String)"SubtransCommitPercentage", (int)0);
        mPercentageUpdate = Performance.getParameterInt((String)"UpdatePercentage", (int)50);
        mPercentageInsert = Performance.getParameterInt((String)"InsertPercentage", (int)50);
        mPercentageDelete = Performance.getParameterInt((String)"DeletePercentage", (int)20);
        mTraceLevel = Performance.getParameterInt((String)"TraceLevel", (int)2);
        mMeasurementOfCreate = Performance.getParameterInt((String)"Create", (int)1);
        mMeasurementOfRead = Performance.getParameterInt((String)"Read", (int)1);
        mMeasurementOfInsert = Performance.getParameterInt((String)"Insert", (int)1);
        mMeasurementOfUpdate = Performance.getParameterInt((String)"Update", (int)1);
        mMeasurementOfDelete = Performance.getParameterInt((String)"Delete", (int)1);
        if (mScaling < 3) {
            mScaling = defaultValue;
        }
        if (mSamples < 3) {
            mSamples = defaultValue;
        }
        Performance.printInfo(1, "\nPerformance", "Starting Performance Test - Version: 0.42\n");
        Performance.printInfo(4, "Performance", "Parameter: TimeScaling                 = " + mScaling);
        Performance.printInfo(4, "Performance", "Parameter: Samples                     = " + mSamples);
        Performance.printInfo(4, "Performance", "Parameter: Objects                     = " + mNoOfObjects);
        Performance.printInfo(4, "Performance", "Parameter: % of object containers      = " + mPercentageObject);
        Performance.printInfo(4, "Performance", "Parameter: % of keyed containers       = " + mPercentageKeyed);
        Performance.printInfo(4, "Performance", "Parameter: % of variable containers    = " + mPercentageVar);
        Performance.printInfo(4, "Performance", "Parameter: max length of var container = " + mVarMaxLength);
        Performance.printInfo(4, "Performance", "Parameter: % of Subtransaction         = " + mPercentageSubtransaction);
        Performance.printInfo(4, "Performance", "Parameter: % of SubtransCommit         = " + mPercentageSubtransCommit);
        Performance.printInfo(4, "Performance", "Parameter: % of Update's               = " + mPercentageUpdate);
        Performance.printInfo(4, "Performance", "Parameter: % of Insert's               = " + mPercentageInsert);
        Performance.printInfo(4, "Performance", "Parameter: % of Delete's               = " + mPercentageDelete);
        Performance.printInfo(4, "Performance", "Parameter: TraceLevel                  = " + mTraceLevel);
    }

    public void run() {
        this.mResult = new Properties();
        this.calculateScaleFactor();
        if (this.mScaleFactor != 0L) {
            if (mMeasurementOfCreate == 1) {
                this.scanPerformanceOfCreation();
            }
            if (mMeasurementOfRead == 1) {
                this.scanPerformanceOfReading();
            }
            if (mMeasurementOfUpdate == 1) {
                this.scanPerformanceOfUpdating();
            }
            if (mMeasurementOfInsert == 1) {
                this.scanPerformanceOfInserting();
            }
            if (mMeasurementOfDelete == 1) {
                this.scanPerformanceOfDeleting();
            }
        }
        this.getResults();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanUp() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        try {
            try {
                con = Performance.getDatabase().connect(Performance.getDatabase().getUser(), Performance.getDatabase().getPassword());
                stmt = new TestStatement(null, con);
                if (stmt != null) {
                    stmt.execute("CALL DROP_CURRENT_SCHEMA('testteam')");
                }
            }
            catch (Exception e) {
                Performance.addGlobalMessage((String)"cleanup", (char)'E', (String)("Error during cleanup: " + e.getMessage()));
                throw new TestCaseException("Error during cleanup: " + e.getMessage());
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                stmt.close();
                con.commit();
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        stmt.close();
        con.commit();
        con.close();
        return;
    }

    private void scanPerformanceOfCreation() {
        long start = 0L;
        long diff = 0L;
        long sum = 0L;
        int i = 0;
        long emptyListTime = 0L;
        long filledListTime = 0L;
        CallableStatement stm = null;
        Oid oid = null;
        try {
            Performance.printInfo(1, "Performance", "Performance measurement of creation ... ");
            this.setStatus("Measurement of creation...");
            stm = this.mConnection.prepareCall("MONITOR INIT");
            stm.execute();
            if (this.checkIOAccess()) {
                // empty if block
            }
            long max = Long.MIN_VALUE;
            long min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            String sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 0, 0, 0, ?, ?)";
            Performance.printInfo(5, "Performance", "Creating a list with " + mNoOfObjects + " linked objects without content.");
            for (i = 1; i <= mSamples; ++i) {
                stm = this.mConnection.prepareCall(sString);
                stm.registerOutParameter(1, 4);
                stm.registerOutParameter(2, -2);
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                oid = new Oid(stm.getBytes(2));
                if (!this.checkIOAccess()) {
                    sum += diff;
                    if (min > diff) {
                        min = diff;
                    }
                    if (max < diff) {
                        max = diff;
                    }
                }
                stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
                stm.setBytes(1, oid.getOmsOid());
                stm.execute();
                this.mConnection.commit();
            }
            try {
                emptyListTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                emptyListTime = (emptyListTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (emptyListTime <= 0L) {
                    throw new ArithmeticException("Something wrong in emptyListTime. emptyListTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time for one linked element: " + emptyListTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! emptyListTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfCreation(): " + e + "\n");
                emptyListTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfCreation(): " + e);
                emptyListTime = 0L;
            }
            this.mResult.setProperty("Create1", String.valueOf(emptyListTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            filledListTime = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 100, 0, 0, 0, ?, ?)";
            Performance.printInfo(5, "Performance", "Creating a list with " + mNoOfObjects + " linked objects with normal objects.");
            for (i = 1; i <= mSamples; ++i) {
                stm = this.mConnection.prepareCall(sString);
                stm.registerOutParameter(1, 4);
                stm.registerOutParameter(2, -2);
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                oid = new Oid(stm.getBytes(2));
                if (!this.checkIOAccess()) {
                    sum += diff;
                    if (min > diff) {
                        min = diff;
                    }
                    if (max < diff) {
                        max = diff;
                    }
                }
                stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
                stm.setBytes(1, oid.getOmsOid());
                stm.execute();
                this.mConnection.commit();
            }
            try {
                filledListTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListTime = (filledListTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListTime. filledListTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time for one linked element with a normal object: " + filledListTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfCreation(): " + e + "\n");
                filledListTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfCreation(): " + e);
                filledListTime = 0L;
            }
            this.mResult.setProperty("Create2", String.valueOf(filledListTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            filledListTime = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 100, 0, 0, ?, ?)";
            Performance.printInfo(5, "Performance", "Creating a list with " + mNoOfObjects + " linked objects with keyed objects.");
            for (i = 1; i <= mSamples; ++i) {
                stm = this.mConnection.prepareCall(sString);
                stm.registerOutParameter(1, 4);
                stm.registerOutParameter(2, -2);
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                oid = new Oid(stm.getBytes(2));
                if (!this.checkIOAccess()) {
                    sum += diff;
                    if (min > diff) {
                        min = diff;
                    }
                    if (max < diff) {
                        max = diff;
                    }
                }
                stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
                stm.setBytes(1, oid.getOmsOid());
                stm.execute();
                this.mConnection.commit();
            }
            try {
                filledListTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListTime = (filledListTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListTime. filledListTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time for one linked element with a keyed object: " + filledListTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfCreation(): " + e + "\n");
                filledListTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfCreation(): " + e);
                filledListTime = 0L;
            }
            this.mResult.setProperty("Create3", String.valueOf(filledListTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            filledListTime = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 0, 100, " + mVarMaxLength + ", ?, ?)";
            Performance.printInfo(5, "Performance", "Creating a list with " + mNoOfObjects + " linked objects with variable objects.");
            for (i = 1; i <= mSamples; ++i) {
                stm = this.mConnection.prepareCall(sString);
                stm.registerOutParameter(1, 4);
                stm.registerOutParameter(2, -2);
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                oid = new Oid(stm.getBytes(2));
                if (!this.checkIOAccess()) {
                    sum += diff;
                    if (min > diff) {
                        min = diff;
                    }
                    if (max < diff) {
                        max = diff;
                    }
                }
                stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
                stm.setBytes(1, oid.getOmsOid());
                stm.execute();
                this.mConnection.commit();
            }
            try {
                filledListTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListTime = (filledListTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListTime. filledListTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time for one linked element with a variable object: " + filledListTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfCreation(): " + e + "\n");
                filledListTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfCreation(): " + e);
                filledListTime = 0L;
            }
            this.mResult.setProperty("Create4", String.valueOf(filledListTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            filledListTime = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( " + mPercentageSubtransaction + ", " + mPercentageSubtransCommit + ", " + mNoOfObjects + ", " + mPercentageObject + ", " + mPercentageKeyed + ", " + mPercentageVar + ", " + mVarMaxLength + ", ?, ?)";
            Performance.printInfo(5, "Performance", "Creating a list with " + mNoOfObjects + " linked objects with objects with parameter from parameterfile.");
            for (i = 1; i <= mSamples; ++i) {
                stm = this.mConnection.prepareCall(sString);
                stm.registerOutParameter(1, 4);
                stm.registerOutParameter(2, -2);
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                oid = new Oid(stm.getBytes(2));
                if (!this.checkIOAccess()) {
                    sum += diff;
                    if (min > diff) {
                        min = diff;
                    }
                    if (max < diff) {
                        max = diff;
                    }
                }
                stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
                stm.setBytes(1, oid.getOmsOid());
                stm.execute();
                this.mConnection.commit();
            }
            try {
                filledListTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListTime = (filledListTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListTime. filledListTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time for one linked element with a random object: " + filledListTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfCreation(): " + e + "\n");
                filledListTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfCreation(): " + e);
                filledListTime = 0L;
            }
            this.mResult.setProperty("Create5", String.valueOf(filledListTime));
        }
        catch (Exception e) {
            System.out.println("\nPerformance - Exception in scanPerformanceOfCreation(): " + e + "\n");
            Performance.addGlobalMessage((String)"Performance", (char)'E', (String)e.getMessage());
        }
    }

    private void scanPerformanceOfDeleting() {
        long start = 0L;
        long diff = 0L;
        long sum = 0L;
        int i = 0;
        long emptyListDeleteTime = 0L;
        long filledListDeleteTime = 0L;
        CallableStatement stm = null;
        Oid oid = null;
        try {
            String sString;
            Performance.printInfo(1, "Performance", "Performance measurement of deleting ... ");
            this.setStatus("Measurement of deleting...");
            stm = this.mConnection.prepareCall("MONITOR INIT");
            stm.execute();
            long max = Long.MIN_VALUE;
            long min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            Performance.printInfo(5, "Performance", "Deleting to 100 % a list with " + mNoOfObjects + " linked objects without content.");
            for (i = 1; i <= mSamples; ++i) {
                sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 0, 0, 0, ?, ?)";
                stm = this.mConnection.prepareCall(sString);
                stm.registerOutParameter(1, 4);
                stm.registerOutParameter(2, -2);
                stm.execute();
                oid = new Oid(stm.getBytes(2));
                sString = "CALL LIST_DELETE( ?, 100, ?, ? )";
                stm = this.mConnection.prepareCall(sString);
                stm.setBytes(1, oid.getOmsOid());
                stm.registerOutParameter(2, 4);
                stm.registerOutParameter(3, 4);
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (!this.checkIOAccess()) {
                    sum += diff;
                    if (min > diff) {
                        min = diff;
                    }
                    if (max < diff) {
                        max = diff;
                    }
                }
                stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
                stm.setBytes(1, oid.getOmsOid());
                stm.execute();
                this.mConnection.commit();
            }
            try {
                emptyListDeleteTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                emptyListDeleteTime = (emptyListDeleteTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (emptyListDeleteTime <= 0L) {
                    throw new ArithmeticException("Something wrong in emptyListDeleteTime. emptyListDeleteTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to delete a linked element: " + emptyListDeleteTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! emptyListDeleteTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfDeleting(): " + e + "\n");
                emptyListDeleteTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfDeleting(): " + e);
                emptyListDeleteTime = 0L;
            }
            this.mResult.setProperty("Delete1", String.valueOf(emptyListDeleteTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            Performance.printInfo(5, "Performance", "Deleting to 100 % a list with " + mNoOfObjects + " linked objects with normal objects.");
            for (i = 1; i <= mSamples; ++i) {
                sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 100, 0, 0, 0, ?, ?)";
                stm = this.mConnection.prepareCall(sString);
                stm.registerOutParameter(1, 4);
                stm.registerOutParameter(2, -2);
                stm.execute();
                oid = new Oid(stm.getBytes(2));
                sString = "CALL LIST_DELETE( ?, 100, ?, ? )";
                stm = this.mConnection.prepareCall(sString);
                stm.setBytes(1, oid.getOmsOid());
                stm.registerOutParameter(2, 4);
                stm.registerOutParameter(3, 4);
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (!this.checkIOAccess()) {
                    sum += diff;
                    if (min > diff) {
                        min = diff;
                    }
                    if (max < diff) {
                        max = diff;
                    }
                }
                stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
                stm.setBytes(1, oid.getOmsOid());
                stm.execute();
                this.mConnection.commit();
            }
            try {
                filledListDeleteTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListDeleteTime = (filledListDeleteTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListDeleteTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListDeleteTime. filledListDeleteTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to delete a linked element: " + filledListDeleteTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListDeleteTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfDeleting(): " + e + "\n");
                filledListDeleteTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfDeleting(): " + e);
                filledListDeleteTime = 0L;
            }
            this.mResult.setProperty("Delete2", String.valueOf(filledListDeleteTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            Performance.printInfo(5, "Performance", "Deleting to 100 % a list with " + mNoOfObjects + " linked objects with keyed objects.");
            for (i = 1; i <= mSamples; ++i) {
                sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 100, 0, 0, ?, ?)";
                stm = this.mConnection.prepareCall(sString);
                stm.registerOutParameter(1, 4);
                stm.registerOutParameter(2, -2);
                stm.execute();
                oid = new Oid(stm.getBytes(2));
                sString = "CALL LIST_DELETE( ?, 100, ?, ? )";
                stm = this.mConnection.prepareCall(sString);
                stm.setBytes(1, oid.getOmsOid());
                stm.registerOutParameter(2, 4);
                stm.registerOutParameter(3, 4);
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (!this.checkIOAccess()) {
                    sum += diff;
                    if (min > diff) {
                        min = diff;
                    }
                    if (max < diff) {
                        max = diff;
                    }
                }
                stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
                stm.setBytes(1, oid.getOmsOid());
                stm.execute();
                this.mConnection.commit();
            }
            try {
                filledListDeleteTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListDeleteTime = (filledListDeleteTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListDeleteTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListDeleteTime. filledListDeleteTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to delete a linked element: " + filledListDeleteTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListDeleteTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfDeleting(): " + e + "\n");
                filledListDeleteTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfDeleting(): " + e);
                filledListDeleteTime = 0L;
            }
            this.mResult.setProperty("Delete3", String.valueOf(filledListDeleteTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            Performance.printInfo(5, "Performance", "Deleting to 100 % a list with " + mNoOfObjects + " linked objects with variable objects.");
            for (i = 1; i <= mSamples; ++i) {
                sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 0, 100, " + mVarMaxLength + ", ?, ?)";
                stm = this.mConnection.prepareCall(sString);
                stm.registerOutParameter(1, 4);
                stm.registerOutParameter(2, -2);
                stm.execute();
                oid = new Oid(stm.getBytes(2));
                sString = "CALL LIST_DELETE( ?, 100, ?, ? )";
                stm = this.mConnection.prepareCall(sString);
                stm.setBytes(1, oid.getOmsOid());
                stm.registerOutParameter(2, 4);
                stm.registerOutParameter(3, 4);
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (!this.checkIOAccess()) {
                    sum += diff;
                    if (min > diff) {
                        min = diff;
                    }
                    if (max < diff) {
                        max = diff;
                    }
                }
                stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
                stm.setBytes(1, oid.getOmsOid());
                stm.execute();
                this.mConnection.commit();
            }
            try {
                filledListDeleteTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListDeleteTime = (filledListDeleteTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListDeleteTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListDeleteTime. filledListDeleteTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to delete a linked element: " + filledListDeleteTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListDeleteTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfDeleting(): " + e + "\n");
                filledListDeleteTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfDeleting(): " + e);
                filledListDeleteTime = 0L;
            }
            this.mResult.setProperty("Delete4", String.valueOf(filledListDeleteTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            Performance.printInfo(5, "Performance", "Deleting to " + mPercentageDelete + " % a list with " + mNoOfObjects + " linked objects with content from parameter file.");
            for (i = 1; i <= mSamples; ++i) {
                sString = "CALL LIST_CREATE( " + mPercentageSubtransaction + ", " + mPercentageSubtransCommit + ", " + mNoOfObjects + ", " + mPercentageObject + ", " + mPercentageKeyed + ", " + mPercentageVar + ", " + mVarMaxLength + ", ?, ?)";
                stm = this.mConnection.prepareCall(sString);
                stm.registerOutParameter(1, 4);
                stm.registerOutParameter(2, -2);
                stm.execute();
                oid = new Oid(stm.getBytes(2));
                sString = "CALL LIST_DELETE( ?, " + mPercentageDelete + " , ?, ? )";
                stm = this.mConnection.prepareCall(sString);
                stm.setBytes(1, oid.getOmsOid());
                stm.registerOutParameter(2, 4);
                stm.registerOutParameter(3, 4);
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (!this.checkIOAccess()) {
                    sum += diff;
                    if (min > diff) {
                        min = diff;
                    }
                    if (max < diff) {
                        max = diff;
                    }
                }
                stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
                stm.setBytes(1, oid.getOmsOid());
                stm.execute();
                this.mConnection.commit();
            }
            try {
                filledListDeleteTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListDeleteTime = (filledListDeleteTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListDeleteTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListDeleteTime. filledListDeleteTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to delete a linked element: " + filledListDeleteTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListDeleteTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfDeleting(): " + e + "\n");
                filledListDeleteTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfDeleting(): " + e);
                filledListDeleteTime = 0L;
            }
            this.mResult.setProperty("Delete5", String.valueOf(filledListDeleteTime));
        }
        catch (Exception e) {
            System.out.println("\nPerformance - Exception in scanPerformanceOfDeleting(): " + e + "\n");
            Performance.addGlobalMessage((String)"Performance", (char)'E', (String)e.getMessage());
        }
    }

    private void scanPerformanceOfInserting() {
        long start = 0L;
        long diff = 0L;
        long sum = 0L;
        int i = 0;
        long emptyListInsertTime = 0L;
        long filledListInsertTime = 0L;
        CallableStatement stm = null;
        Oid oid = null;
        try {
            Performance.printInfo(1, "Performance", "Performance measurement of inserting ... ");
            this.setStatus("Measurement of inserting...");
            stm = this.mConnection.prepareCall("MONITOR INIT");
            stm.execute();
            long max = Long.MIN_VALUE;
            long min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            String sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 0, 0, 0, ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_INSERT( ?, 100, ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, -2);
            Performance.printInfo(5, "Performance", "Inserting to 100 % to a list with " + mNoOfObjects + " linked objects without content.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                emptyListInsertTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                emptyListInsertTime = (emptyListInsertTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (emptyListInsertTime <= 0L) {
                    throw new ArithmeticException("Something wrong in emptyListInsertTime. emptyListInsertTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to insert a linked element: " + emptyListInsertTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! emptyListInsertTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfInserting(): " + e + "\n");
                emptyListInsertTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfInserting(): " + e);
                emptyListInsertTime = 0L;
            }
            this.mResult.setProperty("Insert1", String.valueOf(emptyListInsertTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 100, 0, 0, 0, ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_INSERT( ?, 100, ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, -2);
            Performance.printInfo(5, "Performance", "Inserting to 100 % to a list with " + mNoOfObjects + " linked objects with normal objects.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                filledListInsertTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListInsertTime = (filledListInsertTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListInsertTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListInsertTime. filledListInsertTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to insert a linked element: " + filledListInsertTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListInsertTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfInserting(): " + e + "\n");
                filledListInsertTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfInserting(): " + e);
                filledListInsertTime = 0L;
            }
            this.mResult.setProperty("Insert2", String.valueOf(filledListInsertTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 100, 0, 0, ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_INSERT( ?, 100, ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, -2);
            Performance.printInfo(5, "Performance", "Inserting to 100 % to a list with " + mNoOfObjects + " linked objects with keyed objects.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                filledListInsertTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListInsertTime = (filledListInsertTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListInsertTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListInsertTime. filledListInsertTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to insert a linked element: " + filledListInsertTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListInsertTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfInserting(): " + e + "\n");
                filledListInsertTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfInserting(): " + e);
                filledListInsertTime = 0L;
            }
            this.mResult.setProperty("Insert3", String.valueOf(filledListInsertTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 0, 100, " + mVarMaxLength + ", ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_INSERT( ?, 100, ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, -2);
            Performance.printInfo(5, "Performance", "Inserting to 100 % to a list with " + mNoOfObjects + " linked objects with variable objects.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                filledListInsertTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListInsertTime = (filledListInsertTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListInsertTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListInsertTime. filledListInsertTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to insert a linked element: " + filledListInsertTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListInsertTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfInserting(): " + e + "\n");
                filledListInsertTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfInserting(): " + e);
                filledListInsertTime = 0L;
            }
            this.mResult.setProperty("Insert4", String.valueOf(filledListInsertTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( " + mPercentageSubtransaction + ", " + mPercentageSubtransCommit + ", " + mNoOfObjects + ", " + mPercentageObject + ", " + mPercentageKeyed + ", " + mPercentageVar + ", " + mVarMaxLength + ", ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_INSERT( ?, " + mPercentageInsert + " , ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, -2);
            Performance.printInfo(5, "Performance", "Inserting to " + mPercentageInsert + " % to a list with " + mNoOfObjects + " linked objects with content from parameter file.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                filledListInsertTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListInsertTime = (filledListInsertTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListInsertTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListInsertTime. filledListInsertTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to insert a linked element: " + filledListInsertTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListInsertTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfInserting(): " + e + "\n");
                filledListInsertTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfInserting(): " + e);
                filledListInsertTime = 0L;
            }
            this.mResult.setProperty("Insert5", String.valueOf(filledListInsertTime));
        }
        catch (Exception e) {
            System.out.println("\nPerformance - Exception in scanPerformanceOfInserting(): " + e + "\n");
            Performance.addGlobalMessage((String)"Performance", (char)'E', (String)e.getMessage());
        }
    }

    private void scanPerformanceOfReading() {
        long start = 0L;
        long diff = 0L;
        long sum = 0L;
        int i = 0;
        long emptyListReadTime = 0L;
        long filledListReadTime = 0L;
        CallableStatement stm = null;
        Oid oid = null;
        try {
            Performance.printInfo(1, "Performance", "Performance measurement of reading ... ");
            this.setStatus("Measurement of reading...");
            stm = this.mConnection.prepareCall("MONITOR INIT");
            stm.execute();
            long max = Long.MIN_VALUE;
            long min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            String sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 0, 0, 0, ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_READ( ?, ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, 4);
            Performance.printInfo(5, "Performance", "Reading a list with " + mNoOfObjects + " linked objects without content.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                emptyListReadTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                emptyListReadTime = (emptyListReadTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (emptyListReadTime <= 0L) {
                    throw new ArithmeticException("Something wrong in emptyListReadTime. emptyListReadTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to read a linked element: " + emptyListReadTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! emptyListReadTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfReading(): " + e + "\n");
                emptyListReadTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfReading(): " + e);
                emptyListReadTime = 0L;
            }
            this.mResult.setProperty("Read1", String.valueOf(emptyListReadTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 100, 0, 0, 0, ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_READ( ?, ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, 4);
            Performance.printInfo(5, "Performance", "Reading a list with " + mNoOfObjects + " linked objects with normal objects.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                filledListReadTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListReadTime = (filledListReadTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListReadTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListReadTime. filledListReadTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to read a linked element: " + filledListReadTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListReadTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfReading(): " + e + "\n");
                filledListReadTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfReading(): " + e);
                filledListReadTime = 0L;
            }
            this.mResult.setProperty("Read2", String.valueOf(filledListReadTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 100, 0, 0, ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_READ( ?, ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, 4);
            Performance.printInfo(5, "Performance", "Reading a list with " + mNoOfObjects + " linked objects with keyed objects.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                filledListReadTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListReadTime = (filledListReadTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListReadTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListReadTime. filledListReadTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to read a linked element: " + filledListReadTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListReadTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfReading(): " + e + "\n");
                filledListReadTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfReading(): " + e);
                filledListReadTime = 0L;
            }
            this.mResult.setProperty("Read3", String.valueOf(filledListReadTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 0, 100, " + mVarMaxLength + ", ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_READ( ?, ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, 4);
            Performance.printInfo(5, "Performance", "Reading a list with " + mNoOfObjects + " linked objects with variable objects.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                filledListReadTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListReadTime = (filledListReadTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListReadTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListReadTime. filledListReadTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to read a linked element: " + filledListReadTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListReadTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfReading(): " + e + "\n");
                filledListReadTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfReading(): " + e);
                filledListReadTime = 0L;
            }
            this.mResult.setProperty("Read4", String.valueOf(filledListReadTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( " + mPercentageSubtransaction + ", " + mPercentageSubtransCommit + ", " + mNoOfObjects + ", " + mPercentageObject + ", " + mPercentageKeyed + ", " + mPercentageVar + ", " + mVarMaxLength + ", ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_READ( ?, ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, 4);
            Performance.printInfo(5, "Performance", "Reading a list with " + mNoOfObjects + " linked objects with content from parameter file.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                filledListReadTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListReadTime = (filledListReadTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListReadTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListReadTime. filledListReadTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to read a linked element: " + filledListReadTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListReadTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfReading(): " + e + "\n");
                filledListReadTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfReading(): " + e);
                filledListReadTime = 0L;
            }
            this.mResult.setProperty("Read5", String.valueOf(filledListReadTime));
        }
        catch (Exception e) {
            System.out.println("\nPerformance - Exception in scanPerformanceOfReading(): " + e + "\n");
            Performance.addGlobalMessage((String)"Performance", (char)'E', (String)e.getMessage());
        }
    }

    private void scanPerformanceOfUpdating() {
        long start = 0L;
        long diff = 0L;
        long sum = 0L;
        int i = 0;
        long emptyListUpdateTime = 0L;
        long filledListUpdateTime = 0L;
        CallableStatement stm = null;
        Oid oid = null;
        try {
            Performance.printInfo(1, "Performance", "Performance measurement of updating ... ");
            this.setStatus("Measurement of updating...");
            stm = this.mConnection.prepareCall("MONITOR INIT");
            stm.execute();
            long max = Long.MIN_VALUE;
            long min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            String sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 0, 0, 0, ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_UPDATE( ?, 100, ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, -2);
            Performance.printInfo(5, "Performance", "Updating to 100 % a list with " + mNoOfObjects + " linked objects without content.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                emptyListUpdateTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                emptyListUpdateTime = (emptyListUpdateTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (emptyListUpdateTime <= 0L) {
                    throw new ArithmeticException("Something wrong in emptyListUpdateTime. emptyListUpdateTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to update a linked element: " + emptyListUpdateTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! emptyListUpdateTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfUpdating(): " + e + "\n");
                emptyListUpdateTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfUpdating(): " + e);
                emptyListUpdateTime = 0L;
            }
            this.mResult.setProperty("Update1", String.valueOf(emptyListUpdateTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 100, 0, 0, 0, ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_UPDATE( ?, 100, ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, -2);
            Performance.printInfo(5, "Performance", "Updating to 100 % a list with " + mNoOfObjects + " linked objects with normal objects.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                filledListUpdateTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListUpdateTime = (filledListUpdateTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListUpdateTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListUpdateTime. filledListUpdateTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to update a linked element: " + filledListUpdateTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListUpdateTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfUpdating(): " + e + "\n");
                filledListUpdateTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfUpdating(): " + e);
                filledListUpdateTime = 0L;
            }
            this.mResult.setProperty("Update2", String.valueOf(filledListUpdateTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 100, 0, 0, ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_UPDATE( ?, 100, ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, -2);
            Performance.printInfo(5, "Performance", "Updating to 100 % a list with " + mNoOfObjects + " linked objects with keyed objects.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                filledListUpdateTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListUpdateTime = (filledListUpdateTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListUpdateTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListUpdateTime. filledListUpdateTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to update a linked element: " + filledListUpdateTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListUpdateTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfUpdating(): " + e + "\n");
                filledListUpdateTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfUpdating(): " + e);
                filledListUpdateTime = 0L;
            }
            this.mResult.setProperty("Update3", String.valueOf(filledListUpdateTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 0, 100, " + mVarMaxLength + ", ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_UPDATE( ?, 100, ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, -2);
            Performance.printInfo(5, "Performance", "Updating to 100 % a list with " + mNoOfObjects + " linked objects with variable objects.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                filledListUpdateTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListUpdateTime = (filledListUpdateTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListUpdateTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListUpdateTime. filledListUpdateTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to update a linked element: " + filledListUpdateTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListUpdateTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfUpdating(): " + e + "\n");
                filledListUpdateTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfUpdating(): " + e);
                filledListUpdateTime = 0L;
            }
            this.mResult.setProperty("Update4", String.valueOf(filledListUpdateTime));
            max = Long.MIN_VALUE;
            min = Long.MAX_VALUE;
            sum = 0L;
            this.mIOError = 0;
            sString = "CALL LIST_CREATE( " + mPercentageSubtransaction + ", " + mPercentageSubtransCommit + ", " + mNoOfObjects + ", " + mPercentageObject + ", " + mPercentageKeyed + ", " + mPercentageVar + ", " + mVarMaxLength + ", ?, ?)";
            stm = this.mConnection.prepareCall(sString);
            stm.registerOutParameter(1, 4);
            stm.registerOutParameter(2, -2);
            stm.execute();
            oid = new Oid(stm.getBytes(2));
            sString = "CALL LIST_UPDATE( ?, " + mPercentageUpdate + " , ?, ? )";
            stm = this.mConnection.prepareCall(sString);
            stm.setBytes(1, oid.getOmsOid());
            stm.registerOutParameter(2, 4);
            stm.registerOutParameter(3, -2);
            Performance.printInfo(5, "Performance", "Updating to " + mPercentageUpdate + " % a list with " + mNoOfObjects + " linked objects with content from parameter file.");
            for (i = 1; i <= mSamples; ++i) {
                start = System.currentTimeMillis();
                stm.execute();
                diff = System.currentTimeMillis() - start;
                if (this.checkIOAccess()) continue;
                sum += diff;
                if (min > diff) {
                    min = diff;
                }
                if (max >= diff) continue;
                max = diff;
            }
            stm = this.mConnection.prepareCall("CALL LIST_REMOVE(?)");
            stm.setBytes(1, oid.getOmsOid());
            stm.execute();
            this.mConnection.commit();
            try {
                filledListUpdateTime = (sum - max - min) / (long)(mSamples - 2 - this.mIOError);
                filledListUpdateTime = (filledListUpdateTime * 1000L - this.mOverheadTime) / (long)mNoOfObjects;
                if (filledListUpdateTime <= 0L) {
                    throw new ArithmeticException("Something wrong in filledListUpdateTime. filledListUpdateTime = 0!");
                }
                Performance.printInfo(4, "Performance", "Time to update a linked element: " + filledListUpdateTime + " \u00b5s\n");
            }
            catch (ArithmeticException e) {
                Performance.printInfo(4, "Performance", "Too many io-access during work on livecache! No useful average time! filledListUpdateTime = 0!");
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfUpdating(): " + e + "\n");
                filledListUpdateTime = 0L;
            }
            catch (Exception e) {
                Performance.printInfo(4, "Performance", "Exception in scanPerformanceOfUpdating(): " + e);
                filledListUpdateTime = 0L;
            }
            this.mResult.setProperty("Update5", String.valueOf(filledListUpdateTime));
        }
        catch (Exception e) {
            System.out.println("\nPerformance - Exception in scanPerformanceOfUpdating(): " + e + "\n");
            Performance.addGlobalMessage((String)"Performance", (char)'E', (String)e.getMessage());
        }
    }
}

