/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.lctest.DBProcedure;
import com.sap.sapdb.lctest.LiveCacheConstants;
import com.sap.sapdb.lctest.Oid;
import com.sap.sapdb.testframe.driver.TestDatabase;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.utilities.DirectoryCleaner;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Random;

public class LCRecoverTest2
extends TestCase
implements LiveCacheConstants {
    private static final String sVersion = "1.5";
    private Connection mConnection = null;
    private TestStatement mStatement = null;
    private static int mNoOfObjects = 0;
    private static int mTraceLevel;
    private static int mWorkOnDatabase;
    private static int mUpdateProbability;
    private DBM mDBMan = null;
    private static DirectoryCleaner mDirectoryCleaner;
    private String sString = null;
    private CallableStatement stm = null;
    private Oid oid1 = null;
    private int checkSum1Backup = 0;
    private int checkSum1 = 0;
    private int objCount1 = 0;
    private Oid oid2 = null;
    private int checkSum2Backup = 0;
    private int checkSum2 = 0;
    private int objCount2 = 0;
    private Oid oid3 = null;
    private int checkSum3Backup = 0;
    private int checkSum3 = 0;
    private int objCount3 = 0;
    private int i = 0;
    private int containerNumber = 4;
    private int checkSum4Backup = 0;
    private int checkSum4 = 0;
    private int objCount4 = 0;
    private int dummySum = 0;
    private int dummyCount = 0;
    private Random r = new Random();
    private int rand = 0;

    public static String getTestClassId() {
        return "LCRecoverTest2";
    }

    public static String getMinimumRelease() {
        return "7.4.1.*";
    }

    public static long getTimeout() {
        return 14400000L;
    }

    protected static void createDBProcedures() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        int ExecMode = 1;
        try {
            con = LCRecoverTest2.getDatabase().connect(LCRecoverTest2.getDatabase().getUser(), LCRecoverTest2.getDatabase().getPassword());
            stmt = new TestStatement(null, con);
            try {
                if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.4.4")) {
                    DBProcedure.createPackageWithFile(stmt, "consistent", "consistent");
                } else {
                    DBProcedure.createPackage(stmt, "consistent", "liveCache.consistent.TEST", ExecMode);
                }
            }
            catch (TestDatabaseException e) {
                throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version for creation of package 'consistent'");
            }
            DBProcedure.create(stmt, "EMPTY_PROCEDURE", "consistent", ExecMode);
            DBProcedure.create(stmt, "SCALING_PROCEDURE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_INIT", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_CREATE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_REMOVE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_INSERT", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_UPDATE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_DELETE", "consistent", ExecMode);
            DBProcedure.create(stmt, "LIST_READ", "consistent", ExecMode);
            DBProcedure.create(stmt, "CREATE_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "SET_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "DROP_CURRENT_SCHEMA", "consistent", ExecMode);
            DBProcedure.create(stmt, "CLASS_REGISTER", "consistent", ExecMode);
            DBProcedure.create(stmt, "CREATE_KEYED_OBJECT", "consistent", ExecMode);
            DBProcedure.create(stmt, "CREATE_KEYED_CONTAINER", "consistent", ExecMode);
            DBProcedure.create(stmt, "SUM_ALL_KEYED_OBJECTS", "consistent", ExecMode);
            DBProcedure.create(stmt, "UPD_KEYED_OBJECT", "consistent", ExecMode);
            stmt.enableExceptions(false);
            stmt.execute("CALL DROP_CURRENT_SCHEMA('testteam')");
            stmt.enableExceptions(true);
            stmt.execute("CALL CREATE_CURRENT_SCHEMA('testteam')");
            stmt.execute("CALL CLASS_REGISTER");
            con.commit();
        }
        catch (Exception e) {
            LCRecoverTest2.addGlobalMessage((String)"DPProc registration", (char)'E', (String)("SQL Error while registering DBProcedures: " + e.getMessage()));
            throw new TestCaseException("Performance.createDBProcedures() failed");
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    public static void prepare() throws TestCaseException {
        LCRecoverTest2.readAndPrintParameters();
        LCRecoverTest2.createDBProcedures();
        try {
            TestDatabase db = LCRecoverTest2.getDatabase();
            if (db.isSap()) {
                mDirectoryCleaner = new DirectoryCleaner(new File(((TestDatabaseSap)db).getRunDir()), "autosave.*", 60000);
            }
        }
        catch (Exception ex) {
            LCRecoverTest2.addGlobalMessage((String)"DirectoryCleaner", (char)'W', (String)("Can't start DirectoryCleaner: <" + ex.getMessage() + ">"));
        }
        mDirectoryCleaner.start();
    }

    private static void printInfo(int Level2, String pComponent, String pInfoText) {
        if (Level2 <= mTraceLevel) {
            System.out.println(pComponent + " --> " + pInfoText);
        }
        if (Level2 < 7) {
            LCRecoverTest2.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        } else if (mTraceLevel >= 9) {
            LCRecoverTest2.addGlobalMessage((String)pComponent, (char)'I', (String)pInfoText);
        }
    }

    protected static void readAndPrintParameters() throws TestCaseException {
        mNoOfObjects = LCRecoverTest2.getParameterInt((String)"Objects", (int)5000);
        mTraceLevel = LCRecoverTest2.getParameterInt((String)"TraceLevel", (int)2);
        mWorkOnDatabase = LCRecoverTest2.getParameterInt((String)"WorkOnDatabase", (int)400);
        mUpdateProbability = LCRecoverTest2.getParameterInt((String)"UpdateProbability", (int)5);
        LCRecoverTest2.printInfo(1, "\nLCRecoverTest2", "Starting LCRecoverTest2 Test - Version: 1.5\n");
        LCRecoverTest2.printInfo(2, "LCRecoverTest2", "Parameter: Objects           = " + mNoOfObjects);
        LCRecoverTest2.printInfo(2, "LCRecoverTest2", "Parameter: TraceLevel        = " + mTraceLevel);
        LCRecoverTest2.printInfo(2, "LCRecoverTest2", "Parameter: WorkonDatabase    = " + mWorkOnDatabase + " cycles");
        LCRecoverTest2.printInfo(2, "LCRecoverTest2", "Parameter: UpdateProbability = " + mUpdateProbability + " %");
    }

    private void startUp() throws TestCaseException, SQLException, TestDatabaseException {
        this.addMessage(LCRecoverTest2.getTestClassId(), 'I', "At least 10.000 pages of datadev are required.");
        this.mConnection = LCRecoverTest2.getDatabase().connect(LCRecoverTest2.getUser(), LCRecoverTest2.getPassword());
        this.mStatement = new TestStatement((TestCase)this, this.mConnection);
        LCRecoverTest2.printInfo(7, "LCRecoverTest2", "CALL SET_CURRENT_SCHEMA('testteam')");
        this.mStatement.execute("CALL SET_CURRENT_SCHEMA('testteam')");
        LCRecoverTest2.printInfo(7, "LCRecoverTest2", "CALL CLASS_REGISTER");
        this.mStatement.execute("CALL CLASS_REGISTER");
        this.mConnection.commit();
        LCRecoverTest2.printInfo(7, "LCRecoverTest2", "CALL LIST_INIT");
        this.stm = this.mConnection.prepareCall("CALL LIST_INIT");
        this.stm.execute();
        this.mConnection.commit();
    }

    private void createObjects() throws TestCaseException, SQLException {
        this.sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 100, 0, 0, 0, ?, ?)";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.registerOutParameter(1, 4);
        this.stm.registerOutParameter(2, -2);
        this.stm.execute();
        this.oid1 = new Oid(this.stm.getBytes(2));
        this.checkSum1 = this.stm.getInt(1);
        this.checkSum1Backup = this.stm.getInt(1);
        this.objCount1 = mNoOfObjects;
        LCRecoverTest2.printInfo(4, "LCRecoverTest2", "Oid1 = " + this.oid1.getPagePos() + ":" + this.oid1.getPno() + ":" + this.oid1.getClassId());
        LCRecoverTest2.printInfo(4, "LCRecoverTest2", "CheckSum1 = " + this.checkSum1);
        this.mConnection.commit();
        this.sString = "CALL LIST_READ( ?, ?, ? )";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.setBytes(1, this.oid1.getOmsOid());
        this.stm.registerOutParameter(2, 4);
        this.stm.registerOutParameter(3, 4);
        this.stm.execute();
        this.dummySum = this.stm.getInt(2);
        this.dummyCount = this.stm.getInt(3);
        if (this.dummySum != this.checkSum1 || this.dummyCount != this.objCount1) {
            this.addMessage(LCRecoverTest2.getTestClassId(), 'E', "For OID: " + this.oid1.getPagePos() + ":" + this.oid1.getPno() + ":" + this.oid1.getClassId() + "\nexpecting CheckSum = " + this.checkSum1 + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount1 + " <-> returned = " + this.dummyCount);
            throw new TestCaseException("Wrong values! See above.");
        }
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "Oid1 = " + this.oid1.getPagePos() + ":" + this.oid1.getPno() + ":" + this.oid1.getClassId());
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "CheckSum1 = " + this.checkSum1);
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "ObjCount1 = " + this.objCount1);
        this.mConnection.commit();
        this.sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 100, 0, 0, ?, ?)";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.registerOutParameter(1, 4);
        this.stm.registerOutParameter(2, -2);
        this.stm.execute();
        this.oid2 = new Oid(this.stm.getBytes(2));
        this.checkSum2 = this.stm.getInt(1);
        this.checkSum2Backup = this.stm.getInt(1);
        this.objCount2 = mNoOfObjects;
        LCRecoverTest2.printInfo(4, "LCRecoverTest2", "Oid2 = " + this.oid2.getPagePos() + ":" + this.oid2.getPno() + ":" + this.oid2.getClassId());
        LCRecoverTest2.printInfo(4, "LCRecoverTest2", "CheckSum1 = " + this.checkSum2);
        this.mConnection.commit();
        this.sString = "CALL LIST_READ( ?, ?, ? )";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.setBytes(1, this.oid2.getOmsOid());
        this.stm.registerOutParameter(2, 4);
        this.stm.registerOutParameter(3, 4);
        this.stm.execute();
        this.dummySum = this.stm.getInt(2);
        this.dummyCount = this.stm.getInt(3);
        if (this.dummySum != this.checkSum2 || this.dummyCount != this.objCount2) {
            this.addMessage(LCRecoverTest2.getTestClassId(), 'E', "For OID: " + this.oid2.getPagePos() + ":" + this.oid2.getPno() + ":" + this.oid2.getClassId() + "\nexpecting CheckSum = " + this.checkSum2 + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount2 + " <-> returned = " + this.dummyCount);
            throw new TestCaseException("Wrong values! See above.");
        }
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "Oid2 = " + this.oid2.getPagePos() + ":" + this.oid2.getPno() + ":" + this.oid2.getClassId());
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "CheckSum2 = " + this.checkSum2);
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "ObjCount2 = " + this.objCount2);
        this.mConnection.commit();
        this.sString = "CALL LIST_CREATE( 0, 0, " + mNoOfObjects + ", 0, 0, 100, 5000, ?, ?)";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.registerOutParameter(1, 4);
        this.stm.registerOutParameter(2, -2);
        this.stm.execute();
        this.oid3 = new Oid(this.stm.getBytes(2));
        this.checkSum3 = this.stm.getInt(1);
        this.checkSum3Backup = this.stm.getInt(1);
        this.objCount3 = mNoOfObjects;
        LCRecoverTest2.printInfo(4, "LCRecoverTest2", "Oid3 = " + this.oid3.getPagePos() + ":" + this.oid3.getPno() + ":" + this.oid3.getClassId());
        LCRecoverTest2.printInfo(4, "LCRecoverTest2", "CheckSum3 = " + this.checkSum3);
        this.mConnection.commit();
        this.sString = "CALL LIST_READ( ?, ?, ? )";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.setBytes(1, this.oid3.getOmsOid());
        this.stm.registerOutParameter(2, 4);
        this.stm.registerOutParameter(3, 4);
        this.stm.execute();
        this.dummySum = this.stm.getInt(2);
        this.dummyCount = this.stm.getInt(3);
        if (this.dummySum != this.checkSum3 || this.dummyCount != this.objCount3) {
            this.addMessage(LCRecoverTest2.getTestClassId(), 'E', "For OID: " + this.oid3.getPagePos() + ":" + this.oid3.getPno() + ":" + this.oid3.getClassId() + "\nexpecting CheckSum = " + this.checkSum3 + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount3 + " <-> returned = " + this.dummyCount);
            throw new TestCaseException("Wrong values! See above.");
        }
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "Oid3 = " + this.oid3.getPagePos() + ":" + this.oid3.getPno() + ":" + this.oid3.getClassId());
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "CheckSum3 = " + this.checkSum3);
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "ObjCount3 = " + this.objCount3);
        this.mConnection.commit();
        this.sString = "CALL CREATE_KEYED_CONTAINER ('testteam', " + this.containerNumber + ")";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.execute();
        this.mConnection.commit();
        while (this.i < mNoOfObjects) {
            this.sString = "CALL CREATE_KEYED_OBJECT (" + (this.i + 1) + ", " + (this.i + 1) + ", '" + "testteam" + "', " + this.containerNumber + ")";
            LCRecoverTest2.printInfo(9, "LCRecoverTest2", this.sString);
            this.stm = this.mConnection.prepareCall(this.sString);
            this.stm.execute();
            ++this.i;
        }
        this.mConnection.commit();
        this.sString = "CALL SUM_ALL_KEYED_OBJECTS ( 'testteam', " + this.containerNumber + ", ?, ?)";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.registerOutParameter(1, 4);
        this.stm.registerOutParameter(2, 4);
        this.stm.execute();
        this.checkSum4 = this.stm.getInt(2);
        this.checkSum4Backup = this.stm.getInt(2);
        this.objCount4 = this.stm.getInt(1);
        LCRecoverTest2.printInfo(4, "LCRecoverTest2", "CheckSum4 = " + this.checkSum4);
        LCRecoverTest2.printInfo(4, "LCRecoverTest2", "ObjCount4 = " + this.objCount4);
        this.mConnection.commit();
    }

    private void checkTheNewCheckSum() throws TestCaseException, SQLException {
        this.sString = "CALL LIST_READ( ?, ?, ? )";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.setBytes(1, this.oid1.getOmsOid());
        this.stm.registerOutParameter(2, 4);
        this.stm.registerOutParameter(3, 4);
        this.stm.execute();
        this.dummySum = this.stm.getInt(2);
        this.dummyCount = this.stm.getInt(3);
        if (this.dummySum != this.checkSum1 || this.dummyCount != this.objCount1) {
            this.addMessage(LCRecoverTest2.getTestClassId(), 'E', "For OID1: " + this.oid1.getPagePos() + ":" + this.oid1.getPno() + ":" + this.oid1.getClassId() + "\nexpecting CheckSum = " + this.checkSum1 + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount1 + " <-> returned = " + this.dummyCount);
            LCRecoverTest2.printInfo(3, "LCRecoverTest2", "For OID1: " + this.oid1.getPagePos() + ":" + this.oid1.getPno() + ":" + this.oid1.getClassId() + "\nexpecting CheckSum = " + this.checkSum1 + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount1 + " <-> returned = " + this.dummyCount);
            throw new TestCaseException("Wrong values! See above.");
        }
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "Oid1 = " + this.oid1.getPagePos() + ":" + this.oid1.getPno() + ":" + this.oid1.getClassId());
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "CheckSum1 = " + this.checkSum1);
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "ObjCount1 = " + this.objCount1);
        this.mConnection.commit();
        this.sString = "CALL LIST_READ( ?, ?, ? )";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.setBytes(1, this.oid2.getOmsOid());
        this.stm.registerOutParameter(2, 4);
        this.stm.registerOutParameter(3, 4);
        this.stm.execute();
        this.dummySum = this.stm.getInt(2);
        this.dummyCount = this.stm.getInt(3);
        if (this.dummySum != this.checkSum2 || this.dummyCount != this.objCount2) {
            this.addMessage(LCRecoverTest2.getTestClassId(), 'E', "For OID2: " + this.oid2.getPagePos() + ":" + this.oid2.getPno() + ":" + this.oid2.getClassId() + "\nexpecting CheckSum = " + this.checkSum2 + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount2 + " <-> returned = " + this.dummyCount);
            LCRecoverTest2.printInfo(3, "LCRecoverTest2", "For OID2: " + this.oid2.getPagePos() + ":" + this.oid2.getPno() + ":" + this.oid2.getClassId() + "\nexpecting CheckSum = " + this.checkSum2 + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount2 + " <-> returned = " + this.dummyCount);
            throw new TestCaseException("Wrong values! See above.");
        }
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "Oid2 = " + this.oid2.getPagePos() + ":" + this.oid2.getPno() + ":" + this.oid2.getClassId());
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "CheckSum2 = " + this.checkSum2);
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "ObjCount2 = " + this.objCount2);
        this.mConnection.commit();
        this.sString = "CALL LIST_READ( ?, ?, ? )";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.setBytes(1, this.oid3.getOmsOid());
        this.stm.registerOutParameter(2, 4);
        this.stm.registerOutParameter(3, 4);
        this.stm.execute();
        this.dummySum = this.stm.getInt(2);
        this.dummyCount = this.stm.getInt(3);
        if (this.dummySum != this.checkSum3 || this.dummyCount != this.objCount3) {
            this.addMessage(LCRecoverTest2.getTestClassId(), 'E', "For OID3: " + this.oid3.getPagePos() + ":" + this.oid3.getPno() + ":" + this.oid3.getClassId() + "\nexpecting CheckSum = " + this.checkSum3 + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount3 + " <-> returned = " + this.dummyCount);
            LCRecoverTest2.printInfo(3, "LCRecoverTest2", "For OID3: " + this.oid3.getPagePos() + ":" + this.oid3.getPno() + ":" + this.oid3.getClassId() + "\nexpecting CheckSum = " + this.checkSum3 + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount3 + " <-> returned = " + this.dummyCount);
            throw new TestCaseException("Wrong values! See above.");
        }
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "Oid3 = " + this.oid3.getPagePos() + ":" + this.oid3.getPno() + ":" + this.oid3.getClassId());
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "CheckSum3 = " + this.checkSum3);
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "ObjCount3 = " + this.objCount3);
        this.mConnection.commit();
        this.sString = "CALL SUM_ALL_KEYED_OBJECTS ( 'testteam', " + this.containerNumber + ", ?, ?)";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.registerOutParameter(1, 4);
        this.stm.registerOutParameter(2, 4);
        this.stm.execute();
        this.dummySum = this.stm.getInt(2);
        this.dummyCount = this.stm.getInt(1);
        if (this.dummySum != this.checkSum4 || this.dummyCount != this.objCount4) {
            this.addMessage(LCRecoverTest2.getTestClassId(), 'E', "For 'testteam' and " + this.containerNumber + " \n" + "\nexpecting CheckSum = " + this.checkSum4 + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount4 + " <-> returned = " + this.dummyCount);
            LCRecoverTest2.printInfo(3, "LCRecoverTest2", "For 'testteam' and " + this.containerNumber + " \n" + "\nexpecting CheckSum = " + this.checkSum4 + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount4 + " <-> returned = " + this.dummyCount);
            throw new TestCaseException("Wrong values! See above.");
        }
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "CheckSum4 = " + this.checkSum4);
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "ObjCount4 = " + this.objCount4);
        this.mConnection.commit();
    }

    private void checkTheOldCheckSum() throws TestCaseException, SQLException {
        this.sString = "CALL LIST_READ( ?, ?, ? )";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.setBytes(1, this.oid1.getOmsOid());
        this.stm.registerOutParameter(2, 4);
        this.stm.registerOutParameter(3, 4);
        this.stm.execute();
        this.dummySum = this.stm.getInt(2);
        this.dummyCount = this.stm.getInt(3);
        if (this.dummySum != this.checkSum1Backup || this.dummyCount != this.objCount1) {
            this.addMessage(LCRecoverTest2.getTestClassId(), 'E', "For OID1: " + this.oid1.getPagePos() + ":" + this.oid1.getPno() + ":" + this.oid1.getClassId() + "\nexpecting CheckSum = " + this.checkSum1Backup + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount1 + " <-> returned = " + this.dummyCount);
            LCRecoverTest2.printInfo(3, "LCRecoverTest2", "For OID1: " + this.oid1.getPagePos() + ":" + this.oid1.getPno() + ":" + this.oid1.getClassId() + "\nexpecting CheckSum = " + this.checkSum1Backup + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount1 + " <-> returned = " + this.dummyCount);
            throw new TestCaseException("Wrong values! See above.");
        }
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "Oid1 = " + this.oid1.getPagePos() + ":" + this.oid1.getPno() + ":" + this.oid1.getClassId());
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "CheckSum1 = " + this.checkSum1Backup);
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "ObjCount1 = " + this.objCount1);
        this.mConnection.commit();
        this.sString = "CALL LIST_READ( ?, ?, ? )";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.setBytes(1, this.oid2.getOmsOid());
        this.stm.registerOutParameter(2, 4);
        this.stm.registerOutParameter(3, 4);
        this.stm.execute();
        this.dummySum = this.stm.getInt(2);
        this.dummyCount = this.stm.getInt(3);
        if (this.dummySum != this.checkSum2Backup || this.dummyCount != this.objCount2) {
            this.addMessage(LCRecoverTest2.getTestClassId(), 'E', "For OID2: " + this.oid2.getPagePos() + ":" + this.oid2.getPno() + ":" + this.oid2.getClassId() + "\nexpecting CheckSum = " + this.checkSum2Backup + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount2 + " <-> returned = " + this.dummyCount);
            LCRecoverTest2.printInfo(3, "LCRecoverTest2", "For OID2: " + this.oid2.getPagePos() + ":" + this.oid2.getPno() + ":" + this.oid2.getClassId() + "\nexpecting CheckSum = " + this.checkSum2Backup + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount2 + " <-> returned = " + this.dummyCount);
            throw new TestCaseException("Wrong values! See above.");
        }
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "Oid2 = " + this.oid2.getPagePos() + ":" + this.oid2.getPno() + ":" + this.oid2.getClassId());
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "CheckSum2 = " + this.checkSum2Backup);
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "ObjCount2 = " + this.objCount2);
        this.mConnection.commit();
        this.sString = "CALL LIST_READ( ?, ?, ? )";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.setBytes(1, this.oid3.getOmsOid());
        this.stm.registerOutParameter(2, 4);
        this.stm.registerOutParameter(3, 4);
        this.stm.execute();
        this.dummySum = this.stm.getInt(2);
        this.dummyCount = this.stm.getInt(3);
        if (this.dummySum != this.checkSum3Backup || this.dummyCount != this.objCount3) {
            this.addMessage(LCRecoverTest2.getTestClassId(), 'E', "For OID3: " + this.oid3.getPagePos() + ":" + this.oid3.getPno() + ":" + this.oid3.getClassId() + "\nexpecting CheckSum = " + this.checkSum3Backup + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount3 + " <-> returned = " + this.dummyCount);
            LCRecoverTest2.printInfo(3, "LCRecoverTest2", "For OID3: " + this.oid3.getPagePos() + ":" + this.oid3.getPno() + ":" + this.oid3.getClassId() + "\nexpecting CheckSum = " + this.checkSum3Backup + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount3 + " <-> returned = " + this.dummyCount);
            throw new TestCaseException("Wrong values! See above.");
        }
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "Oid3 = " + this.oid3.getPagePos() + ":" + this.oid3.getPno() + ":" + this.oid3.getClassId());
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "CheckSum3 = " + this.checkSum3Backup);
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "ObjCount3 = " + this.objCount3);
        this.mConnection.commit();
        this.sString = "CALL SUM_ALL_KEYED_OBJECTS ( 'testteam', " + this.containerNumber + ", ?, ?)";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.registerOutParameter(1, 4);
        this.stm.registerOutParameter(2, 4);
        this.stm.execute();
        this.dummySum = this.stm.getInt(2);
        this.dummyCount = this.stm.getInt(1);
        if (this.dummySum != this.checkSum4Backup || this.dummyCount != this.objCount4) {
            this.addMessage(LCRecoverTest2.getTestClassId(), 'E', "For 'testteam' and " + this.containerNumber + " \n" + "\nexpecting CheckSum = " + this.checkSum4Backup + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount4 + " <-> returned = " + this.dummyCount);
            LCRecoverTest2.printInfo(3, "LCRecoverTest2", "For 'testteam' and " + this.containerNumber + " \n" + "\nexpecting CheckSum = " + this.checkSum4Backup + " <-> returned CheckSum = " + this.dummySum + "\nexpecting ObjectCounter = " + this.objCount4 + " <-> returned = " + this.dummyCount);
            throw new TestCaseException("Wrong values! See above.");
        }
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "CheckSum4 = " + this.checkSum4Backup);
        LCRecoverTest2.printInfo(3, "LCRecoverTest2", "ObjCount4 = " + this.objCount4);
        this.mConnection.commit();
    }

    private void buildNewCheckSum() throws TestCaseException, SQLException {
        LCRecoverTest2.printInfo(2, "LCRecoverTest2", "Build new checksum");
        this.sString = "CALL LIST_READ( ?, ?, ? )";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.setBytes(1, this.oid1.getOmsOid());
        this.stm.registerOutParameter(2, 4);
        this.stm.registerOutParameter(3, 4);
        this.stm.execute();
        this.checkSum1 = this.stm.getInt(2);
        this.mConnection.commit();
        this.sString = "CALL LIST_READ( ?, ?, ? )";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.setBytes(1, this.oid2.getOmsOid());
        this.stm.registerOutParameter(2, 4);
        this.stm.registerOutParameter(3, 4);
        this.stm.execute();
        this.checkSum2 = this.stm.getInt(2);
        this.mConnection.commit();
        this.sString = "CALL LIST_READ( ?, ?, ? )";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.setBytes(1, this.oid3.getOmsOid());
        this.stm.registerOutParameter(2, 4);
        this.stm.registerOutParameter(3, 4);
        this.stm.execute();
        this.checkSum3 = this.stm.getInt(2);
        this.mConnection.commit();
        this.sString = "CALL SUM_ALL_KEYED_OBJECTS ( 'testteam', " + this.containerNumber + ", ?, ?)";
        LCRecoverTest2.printInfo(5, "LCRecoverTest2", this.sString);
        this.stm = this.mConnection.prepareCall(this.sString);
        this.stm.registerOutParameter(1, 4);
        this.stm.registerOutParameter(2, 4);
        this.stm.execute();
        this.checkSum4 = this.stm.getInt(2);
        this.mConnection.commit();
    }

    private void workOnTheDatabase() throws TestCaseException, SQLException {
        if (mWorkOnDatabase <= 0) {
            return;
        }
        LCRecoverTest2.printInfo(2, "LCRecoverTest2", "Working with data in the database...");
        this.i = 1;
        while (this.i <= mWorkOnDatabase) {
            switch (Math.abs(this.r.nextInt() % 4) + 1) {
                case 1: {
                    this.sString = "CALL LIST_UPDATE( ?, " + mUpdateProbability + ", ?, ? )";
                    LCRecoverTest2.printInfo(7, "LCRecoverTest2", this.sString + " on list 1");
                    this.stm = this.mConnection.prepareCall(this.sString);
                    this.stm.setBytes(1, this.oid1.getOmsOid());
                    this.stm.registerOutParameter(2, 4);
                    this.stm.registerOutParameter(3, 4);
                    this.stm.execute();
                    break;
                }
                case 2: {
                    this.sString = "CALL LIST_UPDATE( ?, " + mUpdateProbability + ", ?, ? )";
                    LCRecoverTest2.printInfo(7, "LCRecoverTest2", this.sString + " on list 2");
                    this.stm = this.mConnection.prepareCall(this.sString);
                    this.stm.setBytes(1, this.oid2.getOmsOid());
                    this.stm.registerOutParameter(2, 4);
                    this.stm.registerOutParameter(3, 4);
                    this.stm.execute();
                    break;
                }
                case 3: {
                    this.sString = "CALL LIST_UPDATE( ?, " + mUpdateProbability + ", ?, ? )";
                    LCRecoverTest2.printInfo(7, "LCRecoverTest2", this.sString + " on list 3");
                    this.stm = this.mConnection.prepareCall(this.sString);
                    this.stm.setBytes(1, this.oid3.getOmsOid());
                    this.stm.registerOutParameter(2, 4);
                    this.stm.registerOutParameter(3, 4);
                    this.stm.execute();
                    break;
                }
                case 4: {
                    this.sString = "CALL UPD_KEYED_OBJECT ( ?, 'testteam', " + this.containerNumber + ", ?) " + Math.abs(mNoOfObjects / 100 * mUpdateProbability) + " times";
                    LCRecoverTest2.printInfo(7, "LCRecoverTest2", this.sString);
                    for (int j = 0; j <= Math.abs(mNoOfObjects / 100 * mUpdateProbability); ++j) {
                        this.rand = Math.abs(this.r.nextInt() % mNoOfObjects);
                        this.sString = "CALL UPD_KEYED_OBJECT ( ?, 'testteam', " + this.containerNumber + ", ?)";
                        LCRecoverTest2.printInfo(9, "LCRecoverTest2", this.sString);
                        this.stm = this.mConnection.prepareCall(this.sString);
                        this.stm.setInt(1, this.rand);
                        this.stm.setInt(2, Math.abs(this.r.nextInt() % mNoOfObjects));
                        this.stm.execute();
                    }
                    break;
                }
            }
            this.mConnection.commit();
            ++this.i;
        }
    }

    public void run() {
        try {
            this.setStatus("startUp");
            this.startUp();
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "util_connect");
            this.executeDBMCmd("util_connect");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "backup_media_put LCRecoverTest201dat LCRecoverTest201dat FILE DATA 0 8 YES NO ");
            this.executeDBMCmd("backup_media_put LCRecoverTest201dat LCRecoverTest201dat FILE DATA 0 8 YES NO ");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "util_release");
            this.executeDBMCmd("util_release");
            this.setStatus("createObjects");
            this.createObjects();
            this.setStatus("createBackup");
            LCRecoverTest2.printInfo(2, "LCRecoverTest2", "Backup_save");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "util_connect");
            this.executeDBMCmd("util_connect");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "backup_save LCRecoverTest201dat DATA");
            this.executeDBMCmd("backup_save LCRecoverTest201dat DATA");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "util_release");
            this.executeDBMCmd("util_release");
            this.setStatus("Work on Database");
            this.workOnTheDatabase();
            this.setStatus("buildNewCheckSum");
            this.buildNewCheckSum();
            this.setStatus("Restart Database");
            LCRecoverTest2.printInfo(2, "LCRecoverTest2", "Restart");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "db_offline");
            this.executeDBMCmd("db_offline");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "db_warm");
            this.executeDBMCmd("db_warm");
            this.mConnection = LCRecoverTest2.getDatabase().connect(LCRecoverTest2.getUser(), LCRecoverTest2.getPassword());
            this.mStatement = new TestStatement((TestCase)this, this.mConnection);
            LCRecoverTest2.printInfo(7, "LCRecoverTest2", "CALL SET_CURRENT_SCHEMA('testteam')");
            this.mStatement.execute("CALL SET_CURRENT_SCHEMA('testteam')");
            LCRecoverTest2.printInfo(7, "LCRecoverTest2", "CALL CLASS_REGISTER");
            this.mStatement.execute("CALL CLASS_REGISTER");
            this.mStatement.execute("CALL LIST_INIT");
            this.sString = "CALL CREATE_KEYED_CONTAINER ('testteam', " + this.containerNumber + ")";
            LCRecoverTest2.printInfo(7, "LCRecoverTest2", this.sString);
            this.stm = this.mConnection.prepareCall(this.sString);
            this.stm.execute();
            this.mConnection.commit();
            this.setStatus("CheckTheNewCheckSum");
            this.checkTheNewCheckSum();
            this.setStatus("Restart Database");
            LCRecoverTest2.printInfo(2, "LCRecoverTest2", "Restart with backup_restore");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "autosave_off");
            this.executeDBMCmd("autosave_off");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "db_offline");
            this.executeDBMCmd("db_offline");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "db_cold");
            this.executeDBMCmd("db_cold");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "util_connect");
            this.executeDBMCmd("util_connect");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "backup_restore LCRecoverTest201dat DATA");
            this.executeDBMCmd("backup_restore LCRecoverTest201dat DATA");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "db_warm");
            this.executeDBMCmd("db_warm");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "util_release");
            this.executeDBMCmd("util_release");
            this.mConnection = LCRecoverTest2.getDatabase().connect(LCRecoverTest2.getUser(), LCRecoverTest2.getPassword());
            this.mStatement = new TestStatement((TestCase)this, this.mConnection);
            LCRecoverTest2.printInfo(7, "LCRecoverTest2", "CALL SET_CURRENT_SCHEMA('testteam')");
            this.mStatement.execute("CALL SET_CURRENT_SCHEMA('testteam')");
            LCRecoverTest2.printInfo(7, "LCRecoverTest2", "CALL CLASS_REGISTER");
            this.mStatement.execute("CALL CLASS_REGISTER");
            LCRecoverTest2.printInfo(7, "LCRecoverTest2", this.sString);
            this.sString = "CALL CREATE_KEYED_CONTAINER ('testteam', " + this.containerNumber + ")";
            this.stm = this.mConnection.prepareCall(this.sString);
            this.stm.execute();
            this.mConnection.commit();
            this.setStatus("checkTheNewCheckSum");
            this.checkTheNewCheckSum();
            this.setStatus("Restart Database");
            LCRecoverTest2.printInfo(2, "LCRecoverTest2", "Restart with init-config and backup_restore");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "autosave_off");
            this.executeDBMCmd("autosave_off");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "db_offline");
            this.executeDBMCmd("db_offline");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "db_cold");
            this.executeDBMCmd("db_cold");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "util_connect");
            this.executeDBMCmd("util_connect");
            if (TestDriver.compareRelease((String)(((TestDatabaseSap)LCRecoverTest2.getDatabase()).getKernelVersion() + "." + ((TestDatabaseSap)LCRecoverTest2.getDatabase()).getKernelBuild().substring(0, 3)), (String)">=", (String)"7.4.4.1")) {
                LCRecoverTest2.printInfo(5, "LCRecoverTest2", "db_activate RECOVER LCRecoverTest201dat DATA");
                this.executeDBMCmd("db_activate RECOVER LCRecoverTest201dat DATA");
            } else {
                LCRecoverTest2.printInfo(5, "LCRecoverTest2", "util_execute INIT CONFIG");
                this.executeDBMCmd("util_execute INIT CONFIG");
                LCRecoverTest2.printInfo(5, "LCRecoverTest2", "backup_restore LCRecoverTest201dat DATA");
                this.executeDBMCmd("backup_restore LCRecoverTest201dat DATA");
            }
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "db_warm");
            this.executeDBMCmd("db_warm");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "util_release");
            this.executeDBMCmd("util_release");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "util_connect");
            this.executeDBMCmd("util_connect");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "backup_save LCRecoverTest201dat DATA");
            this.executeDBMCmd("backup_save LCRecoverTest201dat DATA");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "autosave_on");
            this.executeDBMCmd("autosave_on");
            LCRecoverTest2.printInfo(5, "LCRecoverTest2", "util_release");
            this.executeDBMCmd("util_release");
            this.mConnection = LCRecoverTest2.getDatabase().connect(LCRecoverTest2.getUser(), LCRecoverTest2.getPassword());
            this.mStatement = new TestStatement((TestCase)this, this.mConnection);
            LCRecoverTest2.printInfo(7, "LCRecoverTest2", "CALL SET_CURRENT_SCHEMA('testteam')");
            this.mStatement.execute("CALL SET_CURRENT_SCHEMA('testteam')");
            LCRecoverTest2.printInfo(7, "LCRecoverTest2", "CALL CLASS_REGISTER");
            this.mStatement.execute("CALL CLASS_REGISTER");
            LCRecoverTest2.printInfo(7, "LCRecoverTest2", this.sString);
            this.sString = "CALL CREATE_KEYED_CONTAINER ('testteam', " + this.containerNumber + ")";
            this.stm = this.mConnection.prepareCall(this.sString);
            this.stm.execute();
            this.mConnection.commit();
            this.setStatus("checkTheOldCheckSum");
            this.checkTheOldCheckSum();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            LCRecoverTest2.addGlobalMessage((String)"LCRecoverTest2", (char)'E', (String)("Exception: " + e.getMessage()));
        }
    }

    public String executeDBMCmd(String pCmd) {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = LCRecoverTest2.getDatabase().getHost();
            mName = LCRecoverTest2.getDatabase().getName();
            int mPort = LCRecoverTest2.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            LCRecoverTest2.addGlobalMessage((String)("executeDBMCmd in " + LCRecoverTest2.getTestClassId()), (char)'E', (String)("Caught an exception during '" + pCmd + "':\n" + e.getLocalizedMessage()));
            System.out.println("Could not execute: " + pCmd);
            System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
            return "error";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cleanUp() throws TestCaseException {
        mDirectoryCleaner.stop();
        Connection con = null;
        TestStatement stmt = null;
        try {
            try {
                con = LCRecoverTest2.getDatabase().connect(LCRecoverTest2.getDatabase().getUser(), LCRecoverTest2.getDatabase().getPassword());
                stmt = new TestStatement(null, con);
                if (stmt != null) {
                    stmt.execute("CALL DROP_CURRENT_SCHEMA('testteam')");
                }
            }
            catch (Exception e) {
                LCRecoverTest2.addGlobalMessage((String)"cleanup", (char)'E', (String)("Error during cleanup: " + e.getMessage()));
                throw new TestCaseException("Error during cleanup: " + e.getMessage());
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                stmt.close();
                con.commit();
                con.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        stmt.close();
        con.commit();
        con.close();
        return;
    }

    static {
        mWorkOnDatabase = 0;
        mUpdateProbability = 0;
        mDirectoryCleaner = null;
    }
}

