/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.dbtech.jdbc.exceptions.DatabaseException;
import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.driver.TestDriver;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class GarbageCollector
extends TestCase {
    private static final int DBERR_DUPLICATE_NAME = -6006;
    private static final int DBERR_SPACE_EXHAUSTED = -904;
    private static final String sUser = "GarbColl";
    private static final String sPassword = "GarbColl";
    private DBM mDBMan = null;

    public String executeDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "";
        String mHost = "";
        String mName = "";
        try {
            mHost = GarbageCollector.getDatabase().getHost();
            mName = GarbageCollector.getDatabase().getName();
            int mPort = GarbageCollector.getDatabase().getPort();
            if (this.mDBMan == null) {
                this.mDBMan = DBM.dbDBM((String)(mHost + ":" + mPort), (String)mName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    public void runVerify() {
        try {
            if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.7.0")) {
                this.executeDBMCmd("db_connect");
                this.executeDBMCmd("db_execute create index restart");
                this.executeDBMCmd("db_execute check data");
                this.executeDBMCmd("db_release");
            } else {
                this.executeDBMCmd("util_connect");
                this.executeDBMCmd("util_execute verify");
                this.executeDBMCmd("util_release");
            }
            this.mDBMan.release();
            this.mDBMan = null;
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
    }

    private static void callTestWithoutParms(TestStatement Statement2, String ProcedureName) throws TestCaseException {
        block2: {
            String CallString = "";
            try {
                CallString = "CALL " + ProcedureName;
                Statement2.execute(CallString);
            }
            catch (SQLException e) {
                if (-904 == e.getErrorCode()) break block2;
                throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getMessage());
            }
        }
    }

    private static void deleteTable(TestStatement Statement2, String TableName) throws TestCaseException {
        block2: {
            String CallString = "";
            try {
                CallString = "delete " + TableName;
                Statement2.execute(CallString);
            }
            catch (SQLException e) {
                if (-904 == e.getErrorCode()) break block2;
                throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getMessage());
            }
        }
    }

    public static void createPackageWithFile(TestStatement Statement2, String PackageName, String PackageIdentifier) throws TestCaseException {
        String CallString = "";
        String CreationMode = "INPROC";
        try {
            Statement2.enableExceptions(false);
            CallString = "DROP PACKAGE " + PackageName;
            Statement2.execute(CallString);
            Statement2.enableExceptions(true);
            CallString = "CREATE PACKAGE " + PackageName + " FILE '" + PackageIdentifier + "' " + CreationMode;
            Statement2.execute(CallString);
            Statement2.execute("COMMIT");
        }
        catch (Exception e) {
            throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getLocalizedMessage());
        }
    }

    private static void createPackage(TestStatement Statement2, String PackageName, String PackageIdentifier) throws TestCaseException {
        String CallString = "";
        try {
            Statement2.enableExceptions(false);
            CallString = "DROP PACKAGE " + PackageName;
            Statement2.execute(CallString);
            Statement2.enableExceptions(true);
            CallString = "CREATE PACKAGE " + PackageName + " AS '" + PackageIdentifier + "' " + " INPROC";
            Statement2.execute(CallString);
            Statement2.execute("COMMIT");
        }
        catch (Exception e) {
            throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getMessage());
        }
    }

    private static void createProc(TestStatement Statement2, String ProcedureName, String PackageName) throws TestCaseException {
        String CallString = "";
        try {
            CallString = "CREATE DBPROC " + ProcedureName + " IN " + PackageName + " EXECUTE INPROC";
            Statement2.execute(CallString);
        }
        catch (Exception e) {
            throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getMessage());
        }
    }

    private static void createDBProcedures() throws TestCaseException {
        Connection con = null;
        TestStatement stmt = null;
        String pkg = "GC_PACKAGE";
        try {
            con = GarbageCollector.getDatabase().connect("GarbColl", "GarbColl");
            stmt = new TestStatement(null, con);
            if (TestDriver.compareRelease((String)((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion(), (String)">=", (String)"7.4.4")) {
                GarbageCollector.createPackageWithFile(stmt, pkg, "garbagecollector");
            } else {
                GarbageCollector.createPackage(stmt, pkg, "liveCache.GarbageCollector.v1.0");
            }
            GarbageCollector.createProc(stmt, "GC_CREATE_OBJECTS", pkg);
            GarbageCollector.createProc(stmt, "GC_GET_COUNTERS", pkg);
            GarbageCollector.createProc(stmt, "GC_WAIT_FOR_RELOBJ", pkg);
            GarbageCollector.createProc(stmt, "GC_UPDATE_OBJECTS", pkg);
            GarbageCollector.createProc(stmt, "GC_CREATE_SCHEMA", pkg);
            GarbageCollector.createProc(stmt, "GC_REGISTER", pkg);
            GarbageCollector.createProc(stmt, "GC_WAIT_FOR_HIST", pkg);
            GarbageCollector.createProc(stmt, "GC_DELETE_OBJECTS", pkg);
            GarbageCollector.createProc(stmt, "GC_LOCK_OBJECTS", pkg);
            GarbageCollector.createProc(stmt, "GC_CHECK_SUBTRANS", pkg);
            con.commit();
        }
        catch (Exception e) {
            GarbageCollector.addGlobalMessage((String)"DPProc registration", (char)'E', (String)("SQL Error while registering DBProcedures: " + e.getMessage()));
            throw new TestCaseException("GarbageCollector.createDBProcedures() failed");
        }
        finally {
            try {
                stmt.close();
                con.close();
            }
            catch (Exception e) {}
        }
    }

    public static void cleanUp() throws TestCaseException {
    }

    public static String getTestClassId() {
        return null;
    }

    public static long getTimeout() {
        return 0L;
    }

    public static boolean isReferenceEnabled() {
        return false;
    }

    public static boolean isSAPOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepare() throws TestCaseException {
        Connection lDefConnection = null;
        TestStatement lDefTstmt = null;
        try {
            block13: {
                lDefConnection = GarbageCollector.getDatabase().connect(GarbageCollector.getUser(), GarbageCollector.getPassword());
                lDefTstmt = new TestStatement(null, lDefConnection);
                lDefTstmt.enableExceptions(false);
                lDefTstmt.executeUpdate("drop user GarbColl");
                lDefTstmt.enableExceptions(true);
                try {
                    lDefTstmt.executeUpdate("Create user GarbColl password GarbColl dba not exclusive");
                }
                catch (DatabaseException e) {
                    if (e.getErrorCode() == -6006) break block13;
                    GarbageCollector.addGlobalMessage((String)"Init failure", (char)'E', (String)"Creation of user : GarbColl not possible");
                    throw e;
                }
            }
            GarbageCollector.createDBProcedures();
        }
        catch (Exception e) {
            GarbageCollector.handleGlobalExceptions((Exception)e);
        }
        finally {
            try {
                lDefTstmt.close();
                lDefConnection.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Connection lConnection = null;
        Object lConnection2 = null;
        TestStatement lTstmt = null;
        try {
            lConnection = GarbageCollector.getDatabase().connect("GarbColl", "GarbColl");
            lConnection.setAutoCommit(false);
            lTstmt = new TestStatement((TestCase)this, lConnection);
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_SCHEMA");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_REGISTER");
            lTstmt.execute("COMMIT WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(1,0,0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_GET_COUNTERS");
            lTstmt.execute("ROLLBACK WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_RELOBJ(1)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_HIST( 1,  1,  0,  0,  0)");
            this.runVerify();
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(1,100,0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_GET_COUNTERS");
            lTstmt.execute("ROLLBACK WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(1,100,0)");
            lTstmt.execute("ROLLBACK WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_RELOBJ(4)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_HIST( 4,  4,  0,  0,  0)");
            this.runVerify();
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(0,0,1)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_GET_COUNTERS");
            lTstmt.execute("ROLLBACK WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_RELOBJ(1)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_HIST( 1,  1,  0,  0,  0)");
            this.runVerify();
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(100,100,100)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_GET_COUNTERS");
            lTstmt.execute("ROLLBACK WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(1,0,0)");
            lTstmt.execute("ROLLBACK WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_RELOBJ(301)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_HIST(301,301, 0,  0,  0)");
            this.runVerify();
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(1,1000,0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_GET_COUNTERS");
            lTstmt.execute("ROLLBACK WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(1,0,0)");
            lTstmt.execute("ROLLBACK WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_RELOBJ(3)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_HIST( 3,  3,  0,  0,  0)");
            this.runVerify();
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(10,100,100)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(10,200,0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(10,500,0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(10,1000,0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(10,2000,0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(10,3000,0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(10,5000,0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(10,7000,0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(10,8000,0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(10,8000,0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_GET_COUNTERS");
            lTstmt.execute("COMMIT WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CREATE_OBJECTS(1,1,0)");
            lTstmt.execute("COMMIT WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_HIST( 0, 302, 0, 302, 0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_UPDATE_OBJECTS(1,0,0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_GET_COUNTERS");
            lTstmt.execute("COMMIT WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_HIST( 0,  0,  0,  0,  1)");
            this.runVerify();
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_UPDATE_OBJECTS(1,100,0)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_GET_COUNTERS");
            lTstmt.execute("COMMIT WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_HIST( 0,  0,  0,  0,  2)");
            this.runVerify();
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_UPDATE_OBJECTS(0,0,1)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_GET_COUNTERS");
            lTstmt.execute("COMMIT WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_HIST( 0,  0,  0,  0,  1)");
            this.runVerify();
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_LOCK_OBJECTS(10,10)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_GET_COUNTERS");
            lTstmt.execute("COMMIT WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_HIST( 0,  0,  30,  0,  0)");
            this.runVerify();
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_DELETE_OBJECTS(10,10)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_GET_COUNTERS");
            lTstmt.execute("COMMIT WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_HIST( 30, 0,  0,  0,  0)");
            this.runVerify();
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_CHECK_SUBTRANS");
            lTstmt.execute("COMMIT WORK");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_RELOBJ(2)");
            GarbageCollector.callTestWithoutParms(lTstmt, "GC_WAIT_FOR_HIST( 2,  3,  0,  0,  0)");
            this.runVerify();
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        finally {
            try {
                lTstmt.close();
                lConnection.close();
            }
            catch (Exception e) {}
        }
    }
}

