/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.lctest;

import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestDatabaseSap;
import com.sap.sapdb.testframe.testcase.TestCase;
import com.sap.sapdb.testframe.testcase.TestCaseException;
import com.sap.sapdb.testframe.testcase.TestStatement;

public class DBProcedure {
    public static final int INPROC = 1;
    public static final int LOCAL = 2;
    public static final int REMOTE = 3;

    public static void create(TestStatement Statement2, String ProcedureName, String PackageName) throws TestCaseException {
        DBProcedure.create(Statement2, ProcedureName, PackageName, 1, "");
    }

    public static void create(TestStatement Statement2, String ProcedureName, String PackageName, int Mode) throws TestCaseException {
        DBProcedure.create(Statement2, ProcedureName, PackageName, Mode, "");
    }

    public static void create(TestStatement Statement2, String ProcedureName, String PackageName, int Mode, String ExtraAttributes) throws TestCaseException {
        String CallString = "";
        String CreationMode = "INPROC";
        switch (Mode) {
            case 2: {
                CreationMode = "LOCAL";
                break;
            }
            case 3: {
                CreationMode = "REMOTE AT " + ExtraAttributes;
            }
        }
        try {
            try {
                if (((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion().startsWith("7.2")) {
                    CallString = "enable write transaction";
                    Statement2.execute(CallString);
                }
            }
            catch (TestDatabaseException e) {
                throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version");
            }
            CallString = Mode == 3 ? "CREATE DBPROC " + ProcedureName + " IN " + PackageName + " EXECUTE " + CreationMode : "CREATE DBPROC " + ProcedureName + " IN " + PackageName + " EXECUTE " + CreationMode + " " + ExtraAttributes;
            Statement2.execute(CallString);
        }
        catch (Exception e) {
            throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getMessage());
        }
    }

    public static void createPackage(TestStatement Statement2, String PackageName, String PackageIdentifier) throws TestCaseException {
        DBProcedure.createPackage(Statement2, PackageName, PackageIdentifier, 1, "");
    }

    public static void createPackage(TestStatement Statement2, String PackageName, String PackageIdentifier, int Mode) throws TestCaseException {
        DBProcedure.createPackage(Statement2, PackageName, PackageIdentifier, Mode, "");
    }

    public static void createPackage(TestStatement Statement2, String PackageName, String PackageIdentifier, int Mode, String ExtraAttributes) throws TestCaseException {
        String CallString = "";
        String CreationMode = "INPROC";
        switch (Mode) {
            case 2: {
                CreationMode = "LOCAL";
                break;
            }
            case 3: {
                CreationMode = "REMOTE AT " + ExtraAttributes;
            }
        }
        try {
            try {
                if (((TestDatabaseSap)TestCase.getDatabase()).getKernelVersion().startsWith("7.2")) {
                    CallString = "enable write transaction";
                    Statement2.execute(CallString);
                }
            }
            catch (TestDatabaseException e) {
                throw new TestDatabaseException((Exception)((Object)e), "Could not retrieve kernel version");
            }
            Statement2.enableExceptions(false);
            CallString = "DROP PACKAGE " + PackageName;
            Statement2.execute(CallString);
            Statement2.enableExceptions(true);
            CallString = "CREATE PACKAGE " + PackageName + " AS '" + PackageIdentifier + "' " + CreationMode;
            Statement2.execute(CallString);
            Statement2.execute("COMMIT");
        }
        catch (Exception e) {
            throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getMessage());
        }
    }

    public static void createPackageWithFile(TestStatement Statement2, String PackageName, String PackageIdentifier) throws TestCaseException {
        String CallString = "";
        String CreationMode = "INPROC";
        try {
            Statement2.enableExceptions(false);
            CallString = "DROP PACKAGE " + PackageName;
            Statement2.execute(CallString);
            Statement2.enableExceptions(true);
            CallString = "CREATE PACKAGE " + PackageName + " FILE '" + PackageIdentifier + "' " + CreationMode;
            Statement2.execute(CallString);
            Statement2.execute("COMMIT");
        }
        catch (Exception e) {
            throw new TestCaseException("Error in call of <" + CallString + "> : " + e.getLocalizedMessage());
        }
    }
}

