/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdb.syncMan.util;

import com.sap.sdb.syncMan.util.ConnectionPool;

public class TableName
implements Comparable {
    private String m_owner;
    private String m_identifier;
    private String m_SQLIdentifier;
    private String m_SQLOwner;
    private String m_SQLTableName;
    private static final char SQL_QUOTATION_MARKS_MAXDB = '\"';
    private static final char SQL_QUOTATION_MARKS_MYSQL = '`';
    private static final char SQL_NAME_SEPARATOR = '.';

    public TableName(String owner, String identifier) {
        this.m_owner = owner;
        this.m_identifier = identifier;
        char quotMark = '\"';
        if (ConnectionPool.isMaxDB() || ConnectionPool.isMinDB()) {
            quotMark = '\"';
        } else if (ConnectionPool.isMySQL()) {
            quotMark = '`';
        }
        this.m_SQLIdentifier = this.m_identifier == null || this.m_identifier.length() == 0 ? "" : quotMark + this.m_identifier + quotMark;
        this.m_SQLOwner = this.m_owner == null || this.m_owner.length() == 0 ? "" : quotMark + this.m_owner + quotMark;
        this.m_SQLTableName = (this.m_SQLOwner.length() > 0 ? this.m_SQLOwner + '.' : "") + this.m_SQLIdentifier;
    }

    public int compareTo(Object o) {
        TableName other = (TableName)o;
        int result = this.m_owner.compareTo(other.m_owner);
        return result != 0 ? result : this.m_identifier.compareTo(other.m_identifier);
    }

    public boolean equals(Object o) {
        TableName other = (TableName)o;
        return this.m_owner.equals(other.m_owner) && this.m_identifier.equals(other.m_identifier);
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public String getOwner() {
        return this.m_owner;
    }

    public String getSQLIdentifier() {
        return this.m_SQLIdentifier;
    }

    public String getSQLTableName() {
        return this.m_SQLTableName;
    }

    public int hashCode() {
        return this.m_identifier.hashCode();
    }
}

