/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xpath.axes.AncestorOrSelfWalker;
import org.apache.xpath.axes.AncestorWalker;
import org.apache.xpath.axes.AttributeIterator;
import org.apache.xpath.axes.AttributeWalker;
import org.apache.xpath.axes.AttributeWalkerOneStep;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.ChildIterator;
import org.apache.xpath.axes.ChildTestIterator;
import org.apache.xpath.axes.ChildWalker;
import org.apache.xpath.axes.ChildWalkerMultiStep;
import org.apache.xpath.axes.ChildWalkerOneStep;
import org.apache.xpath.axes.DescendantIterator;
import org.apache.xpath.axes.DescendantOrSelfWalker;
import org.apache.xpath.axes.DescendantWalker;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.FollowingSiblingWalker;
import org.apache.xpath.axes.FollowingWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.NamespaceWalker;
import org.apache.xpath.axes.ParentWalker;
import org.apache.xpath.axes.PrecedingSiblingWalker;
import org.apache.xpath.axes.PrecedingWalker;
import org.apache.xpath.axes.RootWalker;
import org.apache.xpath.axes.RootWalkerMultiStep;
import org.apache.xpath.axes.SelfWalker;
import org.apache.xpath.axes.SelfWalkerOneStep;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;

public class WalkerFactory {
    static final boolean DEBUG_WALKER_CREATION = false;
    static final boolean DEBUG_ITERATOR_CREATION = false;
    public static final int BITS_COUNT = 255;
    public static final int BITS_RESERVED = 3840;
    public static final int BIT_PREDICATE = 4096;
    public static final int BIT_ANCESTOR = 8192;
    public static final int BIT_ANCESTOR_OR_SELF = 16384;
    public static final int BIT_ATTRIBUTE = 32768;
    public static final int BIT_CHILD = 65536;
    public static final int BIT_DESCENDANT = 131072;
    public static final int BIT_DESCENDANT_OR_SELF = 262144;
    public static final int BIT_FOLLOWING = 524288;
    public static final int BIT_FOLLOWING_SIBLING = 0x100000;
    public static final int BIT_NAMESPACE = 0x200000;
    public static final int BIT_PARENT = 0x400000;
    public static final int BIT_PRECEDING = 0x800000;
    public static final int BIT_PRECEDING_SIBLING = 0x1000000;
    public static final int BIT_SELF = 0x2000000;
    public static final int BIT_FILTER = 0x4000000;
    public static final int BIT_ROOT = 0x8000000;
    public static final int BITMASK_TRAVERSES_OUTSIDE_SUBTREE = 234381312;
    public static final int BIT_BACKWARDS_SELF = 0x10000000;
    public static final int BIT_ANY_DESCENDANT_FROM_ROOT = 0x20000000;
    public static final int BIT_NODETEST_ANY = 0x40000000;
    public static final int BIT_MATCH_PATTERN = Integer.MIN_VALUE;

    private static int analyze(Compiler compiler, int stepOpCodePos, int stepIndex) throws TransformerException {
        int stepType;
        int[] ops = compiler.getOpMap();
        int stepCount = 0;
        int analysisResult = 0;
        while ((stepType = ops[stepOpCodePos]) != -1) {
            ++stepCount;
            boolean predAnalysis = WalkerFactory.analyzePredicate(compiler, stepOpCodePos, stepType);
            if (predAnalysis) {
                analysisResult |= 0x1000;
            }
            switch (stepType) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    analysisResult |= 0x4000000;
                    break;
                }
                case 50: {
                    analysisResult |= 0x8000000;
                    break;
                }
                case 37: {
                    analysisResult |= 0x2000;
                    break;
                }
                case 38: {
                    analysisResult |= 0x4000;
                    break;
                }
                case 39: {
                    analysisResult |= 0x8000;
                    break;
                }
                case 49: {
                    analysisResult |= 0x200000;
                    break;
                }
                case 40: {
                    analysisResult |= 0x10000;
                    break;
                }
                case 41: {
                    analysisResult |= 0x20000;
                    break;
                }
                case 42: {
                    if (stepCount == 2 && analysisResult == 0x8000000) {
                        analysisResult |= 0x20000000;
                    }
                    analysisResult |= 0x40000;
                    break;
                }
                case 43: {
                    analysisResult |= 0x40000;
                    break;
                }
                case 44: {
                    analysisResult |= 0x100000;
                    break;
                }
                case 46: {
                    analysisResult |= 0x800000;
                    break;
                }
                case 47: {
                    analysisResult |= 0x1000000;
                    break;
                }
                case 45: {
                    analysisResult |= 0x400000;
                    break;
                }
                case 48: {
                    analysisResult |= 0x2000000;
                    break;
                }
                case 51: {
                    analysisResult |= 0x80008000;
                    break;
                }
                case 52: {
                    analysisResult |= 0x80002000;
                    break;
                }
                case 53: {
                    analysisResult |= 0x80400000;
                    break;
                }
                default: {
                    throw new RuntimeException("Programmer's assertion: unknown opcode: " + stepType);
                }
            }
            if (ops[stepOpCodePos + 3] == 1033) {
                analysisResult |= 0x40000000;
            }
            if ((stepOpCodePos = compiler.getNextStepPos(stepOpCodePos)) < 0) break;
        }
        return analysisResult |= stepCount & 0xFF;
    }

    static boolean analyzePredicate(Compiler compiler, int opPos, int stepType) throws TransformerException {
        switch (stepType) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                int argLen = compiler.getArgLength(opPos);
                break;
            }
            default: {
                int argLen = compiler.getArgLengthOfStep(opPos);
            }
        }
        int pos = compiler.getFirstPredicateOpPos(opPos);
        int nPredicates = compiler.countPredicates(pos);
        return nPredicates > 0;
    }

    private static AxesWalker createDefaultWalker(Compiler compiler, int opPos, LocPathIterator lpi, int analysis) {
        AxesWalker ai2;
        int stepType = compiler.getOp(opPos);
        boolean simpleInit = false;
        int totalNumberWalkers = analysis & 0xFF;
        boolean prevIsOneStepDown = true;
        switch (stepType) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                prevIsOneStepDown = false;
                ai2 = new FilterExprWalker(lpi);
                simpleInit = true;
                break;
            }
            case 50: {
                if ((analysis & 0xF7DE6F00) == 0) {
                    ai2 = new RootWalkerMultiStep(lpi);
                    break;
                }
                ai2 = new RootWalker(lpi);
                break;
            }
            case 37: {
                prevIsOneStepDown = false;
                ai2 = new AncestorWalker(lpi);
                break;
            }
            case 38: {
                prevIsOneStepDown = false;
                ai2 = new AncestorOrSelfWalker(lpi);
                break;
            }
            case 39: {
                if (totalNumberWalkers == 1) {
                    ai2 = new AttributeWalkerOneStep(lpi);
                    break;
                }
                ai2 = new AttributeWalker(lpi);
                break;
            }
            case 49: {
                ai2 = new NamespaceWalker(lpi);
                break;
            }
            case 40: {
                if (totalNumberWalkers == 1) {
                    ai2 = new ChildWalkerOneStep(lpi);
                    break;
                }
                if ((analysis & 0xF7DE6F00) == 0) {
                    ai2 = new ChildWalkerMultiStep(lpi);
                    break;
                }
                ai2 = new ChildWalker(lpi);
                break;
            }
            case 41: {
                prevIsOneStepDown = false;
                ai2 = new DescendantWalker(lpi);
                break;
            }
            case 42: {
                prevIsOneStepDown = false;
                ai2 = new DescendantOrSelfWalker(lpi);
                break;
            }
            case 43: {
                prevIsOneStepDown = false;
                ai2 = new FollowingWalker(lpi);
                break;
            }
            case 44: {
                prevIsOneStepDown = false;
                ai2 = new FollowingSiblingWalker(lpi);
                break;
            }
            case 46: {
                prevIsOneStepDown = false;
                ai2 = new PrecedingWalker(lpi);
                break;
            }
            case 47: {
                prevIsOneStepDown = false;
                ai2 = new PrecedingSiblingWalker(lpi);
                break;
            }
            case 45: {
                prevIsOneStepDown = false;
                ai2 = new ParentWalker(lpi);
                break;
            }
            case 48: {
                if (totalNumberWalkers == 1) {
                    ai2 = new SelfWalkerOneStep(lpi);
                    break;
                }
                ai2 = new SelfWalker(lpi);
                break;
            }
            case 51: {
                ai2 = new AttributeWalker(lpi);
                break;
            }
            case 52: {
                ai2 = new ChildWalker(lpi);
                break;
            }
            case 53: {
                ai2 = new ChildWalker(lpi);
                break;
            }
            default: {
                throw new RuntimeException("Programmer's assertion: unknown opcode: " + stepType);
            }
        }
        if (simpleInit) {
            ai2.initNodeTest(-1);
        } else {
            int whatToShow = compiler.getWhatToShow(opPos);
            if ((whatToShow & 0x43) == 0 || whatToShow == -1) {
                ai2.initNodeTest(whatToShow);
            } else {
                ai2.initNodeTest(whatToShow, compiler.getStepNS(opPos), compiler.getStepLocalName(opPos));
            }
        }
        return ai2;
    }

    static AxesWalker loadOneWalker(LocPathIterator lpi, Compiler compiler, int stepOpCodePos) throws TransformerException {
        AxesWalker firstWalker = null;
        int stepType = compiler.getOpMap()[stepOpCodePos];
        if (stepType != -1) {
            firstWalker = WalkerFactory.createDefaultWalker(compiler, stepType, lpi, 0);
            firstWalker.init(compiler, stepOpCodePos, stepType);
        }
        return firstWalker;
    }

    static AxesWalker loadWalkers(LocPathIterator lpi, Compiler compiler, int stepOpCodePos, int stepIndex) throws TransformerException {
        int stepType;
        AxesWalker firstWalker = null;
        AxesWalker prevWalker = null;
        int[] ops = compiler.getOpMap();
        int analysis = WalkerFactory.analyze(compiler, stepOpCodePos, stepIndex);
        while ((stepType = ops[stepOpCodePos]) != -1) {
            AxesWalker walker = WalkerFactory.createDefaultWalker(compiler, stepOpCodePos, lpi, analysis);
            walker.init(compiler, stepOpCodePos, stepType);
            if (firstWalker == null) {
                firstWalker = walker;
            } else {
                prevWalker.setNextWalker(walker);
                walker.setPrevWalker(prevWalker);
            }
            prevWalker = walker;
            stepOpCodePos = compiler.getNextStepPos(stepOpCodePos);
            if (stepOpCodePos < 0) break;
        }
        return firstWalker;
    }

    public static LocPathIterator newLocPathIterator(Compiler compiler, int opPos) throws TransformerException {
        int firstStepPos = OpMap.getFirstChildPos(opPos);
        int analysis = WalkerFactory.analyze(compiler, firstStepPos, 0);
        if ((analysis & 0x100FF) == 65537) {
            if ((analysis & 0x40000000) == 0x40000000 && (analysis & 0x1000) != 4096) {
                return new ChildIterator(compiler, opPos, analysis);
            }
            return new ChildTestIterator(compiler, opPos, analysis);
        }
        if ((analysis & 0x80FF) == 32769) {
            return new AttributeIterator(compiler, opPos, analysis);
        }
        if ((0x1000 & analysis) == 0 && ((analysis & 0x600FF) == 393217 || (analysis & 0x20400FF) == 0x2040002 || (analysis & 0x420500FF) == 1107623939 || (analysis & 0x680500FF) == 1745158147)) {
            return new DescendantIterator(compiler, opPos, analysis);
        }
        return new LocPathIterator(compiler, opPos, analysis, true);
    }
}

