/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.patterns.NodeTestFilter;
import org.w3c.dom.Node;

public class ChildWalkerMultiStep
extends AxesWalker {
    public ChildWalkerMultiStep(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    protected Node getNextNode() {
        Node next;
        Node current;
        if (this.m_isFresh) {
            this.m_isFresh = false;
        }
        if ((current = this.getCurrentNode()).isSupported("NodeTestFilter", "1.0")) {
            ((NodeTestFilter)((Object)current)).setNodeTest(this);
        }
        Node node = next = this.m_root == this.m_currentNode ? this.m_currentNode.getFirstChild() : this.m_currentNode.getNextSibling();
        if (next != null) {
            this.m_currentNode = next;
            while (this.acceptNode(next) != 1) {
                if ((next = next.getNextSibling()) == null) break;
                this.m_currentNode = next;
            }
            if (next == null) {
                this.m_currentNode = current;
            }
        }
        if (next == null) {
            this.m_isDone = true;
        }
        return next;
    }

    protected boolean isFastWalker() {
        return true;
    }

    public Node nextNode() {
        AxesWalker walker = this.m_lpi.getLastUsedWalker();
        boolean fast = walker != null ? walker.isFastWalker() : false;
        while (walker != null) {
            Node next;
            if (fast) {
                next = walker.getNextNode();
            } else {
                next = walker.nextNode();
                if (next != null) {
                    return next;
                }
            }
            if (next != null) {
                if (walker.m_nextWalker != null) {
                    walker = walker.m_nextWalker;
                    walker.setRoot(next);
                    this.m_lpi.setLastUsedWalker(walker);
                    fast = walker.isFastWalker();
                    continue;
                }
                return next;
            }
            walker = walker.m_prevWalker;
            if (walker != null) {
                fast = walker.isFastWalker();
            }
            this.m_lpi.setLastUsedWalker(walker);
        }
        return null;
    }
}

