/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.patterns.NodeTestFilter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeWalkerOneStep
extends AxesWalker {
    transient NamedNodeMap m_attributeList;
    transient int m_attrListPos;
    transient int m_nAttrs;

    public AttributeWalkerOneStep(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public Node nextNode() {
        Node current;
        if (this.m_isFresh) {
            this.m_isFresh = false;
        }
        if ((current = this.getCurrentNode()).isSupported("NodeTestFilter", "1.0")) {
            ((NodeTestFilter)((Object)current)).setNodeTest(this);
        }
        Node next = null;
        while (this.m_attributeList != null) {
            ++this.m_attrListPos;
            if (this.m_attrListPos < this.m_nAttrs) {
                next = this.m_attributeList.item(this.m_attrListPos);
                if (next != null) {
                    this.m_currentNode = next;
                }
                if (this.acceptNode(next) != 1) continue;
                break;
            }
            next = null;
            this.m_attributeList = null;
        }
        if (next == null) {
            this.m_isDone = true;
        }
        return next;
    }

    public void setRoot(Node root) {
        super.setRoot(root);
        if (root.getNodeType() == 1) {
            this.m_attrListPos = -1;
            this.m_attributeList = this.m_currentNode.getAttributes();
            this.m_nAttrs = this.m_attributeList != null ? this.m_attributeList.getLength() : -2;
        }
    }
}

