/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.trace;

import java.util.TooManyListenersException;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.SelectionEvent;
import org.apache.xalan.trace.TraceListener;
import org.apache.xalan.trace.TracerEvent;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.QName;
import org.apache.xpath.XPath;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;

public class TraceManager {
    private TransformerImpl m_transformer;
    private Vector m_traceListeners = null;

    public TraceManager(TransformerImpl transformer) {
        this.m_transformer = transformer;
    }

    public void addTraceListener(TraceListener tl) throws TooManyListenersException {
        TransformerImpl.S_DEBUG = true;
        if (this.m_traceListeners == null) {
            this.m_traceListeners = new Vector();
        }
        this.m_traceListeners.addElement(tl);
    }

    public void fireGenerateEvent(GenerateEvent te) {
        if (this.m_traceListeners != null) {
            int nListeners = this.m_traceListeners.size();
            int i2 = 0;
            while (i2 < nListeners) {
                TraceListener tl = (TraceListener)this.m_traceListeners.elementAt(i2);
                tl.generated(te);
                ++i2;
            }
        }
    }

    public void fireSelectedEvent(SelectionEvent se) throws TransformerException {
        if (this.hasTraceListeners()) {
            int nListeners = this.m_traceListeners.size();
            int i2 = 0;
            while (i2 < nListeners) {
                TraceListener tl = (TraceListener)this.m_traceListeners.elementAt(i2);
                tl.selected(se);
                ++i2;
            }
        }
    }

    public void fireSelectedEvent(Node sourceNode, ElemTemplateElement styleNode, String attributeName, XPath xpath, XObject selection) throws TransformerException {
        if (this.hasTraceListeners()) {
            this.fireSelectedEvent(new SelectionEvent(this.m_transformer, sourceNode, styleNode, attributeName, xpath, selection));
        }
    }

    public void fireTraceEvent(TracerEvent te) {
        if (this.hasTraceListeners()) {
            int nListeners = this.m_traceListeners.size();
            int i2 = 0;
            while (i2 < nListeners) {
                TraceListener tl = (TraceListener)this.m_traceListeners.elementAt(i2);
                tl.trace(te);
                ++i2;
            }
        }
    }

    public void fireTraceEvent(Node sourceNode, QName mode, ElemTemplateElement styleNode) {
        if (this.hasTraceListeners()) {
            this.fireTraceEvent(new TracerEvent(this.m_transformer, sourceNode, mode, styleNode));
        }
    }

    public boolean hasTraceListeners() {
        return this.m_traceListeners != null;
    }

    public void removeTraceListener(TraceListener tl) {
        if (this.m_traceListeners != null) {
            this.m_traceListeners.removeElement(tl);
        }
    }
}

