/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.xalan.processor.StopParseException;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.processor.StylesheetPIHandler;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.transformer.TrAXFilter;
import org.apache.xalan.transformer.TransformerIdentityImpl;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.TreeWalker;
import org.apache.xpath.DOM2Helper;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    public static String XSLT_PROPERTIES = "/org/apache/xalan/res/XSLTInfo.properties";
    private static boolean isInited = false;
    private String m_DOMsystemID = null;
    URIResolver m_uriResolver;
    private ErrorListener m_errorListener = new DefaultErrorHandler();
    static /* synthetic */ Class class$java$lang$Process;

    public TransformerFactoryImpl() {
        TransformerFactoryImpl.loadPropertyFileToSystem(XSLT_PROPERTIES);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        StylesheetPIHandler handler;
        block14: {
            String baseID;
            InputSource isource = null;
            Node node = null;
            XMLReader reader = null;
            if (source instanceof DOMSource) {
                DOMSource dsource = (DOMSource)source;
                node = dsource.getNode();
                baseID = dsource.getSystemId();
            } else {
                isource = SAXSource.sourceToInputSource(source);
                baseID = isource.getSystemId();
            }
            handler = new StylesheetPIHandler(baseID, media, title, charset);
            if (this.m_uriResolver != null) {
                handler.setURIResolver(this.m_uriResolver);
            }
            try {
                if (node != null) {
                    TreeWalker walker = new TreeWalker(handler, new DOM2Helper());
                    walker.traverse(node);
                    break block14;
                }
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    SAXParser jaxpParser = factory.newSAXParser();
                    reader = jaxpParser.getXMLReader();
                }
                catch (ParserConfigurationException ex2) {
                    throw new SAXException(ex2);
                }
                catch (FactoryConfigurationError ex1) {
                    throw new SAXException(ex1.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {}
                if (reader == null) {
                    reader = XMLReaderFactory.createXMLReader();
                }
                reader.setContentHandler(handler);
                reader.parse(isource);
            }
            catch (StopParseException stopParseException) {
            }
            catch (SAXException se) {
                throw new TransformerConfigurationException("getAssociatedStylesheets failed", se);
            }
            catch (IOException ioe) {
                throw new TransformerConfigurationException("getAssociatedStylesheets failed", ioe);
            }
        }
        return handler.getAssociatedStylesheet();
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException(name);
    }

    String getDOMsystemID() {
        return this.m_DOMsystemID;
    }

    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    public boolean getFeature(String name) {
        if (name == "http://javax.xml.transform.dom.DOMResult/feature" || name == "http://javax.xml.transform.dom.DOMSource/feature" || name == "http://javax.xml.transform.sax.SAXResult/feature" || name == "http://javax.xml.transform.sax.SAXSource/feature" || name == "http://javax.xml.transform.stream.StreamResult/feature" || name == "http://javax.xml.transform.stream.StreamSource/feature" || name == "http://javax.xml.transform.sax.SAXTransformerFactory/feature" || name == "http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter") {
            return true;
        }
        return "http://javax.xml.transform.dom.DOMResult/feature".equals(name) || "http://javax.xml.transform.dom.DOMSource/feature".equals(name) || "http://javax.xml.transform.sax.SAXResult/feature".equals(name) || "http://javax.xml.transform.sax.SAXSource/feature".equals(name) || "http://javax.xml.transform.stream.StreamResult/feature".equals(name) || "http://javax.xml.transform.stream.StreamSource/feature".equals(name) || "http://javax.xml.transform.sax.SAXTransformerFactory/feature".equals(name) || "http://javax.xml.transform.sax.SAXTransformerFactory/feature/xmlfilter".equals(name);
    }

    public URIResolver getURIResolver() {
        return this.m_uriResolver;
    }

    private static void loadPropertyFileToSystem(String file) {
        block5: {
            if (isInited) break block5;
            try {
                try {
                    Properties props = new Properties();
                    InputStream is = (class$java$lang$Process != null ? class$java$lang$Process : (class$java$lang$Process = TransformerFactoryImpl.class$("java.lang.Process"))).getResourceAsStream(file);
                    BufferedInputStream bis = new BufferedInputStream(is);
                    props.load(bis);
                    bis.close();
                    Properties systemProps = System.getProperties();
                    Enumeration<?> propEnum = props.propertyNames();
                    while (propEnum.hasMoreElements()) {
                        String prop = (String)propEnum.nextElement();
                        if (((Hashtable)systemProps).containsKey(prop)) continue;
                        ((Hashtable)systemProps).put(prop, props.getProperty(prop));
                    }
                    System.setProperties(systemProps);
                    isInited = true;
                }
                catch (Exception exception) {
                }
            }
            catch (SecurityException securityException) {}
        }
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        TemplatesHandler builder = this.newTemplatesHandler();
        String baseID = source.getSystemId();
        if (baseID == null) {
            try {
                String currentDir = System.getProperty("user.dir");
                baseID = "file:///" + currentDir + File.separatorChar + source.getClass().getName();
            }
            catch (SecurityException securityException) {}
        } else {
            try {
                baseID = SystemIDResolver.getAbsoluteURI(baseID);
            }
            catch (TransformerException te) {
                throw new TransformerConfigurationException(te);
            }
        }
        builder.setSystemId(baseID);
        if (source instanceof DOMSource) {
            DOMSource dsource = (DOMSource)source;
            Node node = dsource.getNode();
            if (node != null) {
                return this.processFromNode(node, baseID);
            }
            String messageStr = XSLMessages.createMessage(108, null);
            throw new IllegalArgumentException(messageStr);
        }
        try {
            InputSource isource = SAXSource.sourceToInputSource(source);
            XMLReader reader = null;
            if (source instanceof SAXSource) {
                reader = ((SAXSource)source).getXMLReader();
            }
            if (reader == null) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    SAXParser jaxpParser = factory.newSAXParser();
                    reader = jaxpParser.getXMLReader();
                }
                catch (ParserConfigurationException ex2) {
                    throw new SAXException(ex2);
                }
                catch (FactoryConfigurationError ex1) {
                    throw new SAXException(ex1.toString());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (AbstractMethodError abstractMethodError) {}
            }
            if (reader == null) {
                reader = XMLReaderFactory.createXMLReader();
            }
            try {
                reader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            catch (SAXException sAXException) {}
            reader.setContentHandler(builder);
            reader.parse(isource);
        }
        catch (SAXException se) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(se));
                }
                catch (TransformerException ex1) {
                    throw new TransformerConfigurationException(ex1);
                }
            }
            throw new TransformerConfigurationException(se.getMessage(), se);
        }
        catch (Exception e10) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(e10));
                    return null;
                }
                catch (TransformerException ex1) {
                    throw new TransformerConfigurationException(ex1);
                }
            }
            throw new TransformerConfigurationException(e10.getMessage(), e10);
        }
        return builder.getTemplates();
    }

    public TemplatesHandler newTemplatesHandler() throws TransformerConfigurationException {
        return new StylesheetHandler(this);
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return new TransformerIdentityImpl();
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        try {
            Templates tmpl = this.newTemplates(source);
            if (tmpl == null) {
                return null;
            }
            return tmpl.newTransformer();
        }
        catch (TransformerConfigurationException ex2) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(ex2);
                    return null;
                }
                catch (TransformerException ex1) {
                    ex2 = new TransformerConfigurationException(ex1);
                }
            }
            throw ex2;
        }
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        return new TransformerIdentityImpl();
    }

    public TransformerHandler newTransformerHandler(Source src) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(src);
        if (templates == null) {
            return null;
        }
        return this.newTransformerHandler(templates);
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        try {
            TransformerImpl transformer = (TransformerImpl)templates.newTransformer();
            TransformerHandler th = (TransformerHandler)transformer.getInputContentHandler(true);
            return th;
        }
        catch (TransformerConfigurationException ex2) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(ex2);
                    return null;
                }
                catch (TransformerException ex1) {
                    ex2 = new TransformerConfigurationException(ex1);
                }
            }
            throw ex2;
        }
    }

    public XMLFilter newXMLFilter(Source src) throws TransformerConfigurationException {
        Templates templates = this.newTemplates(src);
        if (templates == null) {
            return null;
        }
        return this.newXMLFilter(templates);
    }

    public XMLFilter newXMLFilter(Templates templates) throws TransformerConfigurationException {
        try {
            return new TrAXFilter(templates);
        }
        catch (TransformerConfigurationException ex2) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(ex2);
                    return null;
                }
                catch (TransformerException ex1) {
                    new TransformerConfigurationException(ex1);
                }
            }
            throw ex2;
        }
    }

    public Templates processFromNode(Node node) throws TransformerConfigurationException {
        try {
            TemplatesHandler builder = this.newTemplatesHandler();
            TreeWalker walker = new TreeWalker(builder, new DOM2Helper());
            walker.traverse(node);
            return builder.getTemplates();
        }
        catch (SAXException se) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(se));
                }
                catch (TransformerException ex2) {
                    throw new TransformerConfigurationException(ex2);
                }
                return null;
            }
            throw new TransformerConfigurationException("processFromNode failed", se);
        }
        catch (TransformerConfigurationException tce) {
            throw tce;
        }
        catch (TransformerException tce) {
            throw new TransformerConfigurationException(tce.getMessage(), tce);
        }
        catch (Exception e10) {
            if (this.m_errorListener != null) {
                try {
                    this.m_errorListener.fatalError(new TransformerException(e10));
                }
                catch (TransformerException ex3) {
                    throw new TransformerConfigurationException(ex3);
                }
                return null;
            }
            throw new TransformerConfigurationException("processFromNode failed", e10);
        }
    }

    Templates processFromNode(Node node, String systemID) throws TransformerConfigurationException {
        this.m_DOMsystemID = systemID;
        return this.processFromNode(node);
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        throw new IllegalArgumentException(name);
    }

    public void setErrorListener(ErrorListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("ErrorListener");
        }
        this.m_errorListener = listener;
    }

    public void setURIResolver(URIResolver resolver) {
        this.m_uriResolver = resolver;
    }
}

