/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.extensions;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.QName;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XRTreeFrag;
import org.apache.xpath.objects.XString;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public class XSLProcessorContext {
    private TransformerImpl transformer;
    private Stylesheet stylesheetTree;
    private Node sourceTree;
    private Node sourceNode;
    private QName mode;

    public XSLProcessorContext(TransformerImpl transformer, Stylesheet stylesheetTree, Node sourceTree, Node sourceNode, QName mode) {
        this.transformer = transformer;
        this.stylesheetTree = stylesheetTree;
        this.mode = mode;
        this.sourceTree = sourceTree;
        this.sourceNode = sourceNode;
    }

    public Node getContextNode() {
        return this.sourceNode;
    }

    public QName getMode() {
        return this.mode;
    }

    public Node getSourceTree() {
        return this.sourceTree;
    }

    public Stylesheet getStylesheet() {
        return this.stylesheetTree;
    }

    public TransformerImpl getTransformer() {
        return this.transformer;
    }

    public void outputToResultTree(Stylesheet stylesheetTree, Object obj) throws TransformerException, MalformedURLException, FileNotFoundException, IOException {
        try {
            ResultTreeHandler rtreeHandler = this.transformer.getResultTreeHandler();
            XObject value = obj instanceof XObject ? (XObject)obj : (obj instanceof String ? new XString((String)obj) : (obj instanceof Boolean ? new XBoolean((Boolean)obj) : (obj instanceof Double ? new XNumber((Double)obj) : (obj instanceof DocumentFragment ? new XRTreeFrag((DocumentFragment)obj) : (obj instanceof Node ? new XNodeSet((Node)obj) : (obj instanceof NodeIterator ? new XNodeSet((NodeIterator)obj) : new XString(obj.toString())))))));
            int type = value.getType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: {
                    String s2 = value.str();
                    rtreeHandler.characters(s2.toCharArray(), 0, s2.length());
                    break;
                }
                case 4: {
                    Node pos;
                    NodeIterator nl = value.nodeset();
                    while ((pos = nl.nextNode()) != null) {
                        Node top = pos;
                        while (pos != null) {
                            rtreeHandler.flushPending();
                            rtreeHandler.cloneToResultTree(pos, true);
                            Node nextNode = pos.getFirstChild();
                            while (nextNode == null) {
                                if (pos.getNodeType() == 1) {
                                    rtreeHandler.endElement("", "", pos.getNodeName());
                                }
                                if (top == pos) break;
                                nextNode = pos.getNextSibling();
                                if (nextNode != null || top != (pos = pos.getParentNode())) continue;
                                if (pos.getNodeType() == 1) {
                                    rtreeHandler.endElement("", "", pos.getNodeName());
                                }
                                nextNode = null;
                                break;
                            }
                            pos = nextNode;
                        }
                    }
                    break;
                }
                case 5: {
                    rtreeHandler.outputResultTreeFragment(value, this.transformer.getXPathContext());
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }
}

