/*
 * Decompiled with CFR 0.152.
 */
package org.apache.regexp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.regexp.CharacterIterator;

public final class StreamCharacterIterator
implements CharacterIterator {
    private final InputStream is;
    private final StringBuffer buff;
    private boolean closed;

    public StreamCharacterIterator(InputStream inputStream) {
        this.is = inputStream;
        this.buff = new StringBuffer(512);
        this.closed = false;
    }

    public char charAt(int n2) {
        try {
            this.ensure(n2);
            return this.buff.charAt(n2);
        }
        catch (IOException iOException) {
            throw new StringIndexOutOfBoundsException(iOException.getMessage());
        }
    }

    private void ensure(int n2) throws IOException {
        if (this.closed) {
            return;
        }
        if (n2 < this.buff.length()) {
            return;
        }
        this.read(n2 + 1 - this.buff.length());
    }

    public boolean isEnd(int n2) {
        if (this.buff.length() > n2) {
            return false;
        }
        try {
            this.ensure(n2);
            return this.buff.length() <= n2;
        }
        catch (IOException iOException) {
            throw new StringIndexOutOfBoundsException(iOException.getMessage());
        }
    }

    private int read(int n2) throws IOException {
        if (this.closed) {
            return 0;
        }
        int n3 = n2;
        while (--n3 >= 0) {
            int n4 = this.is.read();
            if (n4 < 0) {
                this.closed = true;
                break;
            }
            this.buff.append((char)n4);
        }
        return n2 - n3;
    }

    private void readAll() throws IOException {
        while (!this.closed) {
            this.read(1000);
        }
    }

    public String substring(int n2) {
        try {
            this.readAll();
            return this.buff.toString().substring(n2);
        }
        catch (IOException iOException) {
            throw new StringIndexOutOfBoundsException(iOException.getMessage());
        }
    }

    public String substring(int n2, int n3) {
        try {
            this.ensure(n2 + n3);
            return this.buff.toString().substring(n2, n3);
        }
        catch (IOException iOException) {
            throw new StringIndexOutOfBoundsException(iOException.getMessage());
        }
    }
}

