/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.parser.ParserUtils;
import org.apache.jasper.parser.TreeNode;

public class TldLocationsCache {
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private Hashtable mappings = new Hashtable();

    public TldLocationsCache(ServletContext ctxt) {
        try {
            this.processWebDotXml(ctxt);
            this.processJars(ctxt);
        }
        catch (JasperException ex2) {
            Constants.message("jsp.error.internal.tldinit", new Object[]{ex2.getMessage()}, 1);
        }
    }

    public String[] getLocation(String uri) throws JasperException {
        return (String[])this.mappings.get(uri);
    }

    private void p(String s2) {
        System.out.println("[TldLocationsCache] " + s2);
    }

    private String parseTldForUri(String resourcePath, InputStream in) throws JasperException {
        ParserUtils pu = new ParserUtils();
        TreeNode tld = pu.parseXMLDocument(resourcePath, in);
        Iterator taglibs = tld.findChildren("taglib");
        int n2 = 0;
        while (taglibs.hasNext()) {
            String body;
            if (++n2 > 1) {
                Constants.message("jsp.error.more.than.one.taglib", new Object[]{resourcePath}, 1);
                return null;
            }
            TreeNode taglib = (TreeNode)taglibs.next();
            TreeNode uri = taglib.findChild("uri");
            if (uri == null || (body = uri.getBody()) == null) continue;
            return body;
        }
        return null;
    }

    private void processJars(ServletContext ctxt) throws JasperException {
        File libFile;
        URL libURL = null;
        try {
            libURL = ctxt.getResource("/WEB-INF/lib");
        }
        catch (MalformedURLException malformedURLException) {}
        if (libURL != null && "file".equals(libURL.getProtocol()) && (libFile = new File(libURL.getFile())).exists() && libFile.canRead() && libFile.isDirectory()) {
            String[] filenames = libFile.list();
            int i2 = 0;
            while (i2 < filenames.length) {
                if (filenames[i2].endsWith(".jar")) {
                    this.tldConfigJar(ctxt, "/WEB-INF/lib/" + filenames[i2]);
                }
                ++i2;
            }
        }
    }

    private void processWebDotXml(ServletContext ctxt) throws JasperException {
        InputStream is = ctxt.getResourceAsStream(WEB_XML);
        if (is == null) {
            Constants.message("jsp.error.internal.filenotfound", new Object[]{WEB_XML}, 2);
            return;
        }
        ClassLoader cl2 = this.getClass().getClassLoader();
        ParserUtils pu = ParserUtils.createParserUtils(cl2);
        TreeNode webtld = pu.parseXMLDocument(WEB_XML, is);
        Iterator taglibs = webtld.findChildren("taglib");
        while (taglibs.hasNext()) {
            TreeNode taglib = (TreeNode)taglibs.next();
            String tagUri = null;
            String tagLoc = null;
            TreeNode child = taglib.findChild("taglib-uri");
            if (child != null) {
                tagUri = child.getBody();
            }
            if ((child = taglib.findChild("taglib-location")) != null) {
                tagLoc = child.getBody();
            }
            if (tagLoc == null) continue;
            if (TldLocationsCache.uriType(tagLoc) == 2) {
                tagLoc = "/WEB-INF/" + tagLoc;
            }
            String tagLoc2 = null;
            if (tagLoc.endsWith(".jar")) {
                tagLoc2 = "META-INF/taglib.tld";
            }
            this.mappings.put(tagUri, new String[]{tagLoc, tagLoc2});
        }
    }

    private void tldConfigJar(ServletContext ctxt, String resourcePath) throws JasperException {
        block9: {
            ZipFile jarFile = null;
            InputStream stream = null;
            try {
                URL url = ctxt.getResource(resourcePath);
                if (url == null) {
                    return;
                }
                url = new URL("jar:" + url.toString() + "!/");
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                jarFile = conn.getJarFile();
                Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                while (entries.hasMoreElements()) {
                    String uri;
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith("META-INF/") || !name.endsWith(".tld") || (uri = this.parseTldForUri(resourcePath, stream = ((JarFile)jarFile).getInputStream(entry))) == null) continue;
                    this.mappings.put(uri, new String[]{resourcePath, name});
                }
            }
            catch (Exception exception) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (jarFile == null) break block9;
                try {
                    jarFile.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static int uriType(String uri) {
        if (uri.indexOf(58) != -1) {
            return 0;
        }
        if (uri.startsWith("/")) {
            return 1;
        }
        return 2;
    }
}

