/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.ParserXJspSaxHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ParserXJspSax {
    private InputSource is;
    private String filePath;
    private ParseEventListener jspHandler;
    private static final boolean validate = false;
    static final String[] lexicalHandlerPropNames = new String[]{"http://xml.org/sax/handlers/LexicalHandler", "http://xml.org/sax/properties/lexical-handler"};

    public ParserXJspSax(String filePath, InputStreamReader reader, ParseEventListener jspHandler) {
        this.filePath = filePath;
        this.is = new InputSource(reader);
        this.jspHandler = jspHandler;
    }

    public void parse() throws JasperException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader parser = saxParser.getXMLReader();
            ParserXJspSaxHandler handler = new ParserXJspSaxHandler(this.filePath, this.jspHandler);
            parser.setContentHandler(handler);
            parser.setEntityResolver(handler);
            parser.setDTDHandler(handler);
            parser.setErrorHandler(handler);
            int i2 = 0;
            while (i2 < lexicalHandlerPropNames.length) {
                if (this.setSaxProperty(parser, handler, lexicalHandlerPropNames[i2])) break;
                ++i2;
            }
            try {
                parser.setFeature("http://xml.org/sax/features/validation", false);
                parser.setFeature("http://xml.org/sax/features/namespaces", false);
                parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXNotSupportedException ex2) {
                throw new JasperException(Constants.getString("jsp.parser.sax.featurenotsupported", new Object[]{ex2.getMessage()}));
            }
            catch (SAXNotRecognizedException ex3) {
                throw new JasperException(Constants.getString("jsp.parser.sax.featurenotrecognized", new Object[]{ex3.getMessage()}));
            }
            parser.parse(this.is);
        }
        catch (IOException ex4) {
            throw new JasperException(ex4);
        }
        catch (ParserConfigurationException ex5) {
            throw new ParseException(ex5.getMessage());
        }
        catch (SAXParseException ex6) {
            Mark mark = new Mark(this.filePath, ex6.getLineNumber(), ex6.getColumnNumber());
            String reason = ex6.getException() != null ? ex6.getException().getMessage() : ex6.getMessage();
            throw new ParseException(mark, reason);
        }
        catch (SAXException ex7) {
            Exception ex2 = ex7;
            if (ex7.getException() != null) {
                ex2 = ex7.getException();
            }
            throw new JasperException(ex2);
        }
    }

    private boolean setSaxProperty(XMLReader parser, DefaultHandler handler, String propName) {
        try {
            parser.setProperty(propName, handler);
            return true;
        }
        catch (SAXNotSupportedException ex2) {
            Constants.message("jsp.parser.sax.propertynotsupported", new Object[]{ex2.getMessage()}, 2);
            return false;
        }
        catch (SAXNotRecognizedException ex3) {
            Constants.message("jsp.parser.sax.propertynotrecognized", new Object[]{ex3.getMessage()}, 2);
            return false;
        }
    }
}

