/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.MyEntityResolver;
import org.apache.jasper.compiler.MyErrorHandler;
import org.apache.jasper.compiler.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JspUtil {
    private static final String OPEN_EXPR = "<%=";
    private static final String CLOSE_EXPR = "%>";
    private static final String OPEN_EXPR_XML = "%=";
    private static final String CLOSE_EXPR_XML = "%";
    private static ErrorHandler errorHandler = new MyErrorHandler();
    private static EntityResolver entityResolver = new MyEntityResolver();

    public static Hashtable attrsToHashtable(Attributes attrs) {
        int len = attrs.getLength();
        Hashtable<String, String> table = new Hashtable<String, String>(len);
        int i2 = 0;
        while (i2 < len) {
            table.put(attrs.getQName(i2), attrs.getValue(i2));
            ++i2;
        }
        return table;
    }

    public static boolean booleanValue(String s2) {
        boolean b10 = false;
        if (s2 != null) {
            b10 = s2.equalsIgnoreCase("yes") ? true : Boolean.valueOf(s2);
        }
        return b10;
    }

    public static void checkAttributes(String typeOfTag, Attributes attrs, ValidAttribute[] validAttributes, Mark start) throws JasperException {
        boolean valid = true;
        int tempLength = attrs.getLength();
        Vector<String> temp = new Vector<String>(tempLength, 1);
        int i2 = 0;
        while (i2 < tempLength) {
            temp.addElement(attrs.getQName(i2));
            ++i2;
        }
        String missingAttribute = null;
        int i3 = 0;
        while (i3 < validAttributes.length) {
            if (validAttributes[i3].mandatory) {
                int attrPos = temp.indexOf(validAttributes[i3].name);
                if (attrPos != -1) {
                    temp.remove(attrPos);
                    valid = true;
                } else {
                    valid = false;
                    missingAttribute = validAttributes[i3].name;
                    break;
                }
            }
            ++i3;
        }
        if (!valid) {
            throw new ParseException(start, Constants.getString("jsp.error.mandatory.attribute", new Object[]{typeOfTag, missingAttribute}));
        }
        int attrLeftLength = temp.size();
        if (attrLeftLength == 0) {
            return;
        }
        String attribute = null;
        int j2 = 0;
        while (j2 < attrLeftLength) {
            valid = false;
            attribute = (String)temp.elementAt(j2);
            int i4 = 0;
            while (i4 < validAttributes.length) {
                if (attribute.equals(validAttributes[i4].name)) {
                    valid = true;
                    break;
                }
                ++i4;
            }
            if (!valid) {
                throw new ParseException(start, Constants.getString("jsp.error.invalid.attribute", new Object[]{typeOfTag, attribute}));
            }
            ++j2;
        }
    }

    public static String escapeQueryString(String unescString) {
        if (unescString == null) {
            return null;
        }
        String escString = "";
        String shellSpChars = "\\\"";
        int index = 0;
        while (index < unescString.length()) {
            char nextChar = unescString.charAt(index);
            if (shellSpChars.indexOf(nextChar) != -1) {
                escString = String.valueOf(escString) + "\\";
            }
            escString = String.valueOf(escString) + nextChar;
            ++index;
        }
        return escString;
    }

    public static String escapeXml(String s2) {
        if (s2 == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < s2.length()) {
            char c10 = s2.charAt(i2);
            if (c10 == '<') {
                sb.append("&lt;");
            } else if (c10 == '>') {
                sb.append("&gt;");
            } else if (c10 == '\'') {
                sb.append("&apos;");
            } else if (c10 == '&') {
                sb.append("&amp;");
            } else if (c10 == '\"') {
                sb.append("&quote;");
            } else {
                sb.append(c10);
            }
            ++i2;
        }
        return sb.toString();
    }

    public static String getElementChildTextData(Element e10) {
        String s2 = null;
        Text t2 = (Text)e10.getFirstChild();
        if (t2 != null && (s2 = t2.getData()) != null) {
            s2 = s2.trim();
        }
        return s2;
    }

    public static String getExpr(String expression, boolean isXml) {
        String closeExpr;
        String openExpr;
        if (isXml) {
            openExpr = OPEN_EXPR_XML;
            closeExpr = CLOSE_EXPR_XML;
        } else {
            openExpr = OPEN_EXPR;
            closeExpr = CLOSE_EXPR;
        }
        int length = expression.length();
        String returnString = expression.startsWith(openExpr) && expression.endsWith(closeExpr) ? expression.substring(openExpr.length(), length - closeExpr.length()) : "";
        return returnString;
    }

    public static String getExprInXml(String expression) {
        int length = expression.length();
        String returnString = expression.startsWith(OPEN_EXPR) && expression.endsWith(CLOSE_EXPR) ? expression.substring(1, length - 1) : expression;
        return returnString;
    }

    public static boolean isExpression(String token, boolean isXml) {
        String closeExpr;
        String openExpr;
        if (isXml) {
            openExpr = OPEN_EXPR_XML;
            closeExpr = CLOSE_EXPR_XML;
        } else {
            openExpr = OPEN_EXPR;
            closeExpr = CLOSE_EXPR;
        }
        return token.startsWith(openExpr) && token.endsWith(closeExpr);
    }

    public static Document parseXMLDoc(String uri, InputStream in) throws JasperException {
        return JspUtil.parseXMLDocJaxp(uri, in);
    }

    public static Document parseXMLDocJaxp(String uri, InputStream in) throws JasperException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setValidating(true);
            docFactory.setNamespaceAware(true);
            DocumentBuilder builder = docFactory.newDocumentBuilder();
            builder.setEntityResolver(entityResolver);
            builder.setErrorHandler(errorHandler);
            Document doc = builder.parse(in);
            return doc;
        }
        catch (ParserConfigurationException ex2) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml", new Object[]{uri, ex2.getMessage()}));
        }
        catch (SAXParseException ex3) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml.line", new Object[]{uri, new Integer(ex3.getLineNumber()), new Integer(ex3.getColumnNumber()), ex3.getMessage()}));
        }
        catch (SAXException sx) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml", new Object[]{uri, sx.getMessage()}));
        }
        catch (IOException io) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml", new Object[]{uri, io.toString()}));
        }
    }

    public static char[] removeQuotes(char[] chars) {
        CharArrayWriter caw = new CharArrayWriter();
        int i2 = 0;
        while (i2 < chars.length) {
            if (chars[i2] == '%' && chars[i2 + 1] == '\\' && chars[i2 + 2] == '\\' && chars[i2 + 3] == '>') {
                caw.write(37);
                caw.write(62);
                i2 += 3;
            } else {
                caw.write(chars[i2]);
            }
            ++i2;
        }
        return caw.toCharArray();
    }

    public static class ValidAttribute {
        String name;
        boolean mandatory;

        public ValidAttribute(String name) {
            this(name, false);
        }

        public ValidAttribute(String name, boolean mandatory) {
            this.name = name;
            this.mandatory = mandatory;
        }
    }
}

