/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.jaxp;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.crimson.jaxp.DefaultValidationErrorHandler;
import org.apache.crimson.parser.XMLReaderImpl;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

public class SAXParserImpl
extends SAXParser {
    private SAXParserFactory spf = null;
    private XMLReader xmlReader;
    private Parser parser = null;
    private boolean validating = false;
    private boolean namespaceAware = false;

    SAXParserImpl(SAXParserFactory spf) throws SAXNotSupportedException, SAXNotRecognizedException {
        this.spf = spf;
        this.xmlReader = new XMLReaderImpl();
        this.validating = spf.isValidating();
        String validation = "http://xml.org/sax/features/validation";
        this.xmlReader.setFeature(validation, this.validating);
        if (this.validating) {
            this.xmlReader.setErrorHandler(new DefaultValidationErrorHandler());
        }
        if (spf.isNamespaceAware()) {
            this.namespaceAware = true;
        }
    }

    void setFeatures(Hashtable features) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (features != null) {
            Enumeration e10 = features.keys();
            while (e10.hasMoreElements()) {
                String feature = (String)e10.nextElement();
                boolean value = (Boolean)features.get(feature);
                this.xmlReader.setFeature(feature, value);
            }
        }
    }

    public Parser getParser() throws SAXException {
        if (this.parser == null) {
            this.parser = new XMLReaderAdapter(this.xmlReader);
            this.parser.setDocumentHandler(new HandlerBase());
        }
        return this.parser;
    }

    public XMLReader getXMLReader() throws SAXException {
        return this.xmlReader;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.xmlReader.setProperty(name, value);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xmlReader.getProperty(name);
    }
}

