/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.LifecycleSupport;

public abstract class PersistentManagerBase
extends ManagerBase
implements Lifecycle,
PropertyChangeListener,
Runnable {
    private int checkInterval = 60;
    private static final String info = "MiddleManager/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private int maxActiveSessions = -1;
    protected static String name = "PersistentManagerBase";
    private boolean started = false;
    private Thread thread = null;
    private boolean threadDone = false;
    private String threadName = "MiddleManager";
    private Store store = null;

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public void clearStore() {
        if (this.store == null) {
            return;
        }
        try {
            this.store.clear();
        }
        catch (IOException e10) {
            this.log("Exception clearing the Store: " + e10);
            e10.printStackTrace();
        }
    }

    public Session createSession() {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            throw new IllegalStateException(ManagerBase.sm.getString("standardManager.createSession.ise"));
        }
        return super.createSession();
    }

    public Session findSession(String id) throws IOException {
        Session session = super.findSession(id);
        if (session != null) {
            return session;
        }
        session = this.swapIn(id);
        return session;
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public String getInfo() {
        return info;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public String getName() {
        return name;
    }

    public Store getStore() {
        return this.store;
    }

    private boolean isSessionStale(Session session, long timeNow) {
        int timeIdle;
        int maxInactiveInterval = session.getMaxInactiveInterval();
        return maxInactiveInterval >= 0 && (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) >= maxInactiveInterval;
    }

    protected boolean isStarted() {
        return this.started;
    }

    public void load() throws ClassNotFoundException, IOException {
        if (this.store == null) {
            return;
        }
        String[] ids = this.store.keys();
        int n2 = ids.length;
        if (n2 == 0) {
            return;
        }
        if (this.debug >= 1) {
            this.log(ManagerBase.sm.getString("persistentManager.loading", String.valueOf(n2)));
        }
        int i2 = 0;
        while (i2 < n2) {
            this.swapIn(ids[i2]);
            ++i2;
        }
    }

    private void processExpires() {
        if (!this.started) {
            return;
        }
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        int i2 = 0;
        while (i2 < sessions.length) {
            StandardSession session = (StandardSession)sessions[i2];
            if (session.isValid() && this.isSessionStale(session, timeNow)) {
                session.expire();
            }
            ++i2;
        }
    }

    public abstract void processPersistenceChecks();

    public void propertyChange(PropertyChangeEvent event) {
        block3: {
            if (!(event.getSource() instanceof Context)) {
                return;
            }
            Context context = (Context)event.getSource();
            if (!event.getPropertyName().equals("sessionTimeout")) break block3;
            try {
                this.setMaxInactiveInterval((Integer)event.getNewValue() * 60);
            }
            catch (NumberFormatException numberFormatException) {
                this.log(ManagerBase.sm.getString("standardManager.sessionTimeout", event.getNewValue().toString()));
            }
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
            this.processPersistenceChecks();
        }
    }

    public void setCheckInterval(int checkInterval) {
        int oldCheckInterval = this.checkInterval;
        this.checkInterval = checkInterval;
        this.support.firePropertyChange("checkInterval", new Integer(oldCheckInterval), new Integer(this.checkInterval));
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    public void setMaxActiveSessions(int max) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", new Integer(oldMaxActiveSessions), new Integer(this.maxActiveSessions));
    }

    protected void setStarted(boolean started) {
        this.started = started;
    }

    public void setStore(Store store) {
        this.store = store;
        store.setManager(this);
    }

    public void start() throws LifecycleException {
        if (this.debug >= 1) {
            this.log("Starting");
        }
        if (this.started) {
            throw new LifecycleException(ManagerBase.sm.getString("standardManager.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.debug >= 1) {
            this.log("Force random number initialization starting");
        }
        String dummy = this.generateSessionId();
        if (this.debug >= 1) {
            this.log("Force random number initialization completed");
        }
        if (this.store == null) {
            this.log("No Store configured, persistence disabled");
        } else if (this.store instanceof Lifecycle) {
            ((Lifecycle)((Object)this.store)).start();
        }
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (this.debug >= 1) {
            this.log("Stopping");
        }
        if (!this.started) {
            throw new LifecycleException(ManagerBase.sm.getString("standardManager.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.threadStop();
        Session[] sessions = this.findSessions();
        int i2 = 0;
        while (i2 < sessions.length) {
            StandardSession session = (StandardSession)sessions[i2];
            if (session.isValid()) {
                session.expire();
            }
            ++i2;
        }
        this.random = null;
    }

    protected Session swapIn(String id) throws IOException {
        if (this.store == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.store.load(id);
        }
        catch (ClassNotFoundException e10) {
            this.log(ManagerBase.sm.getString("persistentManager.deserializeError", id, e10));
            throw new IllegalStateException(ManagerBase.sm.getString("persistentManager.deserializeError", id, e10));
        }
        if (session == null) {
            return null;
        }
        if (!session.isValid() || this.isSessionStale(session, System.currentTimeMillis())) {
            this.log("session swapped in is invalid or expired");
            session.expire();
            this.store.remove(id);
            return null;
        }
        if (this.debug > 2) {
            this.log(ManagerBase.sm.getString("persistentManager.swapIn", id));
        }
        session.setManager(this);
        this.add(session);
        ((StandardSession)session).activate();
        return session;
    }

    protected void swapOut(Session session) throws IOException {
        if (this.store == null || !session.isValid() || this.isSessionStale(session, System.currentTimeMillis())) {
            return;
        }
        ((StandardSession)session).passivate();
        this.writeSession(session);
        session.expire();
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.threadName = "StandardManager[" + this.container.getName() + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.thread = null;
    }

    public void unload() {
        if (this.store == null) {
            return;
        }
        Session[] sessions = this.findSessions();
        int n2 = sessions.length;
        if (n2 == 0) {
            return;
        }
        if (this.debug >= 1) {
            this.log(ManagerBase.sm.getString("persistentManager.unloading", String.valueOf(n2)));
        }
        int i2 = 0;
        while (i2 < n2) {
            try {
                this.swapOut(sessions[i2]);
            }
            catch (IOException iOException) {}
            ++i2;
        }
    }

    protected void writeSession(Session session) throws IOException {
        if (this.store == null || !session.isValid() || this.isSessionStale(session, System.currentTimeMillis())) {
            return;
        }
        try {
            this.store.save(session);
        }
        catch (IOException e10) {
            this.log(ManagerBase.sm.getString("persistentManager.serializeError", session.getId(), e10));
            throw e10;
        }
    }
}

